/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.launch;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.launch.AndroidLaunchConfiguration;
import com.android.ide.eclipse.adt.internal.launch.LaunchConfigDelegate;
import com.android.ide.eclipse.adt.internal.project.BaseProjectHelper;
import com.android.ide.eclipse.adt.internal.sdk.Sdk;
import com.android.ide.eclipse.ddms.DdmsPlugin;
import com.android.prefs.AndroidLocation;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.NullSdkLog;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.sdkuilib.internal.widgets.AvdSelector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class EmulatorConfigTab
extends AbstractLaunchConfigurationTab {
    private static final String[][] NETWORK_SPEEDS = new String[][]{{"Full", "full"}, {"GSM", "gsm"}, {"HSCSD", "hscsd"}, {"GPRS", "gprs"}, {"EDGE", "edge"}, {"UMTS", "umts"}, {"HSPDA", "hsdpa"}};
    private static final String[][] NETWORK_LATENCIES = new String[][]{{"None", "none"}, {"GPRS", "gprs"}, {"EDGE", "edge"}, {"UMTS", "umts"}};
    private Button mAutoTargetButton;
    private Button mManualTargetButton;
    private AvdSelector mPreferredAvdSelector;
    private Combo mSpeedCombo;
    private Combo mDelayCombo;
    private Group mEmulatorOptionsGroup;
    private Text mEmulatorCLOptions;
    private Button mWipeDataButton;
    private Button mNoBootAnimButton;
    private Label mPreferredAvdLabel;
    private IAndroidTarget mProjectTarget;

    public static String getSpeed(int n) {
        try {
            return NETWORK_SPEEDS[n][1];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return NETWORK_SPEEDS[0][1];
        }
    }

    public static String getDelay(int n) {
        try {
            return NETWORK_LATENCIES[n][1];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return NETWORK_LATENCIES[0][1];
        }
    }

    public void createControl(Composite composite) {
        Label label;
        Font font = composite.getFont();
        try {
            Sdk.getCurrent().getAvdManager().reloadAvds(NullSdkLog.getLogger());
        }
        catch (AndroidLocation.AndroidLocationException androidLocationException) {}
        Composite composite2 = new Composite(composite, 0);
        this.setControl((Control)composite2);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.verticalSpacing = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setFont(font);
        Group group = new Group(composite2, 0);
        group.setText("Deployment Target Selection Mode");
        GridData gridData = new GridData(768);
        group.setLayoutData((Object)gridData);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 1;
        group.setLayout((Layout)gridLayout2);
        group.setFont(font);
        this.mManualTargetButton = new Button((Composite)group, 16);
        this.mManualTargetButton.setText("Manual");
        this.mAutoTargetButton = new Button((Composite)group, 16);
        this.mAutoTargetButton.setText("Automatic");
        this.mAutoTargetButton.setSelection(true);
        this.mAutoTargetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                EmulatorConfigTab.this.updateLaunchConfigurationDialog();
                boolean bl = EmulatorConfigTab.this.mAutoTargetButton.getSelection();
                EmulatorConfigTab.this.mPreferredAvdSelector.setEnabled(bl);
                EmulatorConfigTab.this.mPreferredAvdLabel.setEnabled(bl);
            }
        });
        Composite composite3 = new Composite((Composite)group, 0);
        composite3.setLayoutData((Object)new GridData(768));
        gridLayout2 = new GridLayout(1, false);
        gridLayout2.marginHeight = 0;
        gridLayout2.marginRight = 0;
        gridLayout2.marginLeft = 30;
        composite3.setLayout((Layout)gridLayout2);
        this.mPreferredAvdLabel = new Label(composite3, 0);
        this.mPreferredAvdLabel.setText("Select a preferred Android Virtual Device for deployment:");
        this.mPreferredAvdSelector = new AvdSelector(composite3, Sdk.getCurrent().getSdkLocation(), null, AvdSelector.DisplayMode.SIMPLE_CHECK);
        this.mPreferredAvdSelector.setTableHeightHint(100);
        this.mPreferredAvdSelector.setSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                EmulatorConfigTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.mEmulatorOptionsGroup = new Group(composite2, 0);
        this.mEmulatorOptionsGroup.setText("Emulator launch parameters:");
        this.mEmulatorOptionsGroup.setLayoutData((Object)new GridData(768));
        gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 2;
        this.mEmulatorOptionsGroup.setLayout((Layout)gridLayout2);
        this.mEmulatorOptionsGroup.setFont(font);
        new Label((Composite)this.mEmulatorOptionsGroup, 0).setText("Network Speed:");
        this.mSpeedCombo = new Combo((Composite)this.mEmulatorOptionsGroup, 8);
        String[][] stringArray = NETWORK_SPEEDS;
        int n = NETWORK_SPEEDS.length;
        int n2 = 0;
        while (n2 < n) {
            label = stringArray[n2];
            this.mSpeedCombo.add(label[0]);
            ++n2;
        }
        this.mSpeedCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                EmulatorConfigTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.mSpeedCombo.pack();
        new Label((Composite)this.mEmulatorOptionsGroup, 0).setText("Network Latency:");
        this.mDelayCombo = new Combo((Composite)this.mEmulatorOptionsGroup, 8);
        stringArray = NETWORK_LATENCIES;
        n = NETWORK_LATENCIES.length;
        n2 = 0;
        while (n2 < n) {
            label = stringArray[n2];
            this.mDelayCombo.add(label[0]);
            ++n2;
        }
        this.mDelayCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                EmulatorConfigTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.mDelayCombo.pack();
        this.mWipeDataButton = new Button((Composite)this.mEmulatorOptionsGroup, 32);
        this.mWipeDataButton.setText("Wipe User Data");
        this.mWipeDataButton.setToolTipText("Check this if you want to wipe your user data each time you start the emulator. You will be prompted for confirmation when the emulator starts.");
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.mWipeDataButton.setLayoutData((Object)gridData);
        this.mWipeDataButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                EmulatorConfigTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.mNoBootAnimButton = new Button((Composite)this.mEmulatorOptionsGroup, 32);
        this.mNoBootAnimButton.setText("Disable Boot Animation");
        this.mNoBootAnimButton.setToolTipText("Check this if you want to disable the boot animation. This can help the emulator start faster on slow machines.");
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.mNoBootAnimButton.setLayoutData((Object)gridData);
        this.mNoBootAnimButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                EmulatorConfigTab.this.updateLaunchConfigurationDialog();
            }
        });
        label = new Label((Composite)this.mEmulatorOptionsGroup, 0);
        label.setText("Additional Emulator Command Line Options");
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.mEmulatorCLOptions = new Text((Composite)this.mEmulatorOptionsGroup, 2048);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.mEmulatorCLOptions.setLayoutData((Object)gridData);
        this.mEmulatorCLOptions.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                EmulatorConfigTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    public String getName() {
        return "Target";
    }

    public Image getImage() {
        return DdmsPlugin.getImageLoader().loadImage("emulator.png", null);
    }

    private void updateAvdList(AvdManager avdManager) {
        if (avdManager == null) {
            avdManager = Sdk.getCurrent().getAvdManager();
        }
        this.mPreferredAvdSelector.setManager(avdManager);
        this.mPreferredAvdSelector.setFilter(this.mProjectTarget);
        this.mPreferredAvdSelector.refresh(false);
    }

    public void initializeFrom(ILaunchConfiguration iLaunchConfiguration) {
        IJavaProject iJavaProject;
        int n;
        AvdManager avdManager = Sdk.getCurrent().getAvdManager();
        AndroidLaunchConfiguration.TargetMode targetMode = LaunchConfigDelegate.DEFAULT_TARGET_MODE;
        try {
            targetMode = AndroidLaunchConfiguration.TargetMode.getMode(iLaunchConfiguration.getAttribute("com.android.ide.eclipse.adt.target", targetMode.getValue()));
        }
        catch (CoreException coreException) {}
        this.mAutoTargetButton.setSelection(targetMode.getValue());
        this.mManualTargetButton.setSelection(!targetMode.getValue());
        String string = "";
        try {
            string = iLaunchConfiguration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, string);
        }
        catch (CoreException coreException) {}
        IProject iProject = null;
        IJavaProject[] iJavaProjectArray = BaseProjectHelper.getAndroidProjects();
        if (iJavaProjectArray != null) {
            IJavaProject[] iJavaProjectArray2 = iJavaProjectArray;
            int n2 = iJavaProjectArray.length;
            n = 0;
            while (n < n2) {
                iJavaProject = iJavaProjectArray2[n];
                if (iJavaProject.getElementName().equals(string)) {
                    iProject = iJavaProject.getProject();
                    break;
                }
                ++n;
            }
        }
        if (iProject != null) {
            this.mProjectTarget = Sdk.getCurrent().getTarget(iProject);
        }
        this.updateAvdList(avdManager);
        string = "";
        try {
            string = iLaunchConfiguration.getAttribute("com.android.ide.eclipse.adt.avd", string);
        }
        catch (CoreException coreException) {}
        if (string != null && string.length() > 0 && avdManager != null) {
            iJavaProject = avdManager.getAvd(string, true);
            this.mPreferredAvdSelector.setSelection((AvdManager.AvdInfo)iJavaProject);
        } else {
            this.mPreferredAvdSelector.setSelection(null);
        }
        boolean bl = false;
        try {
            bl = iLaunchConfiguration.getAttribute("com.android.ide.eclipse.adt.wipedata", bl);
        }
        catch (CoreException coreException) {}
        this.mWipeDataButton.setSelection(bl);
        bl = false;
        try {
            bl = iLaunchConfiguration.getAttribute("com.android.ide.eclipse.adt.nobootanim", bl);
        }
        catch (CoreException coreException) {}
        this.mNoBootAnimButton.setSelection(bl);
        n = -1;
        n = 0;
        try {
            n = iLaunchConfiguration.getAttribute("com.android.ide.eclipse.adt.speed", n);
        }
        catch (CoreException coreException) {}
        if (n == -1) {
            this.mSpeedCombo.clearSelection();
        } else {
            this.mSpeedCombo.select(n);
        }
        n = 0;
        try {
            n = iLaunchConfiguration.getAttribute("com.android.ide.eclipse.adt.delay", n);
        }
        catch (CoreException coreException) {}
        if (n == -1) {
            this.mDelayCombo.clearSelection();
        } else {
            this.mDelayCombo.select(n);
        }
        String string2 = null;
        try {
            string2 = iLaunchConfiguration.getAttribute("com.android.ide.eclipse.adt.commandline", "");
        }
        catch (CoreException coreException) {}
        if (string2 != null) {
            this.mEmulatorCLOptions.setText(string2);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        iLaunchConfigurationWorkingCopy.setAttribute("com.android.ide.eclipse.adt.target", this.mAutoTargetButton.getSelection());
        AvdManager.AvdInfo avdInfo = this.mPreferredAvdSelector.getSelected();
        if (avdInfo != null) {
            iLaunchConfigurationWorkingCopy.setAttribute("com.android.ide.eclipse.adt.avd", avdInfo.getName());
        } else {
            iLaunchConfigurationWorkingCopy.setAttribute("com.android.ide.eclipse.adt.avd", null);
        }
        iLaunchConfigurationWorkingCopy.setAttribute("com.android.ide.eclipse.adt.speed", this.mSpeedCombo.getSelectionIndex());
        iLaunchConfigurationWorkingCopy.setAttribute("com.android.ide.eclipse.adt.delay", this.mDelayCombo.getSelectionIndex());
        iLaunchConfigurationWorkingCopy.setAttribute("com.android.ide.eclipse.adt.commandline", this.mEmulatorCLOptions.getText());
        iLaunchConfigurationWorkingCopy.setAttribute("com.android.ide.eclipse.adt.wipedata", this.mWipeDataButton.getSelection());
        iLaunchConfigurationWorkingCopy.setAttribute("com.android.ide.eclipse.adt.nobootanim", this.mNoBootAnimButton.getSelection());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        iLaunchConfigurationWorkingCopy.setAttribute("com.android.ide.eclipse.adt.target", LaunchConfigDelegate.DEFAULT_TARGET_MODE.getValue());
        iLaunchConfigurationWorkingCopy.setAttribute("com.android.ide.eclipse.adt.speed", 0);
        iLaunchConfigurationWorkingCopy.setAttribute("com.android.ide.eclipse.adt.delay", 0);
        iLaunchConfigurationWorkingCopy.setAttribute("com.android.ide.eclipse.adt.wipedata", false);
        iLaunchConfigurationWorkingCopy.setAttribute("com.android.ide.eclipse.adt.nobootanim", false);
        IPreferenceStore iPreferenceStore = AdtPlugin.getDefault().getPreferenceStore();
        String string = iPreferenceStore.getString("com.android.ide.eclipse.adt.emuOptions");
        iLaunchConfigurationWorkingCopy.setAttribute("com.android.ide.eclipse.adt.commandline", string);
    }
}

