/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.launch;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.launch.AndroidLaunch;
import com.android.ide.eclipse.adt.internal.launch.AndroidLaunchConfiguration;
import com.android.ide.eclipse.adt.internal.launch.DelayedLaunchInfo;
import com.android.ide.eclipse.adt.internal.launch.DeviceChooserDialog;
import com.android.ide.eclipse.adt.internal.launch.IAndroidLaunchAction;
import com.android.ide.eclipse.adt.internal.launch.ILaunchController;
import com.android.ide.eclipse.adt.internal.launch.LaunchConfigDelegate;
import com.android.ide.eclipse.adt.internal.project.AndroidManifestParser;
import com.android.ide.eclipse.adt.internal.project.ApkInstallManager;
import com.android.ide.eclipse.adt.internal.project.BaseProjectHelper;
import com.android.ide.eclipse.adt.internal.project.ProjectHelper;
import com.android.ide.eclipse.adt.internal.sdk.Sdk;
import com.android.ide.eclipse.adt.internal.wizards.actions.AvdManagerAction;
import com.android.prefs.AndroidLocation;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.NullSdkLog;
import com.android.sdklib.internal.avd.AvdManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMConnector;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AndroidLaunchController
implements AndroidDebugBridge.IDebugBridgeChangeListener,
AndroidDebugBridge.IDeviceChangeListener,
AndroidDebugBridge.IClientChangeListener,
ILaunchController {
    private static final String FLAG_AVD = "-avd";
    private static final String FLAG_NETDELAY = "-netdelay";
    private static final String FLAG_NETSPEED = "-netspeed";
    private static final String FLAG_WIPE_DATA = "-wipe-data";
    private static final String FLAG_NO_BOOT_ANIM = "-no-boot-anim";
    private static final HashMap<ILaunchConfiguration, Integer> sRunningAppMap;
    private static final Object sListLock;
    private final ArrayList<DelayedLaunchInfo> mWaitingForEmulatorLaunches = new ArrayList();
    private final ArrayList<DelayedLaunchInfo> mWaitingForReadyEmulatorList = new ArrayList();
    private final ArrayList<DelayedLaunchInfo> mWaitingForDebuggerApplications = new ArrayList();
    private final ArrayList<Client> mUnknownClientsWaitingForDebugger = new ArrayList();
    private static AndroidLaunchController sThis;

    static {
        sListLock = sRunningAppMap = new HashMap();
        sThis = new AndroidLaunchController();
    }

    private AndroidLaunchController() {
        AndroidDebugBridge.addDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)this);
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        AndroidDebugBridge.addClientChangeListener((AndroidDebugBridge.IClientChangeListener)this);
    }

    public static AndroidLaunchController getInstance() {
        return sThis;
    }

    public static void debugRunningApp(IProject iProject, int n) {
        ILaunchConfiguration iLaunchConfiguration = AndroidLaunchController.getLaunchConfig(iProject);
        if (iLaunchConfiguration != null) {
            AndroidLaunchController.setPortLaunchConfigAssociation(iLaunchConfiguration, n);
            DebugUITools.launch((ILaunchConfiguration)iLaunchConfiguration, (String)"debug");
        }
    }

    public static ILaunchConfiguration getLaunchConfig(IProject iProject) {
        String string;
        ILaunchConfigurationType iLaunchConfigurationType;
        ILaunchManager iLaunchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfiguration iLaunchConfiguration = AndroidLaunchController.findConfig(iLaunchManager, iLaunchConfigurationType = iLaunchManager.getLaunchConfigurationType("com.android.ide.eclipse.adt.debug.LaunchConfigType"), string = iProject.getName());
        if (iLaunchConfiguration == null) {
            ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy = null;
            try {
                iLaunchConfigurationWorkingCopy = iLaunchConfigurationType.newInstance(null, iLaunchManager.generateUniqueLaunchConfigurationNameFrom(string));
                iLaunchConfigurationWorkingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, string);
                iLaunchConfigurationWorkingCopy.setAttribute("com.android.ide.eclipse.adt.action", 0);
                iLaunchConfigurationWorkingCopy.setAttribute("com.android.ide.eclipse.adt.target", LaunchConfigDelegate.DEFAULT_TARGET_MODE.getValue());
                iLaunchConfigurationWorkingCopy.setAttribute("com.android.ide.eclipse.adt.avd", null);
                iLaunchConfigurationWorkingCopy.setAttribute("com.android.ide.eclipse.adt.speed", 0);
                iLaunchConfigurationWorkingCopy.setAttribute("com.android.ide.eclipse.adt.delay", 0);
                iLaunchConfigurationWorkingCopy.setAttribute("com.android.ide.eclipse.adt.wipedata", false);
                iLaunchConfigurationWorkingCopy.setAttribute("com.android.ide.eclipse.adt.nobootanim", false);
                IPreferenceStore iPreferenceStore = AdtPlugin.getDefault().getPreferenceStore();
                String string2 = iPreferenceStore.getString("com.android.ide.eclipse.adt.emuOptions");
                iLaunchConfigurationWorkingCopy.setAttribute("com.android.ide.eclipse.adt.commandline", string2);
                iLaunchConfigurationWorkingCopy.setMappedResources(AndroidLaunchController.getResourcesToMap(iProject));
                return iLaunchConfigurationWorkingCopy.doSave();
            }
            catch (CoreException coreException) {
                String string3 = String.format("Failed to create a Launch config for project '%1$s': %2$s", iProject.getName(), coreException.getMessage());
                AdtPlugin.printErrorToConsole(iProject, new Object[]{string3});
                return null;
            }
        }
        return iLaunchConfiguration;
    }

    public static IResource[] getResourcesToMap(IProject iProject) {
        ArrayList<Object> arrayList = new ArrayList<Object>(2);
        arrayList.add(iProject);
        IFile iFile = AndroidManifestParser.getManifest(iProject);
        if (iFile != null) {
            arrayList.add(iFile);
        }
        return arrayList.toArray(new IResource[arrayList.size()]);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void launch(final IProject var1_1, String var2_2, IFile var3_3, String var4_4, String var5_5, Boolean var6_6, String var7_7, IAndroidLaunchAction var8_8, final AndroidLaunchConfiguration var9_9, final AndroidLaunch var10_10, IProgressMonitor var11_11) {
        block20: {
            block21: {
                var12_12 = String.format("Performing %1$s", new Object[]{var8_8.getLaunchDescription()});
                AdtPlugin.printToConsole(var1_1, new Object[]{var12_12});
                var13_13 = new DelayedLaunchInfo(var1_1, var4_4, var5_5, var8_8, var3_3, var6_6, var7_7, var10_10, var11_11);
                var13_13.setDebugMode(var2_2.equals("debug"));
                var14_14 = Sdk.getCurrent();
                var15_15 = var14_14.getAvdManager();
                try {
                    var15_15.reloadAvds(NullSdkLog.getLogger());
                }
                catch (AndroidLocation.AndroidLocationException v0) {
                    var9_9.mTargetMode = AndroidLaunchConfiguration.TargetMode.MANUAL;
                }
                var16_16 = var14_14.getTarget(var1_1);
                var17_17 = new DeviceChooserDialog.DeviceChooserResponse();
                if (var9_9.mTargetMode != AndroidLaunchConfiguration.TargetMode.AUTO) break block20;
                var18_18 = AndroidDebugBridge.getBridge().getDevices();
                var19_19 = null;
                if (var9_9.mAvdName != null && !var16_16.isCompatibleBaseFor((var19_19 = var15_15.getAvd(var9_9.mAvdName, true)).getTarget())) {
                    var19_19 = null;
                    AdtPlugin.printErrorToConsole(var1_1, new Object[]{String.format("Preferred AVD '%1$s' is not compatible with the project target '%2$s'. Looking for a compatible AVD...", new Object[]{var9_9.mAvdName, var16_16.getName()})});
                }
                if (var19_19 == null) break block21;
                var23_20 = var18_18;
                var22_24 = var18_18.length;
                var21_26 = 0;
                if (true) ** GOTO lbl39
            }
            var20_29 = new HashMap<Object, AvdManager.AvdInfo>();
            var21_27 = false;
            var25_33 = var18_18;
            var24_31 = var18_18.length;
            var23_21 = 0;
            if (true) ** GOTO lbl57
            do {
                if ((var24_30 = (var20_28 = var23_20[var21_26]).getAvdName()) != null && var24_30.equals(var9_9.mAvdName)) {
                    var17_17.setDeviceToUse(var20_28);
                    AdtPlugin.printToConsole(var1_1, new Object[]{String.format("Automatic Target Mode: Preferred AVD '%1$s' is available on emulator '%2$s'", new Object[]{var9_9.mAvdName, var20_28})});
                    this.continueLaunch(var17_17, var1_1, var10_10, var13_13, var9_9);
                    return;
                }
                ++var21_26;
lbl39:
                // 2 sources

            } while (var21_26 < var22_24);
            var17_17.setAvdToLaunch(var19_19);
            AdtPlugin.printToConsole(var1_1, new Object[]{String.format("Automatic Target Mode: Preferred AVD '%1$s' is not available. Launching new emulator.", new Object[]{var9_9.mAvdName})});
            this.continueLaunch(var17_17, var1_1, var10_10, var13_13, var9_9);
            return;
            do {
                if ((var26_34 = (var22_25 = var25_33[var23_21]).getAvdName()) != null) {
                    var27_35 = var15_15.getAvd(var26_34, true);
                    if (var27_35 != null && var16_16.isCompatibleBaseFor(var27_35.getTarget())) {
                        var20_29.put(var22_25, var27_35);
                    }
                } else if (var16_16.isPlatform() && (var27_35 = Sdk.getDeviceVersion((IDevice)var22_25)).canRun(var16_16.getVersion())) {
                    var20_29.put(var22_25, null);
                } else {
                    var21_27 = true;
                }
                ++var23_21;
lbl57:
                // 2 sources

            } while (var23_21 < var24_31);
            if (!var21_27 && var20_29.size() == 0) {
                var22_25 = this.findMatchingAvd(var15_15, var16_16);
                if (var22_25 != null) {
                    var17_17.setAvdToLaunch((AvdManager.AvdInfo)var22_25);
                    AdtPlugin.printToConsole(var1_1, new Object[]{String.format("Automatic Target Mode: launching new emulator with compatible AVD '%1$s'", new Object[]{var22_25.getName()})});
                    this.continueLaunch(var17_17, var1_1, var10_10, var13_13, var9_9);
                    return;
                }
                AdtPlugin.printToConsole(var1_1, new Object[]{String.format("Failed to find an AVD compatible with target '%1$s'.", new Object[]{var16_16.getName()})});
                var23_22 = AdtPlugin.getDisplay();
                var24_32 = new boolean[1];
                var23_22.syncExec(new Runnable(){

                    public void run() {
                        Shell shell = var23_22.getActiveShell();
                        if (MessageDialog.openQuestion((Shell)shell, (String)"Android AVD Error", (String)"No compatible targets were found. Do you wish to a add new Android Virtual Device?")) {
                            AvdManagerAction avdManagerAction = new AvdManagerAction();
                            avdManagerAction.run(null);
                            var24_32[0] = true;
                        }
                    }
                });
                if (var24_32[0]) {
                    var22_25 = this.findMatchingAvd(var15_15, var16_16);
                    if (var22_25 != null) {
                        var17_17.setAvdToLaunch((AvdManager.AvdInfo)var22_25);
                        AdtPlugin.printToConsole(var1_1, new Object[]{String.format("Launching new emulator with compatible AVD '%1$s'", new Object[]{var22_25.getName()})});
                        this.continueLaunch(var17_17, var1_1, var10_10, var13_13, var9_9);
                        return;
                    }
                    AdtPlugin.printErrorToConsole(var1_1, new Object[]{String.format("Still no compatible AVDs with target '%1$s': Aborting launch.", new Object[]{var16_16.getName()})});
                    this.stopLaunch(var13_13);
                }
            } else if (!var21_27 && var20_29.size() == 1) {
                var22_25 = var20_29.entrySet().iterator().next();
                var17_17.setDeviceToUse((IDevice)var22_25.getKey());
                var23_23 = (AvdManager.AvdInfo)var22_25.getValue();
                var12_12 = var23_23 != null ? String.format("Automatic Target Mode: using existing emulator '%1$s' running compatible AVD '%2$s'", new Object[]{var17_17.getDeviceToUse(), ((AvdManager.AvdInfo)var22_25.getValue()).getName()}) : String.format("Automatic Target Mode: using device '%1$s'", new Object[]{var17_17.getDeviceToUse()});
                AdtPlugin.printToConsole(var1_1, new Object[]{var12_12});
                this.continueLaunch(var17_17, var1_1, var10_10, var13_13, var9_9);
                return;
            }
            if (var20_29.size() >= 2) {
                var12_12 = "Automatic Target Mode: Several compatible targets. Please select a target device.";
            } else if (var21_27) {
                var12_12 = "Automatic Target Mode: Unable to detect device compatibility. Please select a target device.";
            }
            AdtPlugin.printToConsole(var1_1, new Object[]{var12_12});
        }
        AdtPlugin.getDisplay().asyncExec(new Runnable(){

            public void run() {
                try {
                    DeviceChooserDialog deviceChooserDialog = new DeviceChooserDialog(AdtPlugin.getDisplay().getActiveShell(), var17_17, var13_13.getPackageName(), var16_16);
                    if (deviceChooserDialog.open() != 0) {
                        AdtPlugin.printErrorToConsole(var1_1, new Object[]{"Launch canceled!"});
                        AndroidLaunchController.this.stopLaunch(var13_13);
                        return;
                    }
                    AndroidLaunchController.this.continueLaunch(var17_17, var1_1, var10_10, var13_13, var9_9);
                }
                catch (Exception exception) {
                    String string = exception.getMessage();
                    if (string == null) {
                        string = exception.getClass().getCanonicalName();
                    }
                    AdtPlugin.printErrorToConsole(var1_1, new Object[]{String.format("Error during launch: %s", string)});
                    AndroidLaunchController.this.stopLaunch(var13_13);
                }
            }
        });
    }

    private AvdManager.AvdInfo findMatchingAvd(AvdManager avdManager, IAndroidTarget iAndroidTarget) {
        AvdManager.AvdInfo[] avdInfoArray = avdManager.getValidAvds();
        AvdManager.AvdInfo avdInfo = null;
        AvdManager.AvdInfo[] avdInfoArray2 = avdInfoArray;
        int n = avdInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            AvdManager.AvdInfo avdInfo2 = avdInfoArray2[n2];
            if (iAndroidTarget.isCompatibleBaseFor(avdInfo2.getTarget()) && (avdInfo == null || avdInfo2.getTarget().getVersion().getApiLevel() < avdInfo.getTarget().getVersion().getApiLevel())) {
                avdInfo = avdInfo2;
            }
            ++n2;
        }
        return avdInfo;
    }

    void continueLaunch(final DeviceChooserDialog.DeviceChooserResponse deviceChooserResponse, final IProject iProject, AndroidLaunch androidLaunch, final DelayedLaunchInfo delayedLaunchInfo, final AndroidLaunchConfiguration androidLaunchConfiguration) {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                if (deviceChooserResponse.getAvdToLaunch() != null) {
                    Object object = sListLock;
                    synchronized (object) {
                        AvdManager.AvdInfo avdInfo = deviceChooserResponse.getAvdToLaunch();
                        AndroidLaunchController.this.mWaitingForEmulatorLaunches.add(delayedLaunchInfo);
                        AdtPlugin.printToConsole(iProject, String.format("Launching a new emulator with Virtual Device '%1$s'", avdInfo.getName()));
                        boolean bl = AndroidLaunchController.this.launchEmulator(androidLaunchConfiguration, avdInfo);
                        if (!bl) {
                            AdtPlugin.displayError("Emulator Launch", "Couldn't launch the emulator! Make sure the SDK directory is properly setup and the emulator is not missing.");
                            AndroidLaunchController.this.mWaitingForEmulatorLaunches.remove(delayedLaunchInfo);
                            AdtPlugin.printErrorToConsole(iProject, new Object[]{"Launch canceled!"});
                            AndroidLaunchController.this.stopLaunch(delayedLaunchInfo);
                            return;
                        }
                        return;
                    }
                }
                if (deviceChooserResponse.getDeviceToUse() != null) {
                    delayedLaunchInfo.setDevice(deviceChooserResponse.getDeviceToUse());
                    AndroidLaunchController.this.simpleLaunch(delayedLaunchInfo, delayedLaunchInfo.getDevice());
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getPortForConfig(ILaunchConfiguration iLaunchConfiguration) {
        Object object = sListLock;
        synchronized (object) {
            Integer n = sRunningAppMap.get(iLaunchConfiguration);
            if (n != null) {
                sRunningAppMap.remove(iLaunchConfiguration);
                return n;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setPortLaunchConfigAssociation(ILaunchConfiguration iLaunchConfiguration, int n) {
        Object object = sListLock;
        synchronized (object) {
            sRunningAppMap.put(iLaunchConfiguration, n);
        }
    }

    private boolean checkBuildInfo(DelayedLaunchInfo delayedLaunchInfo, IDevice iDevice) {
        if (iDevice != null) {
            String string;
            String string2 = iDevice.getProperty("ro.build.version.release");
            String string3 = iDevice.getProperty("ro.build.version.sdk");
            String string4 = iDevice.getProperty("ro.build.version.codename");
            int n = -1;
            try {
                n = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {}
            String string5 = delayedLaunchInfo.getRequiredApiVersionNumber();
            if (string5 != null) {
                int n2 = -1;
                try {
                    n2 = Integer.parseInt(string5);
                }
                catch (NumberFormatException numberFormatException) {}
                if (n2 == -1) {
                    if (!string5.equals(string4)) {
                        AdtPlugin.printErrorToConsole(delayedLaunchInfo.getProject(), new Object[]{String.format("ERROR: Application requires a device running '%1$s'!", string5)});
                        return false;
                    }
                } else if (n == -1) {
                    AdtPlugin.printToConsole(delayedLaunchInfo.getProject(), "WARNING: Unknown device API version!");
                } else if (n < n2) {
                    String string6 = String.format("ERROR: Application requires API version %1$d. Device API version is %2$d (Android %3$s).", n2, n, string2);
                    AdtPlugin.printErrorToConsole(delayedLaunchInfo.getProject(), new Object[]{string6});
                    return false;
                }
            } else {
                AdtPlugin.printErrorToConsole(delayedLaunchInfo.getProject(), new Object[]{"WARNING: Application does not specify an API level requirement!"});
                if (n == -1) {
                    AdtPlugin.printErrorToConsole(delayedLaunchInfo.getProject(), new Object[]{"WARNING: Unknown device API version!"});
                } else {
                    AdtPlugin.printErrorToConsole(delayedLaunchInfo.getProject(), new Object[]{String.format("Device API version is %1$d (Android %2$s)", n, string2)});
                }
            }
            if (!iDevice.isEmulator() && delayedLaunchInfo.isDebugMode() && (string = iDevice.getProperty("ro.debuggable")) != null && string.equals("0")) {
                if (delayedLaunchInfo.getDebuggable() == null) {
                    String string7 = String.format("Device '%1$s' requires that applications explicitely declare themselves as debuggable in their manifest.", iDevice.getSerialNumber());
                    String string8 = String.format("Application '%1$s' does not have the attribute 'debuggable' set to TRUE in its manifest and cannot be debugged.", delayedLaunchInfo.getPackageName());
                    AdtPlugin.printErrorToConsole(delayedLaunchInfo.getProject(), new Object[]{string7, string8});
                    delayedLaunchInfo.setDebugMode(false);
                } else if (delayedLaunchInfo.getDebuggable() == Boolean.FALSE) {
                    String string9 = String.format("Application '%1$s' has its 'debuggable' attribute set to FALSE and cannot be debugged.", delayedLaunchInfo.getPackageName());
                    AdtPlugin.printErrorToConsole(delayedLaunchInfo.getProject(), new Object[]{string9});
                    delayedLaunchInfo.setDebugMode(false);
                }
            }
        }
        return true;
    }

    private boolean simpleLaunch(DelayedLaunchInfo delayedLaunchInfo, IDevice iDevice) {
        if (!this.checkBuildInfo(delayedLaunchInfo, iDevice)) {
            AdtPlugin.printErrorToConsole(delayedLaunchInfo.getProject(), new Object[]{"Launch canceled!"});
            this.stopLaunch(delayedLaunchInfo);
            return false;
        }
        if (!this.syncApp(delayedLaunchInfo, iDevice)) {
            AdtPlugin.printErrorToConsole(delayedLaunchInfo.getProject(), new Object[]{"Launch canceled!"});
            this.stopLaunch(delayedLaunchInfo);
            return false;
        }
        this.launchApp(delayedLaunchInfo, iDevice);
        return true;
    }

    private boolean syncApp(DelayedLaunchInfo delayedLaunchInfo, IDevice iDevice) {
        boolean bl = ApkInstallManager.getInstance().isApplicationInstalled(delayedLaunchInfo.getProject(), iDevice);
        if (bl) {
            AdtPlugin.printToConsole(delayedLaunchInfo.getProject(), "Application already deployed. No need to reinstall.");
        } else if (!this.doSyncApp(delayedLaunchInfo, iDevice)) {
            return false;
        }
        for (DelayedLaunchInfo delayedLaunchInfo2 : this.getDependenciesLaunchInfo(delayedLaunchInfo)) {
            String string = String.format("Project dependency found, installing: %s", delayedLaunchInfo2.getProject().getName());
            AdtPlugin.printToConsole(delayedLaunchInfo.getProject(), string);
            if (this.syncApp(delayedLaunchInfo2, iDevice)) continue;
            return false;
        }
        return true;
    }

    private boolean doSyncApp(DelayedLaunchInfo delayedLaunchInfo, IDevice iDevice) {
        IPath iPath = delayedLaunchInfo.getPackageFile().getLocation();
        String string = iPath.lastSegment();
        try {
            String string2 = String.format("Uploading %1$s onto device '%2$s'", string, iDevice.getSerialNumber());
            AdtPlugin.printToConsole(delayedLaunchInfo.getProject(), string2);
            String string3 = iDevice.syncPackageToDevice(iPath.toOSString());
            boolean bl = this.installPackage(delayedLaunchInfo, string3, iDevice);
            iDevice.removeRemotePackage(string3);
            if (bl) {
                ApkInstallManager.getInstance().registerInstallation(delayedLaunchInfo.getProject(), iDevice);
            }
            return bl;
        }
        catch (IOException iOException) {
            String string4 = String.format("Failed to upload %1$s on device '%2$s'", string, iDevice.getSerialNumber());
            AdtPlugin.printErrorToConsole(delayedLaunchInfo.getProject(), new Object[]{string4, iOException});
            return false;
        }
    }

    public List<DelayedLaunchInfo> getDependenciesLaunchInfo(DelayedLaunchInfo delayedLaunchInfo) {
        List<IJavaProject> list;
        IJavaProject iJavaProject;
        ArrayList<DelayedLaunchInfo> arrayList = new ArrayList<DelayedLaunchInfo>();
        try {
            iJavaProject = BaseProjectHelper.getJavaProject(delayedLaunchInfo.getProject());
        }
        catch (CoreException coreException) {
            AdtPlugin.printErrorToConsole(delayedLaunchInfo.getProject(), new Object[]{coreException});
            return arrayList;
        }
        try {
            list = ProjectHelper.getAndroidProjectDependencies(iJavaProject);
        }
        catch (JavaModelException javaModelException) {
            AdtPlugin.printErrorToConsole(delayedLaunchInfo.getProject(), new Object[]{javaModelException});
            return arrayList;
        }
        for (IJavaProject iJavaProject2 : list) {
            AndroidManifestParser androidManifestParser;
            try {
                androidManifestParser = AndroidManifestParser.parse(iJavaProject2, null, true, false);
            }
            catch (CoreException coreException) {
                AdtPlugin.printErrorToConsole(delayedLaunchInfo.getProject(), new Object[]{String.format("Error parsing manifest of %s", iJavaProject2.getElementName())});
                continue;
            }
            IFile iFile = ProjectHelper.getApplicationPackage(iJavaProject2.getProject());
            if (iFile == null) continue;
            DelayedLaunchInfo delayedLaunchInfo2 = new DelayedLaunchInfo(iJavaProject2.getProject(), androidManifestParser.getPackage(), androidManifestParser.getPackage(), delayedLaunchInfo.getLaunchAction(), iFile, androidManifestParser.getDebuggable(), androidManifestParser.getApiLevelRequirement(), delayedLaunchInfo.getLaunch(), delayedLaunchInfo.getMonitor());
            arrayList.add(delayedLaunchInfo2);
        }
        return arrayList;
    }

    private boolean installPackage(DelayedLaunchInfo delayedLaunchInfo, String string, IDevice iDevice) {
        String string2 = String.format("Installing %1$s...", delayedLaunchInfo.getPackageFile().getName());
        AdtPlugin.printToConsole(delayedLaunchInfo.getProject(), string2);
        try {
            String string3 = this.doInstall(delayedLaunchInfo, string, iDevice, true);
            return this.checkInstallResult(string3, iDevice, delayedLaunchInfo, string, DelayedLaunchInfo.InstallRetryMode.ALWAYS);
        }
        catch (IOException iOException) {
            String string4 = String.format("Failed to install %1$s on device '%2$s!", delayedLaunchInfo.getPackageFile().getName(), iDevice.getSerialNumber());
            AdtPlugin.printErrorToConsole(delayedLaunchInfo.getProject(), new Object[]{string4, iOException.getMessage()});
            return false;
        }
    }

    private boolean checkInstallResult(String string, IDevice iDevice, DelayedLaunchInfo delayedLaunchInfo, String string2, DelayedLaunchInfo.InstallRetryMode installRetryMode) throws IOException {
        if (string == null) {
            AdtPlugin.printToConsole(delayedLaunchInfo.getProject(), "Success!");
            return true;
        }
        if (string.equals("INSTALL_FAILED_ALREADY_EXISTS")) {
            if (installRetryMode == DelayedLaunchInfo.InstallRetryMode.PROMPT) {
                boolean bl = AdtPlugin.displayPrompt("Application Install", "A previous installation needs to be uninstalled before the new package can be installed.\nDo you want to uninstall?");
                if (bl) {
                    installRetryMode = DelayedLaunchInfo.InstallRetryMode.ALWAYS;
                } else {
                    AdtPlugin.printErrorToConsole(delayedLaunchInfo.getProject(), new Object[]{"Installation error! The package already exists."});
                    return false;
                }
            }
            if (installRetryMode == DelayedLaunchInfo.InstallRetryMode.ALWAYS) {
                AdtPlugin.printToConsole(delayedLaunchInfo.getProject(), "Application already exists. Attempting to re-install instead...");
                String string3 = this.doInstall(delayedLaunchInfo, string2, iDevice, true);
                return this.checkInstallResult(string3, iDevice, delayedLaunchInfo, string2, DelayedLaunchInfo.InstallRetryMode.NEVER);
            }
            AdtPlugin.printErrorToConsole(delayedLaunchInfo.getProject(), new Object[]{"Installation error! The package already exists."});
        } else if (string.equals("INSTALL_FAILED_INVALID_APK")) {
            AdtPlugin.printErrorToConsole(delayedLaunchInfo.getProject(), new Object[]{"Installation failed due to invalid APK file!", "Please check logcat output for more details."});
        } else if (string.equals("INSTALL_FAILED_INVALID_URI")) {
            AdtPlugin.printErrorToConsole(delayedLaunchInfo.getProject(), new Object[]{"Installation failed due to invalid URI!", "Please check logcat output for more details."});
        } else if (string.equals("INSTALL_FAILED_COULDNT_COPY")) {
            AdtPlugin.printErrorToConsole(delayedLaunchInfo.getProject(), new Object[]{String.format("Installation failed: Could not copy %1$s to its final location!", delayedLaunchInfo.getPackageFile().getName()), "Please check logcat output for more details."});
        } else if (string.equals("INSTALL_PARSE_FAILED_INCONSISTENT_CERTIFICATES")) {
            AdtPlugin.printErrorToConsole(delayedLaunchInfo.getProject(), new Object[]{"Re-installation failed due to different application signatures.", "You must perform a full uninstall of the application. WARNING: This will remove the application data!", String.format("Please execute 'adb uninstall %1$s' in a shell.", delayedLaunchInfo.getPackageName())});
        } else {
            AdtPlugin.printErrorToConsole(delayedLaunchInfo.getProject(), new Object[]{String.format("Installation error: %1$s", string), "Please check logcat output for more details."});
        }
        return false;
    }

    private String doUninstall(IDevice iDevice, DelayedLaunchInfo delayedLaunchInfo) throws IOException {
        try {
            return iDevice.uninstallPackage(delayedLaunchInfo.getPackageName());
        }
        catch (IOException iOException) {
            String string = String.format("Failed to uninstall %1$s: %2$s", delayedLaunchInfo.getPackageName(), iOException.getMessage());
            AdtPlugin.printErrorToConsole(delayedLaunchInfo.getProject(), new Object[]{string});
            throw iOException;
        }
    }

    private String doInstall(DelayedLaunchInfo delayedLaunchInfo, String string, IDevice iDevice, boolean bl) throws IOException {
        return iDevice.installRemotePackage(string, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void launchApp(DelayedLaunchInfo delayedLaunchInfo, IDevice iDevice) {
        if (delayedLaunchInfo.isDebugMode()) {
            Object object = sListLock;
            synchronized (object) {
                if (!this.mWaitingForDebuggerApplications.contains(delayedLaunchInfo)) {
                    this.mWaitingForDebuggerApplications.add(delayedLaunchInfo);
                }
            }
        }
        if (delayedLaunchInfo.getLaunchAction().doLaunchAction(delayedLaunchInfo, iDevice)) {
            if (!delayedLaunchInfo.isDebugMode()) {
                this.stopLaunch(delayedLaunchInfo);
            }
        } else {
            this.stopLaunch(delayedLaunchInfo);
        }
    }

    private boolean launchEmulator(AndroidLaunchConfiguration androidLaunchConfiguration, AvdManager.AvdInfo avdInfo) {
        boolean bl;
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        boolean bl2 = false;
        if (androidLaunchConfiguration.mEmulatorCommandLine != null && androidLaunchConfiguration.mEmulatorCommandLine.length() > 0) {
            String[] stringArray;
            String[] stringArray2 = stringArray = androidLaunchConfiguration.mEmulatorCommandLine.split("\\s+");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                object = stringArray2[n2];
                if (((String)object).length() > 0) {
                    arrayList.add(object);
                    if (!bl2 && ((String)object).equals(FLAG_WIPE_DATA)) {
                        bl2 = true;
                    }
                }
                ++n2;
            }
        }
        boolean bl3 = bl = androidLaunchConfiguration.mWipeData && !bl2;
        if (bl && !AdtPlugin.displayPrompt("Android Launch", "Are you sure you want to wipe all user data when starting this emulator?")) {
            bl = false;
        }
        object = new ArrayList<String>();
        ((ArrayList)object).add(AdtPlugin.getOsAbsoluteEmulator());
        ((ArrayList)object).add(FLAG_AVD);
        ((ArrayList)object).add(avdInfo.getName());
        if (androidLaunchConfiguration.mNetworkSpeed != null) {
            ((ArrayList)object).add(FLAG_NETSPEED);
            ((ArrayList)object).add(androidLaunchConfiguration.mNetworkSpeed);
        }
        if (androidLaunchConfiguration.mNetworkDelay != null) {
            ((ArrayList)object).add(FLAG_NETDELAY);
            ((ArrayList)object).add(androidLaunchConfiguration.mNetworkDelay);
        }
        if (bl) {
            ((ArrayList)object).add(FLAG_WIPE_DATA);
        }
        if (androidLaunchConfiguration.mNoBootAnim) {
            ((ArrayList)object).add(FLAG_NO_BOOT_ANIM);
        }
        ((ArrayList)object).addAll(arrayList);
        String[] stringArray = ((ArrayList)object).toArray(new String[((ArrayList)object).size()]);
        try {
            Process process = Runtime.getRuntime().exec(stringArray);
            this.grabEmulatorOutput(process);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    private static ILaunchConfiguration findConfig(ILaunchManager iLaunchManager, ILaunchConfigurationType iLaunchConfigurationType, String string) {
        try {
            ILaunchConfiguration[] iLaunchConfigurationArray;
            ILaunchConfiguration[] iLaunchConfigurationArray2 = iLaunchConfigurationArray = iLaunchManager.getLaunchConfigurations(iLaunchConfigurationType);
            int n = iLaunchConfigurationArray.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration iLaunchConfiguration = iLaunchConfigurationArray2[n2];
                if (iLaunchConfiguration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "").equals(string)) {
                    return iLaunchConfiguration;
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {
            MessageDialog.openError((Shell)AdtPlugin.getDisplay().getActiveShell(), (String)"Launch Error", (String)coreException.getStatus().getMessage());
        }
        return null;
    }

    public static boolean connectRemoteDebugger(int n, AndroidLaunch androidLaunch, IProgressMonitor iProgressMonitor) throws CoreException {
        int n2 = JavaRuntime.getPreferences().getInt(JavaRuntime.PREF_CONNECT_TIMEOUT);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("hostname", "localhost");
        hashMap.put("port", Integer.toString(n));
        hashMap.put("timeout", Integer.toString(n2));
        IVMConnector iVMConnector = JavaRuntime.getDefaultVMConnector();
        iVMConnector.connect(hashMap, iProgressMonitor, (ILaunch)androidLaunch);
        if (iProgressMonitor.isCanceled()) {
            IDebugTarget[] iDebugTargetArray;
            IDebugTarget[] iDebugTargetArray2 = iDebugTargetArray = androidLaunch.getDebugTargets();
            int n3 = iDebugTargetArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IDebugTarget iDebugTarget = iDebugTargetArray2[n4];
                if (iDebugTarget.canDisconnect()) {
                    iDebugTarget.disconnect();
                }
                ++n4;
            }
            return false;
        }
        return true;
    }

    public static void launchRemoteDebugger(final int n, final AndroidLaunch androidLaunch, final IProgressMonitor iProgressMonitor) {
        new Thread("Debugger connection"){

            public void run() {
                try {
                    AndroidLaunchController.connectRemoteDebugger(n, androidLaunch, iProgressMonitor);
                }
                catch (CoreException coreException) {
                    androidLaunch.stopLaunch();
                }
                iProgressMonitor.done();
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bridgeChanged(AndroidDebugBridge androidDebugBridge) {
        String string = "adb server change: cancelling '%1$s'!";
        Object object = sListLock;
        synchronized (object) {
            for (DelayedLaunchInfo delayedLaunchInfo : this.mWaitingForReadyEmulatorList) {
                AdtPlugin.printErrorToConsole(delayedLaunchInfo.getProject(), new Object[]{String.format(string, delayedLaunchInfo.getLaunchAction().getLaunchDescription())});
                this.stopLaunch(delayedLaunchInfo);
            }
            for (DelayedLaunchInfo delayedLaunchInfo : this.mWaitingForDebuggerApplications) {
                AdtPlugin.printErrorToConsole(delayedLaunchInfo.getProject(), new Object[]{String.format(string, delayedLaunchInfo.getLaunchAction().getLaunchDescription())});
                this.stopLaunch(delayedLaunchInfo);
            }
            this.mWaitingForReadyEmulatorList.clear();
            this.mWaitingForDebuggerApplications.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deviceConnected(IDevice iDevice) {
        Object object = sListLock;
        synchronized (object) {
            if (this.mWaitingForEmulatorLaunches.size() > 0) {
                DelayedLaunchInfo delayedLaunchInfo = this.mWaitingForEmulatorLaunches.get(0);
                this.mWaitingForEmulatorLaunches.remove(0);
                delayedLaunchInfo.setDevice(iDevice);
                this.mWaitingForReadyEmulatorList.add(delayedLaunchInfo);
                AdtPlugin.printToConsole(delayedLaunchInfo.getProject(), String.format("New emulator found: %1$s", iDevice.getSerialNumber()));
                AdtPlugin.printToConsole(delayedLaunchInfo.getProject(), String.format("Waiting for HOME ('%1$s') to be launched...", AdtPlugin.getDefault().getPreferenceStore().getString("com.android.ide.eclipse.adt.homePackage")));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deviceDisconnected(IDevice iDevice) {
        String string = "%1$s disconnected! Cancelling '%2$s'!";
        Object object = sListLock;
        synchronized (object) {
            ArrayList arrayList = (ArrayList)this.mWaitingForReadyEmulatorList.clone();
            for (DelayedLaunchInfo delayedLaunchInfo : arrayList) {
                if (delayedLaunchInfo.getDevice() != iDevice) continue;
                AdtPlugin.printErrorToConsole(delayedLaunchInfo.getProject(), new Object[]{String.format(string, iDevice.getSerialNumber(), delayedLaunchInfo.getLaunchAction().getLaunchDescription())});
                this.stopLaunch(delayedLaunchInfo);
            }
            arrayList = (ArrayList)this.mWaitingForDebuggerApplications.clone();
            for (DelayedLaunchInfo delayedLaunchInfo : arrayList) {
                if (delayedLaunchInfo.getDevice() != iDevice) continue;
                AdtPlugin.printErrorToConsole(delayedLaunchInfo.getProject(), new Object[]{String.format(string, iDevice.getSerialNumber(), delayedLaunchInfo.getLaunchAction().getLaunchDescription())});
                this.stopLaunch(delayedLaunchInfo);
            }
        }
    }

    public void deviceChanged(IDevice iDevice, int n) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clientChanged(final Client client, int n) {
        Object object;
        Object object2;
        Object object3;
        String string;
        boolean bl = false;
        if ((n & 1) == 1 && (string = client.getClientData().getClientDescription()) != null) {
            object3 = AdtPlugin.getDefault().getPreferenceStore();
            object2 = object3.getString("com.android.ide.eclipse.adt.homePackage");
            if (((String)object2).equals(string)) {
                object = client.getDevice();
                Object object4 = sListLock;
                synchronized (object4) {
                    int n2 = 0;
                    while (n2 < this.mWaitingForReadyEmulatorList.size()) {
                        DelayedLaunchInfo delayedLaunchInfo = this.mWaitingForReadyEmulatorList.get(n2);
                        if (delayedLaunchInfo.getDevice() == object) {
                            this.mWaitingForReadyEmulatorList.remove(n2);
                            if (!this.checkBuildInfo(delayedLaunchInfo, (IDevice)object)) {
                                AdtPlugin.printErrorToConsole(delayedLaunchInfo.getProject(), new Object[]{"Launch canceled!"});
                                this.stopLaunch(delayedLaunchInfo);
                                return;
                            }
                            AdtPlugin.printToConsole(delayedLaunchInfo.getProject(), String.format("HOME is up on device '%1$s'", object.getSerialNumber()));
                            if (this.syncApp(delayedLaunchInfo, (IDevice)object)) {
                                this.launchApp(delayedLaunchInfo, (IDevice)object);
                                break;
                            }
                            AdtPlugin.printErrorToConsole(delayedLaunchInfo.getProject(), new Object[]{"Launch canceled!"});
                            this.stopLaunch(delayedLaunchInfo);
                            break;
                        }
                        ++n2;
                    }
                }
            }
            if (client.getClientData().getDebuggerConnectionStatus() == 2) {
                object = sListLock;
                synchronized (object) {
                    int n3 = this.mUnknownClientsWaitingForDebugger.indexOf(client);
                    if (n3 != -1) {
                        bl = true;
                        this.mUnknownClientsWaitingForDebugger.remove(client);
                    }
                }
            }
        }
        if ((n & 2) == 2) {
            string = client.getClientData();
            object3 = client.getClientData().getClientDescription();
            if (string.getDebuggerConnectionStatus() == 2) {
                if (object3 == null) {
                    object2 = sListLock;
                    synchronized (object2) {
                        this.mUnknownClientsWaitingForDebugger.add(client);
                    }
                    return;
                }
                bl = true;
            }
        }
        if (bl) {
            Log.d((String)"adt", (String)("Debugging " + client));
            string = client.getClientData().getClientDescription();
            Log.d((String)"adt", (String)("App Name: " + string));
            object3 = sListLock;
            synchronized (object3) {
                int n4 = 0;
                while (n4 < this.mWaitingForDebuggerApplications.size()) {
                    object = this.mWaitingForDebuggerApplications.get(n4);
                    if (client.getDevice() == ((DelayedLaunchInfo)object).getDevice() && string.equals(((DelayedLaunchInfo)object).getDebugPackageName())) {
                        this.mWaitingForDebuggerApplications.remove(n4);
                        String string2 = String.format("Attempting to connect debugger to '%1$s' on port %2$d", ((DelayedLaunchInfo)object).getDebugPackageName(), client.getDebuggerListenPort());
                        AdtPlugin.printToConsole(((DelayedLaunchInfo)object).getProject(), string2);
                        new Thread("Debugger Connection", (DelayedLaunchInfo)object){
                            private final /* synthetic */ DelayedLaunchInfo val$launchInfo;
                            {
                                this.val$launchInfo = delayedLaunchInfo;
                                super(string);
                            }

                            public void run() {
                                try {
                                    if (!AndroidLaunchController.connectRemoteDebugger(client.getDebuggerListenPort(), this.val$launchInfo.getLaunch(), this.val$launchInfo.getMonitor())) {
                                        return;
                                    }
                                }
                                catch (CoreException coreException) {
                                    AdtPlugin.printErrorToConsole(this.val$launchInfo.getProject(), new Object[]{String.format("Launch error: %s", coreException.getMessage())});
                                    AndroidLaunchController.this.stopLaunch(this.val$launchInfo);
                                }
                                this.val$launchInfo.getMonitor().done();
                            }
                        }.start();
                        return;
                    }
                    ++n4;
                }
            }
            object3 = ProjectHelper.findAndroidProjectByAppName(string);
            if (object3 != null) {
                AndroidLaunchController.debugRunningApp((IProject)object3, client.getDebuggerListenPort());
            }
        }
    }

    private void grabEmulatorOutput(final Process process) {
        new Thread(""){

            public void run() {
                InputStreamReader inputStreamReader = new InputStreamReader(process.getErrorStream());
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                try {
                    String string;
                    while ((string = bufferedReader.readLine()) != null) {
                        AdtPlugin.printErrorToConsole("Emulator", string);
                    }
                }
                catch (IOException iOException) {}
            }
        }.start();
        new Thread(""){

            public void run() {
                InputStreamReader inputStreamReader = new InputStreamReader(process.getInputStream());
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                try {
                    String string;
                    while ((string = bufferedReader.readLine()) != null) {
                        AdtPlugin.printToConsole("Emulator", string);
                    }
                }
                catch (IOException iOException) {}
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopLaunch(DelayedLaunchInfo delayedLaunchInfo) {
        delayedLaunchInfo.getLaunch().stopLaunch();
        Object object = sListLock;
        synchronized (object) {
            this.mWaitingForReadyEmulatorList.remove(delayedLaunchInfo);
            this.mWaitingForDebuggerApplications.remove(delayedLaunchInfo);
        }
    }
}

