/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.uimodel;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.editors.AndroidEditor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.AttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.ElementDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.SeparatorAttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.TextAttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.XmlnsAttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.layout.descriptors.CustomViewDescriptorService;
import com.android.ide.eclipse.adt.internal.editors.uimodel.IUiSettableAttributeNode;
import com.android.ide.eclipse.adt.internal.editors.uimodel.IUiUpdateListener;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiAttributeNode;
import com.android.ide.eclipse.adt.internal.sdk.AndroidTargetData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UiElementNode
implements IPropertySource {
    private static String[] ID_PREFIXES = new String[]{"@android:id/", "@+id/", "@id/", "@+", "@"};
    private ElementDescriptor mDescriptor;
    private UiElementNode mUiParent;
    private AndroidEditor mEditor;
    private Document mXmlDocument;
    private Node mXmlNode;
    private ArrayList<UiElementNode> mUiChildren;
    private HashMap<AttributeDescriptor, UiAttributeNode> mUiAttributes;
    private HashSet<UiAttributeNode> mUnknownUiAttributes;
    private List<UiElementNode> mReadOnlyUiChildren;
    private Collection<UiAttributeNode> mReadOnlyUiAttributes;
    private Map<String, AttributeDescriptor> mCachedHiddenAttributes;
    private ArrayList<IUiUpdateListener> mUiUpdateListeners;
    private boolean mHasError;
    private Object mEditData;

    public UiElementNode(ElementDescriptor elementDescriptor) {
        this.mDescriptor = elementDescriptor;
        this.clearContent();
    }

    void clearContent() {
        this.mXmlNode = null;
        this.mXmlDocument = null;
        this.mEditor = null;
        this.clearAttributes();
        this.mReadOnlyUiChildren = null;
        if (this.mUiChildren == null) {
            this.mUiChildren = new ArrayList();
        } else {
            int n = this.mUiChildren.size() - 1;
            while (n >= 0) {
                this.removeUiChildAtIndex(n);
                --n;
            }
        }
    }

    private void clearAttributes() {
        this.mUiAttributes = null;
        this.mReadOnlyUiAttributes = null;
        this.mCachedHiddenAttributes = null;
        this.mUnknownUiAttributes = new HashSet();
    }

    private HashMap<AttributeDescriptor, UiAttributeNode> getInternalUiAttributes() {
        if (this.mUiAttributes == null) {
            AttributeDescriptor[] attributeDescriptorArray = this.getAttributeDescriptors();
            this.mUiAttributes = new HashMap(attributeDescriptorArray.length);
            AttributeDescriptor[] attributeDescriptorArray2 = attributeDescriptorArray;
            int n = attributeDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                AttributeDescriptor attributeDescriptor = attributeDescriptorArray2[n2];
                UiAttributeNode uiAttributeNode = attributeDescriptor.createUiNode(this);
                if (uiAttributeNode != null) {
                    this.mUiAttributes.put(attributeDescriptor, uiAttributeNode);
                }
                ++n2;
            }
        }
        return this.mUiAttributes;
    }

    public String getShortDescription() {
        if (this.mXmlNode != null && this.mXmlNode instanceof Element && this.mXmlNode.hasAttributes()) {
            Element element = (Element)this.mXmlNode;
            String string = element.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
            if (string == null || string.length() == 0) {
                string = element.getAttributeNS("http://schemas.android.com/apk/res/android", "label");
            }
            if (string == null || string.length() == 0) {
                string = element.getAttributeNS("http://schemas.android.com/apk/res/android", "key");
            }
            if (string == null || string.length() == 0) {
                string = element.getAttribute("name");
            }
            if ((string == null || string.length() == 0) && (string = element.getAttributeNS("http://schemas.android.com/apk/res/android", "id")) != null && string.length() > 0) {
                String[] stringArray = ID_PREFIXES;
                int n = ID_PREFIXES.length;
                int n2 = 0;
                while (n2 < n) {
                    String string2 = stringArray[n2];
                    if (string.startsWith(string2)) {
                        string = string.substring(string2.length());
                        break;
                    }
                    ++n2;
                }
            }
            if (string != null && string.length() > 0) {
                return String.format("%1$s (%2$s)", string, this.mDescriptor.getUiName());
            }
        }
        return String.format("%1$s", this.mDescriptor.getUiName());
    }

    public String getBreadcrumbTrailDescription(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(this.getShortDescription());
        UiElementNode uiElementNode = this.getUiParent();
        while (uiElementNode != null) {
            if (!bl && uiElementNode.getUiParent() == null) break;
            stringBuilder.insert(0, String.format("%1$s > ", uiElementNode.getShortDescription()));
            uiElementNode = uiElementNode.getUiParent();
        }
        return stringBuilder.toString();
    }

    public void setXmlDocument(Document document) {
        if (this.mUiParent == null) {
            this.mXmlDocument = document;
        } else {
            this.mUiParent.setXmlDocument(document);
        }
    }

    public Document getXmlDocument() {
        if (this.mXmlDocument != null) {
            return this.mXmlDocument;
        }
        if (this.mUiParent != null) {
            return this.mUiParent.getXmlDocument();
        }
        return null;
    }

    public Node getXmlNode() {
        return this.mXmlNode;
    }

    public ElementDescriptor getDescriptor() {
        return this.mDescriptor;
    }

    public AttributeDescriptor[] getAttributeDescriptors() {
        return this.mDescriptor.getAttributes();
    }

    private Map<String, AttributeDescriptor> getHiddenAttributeDescriptors() {
        if (this.mCachedHiddenAttributes == null) {
            this.mCachedHiddenAttributes = new HashMap<String, AttributeDescriptor>();
            AttributeDescriptor[] attributeDescriptorArray = this.getAttributeDescriptors();
            int n = attributeDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                AttributeDescriptor attributeDescriptor = attributeDescriptorArray[n2];
                if (attributeDescriptor instanceof XmlnsAttributeDescriptor) {
                    this.mCachedHiddenAttributes.put(((XmlnsAttributeDescriptor)attributeDescriptor).getXmlNsName(), attributeDescriptor);
                }
                ++n2;
            }
        }
        return this.mCachedHiddenAttributes;
    }

    protected void setUiParent(UiElementNode uiElementNode) {
        this.mUiParent = uiElementNode;
        this.clearAttributes();
    }

    public UiElementNode getUiParent() {
        return this.mUiParent;
    }

    public UiElementNode getUiRoot() {
        UiElementNode uiElementNode = this;
        while (uiElementNode.mUiParent != null) {
            uiElementNode = uiElementNode.mUiParent;
        }
        return uiElementNode;
    }

    public UiElementNode getUiPreviousSibling() {
        List<UiElementNode> list;
        if (this.mUiParent != null && (list = this.mUiParent.getUiChildren()) != null && list.size() > 1 && list.get(0) != this) {
            int n = list.indexOf(this);
            return n > 0 ? list.get(n - 1) : null;
        }
        return null;
    }

    public UiElementNode getUiNextSibling() {
        int n;
        List<UiElementNode> list;
        if (this.mUiParent != null && (list = this.mUiParent.getUiChildren()) != null && (n = list.size()) > 1 && list.get(n - 1) != this) {
            int n2 = list.indexOf(this);
            return n2 >= 0 && n2 < n - 1 ? list.get(n2 + 1) : null;
        }
        return null;
    }

    public void setEditor(AndroidEditor androidEditor) {
        if (this.mUiParent == null) {
            this.mEditor = androidEditor;
        } else {
            this.mUiParent.setEditor(androidEditor);
        }
    }

    public AndroidEditor getEditor() {
        return this.mUiParent == null ? this.mEditor : this.mUiParent.getEditor();
    }

    public AndroidTargetData getAndroidTarget() {
        return this.getEditor().getTargetData();
    }

    public List<UiElementNode> getUiChildren() {
        if (this.mReadOnlyUiChildren == null) {
            this.mReadOnlyUiChildren = Collections.unmodifiableList(this.mUiChildren);
        }
        return this.mReadOnlyUiChildren;
    }

    public Collection<UiAttributeNode> getUiAttributes() {
        if (this.mReadOnlyUiAttributes == null) {
            this.mReadOnlyUiAttributes = Collections.unmodifiableCollection(this.getInternalUiAttributes().values());
        }
        return this.mReadOnlyUiAttributes;
    }

    public Collection<UiAttributeNode> getUnknownUiAttributes() {
        return Collections.unmodifiableCollection(this.mUnknownUiAttributes);
    }

    public final void setHasError(boolean bl) {
        this.mHasError = bl;
    }

    public final boolean hasError() {
        if (this.mHasError) {
            return true;
        }
        Collection<UiAttributeNode> collection = this.getInternalUiAttributes().values();
        for (UiAttributeNode object : collection) {
            if (!object.hasError()) continue;
            return true;
        }
        for (UiElementNode uiElementNode : this.mUiChildren) {
            if (!uiElementNode.hasError()) continue;
            return true;
        }
        return false;
    }

    public void addUpdateListener(IUiUpdateListener iUiUpdateListener) {
        if (this.mUiUpdateListeners == null) {
            this.mUiUpdateListeners = new ArrayList();
        }
        if (!this.mUiUpdateListeners.contains(iUiUpdateListener)) {
            this.mUiUpdateListeners.add(iUiUpdateListener);
        }
    }

    public void removeUpdateListener(IUiUpdateListener iUiUpdateListener) {
        if (this.mUiUpdateListeners != null) {
            this.mUiUpdateListeners.remove(iUiUpdateListener);
        }
    }

    public UiElementNode findUiChildNode(String string) {
        String[] stringArray = string.split("/");
        UiElementNode uiElementNode = this;
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray2[n2];
            boolean bl = false;
            for (UiElementNode uiElementNode2 : uiElementNode.mUiChildren) {
                if (!uiElementNode2.getDescriptor().getXmlName().equals(string2)) continue;
                uiElementNode = uiElementNode2;
                bl = true;
                break;
            }
            if (!bl) {
                return null;
            }
            ++n2;
        }
        return uiElementNode;
    }

    public UiElementNode findXmlNode(Node node) {
        if (node == null) {
            return null;
        }
        if (this.getXmlNode() == node) {
            return this;
        }
        for (UiElementNode uiElementNode : this.mUiChildren) {
            UiElementNode uiElementNode2 = uiElementNode.findXmlNode(node);
            if (uiElementNode2 == null) continue;
            return uiElementNode2;
        }
        return null;
    }

    public UiAttributeNode findUiAttribute(AttributeDescriptor attributeDescriptor) {
        return this.getInternalUiAttributes().get(attributeDescriptor);
    }

    public boolean loadFromXmlNode(Node node) {
        boolean bl = this.mXmlNode != node;
        this.mXmlNode = node;
        if (node != null) {
            this.updateAttributeList(node);
            this.invokeUiUpdateListeners((bl |= this.updateElementList(node)) ? IUiUpdateListener.UiUpdateState.CHILDREN_CHANGED : IUiUpdateListener.UiUpdateState.ATTR_UPDATED);
        }
        return bl;
    }

    public void reloadFromXmlNode(Node node) {
        AndroidEditor androidEditor = this.getEditor();
        this.clearContent();
        this.setEditor(androidEditor);
        if (node != null) {
            this.setXmlDocument(node.getOwnerDocument());
        }
        this.loadFromXmlNode(node);
    }

    public Node prepareCommit() {
        if (this.getDescriptor().isMandatory()) {
            this.createXmlNode();
        }
        return this.getXmlNode();
    }

    public void commit() {
        for (UiAttributeNode uiAttributeNode : this.getInternalUiAttributes().values()) {
            uiAttributeNode.commit();
        }
        for (UiAttributeNode uiAttributeNode : this.mUnknownUiAttributes) {
            uiAttributeNode.commit();
        }
    }

    public boolean isDirty() {
        for (UiAttributeNode uiAttributeNode : this.getInternalUiAttributes().values()) {
            if (!uiAttributeNode.isDirty()) continue;
            return true;
        }
        for (UiAttributeNode uiAttributeNode : this.mUnknownUiAttributes) {
            if (!uiAttributeNode.isDirty()) continue;
            return true;
        }
        return false;
    }

    public Node createXmlNode() {
        if (this.mXmlNode != null) {
            return null;
        }
        Node node = null;
        if (this.mUiParent != null && (node = this.mUiParent.prepareCommit()) == null) {
            return null;
        }
        String string = this.getDescriptor().getXmlName();
        Document document = this.getXmlDocument();
        if (document == null) {
            throw new RuntimeException(String.format("Missing XML document for %1$s XML node.", string));
        }
        if (node == null) {
            node = document;
        }
        this.mXmlNode = document.createElement(string);
        Node node2 = null;
        UiElementNode uiElementNode = this.getUiNextSibling();
        if (uiElementNode != null) {
            node2 = uiElementNode.getXmlNode();
        }
        node.insertBefore(this.mXmlNode, node2);
        Text text = document.createTextNode("\n");
        node.appendChild(text);
        AttributeDescriptor[] attributeDescriptorArray = this.getAttributeDescriptors();
        int n = attributeDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object;
            AttributeDescriptor attributeDescriptor = attributeDescriptorArray[n2];
            if (attributeDescriptor instanceof XmlnsAttributeDescriptor) {
                object = (XmlnsAttributeDescriptor)attributeDescriptor;
                Attr attr = document.createAttributeNS("http://www.w3.org/2000/xmlns/", ((XmlnsAttributeDescriptor)object).getXmlNsName());
                attr.setValue(((XmlnsAttributeDescriptor)object).getValue());
                attr.setPrefix(((XmlnsAttributeDescriptor)object).getXmlNsPrefix());
                this.mXmlNode.getAttributes().setNamedItemNS(attr);
            } else {
                object = this.getInternalUiAttributes().get(attributeDescriptor);
                this.commitAttributeToXml((UiAttributeNode)object, ((UiAttributeNode)object).getCurrentValue());
            }
            ++n2;
        }
        this.invokeUiUpdateListeners(IUiUpdateListener.UiUpdateState.CREATED);
        return this.mXmlNode;
    }

    public Node deleteXmlNode() {
        if (this.mXmlNode == null) {
            return null;
        }
        Node node = this.mXmlNode;
        this.clearContent();
        Node node2 = node.getParentNode();
        if (node2 == null) {
            node2 = this.getXmlDocument();
        }
        node = node2.removeChild(node);
        this.invokeUiUpdateListeners(IUiUpdateListener.UiUpdateState.DELETED);
        return node;
    }

    protected boolean updateElementList(Node node) {
        boolean bl = false;
        int n = 0;
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            if (node2.getNodeType() == 1) {
                Object object;
                String string = node2.getNodeName();
                Object object2 = null;
                if (this.mUiChildren.size() <= n) {
                    object = this.mDescriptor.findChildrenDescriptor(string, false);
                    if (object == null) {
                        AndroidEditor androidEditor = this.getEditor();
                        IEditorInput iEditorInput = androidEditor.getEditorInput();
                        if (iEditorInput instanceof IFileEditorInput) {
                            IFileEditorInput iFileEditorInput = (IFileEditorInput)iEditorInput;
                            object = CustomViewDescriptorService.getInstance().getDescriptor(iFileEditorInput.getFile().getProject(), string);
                            if (object == null) {
                                object = new ElementDescriptor(string);
                            }
                        } else {
                            object = new ElementDescriptor(string);
                        }
                    }
                    bl = true;
                    object2 = this.appendNewUiChild((ElementDescriptor)object);
                    ++n;
                } else {
                    int n2 = this.mUiChildren.size();
                    int n3 = n;
                    while (n3 < n2) {
                        object = this.mUiChildren.get(n3);
                        if (((UiElementNode)object).getXmlNode() != null && ((UiElementNode)object).getXmlNode() == node2) {
                            if (n3 > n) {
                                this.mUiChildren.remove(n3);
                                this.mUiChildren.add(n, (UiElementNode)object);
                                bl = true;
                            }
                            object2 = object;
                            ++n;
                            break;
                        }
                        ++n3;
                    }
                    if (object2 == null) {
                        n3 = n;
                        while (n3 < n2) {
                            object = this.mUiChildren.get(n3);
                            if (((UiElementNode)object).getXmlNode() == null && ((UiElementNode)object).getDescriptor().isMandatory() && ((UiElementNode)object).getDescriptor().getXmlName().equals(string)) {
                                if (n3 > n) {
                                    this.mUiChildren.remove(n3);
                                    this.mUiChildren.add(n, (UiElementNode)object);
                                }
                                ((UiElementNode)object).mXmlNode = node2;
                                bl = true;
                                object2 = object;
                                ++n;
                            }
                            ++n3;
                        }
                    }
                    if (object2 == null) {
                        ElementDescriptor elementDescriptor = this.mDescriptor.findChildrenDescriptor(string, false);
                        if (elementDescriptor == null) {
                            AdtPlugin.log(2, "AndroidManifest: Ignoring unknown '%s' XML element", string);
                        } else {
                            bl = true;
                            object2 = this.insertNewUiChild(n, elementDescriptor);
                            ++n;
                        }
                    }
                }
                if (object2 != null) {
                    bl |= ((UiElementNode)object2).loadFromXmlNode(node2);
                }
            }
            node2 = node2.getNextSibling();
        }
        int n4 = this.mUiChildren.size() - 1;
        while (n4 >= n) {
            bl |= this.removeUiChildAtIndex(n4);
            --n4;
        }
        return bl;
    }

    private boolean removeUiChildAtIndex(int n) {
        UiElementNode uiElementNode = this.mUiChildren.get(n);
        this.invokeUiUpdateListeners(IUiUpdateListener.UiUpdateState.DELETED);
        if (uiElementNode.getDescriptor().isMandatory()) {
            boolean bl = uiElementNode.getXmlNode() != null;
            uiElementNode.clearContent();
            return bl;
        }
        this.mUiChildren.remove(n);
        return true;
    }

    public UiElementNode appendNewUiChild(ElementDescriptor elementDescriptor) {
        UiElementNode uiElementNode = elementDescriptor.createUiNode();
        this.mUiChildren.add(uiElementNode);
        uiElementNode.setUiParent(this);
        uiElementNode.invokeUiUpdateListeners(IUiUpdateListener.UiUpdateState.CREATED);
        return uiElementNode;
    }

    public UiElementNode insertNewUiChild(int n, ElementDescriptor elementDescriptor) {
        UiElementNode uiElementNode = elementDescriptor.createUiNode();
        this.mUiChildren.add(n, uiElementNode);
        uiElementNode.setUiParent(this);
        uiElementNode.invokeUiUpdateListeners(IUiUpdateListener.UiUpdateState.CREATED);
        return uiElementNode;
    }

    protected void updateAttributeList(Node node) {
        Object object;
        NamedNodeMap namedNodeMap = node.getAttributes();
        HashSet<Object> hashSet = new HashSet<Object>();
        for (UiAttributeNode object22 : this.getInternalUiAttributes().values()) {
            AttributeDescriptor n = object22.getDescriptor();
            if (n instanceof SeparatorAttributeDescriptor) continue;
            object = namedNodeMap == null ? null : namedNodeMap.getNamedItemNS(n.getNamespaceUri(), n.getXmlLocalName());
            object22.updateValue((Node)object);
            hashSet.add(object);
        }
        HashSet hashSet2 = (HashSet)this.mUnknownUiAttributes.clone();
        Map<String, AttributeDescriptor> map = this.getHiddenAttributeDescriptors();
        if (namedNodeMap != null) {
            int uiAttributeNode = 0;
            while (uiAttributeNode < namedNodeMap.getLength()) {
                String string;
                object = namedNodeMap.item(uiAttributeNode);
                if (!hashSet.contains(object) && !map.containsKey(string = object.getNodeName())) {
                    String string2 = object.getLocalName();
                    String string3 = object.getNamespaceURI();
                    UiAttributeNode uiAttributeNode2 = null;
                    for (UiAttributeNode uiAttributeNode3 : this.mUnknownUiAttributes) {
                        String string4 = uiAttributeNode3.getDescriptor().getXmlLocalName();
                        String string5 = uiAttributeNode3.getDescriptor().getNamespaceUri();
                        if (!string4.equals(string2) || string5 != string3 && (string5 == null || !string5.equals(string3))) continue;
                        uiAttributeNode2 = uiAttributeNode3;
                        hashSet2.remove(uiAttributeNode3);
                        break;
                    }
                    if (uiAttributeNode2 == null) {
                        TextAttributeDescriptor textAttributeDescriptor = new TextAttributeDescriptor(string2, string, string3, "Unknown XML attribute");
                        uiAttributeNode2 = textAttributeDescriptor.createUiNode(this);
                        this.mUnknownUiAttributes.add(uiAttributeNode2);
                    }
                    uiAttributeNode2.updateValue((Node)object);
                }
                ++uiAttributeNode;
            }
            for (UiAttributeNode uiAttributeNode4 : hashSet2) {
                this.mUnknownUiAttributes.remove(uiAttributeNode4);
            }
        }
    }

    protected void invokeUiUpdateListeners(IUiUpdateListener.UiUpdateState uiUpdateState) {
        if (this.mUiUpdateListeners != null) {
            for (IUiUpdateListener iUiUpdateListener : this.mUiUpdateListeners) {
                try {
                    iUiUpdateListener.uiElementNodeUpdated(this, uiUpdateState);
                }
                catch (Exception exception) {
                    AdtPlugin.log(exception, "UIElement Listener failed: %s, state=%s", this.getBreadcrumbTrailDescription(true), uiUpdateState.toString());
                }
            }
        }
    }

    protected void setXmlNode(Node node) {
        this.mXmlNode = node;
    }

    public void setEditData(Object object) {
        this.mEditData = object;
    }

    public Object getEditData() {
        return this.mEditData;
    }

    public void refreshUi() {
        this.invokeUiUpdateListeners(IUiUpdateListener.UiUpdateState.ATTR_UPDATED);
    }

    public boolean commitAttributeToXml(UiAttributeNode uiAttributeNode, String string) {
        Node node = this.prepareCommit();
        if (node != null && uiAttributeNode != null) {
            String string2 = uiAttributeNode.getDescriptor().getXmlLocalName();
            String string3 = uiAttributeNode.getDescriptor().getNamespaceUri();
            NamedNodeMap namedNodeMap = node.getAttributes();
            if (string == null || string.length() == 0) {
                if (namedNodeMap.getNamedItemNS(string3, string2) != null) {
                    namedNodeMap.removeNamedItemNS(string3, string2);
                    return true;
                }
            } else {
                Document document = node.getOwnerDocument();
                if (document != null) {
                    Attr attr = document.createAttributeNS(string3, string2);
                    attr.setValue(string);
                    attr.setPrefix(this.lookupNamespacePrefix(node, string3));
                    namedNodeMap.setNamedItemNS(attr);
                    return true;
                }
            }
        }
        return false;
    }

    public boolean commitDirtyAttributesToXml() {
        boolean bl = false;
        HashMap<AttributeDescriptor, UiAttributeNode> hashMap = this.getInternalUiAttributes();
        for (Map.Entry<AttributeDescriptor, UiAttributeNode> entry : hashMap.entrySet()) {
            UiAttributeNode uiAttributeNode = entry.getValue();
            if (!uiAttributeNode.isDirty()) continue;
            bl |= this.commitAttributeToXml(uiAttributeNode, uiAttributeNode.getCurrentValue());
            uiAttributeNode.setDirty(false);
        }
        return bl;
    }

    private String lookupNamespacePrefix(Node node, String string) {
        Object object;
        if (string == null) {
            return null;
        }
        if ("http://www.w3.org/2000/xmlns/".equals(string)) {
            return "xmlns";
        }
        HashSet<String> hashSet = new HashSet<String>();
        Document document = node == null ? null : node.getOwnerDocument();
        while (node != null && node.getNodeType() == 1) {
            object = node.getAttributes();
            int n = object.getLength() - 1;
            while (n >= 0) {
                Node node2 = object.item(n);
                if ("xmlns".equals(node2.getPrefix())) {
                    String string2 = node2.getNodeValue();
                    String string3 = node2.getLocalName();
                    if (string.equals(string2)) {
                        return string3;
                    }
                    hashSet.add(string3);
                }
                --n;
            }
            node = node.getParentNode();
        }
        Object object2 = object = "http://schemas.android.com/apk/res/android".equals(string) ? "android" : "ns";
        int n = 1;
        while (hashSet.contains(object)) {
            object = String.valueOf(object2) + Integer.toString(n);
            ++n;
        }
        if (document != null) {
            node = document.getFirstChild();
            while (node != null && node.getNodeType() != 1) {
                node = node.getNextSibling();
            }
            if (node != null) {
                Attr attr = document.createAttributeNS("http://www.w3.org/2000/xmlns/", (String)object);
                attr.setValue(string);
                attr.setPrefix("xmlns");
                node.getAttributes().setNamedItemNS(attr);
            }
        }
        return object;
    }

    public UiAttributeNode setAttributeValue(String string, String string2, boolean bl) {
        HashMap<AttributeDescriptor, UiAttributeNode> hashMap = this.getInternalUiAttributes();
        if (string2 == null) {
            string2 = "";
        }
        for (Map.Entry<AttributeDescriptor, UiAttributeNode> entry : hashMap.entrySet()) {
            AttributeDescriptor attributeDescriptor = entry.getKey();
            if (!attributeDescriptor.getXmlLocalName().equals(string)) continue;
            UiAttributeNode uiAttributeNode = entry.getValue();
            if (!(uiAttributeNode instanceof IUiSettableAttributeNode)) break;
            String string3 = uiAttributeNode.getCurrentValue();
            if (!bl && string3 != null && string3.equals(string2)) break;
            ((IUiSettableAttributeNode)((Object)uiAttributeNode)).setCurrentValue(string2);
            uiAttributeNode.setDirty(true);
            return uiAttributeNode;
        }
        return null;
    }

    public String getAttributeValue(String string) {
        HashMap<AttributeDescriptor, UiAttributeNode> hashMap = this.getInternalUiAttributes();
        for (Map.Entry<AttributeDescriptor, UiAttributeNode> entry : hashMap.entrySet()) {
            AttributeDescriptor attributeDescriptor = entry.getKey();
            if (!attributeDescriptor.getXmlLocalName().equals(string)) continue;
            UiAttributeNode uiAttributeNode = entry.getValue();
            return uiAttributeNode.getCurrentValue();
        }
        return null;
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<IPropertyDescriptor> arrayList = new ArrayList<IPropertyDescriptor>();
        HashMap<AttributeDescriptor, UiAttributeNode> hashMap = this.getInternalUiAttributes();
        Set<AttributeDescriptor> set = hashMap.keySet();
        for (AttributeDescriptor object : set) {
            if (!(object instanceof IPropertyDescriptor)) continue;
            arrayList.add((IPropertyDescriptor)object);
        }
        for (UiAttributeNode uiAttributeNode : this.mUnknownUiAttributes) {
            if (!(uiAttributeNode.getDescriptor() instanceof IPropertyDescriptor)) continue;
            arrayList.add((IPropertyDescriptor)uiAttributeNode.getDescriptor());
        }
        return arrayList.toArray(new IPropertyDescriptor[arrayList.size()]);
    }

    public Object getPropertyValue(Object object) {
        HashMap<AttributeDescriptor, UiAttributeNode> hashMap = this.getInternalUiAttributes();
        UiAttributeNode uiAttributeNode = hashMap.get(object);
        if (uiAttributeNode == null) {
            for (UiAttributeNode uiAttributeNode2 : this.mUnknownUiAttributes) {
                if (object != uiAttributeNode2.getDescriptor()) continue;
                return uiAttributeNode2;
            }
        }
        return uiAttributeNode;
    }

    public boolean isPropertySet(Object object) {
        HashMap<AttributeDescriptor, UiAttributeNode> hashMap = this.getInternalUiAttributes();
        UiAttributeNode uiAttributeNode = hashMap.get(object);
        if (uiAttributeNode != null) {
            return uiAttributeNode.getCurrentValue().length() > 0;
        }
        for (UiAttributeNode uiAttributeNode2 : this.mUnknownUiAttributes) {
            if (object != uiAttributeNode2.getDescriptor()) continue;
            return uiAttributeNode2.getCurrentValue().length() > 0;
        }
        return false;
    }

    public void resetPropertyValue(Object object) {
        HashMap<AttributeDescriptor, UiAttributeNode> hashMap = this.getInternalUiAttributes();
        UiAttributeNode uiAttributeNode = hashMap.get(object);
        if (uiAttributeNode != null) {
            return;
        }
        for (UiAttributeNode uiAttributeNode2 : this.mUnknownUiAttributes) {
            if (object != uiAttributeNode2.getDescriptor()) continue;
            return;
        }
    }

    public void setPropertyValue(Object object, Object object2) {
        Object object3;
        Object object4;
        HashMap<AttributeDescriptor, UiAttributeNode> hashMap = this.getInternalUiAttributes();
        Object object5 = hashMap.get(object);
        if (object5 == null) {
            object4 = this.mUnknownUiAttributes.iterator();
            while (object4.hasNext()) {
                object3 = (UiAttributeNode)object4.next();
                if (object != ((UiAttributeNode)object3).getDescriptor()) continue;
                object5 = object3;
                break;
            }
        }
        if (object5 != null) {
            object3 = ((UiAttributeNode)object5).getCurrentValue();
            if (((String)object3).equals(object4 = (String)object2)) {
                return;
            }
            final UiAttributeNode uiAttributeNode = object5;
            AndroidEditor androidEditor = this.getEditor();
            androidEditor.editXmlModel(new Runnable((String)object4){
                private final /* synthetic */ String val$newValue;
                {
                    this.val$newValue = string;
                }

                public void run() {
                    UiElementNode.this.commitAttributeToXml(uiAttributeNode, this.val$newValue);
                }
            });
        }
    }
}

