/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.ui.tree;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.editors.descriptors.AttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.DescriptorsUtils;
import com.android.ide.eclipse.adt.internal.editors.descriptors.ElementDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.SeparatorAttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.XmlnsAttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.ui.SectionHelper;
import com.android.ide.eclipse.adt.internal.editors.ui.tree.UiTreeBlock;
import com.android.ide.eclipse.adt.internal.editors.uimodel.IUiUpdateListener;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiAttributeNode;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiElementNode;
import com.android.ide.eclipse.adt.internal.sdk.Sdk;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.SharedScrolledComposite;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UiElementDetail
implements IDetailsPage {
    private SectionHelper.ManifestSectionPart mMasterPart;
    private Section mMasterSection;
    private UiElementNode mCurrentUiElementNode;
    private Composite mCurrentTable;
    private boolean mIsDirty;
    private IManagedForm mManagedForm;
    private final UiTreeBlock mTree;

    public UiElementDetail(UiTreeBlock uiTreeBlock) {
        this.mTree = uiTreeBlock;
        this.mMasterPart = this.mTree.getMasterPart();
        this.mManagedForm = this.mMasterPart.getManagedForm();
    }

    public void initialize(IManagedForm iManagedForm) {
        this.mManagedForm = iManagedForm;
    }

    public void createContents(Composite composite) {
        this.mMasterSection = this.createMasterSection(composite);
    }

    public void selectionChanged(IFormPart iFormPart, ISelection iSelection) {
        ITreeSelection iTreeSelection;
        Object object;
        if (iFormPart == this.mMasterPart && !iSelection.isEmpty() && iSelection instanceof ITreeSelection && (object = (iTreeSelection = (ITreeSelection)iSelection).getFirstElement()) instanceof UiElementNode) {
            UiElementNode uiElementNode = (UiElementNode)object;
            this.createUiAttributeControls(this.mManagedForm, uiElementNode);
        }
    }

    public void commit(boolean bl) {
        IStructuredModel iStructuredModel = this.mTree.getEditor().getModelForEdit();
        try {
            try {
                iStructuredModel.aboutToChangeModel();
                if (this.mCurrentUiElementNode != null) {
                    this.mCurrentUiElementNode.commit();
                }
                this.mIsDirty = false;
            }
            catch (Exception exception) {
                AdtPlugin.log(exception, "Detail node failed to commit XML attribute!", new Object[0]);
                iStructuredModel.changedModel();
                iStructuredModel.releaseFromEdit();
            }
        }
        finally {
            iStructuredModel.changedModel();
            iStructuredModel.releaseFromEdit();
        }
    }

    public void dispose() {
    }

    public boolean isDirty() {
        if (this.mCurrentUiElementNode != null && this.mCurrentUiElementNode.isDirty()) {
            this.markDirty();
        }
        return this.mIsDirty;
    }

    public boolean isStale() {
        return false;
    }

    public void refresh() {
        if (this.mCurrentTable != null) {
            this.mCurrentTable.dispose();
            this.mCurrentTable = null;
        }
        this.mCurrentUiElementNode = null;
        this.mMasterSection.getParent().pack(true);
    }

    public void setFocus() {
    }

    public boolean setFormInput(Object object) {
        return false;
    }

    private Section createMasterSection(Composite composite) {
        TableWrapLayout tableWrapLayout = new TableWrapLayout();
        tableWrapLayout.topMargin = 0;
        composite.setLayout((Layout)tableWrapLayout);
        FormToolkit formToolkit = this.mManagedForm.getToolkit();
        Section section = formToolkit.createSection(composite, 256);
        section.setLayoutData((Object)new TableWrapData(256, 16));
        return section;
    }

    private void createUiAttributeControls(IManagedForm iManagedForm, final UiElementNode uiElementNode) {
        block15: {
            Composite composite;
            Object object;
            ElementDescriptor elementDescriptor = uiElementNode.getDescriptor();
            this.mMasterSection.setText(String.format("Attributes for %1$s", uiElementNode.getShortDescription()));
            if (this.mCurrentUiElementNode == uiElementNode) break block15;
            if (this.mIsDirty) {
                this.commit(false);
            }
            if (this.mCurrentTable != null) {
                this.mCurrentTable.dispose();
                this.mCurrentTable = null;
            }
            FormText formText = uiElementNode.getAttributeDescriptors();
            boolean bl = false;
            FormText formText2 = formText;
            int n = ((AttributeDescriptor[])formText2).length;
            int n2 = 0;
            while (n2 < n) {
                object = formText2[n2];
                if (object instanceof SeparatorAttributeDescriptor) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            object = iManagedForm.getToolkit();
            this.mCurrentTable = composite = SectionHelper.createTableLayout((Composite)this.mMasterSection, object, bl ? 1 : 2);
            this.mCurrentUiElementNode = uiElementNode;
            if (elementDescriptor.getTooltip() != null) {
                String string = Sdk.getCurrent() != null && Sdk.getCurrent().getDocumentationBaseUrl() != null ? DescriptorsUtils.formatFormText(elementDescriptor.getTooltip(), elementDescriptor, Sdk.getCurrent().getDocumentationBaseUrl()) : elementDescriptor.getTooltip();
                try {
                    formText2 = SectionHelper.createFormText(composite, object, true, string, true);
                    formText2.addHyperlinkListener(this.mTree.getEditor().createHyperlinkListener());
                    Image image = elementDescriptor.getIcon();
                    if (image != null) {
                        formText2.setImage("image", image);
                    }
                }
                catch (Exception exception) {
                    AdtPlugin.log(exception, "Malformed javadoc, rejected by FormText for node %1$s: '%2$s'", uiElementNode.getDescriptor().getXmlName(), string);
                    string = DescriptorsUtils.formatTooltip(elementDescriptor.getTooltip());
                    SectionHelper.createLabel(composite, object, string, string);
                }
            }
            Composite composite2 = bl ? null : composite;
            FormText formText3 = formText;
            int n3 = ((AttributeDescriptor[])formText3).length;
            int n4 = 0;
            while (n4 < n3) {
                block16: {
                    Object object2;
                    block17: {
                        formText2 = formText3[n4];
                        if (formText2 instanceof XmlnsAttributeDescriptor) break block16;
                        if (composite2 != null && !(formText2 instanceof SeparatorAttributeDescriptor)) break block17;
                        object2 = null;
                        object2 = formText2 instanceof SeparatorAttributeDescriptor ? formText2.getXmlLocalName() : String.format("Attributes from %1$s", elementDescriptor.getUiName());
                        composite2 = this.createSubSectionTable((FormToolkit)object, composite, (String)object2);
                        if (formText2 instanceof SeparatorAttributeDescriptor) break block16;
                    }
                    if ((object2 = uiElementNode.findUiAttribute((AttributeDescriptor)formText2)) != null) {
                        ((UiAttributeNode)object2).createUiControl(composite2, iManagedForm);
                        if (((UiAttributeNode)object2).getCurrentValue() != null && ((UiAttributeNode)object2).getCurrentValue().length() > 0) {
                            ((Section)composite2.getParent()).setExpanded(true);
                        }
                    } else {
                        AdtPlugin.log(1, "Attribute %1$s not declared in node %2$s, ignored.", formText2.getXmlLocalName(), uiElementNode.getDescriptor().getXmlName());
                    }
                }
                ++n4;
            }
            formText2 = this.createSubSectionTable((FormToolkit)object, composite, "Unknown XML Attributes");
            formText2.getParent().setVisible(false);
            HashSet<UiAttributeNode> hashSet = new HashSet<UiAttributeNode>();
            final IUiUpdateListener iUiUpdateListener = new IUiUpdateListener((Composite)formText2, iManagedForm, hashSet){
                private final /* synthetic */ Composite val$unknownTable;
                private final /* synthetic */ IManagedForm val$managedForm;
                private final /* synthetic */ HashSet val$reference;
                {
                    this.val$unknownTable = composite;
                    this.val$managedForm = iManagedForm;
                    this.val$reference = hashSet;
                }

                public void uiElementNodeUpdated(UiElementNode uiElementNode, IUiUpdateListener.UiUpdateState uiUpdateState) {
                    if (uiUpdateState == IUiUpdateListener.UiUpdateState.ATTR_UPDATED) {
                        UiElementDetail.this.updateUnknownAttributesSection(uiElementNode, this.val$unknownTable, this.val$managedForm, this.val$reference);
                    }
                }
            };
            uiElementNode.addUpdateListener(iUiUpdateListener);
            formText2.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent disposeEvent) {
                    uiElementNode.removeUpdateListener(iUiUpdateListener);
                }
            });
            this.updateUnknownAttributesSection(uiElementNode, (Composite)formText2, iManagedForm, hashSet);
            this.mMasterSection.getParent().pack(true);
        }
    }

    private Composite createSubSectionTable(FormToolkit formToolkit, Composite composite, String string) {
        TableWrapData tableWrapData;
        int n = ((TableWrapLayout)composite.getLayout()).numColumns;
        if (n > 1) {
            composite = SectionHelper.createTableLayout(composite, formToolkit, 1);
            tableWrapData = new TableWrapData(256);
            tableWrapData.maxWidth = 50;
            tableWrapData.colspan = n;
            composite.setLayoutData((Object)tableWrapData);
        }
        Section section = formToolkit.createSection(composite, 258);
        section.addExpansionListener(new IExpansionListener(){

            public void expansionStateChanged(ExpansionEvent expansionEvent) {
                UiElementDetail.this.reflowMasterSection();
            }

            public void expansionStateChanging(ExpansionEvent expansionEvent) {
            }
        });
        section.setText(string);
        section.setLayoutData((Object)new TableWrapData(256, 16));
        tableWrapData = SectionHelper.createTableLayout((Composite)section, formToolkit, 2);
        return tableWrapData;
    }

    private void reflowMasterSection() {
        Section section = this.mMasterSection;
        while (section != null) {
            if (section instanceof SharedScrolledComposite) {
                ((SharedScrolledComposite)section).reflow(true);
                break;
            }
            section = section.getParent();
        }
    }

    private void updateUnknownAttributesSection(UiElementNode uiElementNode, Composite composite, IManagedForm iManagedForm, HashSet<UiAttributeNode> hashSet) {
        boolean bl;
        Collection<UiAttributeNode> collection = uiElementNode.getUnknownUiAttributes();
        Section section = (Section)composite.getParent();
        boolean bl2 = false;
        if (collection.size() > 0 && !section.isVisible()) {
            section.setVisible(true);
            bl2 = true;
        }
        boolean bl3 = bl = collection.size() != hashSet.size();
        if (!bl) {
            for (UiAttributeNode uiAttributeNode : collection) {
                if (hashSet.contains(uiAttributeNode)) continue;
                bl = true;
                break;
            }
        }
        if (bl) {
            bl2 = true;
            hashSet.clear();
            Control[] controlArray = composite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                UiAttributeNode uiAttributeNode;
                uiAttributeNode = controlArray[n2];
                uiAttributeNode.dispose();
                ++n2;
            }
            for (UiAttributeNode uiAttributeNode : collection) {
                hashSet.add(uiAttributeNode);
                uiAttributeNode.createUiControl(composite, iManagedForm);
                if (uiAttributeNode.getCurrentValue() == null || uiAttributeNode.getCurrentValue().length() <= 0) continue;
                section.setExpanded(true);
            }
        }
        if (bl2) {
            this.reflowMasterSection();
        }
    }

    private void markDirty() {
        if (!this.mIsDirty) {
            this.mIsDirty = true;
            this.mManagedForm.dirtyStateChanged();
        }
    }
}

