/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.ui;

import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.PlatformUI;

public class ErrorImageComposite
extends CompositeImageDescriptor {
    private Image mBaseImage;
    private ImageDescriptor mErrorImageDescriptor;
    private Point mSize;

    public ErrorImageComposite(Image image) {
        this.mBaseImage = image;
        this.mErrorImageDescriptor = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_ERROR_TSK");
        this.mSize = new Point(image.getBounds().width, image.getBounds().height);
    }

    protected void drawCompositeImage(int n, int n2) {
        ImageData imageData = this.mBaseImage.getImageData();
        this.drawImage(imageData, 0, 0);
        ImageData imageData2 = this.mErrorImageDescriptor.getImageData();
        if (imageData2.width == imageData.width && imageData.height == imageData.height) {
            imageData2 = imageData2.scaledTo(14, 14);
            this.drawImage(imageData2, -3, this.mSize.y - imageData2.height + 3);
        } else {
            this.drawImage(imageData2, 0, this.mSize.y - imageData2.height);
        }
    }

    protected Point getSize() {
        return this.mSize;
    }
}

