/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.resources.uimodel;

import com.android.ide.eclipse.adt.internal.editors.descriptors.TextValueDescriptor;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiElementNode;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiTextValueNode;
import java.util.regex.Pattern;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class UiColorValueNode
extends UiTextValueNode {
    private static final Pattern RGBA_REGEXP = Pattern.compile("#(?:[0-9a-fA-F]{3,4}|[0-9a-fA-F]{6}|[0-9a-fA-F]{8})");

    public UiColorValueNode(TextValueDescriptor textValueDescriptor, UiElementNode uiElementNode) {
        super(textValueDescriptor, uiElementNode);
    }

    protected void onAddValidators(final Text text) {
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                String string = text.getText();
                if (RGBA_REGEXP.matcher(string).matches()) {
                    UiColorValueNode.this.getManagedForm().getMessageManager().removeMessage((Object)text, (Control)text);
                } else {
                    UiColorValueNode.this.getManagedForm().getMessageManager().addMessage((Object)text, "Accepted color formats are one of #RGB, #ARGB, #RRGGBB or #AARRGGBB.", null, 3, (Control)text);
                }
            }
        };
        text.addModifyListener(modifyListener);
        text.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                UiColorValueNode.this.getManagedForm().getMessageManager().removeMessage((Object)text, (Control)text);
            }
        });
        modifyListener.modifyText(null);
    }
}

