/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.manifest.pages;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.editors.descriptors.DescriptorsUtils;
import com.android.ide.eclipse.adt.internal.editors.manifest.ManifestEditor;
import com.android.ide.eclipse.adt.internal.editors.ui.UiElementPart;
import com.android.ide.eclipse.adt.internal.editors.uimodel.IUiUpdateListener;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiElementNode;
import com.android.ide.eclipse.adt.internal.sdk.Sdk;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

final class ApplicationToggle
extends UiElementPart {
    private Button mCheckbox;
    private AppNodeUpdateListener mAppNodeUpdateListener;
    public boolean mInternalModification;
    private FormText mTooltipFormText;

    public ApplicationToggle(Composite composite, FormToolkit formToolkit, ManifestEditor manifestEditor, UiElementNode uiElementNode) {
        super(composite, formToolkit, manifestEditor, uiElementNode, "Application Toggle", null, 66);
    }

    public void dispose() {
        super.dispose();
        if (this.getUiElementNode() != null && this.mAppNodeUpdateListener != null) {
            this.getUiElementNode().removeUpdateListener(this.mAppNodeUpdateListener);
            this.mAppNodeUpdateListener = null;
        }
    }

    public void setUiElementNode(UiElementNode uiElementNode) {
        super.setUiElementNode(uiElementNode);
        this.updateTooltip();
        this.mAppNodeUpdateListener.uiElementNodeUpdated(this.getUiElementNode(), IUiUpdateListener.UiUpdateState.CHILDREN_CHANGED);
    }

    protected void createFormControls(IManagedForm iManagedForm) {
        FormToolkit formToolkit = iManagedForm.getToolkit();
        Composite composite = this.createTableLayout(formToolkit, 1);
        this.mTooltipFormText = this.createFormText(composite, formToolkit, true, "<form></form>", false);
        this.updateTooltip();
        this.mCheckbox = formToolkit.createButton(composite, "Define an <application> tag in the AndroidManifest.xml", 32);
        this.mCheckbox.setLayoutData((Object)new TableWrapData(256, 16));
        this.mCheckbox.setSelection(false);
        this.mCheckbox.addSelectionListener((SelectionListener)new CheckboxSelectionListener());
        this.mAppNodeUpdateListener = new AppNodeUpdateListener();
        this.getUiElementNode().addUpdateListener(this.mAppNodeUpdateListener);
        this.mAppNodeUpdateListener.uiElementNodeUpdated(this.getUiElementNode(), IUiUpdateListener.UiUpdateState.CHILDREN_CHANGED);
        this.layoutChanged();
    }

    private void updateTooltip() {
        boolean bl = false;
        String string = this.getUiElementNode().getDescriptor().getTooltip();
        if (string != null) {
            string = DescriptorsUtils.formatFormText(string, this.getUiElementNode().getDescriptor(), Sdk.getCurrent().getDocumentationBaseUrl());
            this.mTooltipFormText.setText(string, true, true);
            this.mTooltipFormText.setImage("image", AdtPlugin.getAndroidLogo());
            this.mTooltipFormText.addHyperlinkListener(this.getEditor().createHyperlinkListener());
            bl = true;
        }
        this.mTooltipFormText.setVisible(bl);
    }

    private class AppNodeUpdateListener
    implements IUiUpdateListener {
        private AppNodeUpdateListener() {
        }

        public void uiElementNodeUpdated(UiElementNode uiElementNode, IUiUpdateListener.UiUpdateState uiUpdateState) {
            try {
                boolean bl;
                ApplicationToggle.this.mInternalModification = true;
                boolean bl2 = bl = uiElementNode.getXmlNode() != null;
                if (ApplicationToggle.this.mCheckbox.getSelection() != bl) {
                    ApplicationToggle.this.mCheckbox.setSelection(bl);
                }
            }
            finally {
                ApplicationToggle.this.mInternalModification = false;
            }
        }
    }

    private class CheckboxSelectionListener
    extends SelectionAdapter {
        private Node mUndoXmlNode;
        private Node mUndoXmlParent;
        private Node mUndoXmlNextNode;
        private Node mUndoXmlNextElement;
        private Document mUndoXmlDocument;

        private CheckboxSelectionListener() {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            super.widgetSelected(selectionEvent);
            if (!ApplicationToggle.this.mInternalModification && ApplicationToggle.this.getUiElementNode() != null) {
                ApplicationToggle.this.getUiElementNode().getEditor().wrapUndoRecording(ApplicationToggle.this.mCheckbox.getSelection() ? "Create or restore Application node" : "Remove Application node", new Runnable(){

                    public void run() {
                        ApplicationToggle.this.getUiElementNode().getEditor().editXmlModel(new Runnable(){

                            public void run() {
                                if (ApplicationToggle.this.mCheckbox.getSelection()) {
                                    boolean bl = true;
                                    if (CheckboxSelectionListener.this.mUndoXmlNode != null) {
                                        boolean bl2 = bl = !CheckboxSelectionListener.this.restoreApplicationNode();
                                    }
                                    if (bl) {
                                        ApplicationToggle.this.getUiElementNode().createXmlNode();
                                    }
                                } else {
                                    CheckboxSelectionListener.this.removeApplicationNode();
                                }
                            }
                        });
                    }
                });
            }
        }

        private boolean restoreApplicationNode() {
            if (this.mUndoXmlDocument == null || this.mUndoXmlNode == null) {
                return false;
            }
            this.mUndoXmlParent = this.validateNode(this.mUndoXmlDocument, this.mUndoXmlParent);
            this.mUndoXmlNextNode = this.validateNode(this.mUndoXmlDocument, this.mUndoXmlNextNode);
            this.mUndoXmlNextElement = this.validateNode(this.mUndoXmlDocument, this.mUndoXmlNextElement);
            if (this.mUndoXmlParent == null) {
                this.mUndoXmlParent = ApplicationToggle.this.getUiElementNode().getUiParent().prepareCommit();
                this.mUndoXmlNextNode = null;
                this.mUndoXmlNextElement = null;
            }
            boolean bl = false;
            if (this.mUndoXmlParent != null) {
                Node node = this.mUndoXmlNextNode;
                if (node == null) {
                    node = this.mUndoXmlNextElement;
                }
                this.mUndoXmlParent.insertBefore(this.mUndoXmlNode, node);
                if (node == null) {
                    Text text = this.mUndoXmlDocument.createTextNode("\n");
                    this.mUndoXmlParent.insertBefore(text, null);
                }
                bl = true;
            }
            this.mUndoXmlParent = null;
            this.mUndoXmlNextNode = null;
            this.mUndoXmlNextElement = null;
            this.mUndoXmlNode = null;
            this.mUndoXmlDocument = null;
            return bl;
        }

        private Node validateNode(Node node, Node node2) {
            if (node == node2) {
                return node2;
            }
            Node node3 = node.getFirstChild();
            while (node3 != null) {
                if (node == node2 || this.validateNode(node3, node2) != null) {
                    return node2;
                }
                node3 = node3.getNextSibling();
            }
            return null;
        }

        private void removeApplicationNode() {
            Node node = ApplicationToggle.this.getUiElementNode().getXmlNode();
            if (node == null) {
                return;
            }
            this.mUndoXmlDocument = node.getOwnerDocument();
            this.mUndoXmlParent = node.getParentNode();
            this.mUndoXmlNextElement = this.mUndoXmlNextNode = node.getNextSibling();
            while (this.mUndoXmlNextElement != null && this.mUndoXmlNextElement.getNodeType() != 1) {
                this.mUndoXmlNextElement = this.mUndoXmlNextElement.getNextSibling();
            }
            this.mUndoXmlNode = ApplicationToggle.this.getUiElementNode().deleteXmlNode();
        }
    }
}

