/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.manifest.descriptors;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.editors.descriptors.AttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.DescriptorsUtils;
import com.android.ide.eclipse.adt.internal.editors.descriptors.ElementDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.IDescriptorProvider;
import com.android.ide.eclipse.adt.internal.editors.descriptors.ListAttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.ReferenceAttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.TextAttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.XmlnsAttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.manifest.descriptors.ApplicationAttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.manifest.descriptors.ClassAttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.manifest.descriptors.ManifestElementDescriptor;
import com.android.ide.eclipse.adt.internal.editors.manifest.descriptors.ManifestPkgAttrDescriptor;
import com.android.ide.eclipse.adt.internal.editors.manifest.descriptors.PackageAttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.manifest.descriptors.PostActivityCreationAction;
import com.android.ide.eclipse.adt.internal.editors.manifest.descriptors.PostReceiverCreationAction;
import com.android.ide.eclipse.adt.internal.editors.manifest.descriptors.ThemeAttributeDescriptor;
import com.android.ide.eclipse.adt.internal.resources.DeclareStyleableInfo;
import com.android.ide.eclipse.adt.internal.resources.ResourceType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AndroidManifestDescriptors
implements IDescriptorProvider {
    private static final String MANIFEST_NODE_NAME = "manifest";
    private static final String ANDROID_MANIFEST_STYLEABLE = "AndroidManifest";
    public static final String ANDROID_LABEL_ATTR = "label";
    public static final String ANDROID_NAME_ATTR = "name";
    public static final String PACKAGE_ATTR = "package";
    private final ElementDescriptor MANIFEST_ELEMENT;
    private final ElementDescriptor APPLICATION_ELEMENT = this.createElement("application", null, true);
    private final ElementDescriptor INTRUMENTATION_ELEMENT = this.createElement("instrumentation");
    private final ElementDescriptor PERMISSION_ELEMENT = this.createElement("permission");
    private final ElementDescriptor USES_PERMISSION_ELEMENT = this.createElement("uses-permission");
    private final ElementDescriptor USES_SDK_ELEMENT = this.createElement("uses-sdk", null, true);
    private final ElementDescriptor PERMISSION_GROUP_ELEMENT = this.createElement("permission-group");
    private final ElementDescriptor PERMISSION_TREE_ELEMENT = this.createElement("permission-tree");
    private final TextAttributeDescriptor PACKAGE_ATTR_DESC;

    public AndroidManifestDescriptors() {
        this.MANIFEST_ELEMENT = this.createElement(MANIFEST_NODE_NAME, new ElementDescriptor[]{this.APPLICATION_ELEMENT, this.INTRUMENTATION_ELEMENT, this.PERMISSION_ELEMENT, this.USES_PERMISSION_ELEMENT, this.PERMISSION_GROUP_ELEMENT, this.PERMISSION_TREE_ELEMENT, this.USES_SDK_ELEMENT}, true);
        this.PACKAGE_ATTR_DESC = new PackageAttributeDescriptor(PACKAGE_ATTR, "Package", null, "This attribute gives a unique name for the package, using a Java-style naming convention to avoid name collisions.\nFor example, applications published by Google could have names of the form com.google.app.appname");
    }

    @Override
    public ElementDescriptor[] getRootElementDescriptors() {
        return new ElementDescriptor[]{this.MANIFEST_ELEMENT};
    }

    @Override
    public ElementDescriptor getDescriptor() {
        return this.getManifestElement();
    }

    public ElementDescriptor getApplicationElement() {
        return this.APPLICATION_ELEMENT;
    }

    public ElementDescriptor getManifestElement() {
        return this.MANIFEST_ELEMENT;
    }

    public ElementDescriptor getUsesSdkElement() {
        return this.USES_SDK_ELEMENT;
    }

    public ElementDescriptor getInstrumentationElement() {
        return this.INTRUMENTATION_ELEMENT;
    }

    public ElementDescriptor getPermissionElement() {
        return this.PERMISSION_ELEMENT;
    }

    public ElementDescriptor getUsesPermissionElement() {
        return this.USES_PERMISSION_ELEMENT;
    }

    public ElementDescriptor getPermissionGroupElement() {
        return this.PERMISSION_GROUP_ELEMENT;
    }

    public ElementDescriptor getPermissionTreeElement() {
        return this.PERMISSION_TREE_ELEMENT;
    }

    public synchronized void updateDescriptors(Map<String, DeclareStyleableInfo> map) {
        new XmlnsAttributeDescriptor("android", "http://schemas.android.com/apk/res/android");
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("provider/authorities");
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("*/icon", new DescriptorsUtils.ITextAttributeCreator(){

            public TextAttributeDescriptor create(String string, String string2, String string3, String string4) {
                return new ReferenceAttributeDescriptor(ResourceType.DRAWABLE, string, string2, string3, string4);
            }
        });
        hashMap.put("*/theme", ThemeAttributeDescriptor.class);
        hashMap.put("*/permission", ListAttributeDescriptor.class);
        hashMap.put("*/targetPackage", ManifestPkgAttrDescriptor.class);
        hashMap.put("uses-library/name", ListAttributeDescriptor.class);
        hashMap.put("action,category,uses-permission/name", ListAttributeDescriptor.class);
        hashMap.put("application/name", ApplicationAttributeDescriptor.class);
        AndroidManifestDescriptors.overrideClassName(hashMap, "activity", "android.app.Activity");
        AndroidManifestDescriptors.overrideClassName(hashMap, "receiver", "android.content.BroadcastReceiver");
        AndroidManifestDescriptors.overrideClassName(hashMap, "service", "android.app.Service");
        AndroidManifestDescriptors.overrideClassName(hashMap, "provider", "android.content.ContentProvider");
        AndroidManifestDescriptors.overrideClassName(hashMap, "instrumentation", "android.app.Instrumentation");
        HashMap<String, ElementDescriptor> hashMap2 = new HashMap<String, ElementDescriptor>();
        hashMap2.put(this.MANIFEST_ELEMENT.getXmlLocalName(), this.MANIFEST_ELEMENT);
        hashMap2.put(this.APPLICATION_ELEMENT.getXmlLocalName(), this.APPLICATION_ELEMENT);
        hashMap2.put(this.INTRUMENTATION_ELEMENT.getXmlLocalName(), this.INTRUMENTATION_ELEMENT);
        hashMap2.put(this.PERMISSION_ELEMENT.getXmlLocalName(), this.PERMISSION_ELEMENT);
        hashMap2.put(this.USES_PERMISSION_ELEMENT.getXmlLocalName(), this.USES_PERMISSION_ELEMENT);
        hashMap2.put(this.USES_SDK_ELEMENT.getXmlLocalName(), this.USES_SDK_ELEMENT);
        hashMap2.put(this.PERMISSION_GROUP_ELEMENT.getXmlLocalName(), this.PERMISSION_GROUP_ELEMENT);
        hashMap2.put(this.PERMISSION_TREE_ELEMENT.getXmlLocalName(), this.PERMISSION_TREE_ELEMENT);
        this.inflateElement(map, hashMap, hashSet, hashMap2, this.MANIFEST_ELEMENT, ANDROID_MANIFEST_STYLEABLE);
        this.insertAttribute(this.MANIFEST_ELEMENT, this.PACKAGE_ATTR_DESC);
        this.sanityCheck(map, this.MANIFEST_ELEMENT);
    }

    private static void overrideClassName(Map<String, Object> map, String string, final String string2) {
        map.put(String.valueOf(string) + "/" + ANDROID_NAME_ATTR, new DescriptorsUtils.ITextAttributeCreator(){

            public TextAttributeDescriptor create(String string, String string22, String string3, String string4) {
                string22 = String.valueOf(string22) + "*";
                if ("android.app.Activity".equals(string2)) {
                    return new ClassAttributeDescriptor(string2, PostActivityCreationAction.getAction(), string, string22, string3, string4, true, true);
                }
                if ("android.content.BroadcastReceiver".equals(string2)) {
                    return new ClassAttributeDescriptor(string2, PostReceiverCreationAction.getAction(), string, string22, string3, string4, true, true);
                }
                if ("android.app.Instrumentation".equals(string2)) {
                    return new ClassAttributeDescriptor(string2, null, string, string22, string3, string4, true, false);
                }
                return new ClassAttributeDescriptor(string2, string, string22, string3, string4, true);
            }
        });
    }

    private ElementDescriptor createElement(String string, ElementDescriptor[] elementDescriptorArray, boolean bl) {
        String string2 = this.guessStyleName(string);
        String string3 = "/reference/android/R.styleable.html#" + string2;
        String string4 = this.getUiName(string);
        ManifestElementDescriptor manifestElementDescriptor = new ManifestElementDescriptor(string, string4, null, string3, null, elementDescriptorArray, bl);
        return manifestElementDescriptor;
    }

    private ElementDescriptor createElement(String string) {
        return this.createElement(string, null, false);
    }

    private void insertAttribute(ElementDescriptor elementDescriptor, AttributeDescriptor attributeDescriptor) {
        AttributeDescriptor[] attributeDescriptorArray;
        AttributeDescriptor[] attributeDescriptorArray2;
        AttributeDescriptor[] attributeDescriptorArray3 = attributeDescriptorArray2 = elementDescriptor.getAttributes();
        int n = attributeDescriptorArray2.length;
        int n2 = 0;
        while (n2 < n) {
            attributeDescriptorArray = attributeDescriptorArray3[n2];
            if (attributeDescriptorArray.getXmlLocalName().equals(attributeDescriptor.getXmlLocalName())) {
                return;
            }
            ++n2;
        }
        attributeDescriptorArray = new AttributeDescriptor[attributeDescriptorArray2.length + 1];
        attributeDescriptorArray[0] = attributeDescriptor;
        System.arraycopy(attributeDescriptorArray2, 0, attributeDescriptorArray, 1, attributeDescriptorArray2.length);
        elementDescriptor.setAttributes(attributeDescriptorArray);
    }

    private void inflateElement(Map<String, DeclareStyleableInfo> map, Map<String, Object> map2, Set<String> set, HashMap<String, ElementDescriptor> hashMap, ElementDescriptor elementDescriptor, String string) {
        ArrayList<AttributeDescriptor> arrayList;
        DeclareStyleableInfo declareStyleableInfo;
        assert (elementDescriptor != null);
        assert (string != null);
        DeclareStyleableInfo declareStyleableInfo2 = declareStyleableInfo = map != null ? map.get(string) : null;
        if (declareStyleableInfo != null) {
            arrayList = new ArrayList<AttributeDescriptor>();
            DescriptorsUtils.appendAttributes(arrayList, elementDescriptor.getXmlLocalName(), "http://schemas.android.com/apk/res/android", declareStyleableInfo.getAttributes(), set, map2);
            elementDescriptor.setTooltip(declareStyleableInfo.getJavaDoc());
            elementDescriptor.setAttributes(arrayList.toArray(new AttributeDescriptor[arrayList.size()]));
        }
        arrayList = new ArrayList();
        for (Map.Entry<String, DeclareStyleableInfo> entry : map.entrySet()) {
            String string2;
            DeclareStyleableInfo declareStyleableInfo3 = entry.getValue();
            boolean bl = false;
            String[] stringArray = declareStyleableInfo3.getParents();
            if (stringArray != null) {
                String[] stringArray2 = stringArray;
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    string2 = stringArray2[n2];
                    if (string.equals(string2)) {
                        bl = true;
                        break;
                    }
                    ++n2;
                }
            }
            if (!bl) continue;
            string2 = entry.getKey();
            String string3 = this.guessXmlName(string2);
            ElementDescriptor elementDescriptor2 = hashMap.get(string3);
            if (elementDescriptor2 == null) {
                elementDescriptor2 = this.createElement(string3);
                hashMap.put(string3, elementDescriptor2);
            }
            arrayList.add((AttributeDescriptor)((Object)elementDescriptor2));
            this.inflateElement(map, map2, set, hashMap, elementDescriptor2, string2);
        }
        elementDescriptor.setChildren(arrayList.toArray(new ElementDescriptor[arrayList.size()]));
    }

    private String getUiName(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (bl && c >= 'a' && c <= 'z') {
                stringBuilder.append((char)(c + 65 - 97));
                bl = false;
            } else if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z')) {
                stringBuilder.append(' ');
                bl = true;
            } else {
                stringBuilder.append(c);
            }
            ++n2;
        }
        return stringBuilder.toString();
    }

    private String guessStyleName(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!string.equals(MANIFEST_NODE_NAME)) {
            boolean bl = true;
            char[] cArray = string.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (bl && c >= 'a' && c <= 'z') {
                    stringBuilder.append((char)(c + 65 - 97));
                    bl = false;
                } else if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z')) {
                    bl = true;
                } else {
                    stringBuilder.append(c);
                }
                ++n2;
            }
        }
        stringBuilder.insert(0, ANDROID_MANIFEST_STYLEABLE);
        return stringBuilder.toString();
    }

    private void sanityCheck(Map<String, DeclareStyleableInfo> map, ElementDescriptor elementDescriptor) {
        TreeSet<String> treeSet = new TreeSet<String>();
        this.findAllElementNames(elementDescriptor, treeSet);
        TreeSet<String> treeSet2 = new TreeSet<String>();
        for (String string : map.keySet()) {
            if (!string.startsWith(ANDROID_MANIFEST_STYLEABLE)) continue;
            treeSet2.add(string);
        }
        Iterator<String> iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            String string2 = this.guessStyleName(string);
            if (!treeSet2.remove(string2)) continue;
            iterator.remove();
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (!treeSet2.isEmpty()) {
            stringBuilder.append("Warning, ADT/SDK Mismatch! The following elements are declared by the SDK but unknown to ADT: ");
            for (String string : treeSet2) {
                String string3 = this.guessXmlName(string);
                if (string3 == treeSet2.last()) continue;
                stringBuilder.append(", ");
            }
            AdtPlugin.log(2, "%s", stringBuilder.toString());
            AdtPlugin.printToConsole(null, new Object[]{stringBuilder});
            stringBuilder.setLength(0);
        }
        if (!treeSet.isEmpty()) {
            stringBuilder.append("Warning, ADT/SDK Mismatch! The following elements are declared by ADT but not by the SDK: ");
            for (String string : treeSet) {
                stringBuilder.append(string);
                if (string == treeSet.last()) continue;
                stringBuilder.append(", ");
            }
            AdtPlugin.log(2, "%s", stringBuilder.toString());
            AdtPlugin.printToConsole(null, new Object[]{stringBuilder});
        }
    }

    private String guessXmlName(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (ANDROID_MANIFEST_STYLEABLE.equals(string)) {
            stringBuilder.append(MANIFEST_NODE_NAME);
        } else {
            string = string.replace(ANDROID_MANIFEST_STYLEABLE, "");
            boolean bl = true;
            char[] cArray = string.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (c >= 'A' && c <= 'Z') {
                    if (!bl) {
                        stringBuilder.append('-');
                    }
                    c = (char)(c - 65 + 97);
                }
                stringBuilder.append(c);
                bl = false;
                ++n2;
            }
        }
        return stringBuilder.toString();
    }

    private void findAllElementNames(ElementDescriptor elementDescriptor, TreeSet<String> treeSet) {
        treeSet.add(elementDescriptor.getXmlName());
        ElementDescriptor[] elementDescriptorArray = elementDescriptor.getChildren();
        int n = elementDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            ElementDescriptor elementDescriptor2 = elementDescriptorArray[n2];
            this.findAllElementNames(elementDescriptor2, treeSet);
            ++n2;
        }
    }
}

