/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.manifest;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.editors.AndroidEditor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.ElementDescriptor;
import com.android.ide.eclipse.adt.internal.editors.manifest.descriptors.AndroidManifestDescriptors;
import com.android.ide.eclipse.adt.internal.editors.manifest.pages.ApplicationPage;
import com.android.ide.eclipse.adt.internal.editors.manifest.pages.InstrumentationPage;
import com.android.ide.eclipse.adt.internal.editors.manifest.pages.OverviewPage;
import com.android.ide.eclipse.adt.internal.editors.manifest.pages.PermissionPage;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiAttributeNode;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiElementNode;
import com.android.ide.eclipse.adt.internal.resources.manager.ResourceMonitor;
import com.android.ide.eclipse.adt.internal.sdk.AndroidTargetData;
import com.android.sdklib.xml.AndroidXPathFactory;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.part.FileEditorInput;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ManifestEditor
extends AndroidEditor {
    public static final String ID = "com.android.ide.eclipse.editors.manifest.ManifestEditor";
    private static final String EMPTY = "";
    private UiElementNode mUiManifestNode;
    private ApplicationPage mAppPage;
    private OverviewPage mOverviewPage;
    private PermissionPage mPermissionPage;
    private InstrumentationPage mInstrumentationPage;
    private ResourceMonitor.IFileListener mMarkerMonitor;

    @Override
    public void dispose() {
        super.dispose();
        ResourceMonitor.getMonitor().removeFileListener(this.mMarkerMonitor);
    }

    @Override
    public UiElementNode getUiRootNode() {
        return this.mUiManifestNode;
    }

    public AndroidManifestDescriptors getManifestDescriptors() {
        AndroidTargetData androidTargetData = this.getTargetData();
        if (androidTargetData != null) {
            return androidTargetData.getManifestDescriptors();
        }
        return null;
    }

    @Override
    public boolean isSaveAsAllowed() {
        return true;
    }

    @Override
    protected void createFormPages() {
        try {
            this.mOverviewPage = new OverviewPage(this);
            this.addPage((IFormPage)this.mOverviewPage);
            this.mAppPage = new ApplicationPage(this);
            this.addPage((IFormPage)this.mAppPage);
            this.mPermissionPage = new PermissionPage(this);
            this.addPage((IFormPage)this.mPermissionPage);
            this.mInstrumentationPage = new InstrumentationPage(this);
            this.addPage((IFormPage)this.mInstrumentationPage);
        }
        catch (PartInitException partInitException) {
            AdtPlugin.log(partInitException, "Error creating nested page", new Object[0]);
        }
    }

    protected void setInput(IEditorInput iEditorInput) {
        super.setInput(iEditorInput);
        IFile iFile = this.getInputFile();
        if (iFile != null) {
            this.startMonitoringMarkers();
            this.setPartName(String.format("%1$s Manifest", iFile.getProject().getName()));
        }
    }

    @Override
    protected void xmlModelChanged(Document document) {
        this.initUiRootNode(false);
        this.loadFromXml(document);
        super.xmlModelChanged(document);
    }

    private void loadFromXml(Document document) {
        this.mUiManifestNode.setXmlDocument(document);
        if (document != null) {
            ElementDescriptor elementDescriptor = this.mUiManifestNode.getDescriptor();
            try {
                XPath xPath = AndroidXPathFactory.newXPath();
                Node node = (Node)xPath.evaluate("/" + elementDescriptor.getXmlName(), document, XPathConstants.NODE);
                assert (node != null && node.getNodeName().equals(elementDescriptor.getXmlName()));
                this.mUiManifestNode.loadFromXmlNode(node);
            }
            catch (XPathExpressionException xPathExpressionException) {
                AdtPlugin.log(xPathExpressionException, "XPath error when trying to find '%s' element in XML.", elementDescriptor.getXmlName());
            }
        }
    }

    private void onDescriptorsChanged(UiElementNode uiElementNode) {
        this.mUiManifestNode.reloadFromXmlNode(uiElementNode.getXmlNode());
        if (this.mOverviewPage != null) {
            this.mOverviewPage.refreshUiApplicationNode();
        }
        if (this.mAppPage != null) {
            this.mAppPage.refreshUiApplicationNode();
        }
        if (this.mPermissionPage != null) {
            this.mPermissionPage.refreshUiNode();
        }
        if (this.mInstrumentationPage != null) {
            this.mInstrumentationPage.refreshUiNode();
        }
    }

    private void startMonitoringMarkers() {
        final IFile iFile = this.getInputFile();
        if (iFile != null) {
            this.updateFromExistingMarkers(iFile);
            this.mMarkerMonitor = new ResourceMonitor.IFileListener(){

                public void fileChanged(IFile iFile2, IMarkerDelta[] iMarkerDeltaArray, int n) {
                    if (iFile2.equals((Object)iFile)) {
                        ManifestEditor.this.processMarkerChanges(iMarkerDeltaArray);
                    }
                }
            };
            ResourceMonitor.getMonitor().addFileListener(this.mMarkerMonitor, 4);
        }
    }

    private void updateFromExistingMarkers(IFile iFile) {
        try {
            ElementDescriptor elementDescriptor;
            IMarker[] iMarkerArray = iFile.findMarkers("com.android.ide.eclipse.common.androidProblem", true, 0);
            AndroidManifestDescriptors androidManifestDescriptors = this.getManifestDescriptors();
            if (androidManifestDescriptors != null && (elementDescriptor = androidManifestDescriptors.getApplicationElement()) != null) {
                UiElementNode uiElementNode = this.mUiManifestNode.findUiChildNode(elementDescriptor.getXmlName());
                List<UiElementNode> list = uiElementNode.getUiChildren();
                IMarker[] iMarkerArray2 = iMarkerArray;
                int n = iMarkerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarker iMarker = iMarkerArray2[n2];
                    this.processMarker(iMarker, list, 1);
                    ++n2;
                }
            }
        }
        catch (CoreException coreException) {}
    }

    private void processMarkerChanges(IMarkerDelta[] iMarkerDeltaArray) {
        AndroidManifestDescriptors androidManifestDescriptors = this.getManifestDescriptors();
        if (androidManifestDescriptors != null && androidManifestDescriptors.getApplicationElement() != null) {
            UiElementNode uiElementNode = this.mUiManifestNode.findUiChildNode(androidManifestDescriptors.getApplicationElement().getXmlName());
            List<UiElementNode> list = uiElementNode.getUiChildren();
            IMarkerDelta[] iMarkerDeltaArray2 = iMarkerDeltaArray;
            int n = iMarkerDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMarkerDelta iMarkerDelta = iMarkerDeltaArray2[n2];
                this.processMarker(iMarkerDelta.getMarker(), list, iMarkerDelta.getKind());
                ++n2;
            }
        }
    }

    private void processMarker(IMarker iMarker, List<UiElementNode> list, int n) {
        String string = iMarker.getAttribute("android.type", EMPTY);
        if (string == EMPTY) {
            return;
        }
        String string2 = iMarker.getAttribute("android.class", EMPTY);
        if (string2 == EMPTY) {
            return;
        }
        for (UiElementNode uiElementNode : list) {
            if (!uiElementNode.getDescriptor().getXmlName().equals(string)) continue;
            for (UiAttributeNode uiAttributeNode : uiElementNode.getUiAttributes()) {
                if (!uiAttributeNode.getDescriptor().getXmlLocalName().equals("name") || !uiAttributeNode.getCurrentValue().equals(string2)) continue;
                if (n == 2) {
                    uiAttributeNode.setHasError(false);
                } else {
                    uiAttributeNode.setHasError(true);
                }
                return;
            }
        }
    }

    @Override
    protected void initUiRootNode(boolean bl) {
        if (this.mUiManifestNode != null && !bl) {
            return;
        }
        AndroidManifestDescriptors androidManifestDescriptors = this.getManifestDescriptors();
        if (androidManifestDescriptors != null) {
            UiElementNode uiElementNode = this.mUiManifestNode;
            ElementDescriptor elementDescriptor = androidManifestDescriptors.getManifestElement();
            this.mUiManifestNode = elementDescriptor.createUiNode();
            this.mUiManifestNode.setEditor(this);
            ElementDescriptor elementDescriptor2 = androidManifestDescriptors.getApplicationElement();
            boolean bl2 = false;
            for (UiElementNode uiElementNode2 : this.mUiManifestNode.getUiChildren()) {
                if (uiElementNode2.getDescriptor() != elementDescriptor2) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                this.mUiManifestNode.appendNewUiChild(elementDescriptor2);
            }
            elementDescriptor2 = androidManifestDescriptors.getUsesSdkElement();
            bl2 = false;
            for (UiElementNode uiElementNode2 : this.mUiManifestNode.getUiChildren()) {
                if (uiElementNode2.getDescriptor() != elementDescriptor2) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                this.mUiManifestNode.appendNewUiChild(elementDescriptor2);
            }
            if (uiElementNode != null) {
                this.onDescriptorsChanged(uiElementNode);
            }
        } else {
            ElementDescriptor elementDescriptor = new ElementDescriptor("manifest", "temporary descriptors due to missing decriptors", null, null, null, null, false);
            this.mUiManifestNode = elementDescriptor.createUiNode();
            this.mUiManifestNode.setEditor(this);
        }
    }

    private IFile getInputFile() {
        IEditorInput iEditorInput = this.getEditorInput();
        if (iEditorInput instanceof FileEditorInput) {
            FileEditorInput fileEditorInput = (FileEditorInput)iEditorInput;
            return fileEditorInput.getFile();
        }
        return null;
    }
}

