/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.layout.descriptors;

import com.android.ide.eclipse.adt.internal.editors.descriptors.AttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.DescriptorsUtils;
import com.android.ide.eclipse.adt.internal.editors.descriptors.DocumentDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.ElementDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.IDescriptorProvider;
import com.android.ide.eclipse.adt.internal.editors.descriptors.SeparatorAttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.layout.descriptors.ViewElementDescriptor;
import com.android.ide.eclipse.adt.internal.resources.DeclareStyleableInfo;
import com.android.ide.eclipse.adt.internal.resources.ViewClassInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LayoutDescriptors
implements IDescriptorProvider {
    public static final String ID_ATTR = "id";
    private DocumentDescriptor mRootDescriptor = new DocumentDescriptor("layout_doc", null);
    private ArrayList<ElementDescriptor> mLayoutDescriptors = new ArrayList();
    private List<ElementDescriptor> mROLayoutDescriptors;
    private ArrayList<ElementDescriptor> mViewDescriptors = new ArrayList();
    private List<ElementDescriptor> mROViewDescriptors;

    @Override
    public DocumentDescriptor getDescriptor() {
        return this.mRootDescriptor;
    }

    public List<ElementDescriptor> getLayoutDescriptors() {
        return this.mROLayoutDescriptors;
    }

    public List<ElementDescriptor> getViewDescriptors() {
        return this.mROViewDescriptors;
    }

    @Override
    public ElementDescriptor[] getRootElementDescriptors() {
        return this.mRootDescriptor.getChildren();
    }

    public synchronized void updateDescriptors(ViewClassInfo[] viewClassInfoArray, ViewClassInfo[] viewClassInfoArray2) {
        Object object;
        Object object2;
        int n;
        Object object3;
        ArrayList<ElementDescriptor> arrayList = new ArrayList<ElementDescriptor>();
        if (viewClassInfoArray != null) {
            object3 = viewClassInfoArray;
            n = viewClassInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                object2 = object3[n2];
                object = this.convertView((ViewClassInfo)object2);
                arrayList.add((ElementDescriptor)object);
                ++n2;
            }
        }
        this.insertInclude(arrayList);
        object2 = new ArrayList();
        if (viewClassInfoArray2 != null) {
            object = viewClassInfoArray2;
            int n3 = viewClassInfoArray2.length;
            n = 0;
            while (n < n3) {
                ViewClassInfo viewClassInfo = object[n];
                ElementDescriptor elementDescriptor = this.convertView(viewClassInfo);
                ((ArrayList)object2).add(elementDescriptor);
                ++n;
            }
        }
        ArrayList<ElementDescriptor> arrayList2 = new ArrayList<ElementDescriptor>();
        arrayList2.addAll((Collection<ElementDescriptor>)object2);
        arrayList2.addAll(arrayList);
        object3 = ((ArrayList)object2).iterator();
        while (object3.hasNext()) {
            ElementDescriptor elementDescriptor = (ElementDescriptor)object3.next();
            elementDescriptor.setChildren(arrayList2);
        }
        ElementDescriptor elementDescriptor = this.createMerge((ArrayList<ElementDescriptor>)object2);
        elementDescriptor.setChildren(arrayList2);
        arrayList2.add(elementDescriptor);
        ((ArrayList)object2).add(elementDescriptor);
        this.mViewDescriptors = arrayList;
        this.mLayoutDescriptors = object2;
        this.mRootDescriptor.setChildren(arrayList2);
        this.mROLayoutDescriptors = Collections.unmodifiableList(this.mLayoutDescriptors);
        this.mROViewDescriptors = Collections.unmodifiableList(this.mViewDescriptors);
    }

    private ElementDescriptor convertView(ViewClassInfo viewClassInfo) {
        Object object;
        String string = viewClassInfo.getShortClassName();
        String string2 = viewClassInfo.getJavaDoc();
        ArrayList<AttributeDescriptor> arrayList = new ArrayList<AttributeDescriptor>();
        DeclareStyleableInfo.AttributeInfo attributeInfo = new DeclareStyleableInfo.AttributeInfo("style", new DeclareStyleableInfo.AttributeInfo.Format[]{DeclareStyleableInfo.AttributeInfo.Format.REFERENCE});
        attributeInfo.setJavaDoc("A reference to a custom style");
        DescriptorsUtils.appendAttribute(arrayList, "style", null, attributeInfo, false, null);
        DescriptorsUtils.appendAttributes(arrayList, null, "http://schemas.android.com/apk/res/android", viewClassInfo.getAttributes(), null, null);
        Object object2 = viewClassInfo.getSuperClass();
        while (object2 != null) {
            object = ((ViewClassInfo)object2).getAttributes();
            if (((DeclareStyleableInfo.AttributeInfo[])object).length > 0) {
                arrayList.add(new SeparatorAttributeDescriptor(String.format("Attributes from %1$s", ((ViewClassInfo)object2).getShortClassName())));
                DescriptorsUtils.appendAttributes(arrayList, null, "http://schemas.android.com/apk/res/android", (DeclareStyleableInfo.AttributeInfo[])object, null, null);
            }
            object2 = ((ViewClassInfo)object2).getSuperClass();
        }
        object2 = new ArrayList();
        object = viewClassInfo.getLayoutData();
        while (object != null) {
            boolean bl = true;
            DeclareStyleableInfo.AttributeInfo[] attributeInfoArray = ((ViewClassInfo.LayoutParamsInfo)object).getAttributes();
            int n = attributeInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                DeclareStyleableInfo.AttributeInfo attributeInfo2 = attributeInfoArray[n2];
                if (!DescriptorsUtils.containsAttribute((ArrayList<AttributeDescriptor>)object2, "http://schemas.android.com/apk/res/android", attributeInfo2)) {
                    if (bl) {
                        String string3 = ((ViewClassInfo.LayoutParamsInfo)object).getShortClassName().equals("LayoutParams") ? String.format("Layout Attributes from %1$s", ((ViewClassInfo.LayoutParamsInfo)object).getViewLayoutClass().getShortClassName()) : String.format("Layout Attributes from %1$s (%2$s)", ((ViewClassInfo.LayoutParamsInfo)object).getViewLayoutClass().getShortClassName(), ((ViewClassInfo.LayoutParamsInfo)object).getShortClassName());
                        ((ArrayList)object2).add(new SeparatorAttributeDescriptor(string3));
                        bl = false;
                    }
                    DescriptorsUtils.appendAttribute((ArrayList<AttributeDescriptor>)object2, null, "http://schemas.android.com/apk/res/android", attributeInfo2, false, null);
                }
                ++n2;
            }
            object = ((ViewClassInfo.LayoutParamsInfo)object).getSuperClass();
        }
        return new ViewElementDescriptor(string, string, viewClassInfo.getCanonicalClassName(), string2, null, arrayList.toArray(new AttributeDescriptor[arrayList.size()]), ((ArrayList)object2).toArray(new AttributeDescriptor[((ArrayList)object2).size()]), null, false);
    }

    private void insertInclude(ArrayList<ElementDescriptor> arrayList) {
        String string = "include";
        ArrayList<AttributeDescriptor> arrayList2 = new ArrayList<AttributeDescriptor>();
        DescriptorsUtils.appendAttribute(arrayList2, null, null, new DeclareStyleableInfo.AttributeInfo("layout", new DeclareStyleableInfo.AttributeInfo.Format[]{DeclareStyleableInfo.AttributeInfo.Format.REFERENCE}), true, null);
        DescriptorsUtils.appendAttribute(arrayList2, null, "http://schemas.android.com/apk/res/android", new DeclareStyleableInfo.AttributeInfo(ID_ATTR, new DeclareStyleableInfo.AttributeInfo.Format[]{DeclareStyleableInfo.AttributeInfo.Format.REFERENCE}), true, null);
        AttributeDescriptor[] attributeDescriptorArray = this.findViewLayoutAttributes("android.view.View", arrayList);
        ViewElementDescriptor viewElementDescriptor = new ViewElementDescriptor(string, string, null, "Lets you statically include XML layouts inside other XML layouts.", null, arrayList2.toArray(new AttributeDescriptor[arrayList2.size()]), attributeDescriptorArray, null, false);
        arrayList.add(viewElementDescriptor);
    }

    private ElementDescriptor createMerge(ArrayList<ElementDescriptor> arrayList) {
        String string = "merge";
        AttributeDescriptor[] attributeDescriptorArray = this.findViewLayoutAttributes("android.widget.FrameLayout", arrayList);
        ViewElementDescriptor viewElementDescriptor = new ViewElementDescriptor(string, string, null, "A root tag useful for XML layouts inflated using a ViewStub.", null, null, attributeDescriptorArray, null, false);
        return viewElementDescriptor;
    }

    private AttributeDescriptor[] findViewLayoutAttributes(String string, ArrayList<ElementDescriptor> arrayList) {
        for (ElementDescriptor elementDescriptor : arrayList) {
            ViewElementDescriptor viewElementDescriptor;
            if (!(elementDescriptor instanceof ViewElementDescriptor) || !string.equals((viewElementDescriptor = (ViewElementDescriptor)elementDescriptor).getCanonicalClassName())) continue;
            return viewElementDescriptor.getLayoutAttributes();
        }
        return null;
    }
}

