/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.layout;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.views.properties.PropertySheetEntry;
import org.eclipse.ui.views.properties.PropertySheetPage;

public class UiPropertySheetPage
extends PropertySheetPage {
    public void createControl(Composite composite) {
        super.createControl(composite);
        this.setupTooltip();
    }

    private void setupTooltip() {
        final Tree tree = (Tree)this.getControl();
        Listener listener = new Listener(){
            Shell tip = null;
            Label label = null;

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 1: 
                    case 3: 
                    case 5: 
                    case 7: 
                    case 12: {
                        if (this.tip == null) break;
                        this.tip.dispose();
                        this.tip = null;
                        this.label = null;
                        break;
                    }
                    case 32: {
                        Object object;
                        if (this.tip != null) {
                            this.tip.dispose();
                            this.tip = null;
                            this.label = null;
                        }
                        String string = null;
                        TreeItem treeItem = tree.getItem(new Point(event.x, event.y));
                        if (treeItem != null) {
                            object = treeItem.getData();
                            if (object instanceof PropertySheetEntry) {
                                string = ((PropertySheetEntry)object).getDescription();
                            }
                            string = string == null ? treeItem.getText() : String.valueOf(treeItem.getText()) + ":\r" + string;
                        }
                        if (string == null) break;
                        object = tree.getShell();
                        Display display = tree.getDisplay();
                        this.tip = new Shell((Shell)object, 540676);
                        this.tip.setBackground(display.getSystemColor(29));
                        FillLayout fillLayout = new FillLayout();
                        fillLayout.marginWidth = 2;
                        this.tip.setLayout((Layout)fillLayout);
                        this.label = new Label((Composite)this.tip, 0);
                        this.label.setForeground(display.getSystemColor(28));
                        this.label.setBackground(display.getSystemColor(29));
                        this.label.setData("_TABLEITEM", (Object)treeItem);
                        this.label.setText(string);
                        this.label.addListener(7, (Listener)this);
                        this.label.addListener(3, (Listener)this);
                        Point point = this.tip.computeSize(-1, -1);
                        Rectangle rectangle = treeItem.getBounds(0);
                        Point point2 = tree.toDisplay(rectangle.x, rectangle.y);
                        this.tip.setBounds(point2.x, point2.y, point.x, point.y);
                        this.tip.setVisible(true);
                    }
                }
            }
        };
        tree.addListener(12, listener);
        tree.addListener(1, listener);
        tree.addListener(5, listener);
        tree.addListener(32, listener);
    }
}

