/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.layout;

import com.android.ide.eclipse.adt.internal.editors.layout.BasePullParser;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiElementNode;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public final class UiElementPullParser
extends BasePullParser {
    private final ArrayList<UiElementNode> mNodeStack = new ArrayList();
    private UiElementNode mRoot;

    public UiElementPullParser(UiElementNode uiElementNode) {
        this.mRoot = uiElementNode;
        this.push(this.mRoot);
    }

    private UiElementNode getCurrentNode() {
        if (this.mNodeStack.size() > 0) {
            return this.mNodeStack.get(this.mNodeStack.size() - 1);
        }
        return null;
    }

    private Node getAttribute(int n) {
        if (this.mParsingState != 2) {
            throw new IndexOutOfBoundsException();
        }
        UiElementNode uiElementNode = this.getCurrentNode();
        Node node = uiElementNode.getXmlNode();
        if (node != null) {
            return node.getAttributes().item(n);
        }
        return null;
    }

    private void push(UiElementNode uiElementNode) {
        this.mNodeStack.add(uiElementNode);
    }

    private UiElementNode pop() {
        return this.mNodeStack.remove(this.mNodeStack.size() - 1);
    }

    public Object getViewKey() {
        return this.getCurrentNode();
    }

    public String getPositionDescription() {
        return "XML DOM element depth:" + this.mNodeStack.size();
    }

    public int getAttributeCount() {
        UiElementNode uiElementNode = this.getCurrentNode();
        if (uiElementNode != null) {
            return uiElementNode.getUiAttributes().size();
        }
        return 0;
    }

    public String getAttributeName(int n) {
        Node node = this.getAttribute(n);
        if (node != null) {
            return node.getLocalName();
        }
        return null;
    }

    public String getAttributeNamespace(int n) {
        Node node = this.getAttribute(n);
        if (node != null) {
            return node.getNamespaceURI();
        }
        return "";
    }

    public String getAttributePrefix(int n) {
        Node node = this.getAttribute(n);
        if (node != null) {
            return node.getPrefix();
        }
        return null;
    }

    public String getAttributeValue(int n) {
        Node node = this.getAttribute(n);
        if (node != null) {
            return node.getNodeValue();
        }
        return null;
    }

    public String getAttributeValue(String string, String string2) {
        Node node;
        UiElementNode uiElementNode = this.getCurrentNode();
        Node node2 = uiElementNode.getXmlNode();
        if (node2 != null && (node = node2.getAttributes().getNamedItemNS(string, string2)) != null) {
            return node.getNodeValue();
        }
        return null;
    }

    public int getDepth() {
        return this.mNodeStack.size();
    }

    public String getName() {
        if (this.mParsingState == 2 || this.mParsingState == 3) {
            return this.getCurrentNode().getDescriptor().getXmlLocalName();
        }
        return null;
    }

    public String getNamespace() {
        if (this.mParsingState == 2 || this.mParsingState == 3) {
            return this.getCurrentNode().getDescriptor().getNamespace();
        }
        return null;
    }

    public String getPrefix() {
        if ((this.mParsingState == 2 || this.mParsingState == 3) && this.getCurrentNode().getDescriptor().getXmlLocalName().startsWith("android:")) {
            return "android";
        }
        return null;
    }

    public boolean isEmptyElementTag() throws XmlPullParserException {
        if (this.mParsingState == 2) {
            return this.getCurrentNode().getUiChildren().size() == 0;
        }
        throw new XmlPullParserException("Call to isEmptyElementTag while not in START_TAG", (XmlPullParser)this, null);
    }

    public void onNextFromStartDocument() {
        this.onNextFromStartTag();
    }

    public void onNextFromStartTag() {
        UiElementNode uiElementNode = this.getCurrentNode();
        List<UiElementNode> list = uiElementNode.getUiChildren();
        if (list.size() > 0) {
            this.push(list.get(0));
            this.mParsingState = 2;
        } else {
            this.mParsingState = this.mParsingState == 0 ? 1 : 3;
        }
    }

    public void onNextFromEndTag() {
        UiElementNode uiElementNode = this.getCurrentNode();
        if ((uiElementNode = uiElementNode.getUiNextSibling()) != null) {
            this.pop();
            this.push(uiElementNode);
            this.mParsingState = 2;
        } else {
            this.pop();
            this.mParsingState = this.mNodeStack.size() == 1 ? 1 : 3;
        }
    }
}

