/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.layout;

import com.android.ide.eclipse.adt.internal.editors.IconFactory;
import com.android.ide.eclipse.adt.internal.resources.configurations.FolderConfiguration;
import com.android.ide.eclipse.adt.internal.resources.configurations.ResourceQualifier;
import com.android.ide.eclipse.adt.internal.resources.manager.ResourceFolderType;
import com.android.ide.eclipse.adt.internal.ui.ConfigurationSelector;
import com.android.sdklib.IAndroidTarget;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

class LayoutCreatorDialog
extends TrayDialog {
    private ConfigurationSelector mSelector;
    private Composite mStatusComposite;
    private Label mStatusLabel;
    private Label mStatusImage;
    private final FolderConfiguration mConfig = new FolderConfiguration();
    private final String mFileName;
    private final IAndroidTarget mTarget;

    LayoutCreatorDialog(Shell shell, String string, IAndroidTarget iAndroidTarget, FolderConfiguration folderConfiguration) {
        super(shell);
        this.mFileName = string;
        this.mTarget = iAndroidTarget;
        this.mConfig.set(folderConfiguration);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData());
        composite2.setLayout((Layout)new GridLayout(1, false));
        new Label(composite2, 0).setText(String.format("Configuration for the alternate version of %1$s", this.mFileName));
        this.mSelector = new ConfigurationSelector(composite2);
        this.mSelector.setConfiguration(this.mConfig);
        GridData gridData = new GridData();
        gridData.widthHint = 600;
        gridData.heightHint = 250;
        this.mSelector.setLayoutData(gridData);
        this.mSelector.setOnChangeListener(new Runnable(){

            public void run() {
                ConfigurationSelector.ConfigurationState configurationState = LayoutCreatorDialog.this.mSelector.getState();
                switch (configurationState) {
                    case OK: {
                        LayoutCreatorDialog.this.mSelector.getConfiguration(LayoutCreatorDialog.this.mConfig);
                        LayoutCreatorDialog.this.resetStatus();
                        LayoutCreatorDialog.this.mStatusImage.setImage(null);
                        LayoutCreatorDialog.this.getButton(0).setEnabled(true);
                        break;
                    }
                    case INVALID_CONFIG: {
                        ResourceQualifier resourceQualifier = LayoutCreatorDialog.this.mSelector.getInvalidQualifier();
                        LayoutCreatorDialog.this.mStatusLabel.setText(String.format("Invalid Configuration: %1$s has no filter set.", resourceQualifier.getName()));
                        LayoutCreatorDialog.this.mStatusImage.setImage(IconFactory.getInstance().getIcon("warning"));
                        LayoutCreatorDialog.this.getButton(0).setEnabled(false);
                        break;
                    }
                    case REGION_WITHOUT_LANGUAGE: {
                        LayoutCreatorDialog.this.mStatusLabel.setText("The Region qualifier requires the Language qualifier.");
                        LayoutCreatorDialog.this.mStatusImage.setImage(IconFactory.getInstance().getIcon("warning"));
                        LayoutCreatorDialog.this.getButton(0).setEnabled(false);
                    }
                }
                LayoutCreatorDialog.this.mStatusComposite.layout();
            }
        });
        this.mStatusComposite = new Composite(composite2, 0);
        this.mStatusComposite.setLayoutData((Object)new GridData(768));
        GridLayout gridLayout = new GridLayout(2, false);
        this.mStatusComposite.setLayout((Layout)gridLayout);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.mStatusImage = new Label(this.mStatusComposite, 0);
        this.mStatusLabel = new Label(this.mStatusComposite, 0);
        this.mStatusLabel.setLayoutData((Object)new GridData(768));
        this.resetStatus();
        return composite2;
    }

    public void getConfiguration(FolderConfiguration folderConfiguration) {
        folderConfiguration.set(this.mConfig);
    }

    private void resetStatus() {
        this.mStatusLabel.setText(String.format("New File: res/%1$s/%2$s", this.mConfig.getFolderName(ResourceFolderType.LAYOUT, this.mTarget), this.mFileName));
    }
}

