/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.layout;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.editors.AndroidEditor;
import com.android.ide.eclipse.adt.internal.editors.IconFactory;
import com.android.ide.eclipse.adt.internal.editors.layout.AbstractGraphicalLayoutEditor;
import com.android.ide.eclipse.adt.internal.editors.layout.LayoutCreatorDialog;
import com.android.ide.eclipse.adt.internal.editors.layout.LayoutEditor;
import com.android.ide.eclipse.adt.internal.editors.layout.LayoutReloadMonitor;
import com.android.ide.eclipse.adt.internal.editors.layout.PaletteFactory;
import com.android.ide.eclipse.adt.internal.editors.layout.ProjectCallback;
import com.android.ide.eclipse.adt.internal.editors.layout.UiElementPullParser;
import com.android.ide.eclipse.adt.internal.editors.layout.WidgetPullParser;
import com.android.ide.eclipse.adt.internal.editors.layout.descriptors.ViewElementDescriptor;
import com.android.ide.eclipse.adt.internal.editors.layout.parts.UiElementEditPart;
import com.android.ide.eclipse.adt.internal.editors.layout.parts.UiElementsEditPartFactory;
import com.android.ide.eclipse.adt.internal.editors.ui.tree.CopyCutAction;
import com.android.ide.eclipse.adt.internal.editors.ui.tree.PasteAction;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiDocumentNode;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiElementNode;
import com.android.ide.eclipse.adt.internal.resources.ResourceType;
import com.android.ide.eclipse.adt.internal.resources.configurations.CountryCodeQualifier;
import com.android.ide.eclipse.adt.internal.resources.configurations.FolderConfiguration;
import com.android.ide.eclipse.adt.internal.resources.configurations.KeyboardStateQualifier;
import com.android.ide.eclipse.adt.internal.resources.configurations.LanguageQualifier;
import com.android.ide.eclipse.adt.internal.resources.configurations.NavigationMethodQualifier;
import com.android.ide.eclipse.adt.internal.resources.configurations.NetworkCodeQualifier;
import com.android.ide.eclipse.adt.internal.resources.configurations.PixelDensityQualifier;
import com.android.ide.eclipse.adt.internal.resources.configurations.RegionQualifier;
import com.android.ide.eclipse.adt.internal.resources.configurations.ScreenDimensionQualifier;
import com.android.ide.eclipse.adt.internal.resources.configurations.ScreenOrientationQualifier;
import com.android.ide.eclipse.adt.internal.resources.configurations.TextInputMethodQualifier;
import com.android.ide.eclipse.adt.internal.resources.configurations.TouchScreenQualifier;
import com.android.ide.eclipse.adt.internal.resources.manager.ProjectResources;
import com.android.ide.eclipse.adt.internal.resources.manager.ResourceFile;
import com.android.ide.eclipse.adt.internal.resources.manager.ResourceFolderType;
import com.android.ide.eclipse.adt.internal.resources.manager.ResourceManager;
import com.android.ide.eclipse.adt.internal.sdk.AndroidTargetData;
import com.android.ide.eclipse.adt.internal.sdk.LoadStatus;
import com.android.ide.eclipse.adt.internal.sdk.Sdk;
import com.android.ide.eclipse.adt.internal.ui.ConfigurationSelector;
import com.android.layoutlib.api.ILayoutLog;
import com.android.layoutlib.api.ILayoutResult;
import com.android.layoutlib.api.IProjectCallback;
import com.android.layoutlib.api.IResourceValue;
import com.android.layoutlib.api.IStyleResourceValue;
import com.android.layoutlib.api.IXmlPullParser;
import com.android.sdklib.IAndroidTarget;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.SelectionManager;
import org.eclipse.gef.dnd.TemplateTransferDragSourceListener;
import org.eclipse.gef.dnd.TemplateTransferDropTargetListener;
import org.eclipse.gef.dnd.TransferDragSourceListener;
import org.eclipse.gef.dnd.TransferDropTargetListener;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphicalLayoutEditor
extends AbstractGraphicalLayoutEditor
implements LayoutReloadMonitor.ILayoutReloadListener {
    private static final String THEME_SEPARATOR = "----------";
    private final LayoutEditor mLayoutEditor;
    private IFile mEditedFile;
    private Clipboard mClipboard;
    private Composite mParent;
    private PaletteRoot mPaletteRoot;
    private Text mCountry;
    private Text mNetwork;
    private Combo mLanguage;
    private Combo mRegion;
    private Combo mOrientation;
    private Combo mDensity;
    private Combo mTouch;
    private Combo mKeyboard;
    private Combo mTextInput;
    private Combo mNavigation;
    private Text mSize1;
    private Text mSize2;
    private Combo mThemeCombo;
    private Button mCreateButton;
    private Label mCountryIcon;
    private Label mNetworkIcon;
    private Label mLanguageIcon;
    private Label mRegionIcon;
    private Label mOrientationIcon;
    private Label mDensityIcon;
    private Label mTouchIcon;
    private Label mKeyboardIcon;
    private Label mTextInputIcon;
    private Label mNavigationIcon;
    private Label mSizeIcon;
    private Label mCurrentLayoutLabel;
    private Image mWarningImage;
    private Image mMatchImage;
    private Image mErrorImage;
    private FolderConfiguration mCurrentConfig = new FolderConfiguration();
    private FolderConfiguration mEditedConfig;
    private Map<String, Map<String, IResourceValue>> mConfiguredFrameworkRes;
    private Map<String, Map<String, IResourceValue>> mConfiguredProjectRes;
    private ProjectCallback mProjectCallback;
    private ILayoutLog mLogger;
    private boolean mNeedsXmlReload = false;
    private boolean mNeedsRecompute = false;
    private int mPlatformThemeCount = 0;
    private boolean mDisableUpdates = false;
    private Sdk.ITargetChangeListener mTargetListener = new Sdk.ITargetChangeListener(){

        public void onProjectTargetChange(IProject iProject) {
            if (iProject == GraphicalLayoutEditor.this.getLayoutEditor().getProject()) {
                this.onTargetsLoaded();
            }
        }

        public void onTargetsLoaded() {
            GraphicalLayoutEditor.this.mConfiguredFrameworkRes = null;
            GraphicalLayoutEditor.this.updateUIFromResources();
            GraphicalLayoutEditor.this.mThemeCombo.getParent().layout();
            if (GraphicalLayoutEditor.this.mEditedConfig != null) {
                GraphicalLayoutEditor.this.setConfiguration(GraphicalLayoutEditor.this.mEditedConfig, false);
            }
            GraphicalLayoutEditor.this.mProjectCallback = null;
            GraphicalLayoutEditor.this.recomputeLayout();
        }
    };
    private final Runnable mConditionalRecomputeRunnable = new Runnable(){

        public void run() {
            if (GraphicalLayoutEditor.this.mLayoutEditor.isGraphicalEditorActive()) {
                GraphicalLayoutEditor.this.recomputeLayout();
            } else {
                GraphicalLayoutEditor.this.mNeedsRecompute = true;
            }
        }
    };
    private final Runnable mUiUpdateFromResourcesRunnable = new Runnable(){

        public void run() {
            GraphicalLayoutEditor.this.updateUIFromResources();
            GraphicalLayoutEditor.this.mThemeCombo.getParent().layout();
        }
    };

    public GraphicalLayoutEditor(LayoutEditor layoutEditor) {
        this.mLayoutEditor = layoutEditor;
        this.setEditDomain(new DefaultEditDomain((IEditorPart)this));
        this.setPartName("Layout");
        IconFactory iconFactory = IconFactory.getInstance();
        this.mWarningImage = iconFactory.getIcon("warning");
        this.mMatchImage = iconFactory.getIcon("match");
        this.mErrorImage = iconFactory.getIcon("error");
        AdtPlugin.getDefault().addTargetListener(this.mTargetListener);
    }

    public void createPartControl(Composite composite) {
        PixelDensityQualifier.Density[] densityArray;
        this.mParent = composite;
        this.mClipboard = new Clipboard(composite.getDisplay());
        GridLayout gridLayout = new GridLayout(1, false);
        composite.setLayout((Layout)gridLayout);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        int n = 10;
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(768));
        gridLayout = new GridLayout(n, false);
        composite2.setLayout((Layout)gridLayout);
        new Label(composite2, 0).setText("MCC");
        this.mCountryIcon = this.createControlComposite(composite2, true);
        this.mCountry = new Text(this.mCountryIcon.getParent(), 2048);
        this.mCountry.setLayoutData((Object)new GridData(768));
        this.mCountry.addVerifyListener((VerifyListener)new ConfigurationSelector.MobileCodeVerifier());
        this.mCountry.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                GraphicalLayoutEditor.this.onCountryCodeChange();
            }
        });
        this.mCountry.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                GraphicalLayoutEditor.this.onCountryCodeChange();
            }
        });
        new Label(composite2, 0).setText("MNC");
        this.mNetworkIcon = this.createControlComposite(composite2, true);
        this.mNetwork = new Text(this.mNetworkIcon.getParent(), 2048);
        this.mNetwork.setLayoutData((Object)new GridData(768));
        this.mNetwork.addVerifyListener((VerifyListener)new ConfigurationSelector.MobileCodeVerifier());
        this.mNetwork.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                GraphicalLayoutEditor.this.onNetworkCodeChange();
            }
        });
        this.mNetwork.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                GraphicalLayoutEditor.this.onNetworkCodeChange();
            }
        });
        new Label(composite2, 0).setText("Lang");
        this.mLanguageIcon = this.createControlComposite(composite2, true);
        this.mLanguage = new Combo(this.mLanguageIcon.getParent(), 4);
        this.mLanguage.setLayoutData((Object)new GridData(768));
        this.mLanguage.addVerifyListener((VerifyListener)new ConfigurationSelector.LanguageRegionVerifier());
        this.mLanguage.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                GraphicalLayoutEditor.this.onLanguageChange();
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                GraphicalLayoutEditor.this.onLanguageChange();
            }
        });
        this.mLanguage.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                GraphicalLayoutEditor.this.onLanguageChange();
            }
        });
        new Label(composite2, 0).setText("Region");
        this.mRegionIcon = this.createControlComposite(composite2, true);
        this.mRegion = new Combo(this.mRegionIcon.getParent(), 4);
        this.mRegion.setLayoutData((Object)new GridData(768));
        this.mRegion.addVerifyListener((VerifyListener)new ConfigurationSelector.LanguageRegionVerifier());
        this.mRegion.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                GraphicalLayoutEditor.this.onRegionChange();
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                GraphicalLayoutEditor.this.onRegionChange();
            }
        });
        this.mRegion.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                GraphicalLayoutEditor.this.onRegionChange();
            }
        });
        new Label(composite2, 0).setText("Orient");
        this.mOrientationIcon = this.createControlComposite(composite2, true);
        this.mOrientation = new Combo(this.mOrientationIcon.getParent(), 12);
        ScreenOrientationQualifier.ScreenOrientation[] screenOrientationArray = ScreenOrientationQualifier.ScreenOrientation.values();
        this.mOrientation.add("(Default)");
        ScreenOrientationQualifier.ScreenOrientation[] screenOrientationArray2 = screenOrientationArray;
        int n2 = screenOrientationArray.length;
        int n3 = 0;
        while (n3 < n2) {
            densityArray = screenOrientationArray2[n3];
            this.mOrientation.add(densityArray.getDisplayValue());
            ++n3;
        }
        this.mOrientation.select(0);
        this.mOrientation.setLayoutData((Object)new GridData(768));
        this.mOrientation.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                GraphicalLayoutEditor.this.onOrientationChange();
            }
        });
        new Label(composite2, 0).setText("Density");
        this.mDensityIcon = this.createControlComposite(composite2, true);
        this.mDensity = new Combo(this.mDensityIcon.getParent(), 12);
        densityArray = PixelDensityQualifier.Density.values();
        this.mDensity.add("(Default)");
        PixelDensityQualifier.Density[] densityArray2 = densityArray;
        int n4 = densityArray.length;
        n2 = 0;
        while (n2 < n4) {
            PixelDensityQualifier.Density density = densityArray2[n2];
            this.mDensity.add(density.getDisplayValue());
            ++n2;
        }
        this.mDensity.select(0);
        this.mDensity.setLayoutData((Object)new GridData(768));
        this.mDensity.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                GraphicalLayoutEditor.this.onDensityChange();
            }
        });
        new Label(composite2, 0).setText("Touch");
        this.mTouchIcon = this.createControlComposite(composite2, true);
        this.mTouch = new Combo(this.mTouchIcon.getParent(), 12);
        TouchScreenQualifier.TouchScreenType[] touchScreenTypeArray = TouchScreenQualifier.TouchScreenType.values();
        this.mTouch.add("(Default)");
        TouchScreenQualifier.TouchScreenType[] touchScreenTypeArray2 = touchScreenTypeArray;
        int n5 = touchScreenTypeArray.length;
        n4 = 0;
        while (n4 < n5) {
            TouchScreenQualifier.TouchScreenType touchScreenType = touchScreenTypeArray2[n4];
            this.mTouch.add(touchScreenType.getDisplayValue());
            ++n4;
        }
        this.mTouch.select(0);
        this.mTouch.setLayoutData((Object)new GridData(768));
        this.mTouch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                GraphicalLayoutEditor.this.onTouchChange();
            }
        });
        new Label(composite2, 0).setText("Keybrd");
        this.mKeyboardIcon = this.createControlComposite(composite2, true);
        this.mKeyboard = new Combo(this.mKeyboardIcon.getParent(), 12);
        KeyboardStateQualifier.KeyboardState[] keyboardStateArray = KeyboardStateQualifier.KeyboardState.values();
        this.mKeyboard.add("(Default)");
        KeyboardStateQualifier.KeyboardState[] keyboardStateArray2 = keyboardStateArray;
        int n6 = keyboardStateArray.length;
        n5 = 0;
        while (n5 < n6) {
            KeyboardStateQualifier.KeyboardState keyboardState = keyboardStateArray2[n5];
            this.mKeyboard.add(keyboardState.getDisplayValue());
            ++n5;
        }
        this.mKeyboard.select(0);
        this.mKeyboard.setLayoutData((Object)new GridData(768));
        this.mKeyboard.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                GraphicalLayoutEditor.this.onKeyboardChange();
            }
        });
        new Label(composite2, 0).setText("Input");
        this.mTextInputIcon = this.createControlComposite(composite2, true);
        this.mTextInput = new Combo(this.mTextInputIcon.getParent(), 12);
        TextInputMethodQualifier.TextInputMethod[] textInputMethodArray = TextInputMethodQualifier.TextInputMethod.values();
        this.mTextInput.add("(Default)");
        TextInputMethodQualifier.TextInputMethod[] textInputMethodArray2 = textInputMethodArray;
        int n7 = textInputMethodArray.length;
        n6 = 0;
        while (n6 < n7) {
            TextInputMethodQualifier.TextInputMethod textInputMethod = textInputMethodArray2[n6];
            this.mTextInput.add(textInputMethod.getDisplayValue());
            ++n6;
        }
        this.mTextInput.select(0);
        this.mTextInput.setLayoutData((Object)new GridData(768));
        this.mTextInput.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                GraphicalLayoutEditor.this.onTextInputChange();
            }
        });
        new Label(composite2, 0).setText("Nav");
        this.mNavigationIcon = this.createControlComposite(composite2, true);
        this.mNavigation = new Combo(this.mNavigationIcon.getParent(), 12);
        NavigationMethodQualifier.NavigationMethod[] navigationMethodArray = NavigationMethodQualifier.NavigationMethod.values();
        this.mNavigation.add("(Default)");
        Object object = navigationMethodArray;
        int n8 = navigationMethodArray.length;
        n7 = 0;
        while (n7 < n8) {
            NavigationMethodQualifier.NavigationMethod navigationMethod = object[n7];
            this.mNavigation.add(navigationMethod.getDisplayValue());
            ++n7;
        }
        this.mNavigation.select(0);
        this.mNavigation.setLayoutData((Object)new GridData(768));
        this.mNavigation.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                GraphicalLayoutEditor.this.onNavigationChange();
            }
        });
        Composite composite3 = new Composite(composite2, 0);
        gridLayout = new GridLayout(8, false);
        composite3.setLayout((Layout)gridLayout);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        GridData gridData = new GridData(768);
        composite3.setLayoutData((Object)gridData);
        gridData.horizontalSpan = n;
        new Label(composite3, 0).setText("Editing config:");
        this.mCurrentLayoutLabel = new Label(composite3, 0);
        gridData = new GridData(768);
        this.mCurrentLayoutLabel.setLayoutData((Object)gridData);
        gridData.widthHint = 50;
        new Label(composite3, 0).setText("Size");
        this.mSizeIcon = this.createControlComposite(composite3, false);
        Composite composite4 = new Composite(this.mSizeIcon.getParent(), 0);
        gridLayout = new GridLayout(3, false);
        composite4.setLayout((Layout)gridLayout);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        this.mSize1 = new Text(composite4, 2048);
        gridData = new GridData();
        this.mSize1.setLayoutData((Object)gridData);
        gridData.widthHint = 30;
        new Label(composite4, 0).setText("x");
        this.mSize2 = new Text(composite4, 2048);
        gridData = new GridData();
        this.mSize2.setLayoutData((Object)gridData);
        gridData.widthHint = 30;
        ConfigurationSelector.DimensionVerifier dimensionVerifier = new ConfigurationSelector.DimensionVerifier();
        this.mSize1.addVerifyListener((VerifyListener)dimensionVerifier);
        this.mSize2.addVerifyListener((VerifyListener)dimensionVerifier);
        object = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                GraphicalLayoutEditor.this.onSizeChange();
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                GraphicalLayoutEditor.this.onSizeChange();
            }
        };
        this.mSize1.addSelectionListener((SelectionListener)object);
        this.mSize2.addSelectionListener((SelectionListener)object);
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                GraphicalLayoutEditor.this.onSizeChange();
            }
        };
        this.mSize1.addModifyListener(modifyListener);
        this.mSize2.addModifyListener(modifyListener);
        Label label = new Label(composite3, 514);
        gridData = new GridData(1040);
        label.setLayoutData((Object)gridData);
        gridData.heightHint = 0;
        this.mThemeCombo = new Combo(composite3, 12);
        this.mThemeCombo.setEnabled(false);
        this.updateUIFromResources();
        this.mThemeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                GraphicalLayoutEditor.this.onThemeChange();
            }
        });
        label = new Label(composite3, 514);
        gridData = new GridData(1040);
        label.setLayoutData((Object)gridData);
        gridData.heightHint = 0;
        this.mCreateButton = new Button(composite3, 0x800008);
        this.mCreateButton.setText("Create...");
        this.mCreateButton.setEnabled(false);
        this.mCreateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                LayoutCreatorDialog layoutCreatorDialog = new LayoutCreatorDialog(GraphicalLayoutEditor.this.mCreateButton.getShell(), GraphicalLayoutEditor.this.mEditedFile.getName(), Sdk.getCurrent().getTarget(GraphicalLayoutEditor.this.mEditedFile.getProject()), GraphicalLayoutEditor.this.mCurrentConfig);
                if (layoutCreatorDialog.open() == 0) {
                    FolderConfiguration folderConfiguration = new FolderConfiguration();
                    layoutCreatorDialog.getConfiguration(folderConfiguration);
                    GraphicalLayoutEditor.this.createAlternateLayout(folderConfiguration);
                }
            }
        });
        Composite composite5 = new Composite(composite, 0);
        composite5.setLayoutData((Object)new GridData(1808));
        composite5.setLayout((Layout)new FillLayout());
        super.createPartControl(composite5);
    }

    public void dispose() {
        if (this.mTargetListener != null) {
            AdtPlugin.getDefault().removeTargetListener(this.mTargetListener);
            this.mTargetListener = null;
        }
        LayoutReloadMonitor.getMonitor().removeListener(this.mEditedFile.getProject(), this);
        if (this.mClipboard != null) {
            this.mClipboard.dispose();
            this.mClipboard = null;
        }
        super.dispose();
    }

    protected PaletteRoot getPaletteRoot() {
        this.mPaletteRoot = PaletteFactory.createPaletteRoot(this.mPaletteRoot, this.mLayoutEditor.getTargetData());
        return this.mPaletteRoot;
    }

    @Override
    public Clipboard getClipboard() {
        return this.mClipboard;
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        this.getCommandStack().markSaveLocation();
        this.firePropertyChange(257);
    }

    protected void configurePaletteViewer() {
        super.configurePaletteViewer();
        TemplateTransferDragSourceListener templateTransferDragSourceListener = new TemplateTransferDragSourceListener((EditPartViewer)this.getPaletteViewer());
        this.getPaletteViewer().addDragSourceListener((TransferDragSourceListener)templateTransferDragSourceListener);
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        GraphicalViewer graphicalViewer = this.getGraphicalViewer();
        graphicalViewer.setEditPartFactory((EditPartFactory)new UiElementsEditPartFactory(this.mParent.getDisplay()));
        graphicalViewer.setRootEditPart((RootEditPart)new ScalableFreeformRootEditPart());
        graphicalViewer.addDropTargetListener((TransferDropTargetListener)new DropListener((EditPartViewer)graphicalViewer));
    }

    protected void initializeGraphicalViewer() {
        GraphicalViewer graphicalViewer = this.getGraphicalViewer();
        graphicalViewer.setContents((Object)this.getModel());
        IEditorInput iEditorInput = this.getEditorInput();
        if (iEditorInput instanceof FileEditorInput) {
            FileEditorInput fileEditorInput = (FileEditorInput)iEditorInput;
            this.mEditedFile = fileEditorInput.getFile();
            this.updateUIFromResources();
            LayoutReloadMonitor.getMonitor().addListener(this.mEditedFile.getProject(), this);
        } else {
            this.mEditedFile = null;
            AdtPlugin.log(4, "Input is not of type FileEditorInput: %1$s", iEditorInput.toString());
        }
    }

    protected void setGraphicalViewer(GraphicalViewer graphicalViewer) {
        super.setGraphicalViewer(graphicalViewer);
        graphicalViewer.setContextMenu(this.createContextMenu(graphicalViewer));
    }

    @Override
    void selectModel(UiElementNode uiElementNode) {
        GraphicalViewer graphicalViewer = this.getGraphicalViewer();
        graphicalViewer.getControl().forceFocus();
        Object v = graphicalViewer.getEditPartRegistry().get(uiElementNode);
        if (v instanceof EditPart) {
            graphicalViewer.select((EditPart)v);
        }
    }

    @Override
    public LayoutEditor getLayoutEditor() {
        return this.mLayoutEditor;
    }

    private MenuManager createContextMenu(GraphicalViewer graphicalViewer) {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener((IMenuListener)new ActionMenuListener(graphicalViewer));
        return menuManager;
    }

    private void doCreateMenuAction(IMenuManager iMenuManager, final GraphicalViewer graphicalViewer, final ArrayList<UiElementNode> arrayList) {
        if (arrayList != null) {
            boolean bl = false;
            for (UiElementNode object2 : arrayList) {
                if (object2.getXmlNode() == null) continue;
                bl = true;
                break;
            }
            if (bl) {
                UiElementNode uiElementNode;
                iMenuManager.add((IAction)new CopyCutAction((AndroidEditor)this.mLayoutEditor, this.getClipboard(), null, arrayList, true));
                iMenuManager.add((IAction)new CopyCutAction((AndroidEditor)this.mLayoutEditor, this.getClipboard(), null, arrayList, false));
                if (arrayList.size() <= 1 && ((uiElementNode = arrayList.get(0).getUiRoot()).getDescriptor().hasChildren() || !(uiElementNode.getUiParent() instanceof UiDocumentNode))) {
                    iMenuManager.add((IAction)new PasteAction(this.mLayoutEditor, this.getClipboard(), arrayList.get(0)));
                }
                iMenuManager.add((IContributionItem)new Separator());
            }
        }
        IconFactory iconFactory = IconFactory.getInstance();
        final LayoutEditor.UiEditorActions uiEditorActions = this.mLayoutEditor.getUiEditorActions();
        if (arrayList == null || arrayList.size() <= 1) {
            iMenuManager.add((IAction)new Action("Add...", iconFactory.getImageDescriptor("add")){

                public void run() {
                    UiElementNode uiElementNode = arrayList != null && arrayList.size() > 0 ? (UiElementNode)arrayList.get(0) : null;
                    uiEditorActions.doAdd(uiElementNode, graphicalViewer.getControl().getShell());
                }
            });
        }
        if (arrayList != null) {
            iMenuManager.add((IAction)new Action("Remove", iconFactory.getImageDescriptor("delete")){

                public void run() {
                    uiEditorActions.doRemove(arrayList, graphicalViewer.getControl().getShell());
                }
            });
            iMenuManager.add((IContributionItem)new Separator());
            iMenuManager.add((IAction)new Action("Up", iconFactory.getImageDescriptor("up")){

                public void run() {
                    uiEditorActions.doUp(arrayList);
                }
            });
            iMenuManager.add((IAction)new Action("Down", iconFactory.getImageDescriptor("down")){

                public void run() {
                    uiEditorActions.doDown(arrayList);
                }
            });
        }
    }

    @Override
    void editNewFile(FolderConfiguration folderConfiguration) {
        this.setConfiguration(folderConfiguration, true);
        this.mCreateButton.setEnabled(!this.mEditedConfig.equals(this.mCurrentConfig));
    }

    public Rectangle getBounds() {
        int n;
        int n2;
        ScreenOrientationQualifier.ScreenOrientation screenOrientation = null;
        screenOrientation = this.mOrientation.getSelectionIndex() == 0 ? ScreenOrientationQualifier.ScreenOrientation.PORTRAIT : ScreenOrientationQualifier.ScreenOrientation.getByIndex(this.mOrientation.getSelectionIndex() - 1);
        try {
            n2 = Integer.parseInt(this.mSize1.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {
            n2 = 480;
        }
        try {
            n = Integer.parseInt(this.mSize2.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {
            n = 320;
        }
        if (n2 < n) {
            int n3 = n2;
            n2 = n;
            n = n3;
        }
        switch (screenOrientation) {
            default: {
                return new Rectangle(0, 0, n, n2);
            }
            case LANDSCAPE: {
                return new Rectangle(0, 0, n2, n);
            }
            case SQUARE: 
        }
        return new Rectangle(0, 0, n2, n2);
    }

    public ImageData renderWidget(ViewElementDescriptor viewElementDescriptor) {
        if (this.mEditedFile == null) {
            return null;
        }
        IAndroidTarget iAndroidTarget = Sdk.getCurrent().getTarget(this.mEditedFile.getProject());
        if (iAndroidTarget == null) {
            return null;
        }
        AndroidTargetData androidTargetData = Sdk.getCurrent().getTargetData(iAndroidTarget);
        if (androidTargetData == null) {
            return null;
        }
        AndroidTargetData.LayoutBridge layoutBridge = androidTargetData.getLayoutBridge();
        if (layoutBridge.bridge != null) {
            String string;
            WidgetPullParser widgetPullParser;
            ILayoutResult iLayoutResult;
            int n;
            Object object;
            ResourceManager resourceManager = ResourceManager.getInstance();
            ProjectCallback projectCallback = null;
            HashMap<String, Map<String, IResourceValue>> hashMap = null;
            if (this.mEditedFile != null) {
                object = resourceManager.getProjectResources(this.mEditedFile.getProject());
                projectCallback = new ProjectCallback(layoutBridge.classLoader, (ProjectResources)object, this.mEditedFile.getProject());
                if (this.mConfiguredProjectRes == null && object != null) {
                    ((ProjectResources)object).loadAll();
                    this.mConfiguredProjectRes = ((ProjectResources)object).getConfiguredResources(this.mCurrentConfig);
                }
                hashMap = this.mConfiguredProjectRes;
            } else {
                hashMap = new HashMap();
            }
            object = this.getConfiguredFrameworkResources();
            if (hashMap != null && object != null && (n = this.mThemeCombo.getSelectionIndex()) != -1 && (iLayoutResult = this.computeLayout(layoutBridge, widgetPullParser = new WidgetPullParser(viewElementDescriptor), null, 300, 300, 160, 160.0f, 160.0f, string = this.mThemeCombo.getItem(n), n >= this.mPlatformThemeCount, hashMap, (Map<String, Map<String, IResourceValue>>)object, projectCallback, null)).getSuccess() == 0) {
                BufferedImage bufferedImage = iLayoutResult.getImage();
                int n2 = iLayoutResult.getRootView().getRight();
                int n3 = iLayoutResult.getRootView().getBottom();
                Raster raster = bufferedImage.getData(new java.awt.Rectangle(n2, n3));
                int[] nArray = ((DataBufferInt)raster.getDataBuffer()).getData();
                ImageData imageData = new ImageData(n2, n3, 32, new PaletteData(0xFF0000, 65280, 255));
                imageData.setPixels(0, 0, nArray.length, nArray, 0);
                return imageData;
            }
        }
        return null;
    }

    @Override
    void reloadEditor() {
        GraphicalViewer graphicalViewer = this.getGraphicalViewer();
        graphicalViewer.setContents((Object)this.getModel());
        IEditorInput iEditorInput = this.mLayoutEditor.getEditorInput();
        this.setInput(iEditorInput);
        if (iEditorInput instanceof FileEditorInput) {
            FileEditorInput fileEditorInput = (FileEditorInput)iEditorInput;
            this.mEditedFile = fileEditorInput.getFile();
        } else {
            this.mEditedFile = null;
            AdtPlugin.log(4, "Input is not of type FileEditorInput: %1$s", iEditorInput.toString());
        }
    }

    @Override
    void onXmlModelChanged() {
        if (this.mLayoutEditor.isGraphicalEditorActive()) {
            this.doXmlReload(true);
            this.recomputeLayout();
        } else {
            this.mNeedsXmlReload = true;
        }
    }

    private void doXmlReload(boolean bl) {
        if (bl || this.mNeedsXmlReload) {
            GraphicalViewer graphicalViewer = this.getGraphicalViewer();
            SelectionManager selectionManager = graphicalViewer.getSelectionManager();
            ISelection iSelection = selectionManager.getSelection();
            try {
                graphicalViewer.setContents((Object)this.getModel());
            }
            finally {
                selectionManager.setSelection(iSelection);
            }
            this.mNeedsXmlReload = false;
        }
    }

    void setConfiguration(FolderConfiguration folderConfiguration, boolean bl) {
        this.mDisableUpdates = true;
        this.mEditedConfig = folderConfiguration;
        this.mConfiguredProjectRes = null;
        this.mConfiguredFrameworkRes = null;
        this.mCountryIcon.setImage(this.mMatchImage);
        CountryCodeQualifier countryCodeQualifier = folderConfiguration.getCountryCodeQualifier();
        if (countryCodeQualifier != null) {
            this.mCountry.setText(String.format("%1$d", countryCodeQualifier.getCode()));
            this.mCurrentConfig.setCountryCodeQualifier(countryCodeQualifier);
        } else if (bl) {
            this.mCountry.setText("");
            this.mCurrentConfig.setCountryCodeQualifier(null);
        } else if (this.mCountry.getText().length() > 0) {
            this.mCountryIcon.setImage(this.mWarningImage);
        }
        this.mNetworkIcon.setImage(this.mMatchImage);
        NetworkCodeQualifier networkCodeQualifier = folderConfiguration.getNetworkCodeQualifier();
        if (networkCodeQualifier != null) {
            this.mNetwork.setText(String.format("%1$d", networkCodeQualifier.getCode()));
            this.mCurrentConfig.setNetworkCodeQualifier(networkCodeQualifier);
        } else if (bl) {
            this.mNetwork.setText("");
            this.mCurrentConfig.setNetworkCodeQualifier(null);
        } else if (this.mNetwork.getText().length() > 0) {
            this.mNetworkIcon.setImage(this.mWarningImage);
        }
        this.mLanguageIcon.setImage(this.mMatchImage);
        LanguageQualifier languageQualifier = folderConfiguration.getLanguageQualifier();
        if (languageQualifier != null) {
            this.mLanguage.setText(languageQualifier.getValue());
            this.mCurrentConfig.setLanguageQualifier(languageQualifier);
        } else if (bl) {
            this.mLanguage.setText("");
            this.mCurrentConfig.setLanguageQualifier(null);
        } else if (this.mLanguage.getText().length() > 0) {
            this.mLanguageIcon.setImage(this.mWarningImage);
        }
        this.mRegionIcon.setImage(this.mMatchImage);
        RegionQualifier regionQualifier = folderConfiguration.getRegionQualifier();
        if (regionQualifier != null) {
            this.mRegion.setText(regionQualifier.getValue());
            this.mCurrentConfig.setRegionQualifier(regionQualifier);
        } else if (bl) {
            this.mRegion.setText("");
            this.mCurrentConfig.setRegionQualifier(null);
        } else if (this.mRegion.getText().length() > 0) {
            this.mRegionIcon.setImage(this.mWarningImage);
        }
        this.mOrientationIcon.setImage(this.mMatchImage);
        ScreenOrientationQualifier screenOrientationQualifier = folderConfiguration.getScreenOrientationQualifier();
        if (screenOrientationQualifier != null) {
            this.mOrientation.select(ScreenOrientationQualifier.ScreenOrientation.getIndex(screenOrientationQualifier.getValue()) + 1);
            this.mCurrentConfig.setScreenOrientationQualifier(screenOrientationQualifier);
        } else if (bl) {
            this.mOrientation.select(0);
            this.mCurrentConfig.setScreenOrientationQualifier(null);
        } else if (this.mOrientation.getSelectionIndex() != 0) {
            this.mOrientationIcon.setImage(this.mWarningImage);
        }
        this.mDensityIcon.setImage(this.mMatchImage);
        PixelDensityQualifier pixelDensityQualifier = folderConfiguration.getPixelDensityQualifier();
        if (pixelDensityQualifier != null) {
            this.mDensity.select(PixelDensityQualifier.Density.getIndex(pixelDensityQualifier.getValue()) + 1);
            this.mCurrentConfig.setPixelDensityQualifier(pixelDensityQualifier);
        } else if (bl) {
            this.mOrientation.select(0);
            this.mCurrentConfig.setPixelDensityQualifier(null);
        } else if (this.mDensity.getSelectionIndex() != 0) {
            this.mDensityIcon.setImage(this.mWarningImage);
        }
        this.mTouchIcon.setImage(this.mMatchImage);
        TouchScreenQualifier touchScreenQualifier = folderConfiguration.getTouchTypeQualifier();
        if (touchScreenQualifier != null) {
            this.mTouch.select(TouchScreenQualifier.TouchScreenType.getIndex(touchScreenQualifier.getValue()) + 1);
            this.mCurrentConfig.setTouchTypeQualifier(touchScreenQualifier);
        } else if (bl) {
            this.mTouch.select(0);
            this.mCurrentConfig.setTouchTypeQualifier(null);
        } else if (this.mTouch.getSelectionIndex() != 0) {
            this.mTouchIcon.setImage(this.mWarningImage);
        }
        this.mKeyboardIcon.setImage(this.mMatchImage);
        KeyboardStateQualifier keyboardStateQualifier = folderConfiguration.getKeyboardStateQualifier();
        if (keyboardStateQualifier != null) {
            this.mKeyboard.select(KeyboardStateQualifier.KeyboardState.getIndex(keyboardStateQualifier.getValue()) + 1);
            this.mCurrentConfig.setKeyboardStateQualifier(keyboardStateQualifier);
        } else if (bl) {
            this.mKeyboard.select(0);
            this.mCurrentConfig.setKeyboardStateQualifier(null);
        } else if (this.mKeyboard.getSelectionIndex() != 0) {
            this.mKeyboardIcon.setImage(this.mWarningImage);
        }
        this.mTextInputIcon.setImage(this.mMatchImage);
        TextInputMethodQualifier textInputMethodQualifier = folderConfiguration.getTextInputMethodQualifier();
        if (textInputMethodQualifier != null) {
            this.mTextInput.select(TextInputMethodQualifier.TextInputMethod.getIndex(textInputMethodQualifier.getValue()) + 1);
            this.mCurrentConfig.setTextInputMethodQualifier(textInputMethodQualifier);
        } else if (bl) {
            this.mTextInput.select(0);
            this.mCurrentConfig.setTextInputMethodQualifier(null);
        } else if (this.mTextInput.getSelectionIndex() != 0) {
            this.mTextInputIcon.setImage(this.mWarningImage);
        }
        this.mNavigationIcon.setImage(this.mMatchImage);
        NavigationMethodQualifier navigationMethodQualifier = folderConfiguration.getNavigationMethodQualifier();
        if (navigationMethodQualifier != null) {
            this.mNavigation.select(NavigationMethodQualifier.NavigationMethod.getIndex(navigationMethodQualifier.getValue()) + 1);
            this.mCurrentConfig.setNavigationMethodQualifier(navigationMethodQualifier);
        } else if (bl) {
            this.mNavigation.select(0);
            this.mCurrentConfig.setNavigationMethodQualifier(null);
        } else if (this.mNavigation.getSelectionIndex() != 0) {
            this.mNavigationIcon.setImage(this.mWarningImage);
        }
        this.mSizeIcon.setImage(this.mMatchImage);
        ScreenDimensionQualifier screenDimensionQualifier = folderConfiguration.getScreenDimensionQualifier();
        if (screenDimensionQualifier != null) {
            this.mSize1.setText(String.format("%1$d", screenDimensionQualifier.getValue1()));
            this.mSize2.setText(String.format("%1$d", screenDimensionQualifier.getValue2()));
            this.mCurrentConfig.setScreenDimensionQualifier(screenDimensionQualifier);
        } else if (bl) {
            this.mSize1.setText("");
            this.mSize2.setText("");
            this.mCurrentConfig.setScreenDimensionQualifier(null);
        } else if (this.mSize1.getText().length() > 0 && this.mSize2.getText().length() > 0) {
            this.mSizeIcon.setImage(this.mWarningImage);
        }
        String string = folderConfiguration.toDisplayString();
        this.mCurrentLayoutLabel.setText(string != null ? string : "(Default)");
        this.mDisableUpdates = false;
    }

    void displayConfigError() {
        String string;
        this.mCountryIcon.setImage(this.mMatchImage);
        CountryCodeQualifier countryCodeQualifier = this.mCurrentConfig.getCountryCodeQualifier();
        if (countryCodeQualifier != null) {
            this.mCountryIcon.setImage(this.mErrorImage);
        }
        this.mNetworkIcon.setImage(this.mMatchImage);
        NetworkCodeQualifier networkCodeQualifier = this.mCurrentConfig.getNetworkCodeQualifier();
        if (networkCodeQualifier != null) {
            this.mNetworkIcon.setImage(this.mErrorImage);
        }
        this.mLanguageIcon.setImage(this.mMatchImage);
        LanguageQualifier languageQualifier = this.mCurrentConfig.getLanguageQualifier();
        if (languageQualifier != null) {
            this.mLanguageIcon.setImage(this.mErrorImage);
        }
        this.mRegionIcon.setImage(this.mMatchImage);
        RegionQualifier regionQualifier = this.mCurrentConfig.getRegionQualifier();
        if (regionQualifier != null) {
            this.mRegionIcon.setImage(this.mErrorImage);
        }
        this.mOrientationIcon.setImage(this.mMatchImage);
        ScreenOrientationQualifier screenOrientationQualifier = this.mCurrentConfig.getScreenOrientationQualifier();
        if (screenOrientationQualifier != null) {
            this.mOrientationIcon.setImage(this.mErrorImage);
        }
        this.mDensityIcon.setImage(this.mMatchImage);
        PixelDensityQualifier pixelDensityQualifier = this.mCurrentConfig.getPixelDensityQualifier();
        if (pixelDensityQualifier != null) {
            this.mDensityIcon.setImage(this.mErrorImage);
        }
        this.mTouchIcon.setImage(this.mMatchImage);
        TouchScreenQualifier touchScreenQualifier = this.mCurrentConfig.getTouchTypeQualifier();
        if (touchScreenQualifier != null) {
            this.mTouchIcon.setImage(this.mErrorImage);
        }
        this.mKeyboardIcon.setImage(this.mMatchImage);
        KeyboardStateQualifier keyboardStateQualifier = this.mCurrentConfig.getKeyboardStateQualifier();
        if (keyboardStateQualifier != null) {
            this.mKeyboardIcon.setImage(this.mErrorImage);
        }
        this.mTextInputIcon.setImage(this.mMatchImage);
        TextInputMethodQualifier textInputMethodQualifier = this.mCurrentConfig.getTextInputMethodQualifier();
        if (textInputMethodQualifier != null) {
            this.mTextInputIcon.setImage(this.mErrorImage);
        }
        this.mNavigationIcon.setImage(this.mMatchImage);
        NavigationMethodQualifier navigationMethodQualifier = this.mCurrentConfig.getNavigationMethodQualifier();
        if (navigationMethodQualifier != null) {
            this.mNavigationIcon.setImage(this.mErrorImage);
        }
        this.mSizeIcon.setImage(this.mMatchImage);
        ScreenDimensionQualifier screenDimensionQualifier = this.mCurrentConfig.getScreenDimensionQualifier();
        if (screenDimensionQualifier != null) {
            this.mSizeIcon.setImage(this.mErrorImage);
        }
        this.mCurrentLayoutLabel.setText((string = this.mCurrentConfig.toDisplayString()) != null ? string : "(Default)");
    }

    @Override
    UiDocumentNode getModel() {
        return this.mLayoutEditor.getUiRootNode();
    }

    @Override
    void reloadPalette() {
        PaletteFactory.createPaletteRoot(this.mPaletteRoot, this.mLayoutEditor.getTargetData());
    }

    private void onCountryCodeChange() {
        if (this.mDisableUpdates) {
            return;
        }
        String string = this.mCountry.getText();
        if (string.length() == 0) {
            this.mCurrentConfig.setCountryCodeQualifier(null);
        } else {
            try {
                CountryCodeQualifier countryCodeQualifier = CountryCodeQualifier.getQualifier(CountryCodeQualifier.getFolderSegment(Integer.parseInt(string)));
                if (countryCodeQualifier == null) {
                    this.mCountryIcon.setImage(this.mErrorImage);
                    return;
                }
                this.mCurrentConfig.setCountryCodeQualifier(countryCodeQualifier);
            }
            catch (NumberFormatException numberFormatException) {
                this.mCurrentConfig.setCountryCodeQualifier(null);
                this.mCountryIcon.setImage(this.mErrorImage);
            }
        }
        this.onConfigurationChange();
    }

    private void onNetworkCodeChange() {
        if (this.mDisableUpdates) {
            return;
        }
        String string = this.mNetwork.getText();
        if (string.length() == 0) {
            this.mCurrentConfig.setNetworkCodeQualifier(null);
        } else {
            try {
                NetworkCodeQualifier networkCodeQualifier = NetworkCodeQualifier.getQualifier(NetworkCodeQualifier.getFolderSegment(Integer.parseInt(string)));
                if (networkCodeQualifier == null) {
                    this.mNetworkIcon.setImage(this.mErrorImage);
                    return;
                }
                this.mCurrentConfig.setNetworkCodeQualifier(networkCodeQualifier);
            }
            catch (NumberFormatException numberFormatException) {
                this.mCurrentConfig.setNetworkCodeQualifier(null);
                this.mNetworkIcon.setImage(this.mErrorImage);
            }
        }
        this.onConfigurationChange();
    }

    private void onLanguageChange() {
        if (this.mDisableUpdates) {
            return;
        }
        String string = this.mLanguage.getText();
        this.updateRegionUi(null, null);
        if (string.length() == 0) {
            this.mCurrentConfig.setLanguageQualifier(null);
        } else {
            LanguageQualifier languageQualifier = null;
            String string2 = LanguageQualifier.getFolderSegment(string);
            if (string2 != null) {
                languageQualifier = LanguageQualifier.getQualifier(string2);
            }
            if (languageQualifier != null) {
                this.mCurrentConfig.setLanguageQualifier(languageQualifier);
            } else {
                this.mCurrentConfig.setLanguageQualifier(null);
                this.mLanguageIcon.setImage(this.mErrorImage);
            }
        }
        this.onConfigurationChange();
    }

    private void onRegionChange() {
        if (this.mDisableUpdates) {
            return;
        }
        String string = this.mRegion.getText();
        if (string.length() == 0) {
            this.mCurrentConfig.setRegionQualifier(null);
        } else {
            RegionQualifier regionQualifier = null;
            String string2 = RegionQualifier.getFolderSegment(string);
            if (string2 != null) {
                regionQualifier = RegionQualifier.getQualifier(string2);
            }
            if (regionQualifier != null) {
                this.mCurrentConfig.setRegionQualifier(regionQualifier);
            } else {
                this.mCurrentConfig.setRegionQualifier(null);
                this.mRegionIcon.setImage(this.mErrorImage);
            }
        }
        this.onConfigurationChange();
    }

    private void onOrientationChange() {
        int n = this.mOrientation.getSelectionIndex();
        if (n != 0) {
            this.mCurrentConfig.setScreenOrientationQualifier(new ScreenOrientationQualifier(ScreenOrientationQualifier.ScreenOrientation.getByIndex(n - 1)));
        } else {
            this.mCurrentConfig.setScreenOrientationQualifier(null);
        }
        this.onConfigurationChange();
    }

    private void onDensityChange() {
        int n = this.mDensity.getSelectionIndex();
        if (n != 0) {
            this.mCurrentConfig.setPixelDensityQualifier(new PixelDensityQualifier(PixelDensityQualifier.Density.getByIndex(n - 1)));
        } else {
            this.mCurrentConfig.setPixelDensityQualifier(null);
        }
        this.onConfigurationChange();
    }

    private void onTouchChange() {
        int n = this.mTouch.getSelectionIndex();
        if (n != 0) {
            this.mCurrentConfig.setTouchTypeQualifier(new TouchScreenQualifier(TouchScreenQualifier.TouchScreenType.getByIndex(n - 1)));
        } else {
            this.mCurrentConfig.setTouchTypeQualifier(null);
        }
        this.onConfigurationChange();
    }

    private void onKeyboardChange() {
        int n = this.mKeyboard.getSelectionIndex();
        if (n != 0) {
            this.mCurrentConfig.setKeyboardStateQualifier(new KeyboardStateQualifier(KeyboardStateQualifier.KeyboardState.getByIndex(n - 1)));
        } else {
            this.mCurrentConfig.setKeyboardStateQualifier(null);
        }
        this.onConfigurationChange();
    }

    private void onTextInputChange() {
        int n = this.mTextInput.getSelectionIndex();
        if (n != 0) {
            this.mCurrentConfig.setTextInputMethodQualifier(new TextInputMethodQualifier(TextInputMethodQualifier.TextInputMethod.getByIndex(n - 1)));
        } else {
            this.mCurrentConfig.setTextInputMethodQualifier(null);
        }
        this.onConfigurationChange();
    }

    private void onNavigationChange() {
        int n = this.mNavigation.getSelectionIndex();
        if (n != 0) {
            this.mCurrentConfig.setNavigationMethodQualifier(new NavigationMethodQualifier(NavigationMethodQualifier.NavigationMethod.getByIndex(n - 1)));
        } else {
            this.mCurrentConfig.setNavigationMethodQualifier(null);
        }
        this.onConfigurationChange();
    }

    private void onSizeChange() {
        if (this.mDisableUpdates) {
            return;
        }
        String string = this.mSize1.getText();
        String string2 = this.mSize2.getText();
        if (string.length() == 0 ^ string2.length() == 0) {
            this.mSizeIcon.setImage(this.mErrorImage);
            return;
        }
        if (string.length() == 0 && string2.length() == 0) {
            this.mCurrentConfig.setScreenDimensionQualifier(null);
        } else {
            ScreenDimensionQualifier screenDimensionQualifier = ScreenDimensionQualifier.getQualifier(string, string2);
            if (screenDimensionQualifier != null) {
                this.mCurrentConfig.setScreenDimensionQualifier(screenDimensionQualifier);
            } else {
                return;
            }
        }
        this.onConfigurationChange();
    }

    private void onConfigurationChange() {
        this.mConfiguredProjectRes = null;
        this.mConfiguredFrameworkRes = null;
        if (this.mEditedFile == null || this.mEditedConfig == null) {
            return;
        }
        ProjectResources projectResources = ResourceManager.getInstance().getProjectResources(this.mEditedFile.getProject());
        ResourceFile resourceFile = null;
        if (projectResources != null) {
            resourceFile = projectResources.getMatchingFile(this.mEditedFile.getName(), ResourceFolderType.LAYOUT, this.mCurrentConfig);
        }
        if (resourceFile != null) {
            if (!resourceFile.getFile().equals(this.mEditedFile)) {
                try {
                    IDE.openEditor((IWorkbenchPage)this.getSite().getWorkbenchWindow().getActivePage(), (IFile)resourceFile.getFile().getIFile());
                    return;
                }
                catch (PartInitException partInitException) {}
            }
            this.setConfiguration(this.mEditedConfig, false);
            this.mCreateButton.setEnabled(!this.mEditedConfig.equals(this.mCurrentConfig));
            this.recomputeLayout();
        } else {
            this.displayConfigError();
            this.mCreateButton.setEnabled(true);
            String string = String.format("No resources match the configuration\n \n\t%1$s\n \nChange the configuration or create:\n \n\tres/%2$s/%3$s\n \nYou can also click the 'Create' button above.", this.mCurrentConfig.toDisplayString(), this.mCurrentConfig.getFolderName(ResourceFolderType.LAYOUT, Sdk.getCurrent().getTarget(this.mEditedFile.getProject())), this.mEditedFile.getName());
            this.showErrorInEditor(string);
        }
    }

    private void onThemeChange() {
        int n = this.mThemeCombo.getSelectionIndex();
        if (n != -1) {
            String string = this.mThemeCombo.getItem(n);
            if (string.equals(THEME_SEPARATOR)) {
                this.mThemeCombo.select(0);
            }
            this.recomputeLayout();
        }
    }

    private Label createControlComposite(Composite composite, boolean bl) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        composite2.setLayout((Layout)gridLayout);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        if (bl) {
            composite2.setLayoutData((Object)new GridData(768));
        }
        Label label = new Label(composite2, 0);
        label.setImage(this.mMatchImage);
        return label;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    void recomputeLayout() {
        this.doXmlReload(false);
        try {
            if (!this.mEditedFile.exists()) {
                String string = String.format("Resource '%1$s' does not exist.", this.mEditedFile.getFullPath().toString());
                this.showErrorInEditor(string);
                return;
            }
            IProject iProject = this.mEditedFile.getProject();
            if (!this.mEditedFile.isSynchronized(0)) {
                String string = String.format("%1$s is out of sync. Please refresh.", this.mEditedFile.getName());
                this.showErrorInEditor(string);
                AdtPlugin.printErrorToConsole(iProject.getName(), string);
                return;
            }
            Sdk sdk = Sdk.getCurrent();
            if (sdk != null) {
                IAndroidTarget iAndroidTarget = sdk.getTarget(this.mEditedFile.getProject());
                if (iAndroidTarget == null) {
                    this.showErrorInEditor("The project target is not set.");
                    return;
                }
                AndroidTargetData androidTargetData = sdk.getTargetData(iAndroidTarget);
                if (androidTargetData == null) {
                    if (AdtPlugin.getDefault().getSdkLoadStatus() == LoadStatus.LOADING) return;
                    this.showErrorInEditor(String.format("The project target (%s) was not properly loaded.", iAndroidTarget.getName()));
                    return;
                }
                UiDocumentNode uiDocumentNode = this.getModel();
                if (uiDocumentNode.getUiChildren().size() == 0) {
                    this.showErrorInEditor("No Xml content. Go to the Outline view and add nodes.");
                    return;
                }
                AndroidTargetData.LayoutBridge layoutBridge = androidTargetData.getLayoutBridge();
                if (layoutBridge.bridge != null) {
                    ILayoutResult iLayoutResult;
                    int n;
                    int n2;
                    ResourceManager resourceManager = ResourceManager.getInstance();
                    ProjectResources projectResources = resourceManager.getProjectResources(iProject);
                    if (projectResources == null) {
                        return;
                    }
                    if (this.mConfiguredProjectRes == null) {
                        projectResources.loadAll();
                        this.mConfiguredProjectRes = projectResources.getConfiguredResources(this.mCurrentConfig);
                    }
                    Map<String, Map<String, IResourceValue>> map = this.getConfiguredFrameworkResources();
                    if (this.mConfiguredProjectRes == null) return;
                    if (map == null) return;
                    if (this.mProjectCallback == null) {
                        this.mProjectCallback = new ProjectCallback(layoutBridge.classLoader, projectResources, iProject);
                    }
                    if (this.mLogger == null) {
                        this.mLogger = new ILayoutLog(){

                            public void error(String string) {
                                AdtPlugin.printErrorToConsole(GraphicalLayoutEditor.this.mEditedFile.getName(), string);
                            }

                            public void error(Throwable throwable) {
                                String string = throwable.getMessage();
                                if (string == null) {
                                    string = throwable.getClass().getName();
                                }
                                PrintStream printStream = new PrintStream(AdtPlugin.getErrorStream());
                                throwable.printStackTrace(printStream);
                            }

                            public void warning(String string) {
                                AdtPlugin.printToConsole(GraphicalLayoutEditor.this.mEditedFile.getName(), string);
                            }
                        };
                    }
                    if ((n2 = this.mThemeCombo.getSelectionIndex()) == -1) return;
                    String string = this.mThemeCombo.getItem(n2);
                    UiElementPullParser uiElementPullParser = new UiElementPullParser(this.getModel());
                    Rectangle rectangle = this.getBounds();
                    boolean bl = n2 >= this.mPlatformThemeCount;
                    int n3 = PixelDensityQualifier.Density.MEDIUM.getDpiValue();
                    PixelDensityQualifier pixelDensityQualifier = this.mCurrentConfig.getPixelDensityQualifier();
                    if (pixelDensityQualifier != null && (n = pixelDensityQualifier.getValue().getDpiValue()) > 0) {
                        n3 = n;
                    }
                    if ((iLayoutResult = this.computeLayout(layoutBridge, uiElementPullParser, iProject, rectangle.width, rectangle.height, n3, n3, n3, string, bl, this.mConfiguredProjectRes, map, this.mProjectCallback, this.mLogger)).getSuccess() == 0) {
                        uiDocumentNode.setEditData(iLayoutResult.getImage());
                        this.updateNodeWithBounds(iLayoutResult.getRootView());
                    } else {
                        String string2 = iLayoutResult.getErrorMessage();
                        this.resetNodeBounds(uiDocumentNode);
                        if (string2 != null) {
                            uiDocumentNode.setEditData(string2);
                        }
                    }
                    uiDocumentNode.refreshUi();
                    return;
                }
                String string = null;
                string = layoutBridge.status == LoadStatus.LOADING ? String.format("Eclipse is loading framework information and the Layout library from the SDK folder.\n%1$s will refresh automatically once the process is finished.", this.mEditedFile.getName()) : String.format("Eclipse failed to load the framework information and the Layout library!", new Object[0]);
                this.showErrorInEditor(string);
                return;
            }
            String string = String.format("Eclipse is loading the SDK.\n%1$s will refresh automatically once the process is finished.", this.mEditedFile.getName());
            this.showErrorInEditor(string);
            return;
        }
        finally {
            this.mNeedsRecompute = false;
        }
    }

    private void showErrorInEditor(String string) {
        UiDocumentNode uiDocumentNode = this.getModel();
        this.resetNodeBounds(uiDocumentNode);
        if (string != null) {
            uiDocumentNode.setEditData(string);
        }
        uiDocumentNode.refreshUi();
    }

    private void resetNodeBounds(UiElementNode uiElementNode) {
        uiElementNode.setEditData(null);
        List<UiElementNode> list = uiElementNode.getUiChildren();
        for (UiElementNode uiElementNode2 : list) {
            this.resetNodeBounds(uiElementNode2);
        }
    }

    private void updateNodeWithBounds(ILayoutResult.ILayoutViewInfo iLayoutViewInfo) {
        if (iLayoutViewInfo != null) {
            Rectangle rectangle;
            Object object = iLayoutViewInfo.getViewKey();
            if (object instanceof UiElementNode) {
                rectangle = new Rectangle(iLayoutViewInfo.getLeft(), iLayoutViewInfo.getTop(), iLayoutViewInfo.getRight() - iLayoutViewInfo.getLeft(), iLayoutViewInfo.getBottom() - iLayoutViewInfo.getTop());
                ((UiElementNode)object).setEditData(rectangle);
            }
            if ((rectangle = iLayoutViewInfo.getChildren()) != null) {
                Rectangle rectangle2 = rectangle;
                int n = ((ILayoutResult.ILayoutViewInfo[])rectangle2).length;
                int n2 = 0;
                while (n2 < n) {
                    Rectangle rectangle3 = rectangle2[n2];
                    this.updateNodeWithBounds((ILayoutResult.ILayoutViewInfo)rectangle3);
                    ++n2;
                }
            }
        }
    }

    @Override
    public void reloadLayout(boolean bl, boolean bl2, boolean bl3) {
        boolean bl4 = bl2;
        if (bl3) {
            AndroidTargetData androidTargetData;
            bl4 = true;
            this.mConfiguredProjectRes = null;
            IAndroidTarget iAndroidTarget = Sdk.getCurrent().getTarget(this.mEditedFile.getProject());
            if (iAndroidTarget != null && (androidTargetData = Sdk.getCurrent().getTargetData(iAndroidTarget)) != null) {
                AndroidTargetData.LayoutBridge layoutBridge = androidTargetData.getLayoutBridge();
                if (layoutBridge.bridge != null) {
                    layoutBridge.bridge.clearCaches((Object)this.mEditedFile.getProject());
                }
            }
            this.mParent.getDisplay().asyncExec(this.mUiUpdateFromResourcesRunnable);
        }
        if (bl && this.mProjectCallback != null && this.mProjectCallback.isUsed()) {
            this.mProjectCallback = null;
            bl4 = true;
        }
        if (bl4) {
            this.mParent.getDisplay().asyncExec(this.mConditionalRecomputeRunnable);
        }
    }

    @Override
    void activated() {
        if (this.mNeedsRecompute || this.mNeedsXmlReload) {
            this.recomputeLayout();
        }
    }

    @Override
    void deactivated() {
    }

    private void updateUIFromResources() {
        Map<String, Map<String, IResourceValue>> map;
        ResourceManager resourceManager = ResourceManager.getInstance();
        ProjectResources projectResources = this.getFrameworkResources();
        this.mDisableUpdates = true;
        int n = this.mThemeCombo.getSelectionIndex();
        this.mThemeCombo.removeAll();
        this.mPlatformThemeCount = 0;
        this.mLanguage.removeAll();
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (projectResources != null) {
            Set<String> set;
            map = this.getConfiguredFrameworkResources();
            if (map != null) {
                Map<String, IResourceValue> object3 = map.get(ResourceType.STYLE.getName());
                for (IResourceValue iResourceValue : object3.values()) {
                    String string = iResourceValue.getName();
                    if (!string.startsWith("Theme.") && !string.equals("Theme")) continue;
                    arrayList.add(iResourceValue.getName());
                    ++this.mPlatformThemeCount;
                }
                Collections.sort(arrayList);
                for (String string : arrayList) {
                    this.mThemeCombo.add(string);
                }
                this.mPlatformThemeCount = arrayList.size();
                arrayList.clear();
            }
            if ((set = projectResources.getLanguages()) != null) {
                hashSet.addAll(set);
            }
        }
        map = null;
        if (this.mEditedFile != null && (map = resourceManager.getProjectResources(this.mEditedFile.getProject())) != null) {
            Set<String> set;
            Map<String, IResourceValue> map2;
            if (this.mConfiguredProjectRes == null) {
                ((ProjectResources)((Object)map)).loadAll();
                this.mConfiguredProjectRes = ((ProjectResources)((Object)map)).getConfiguredResources(this.mCurrentConfig);
            }
            if (this.mConfiguredProjectRes != null && (map2 = this.mConfiguredProjectRes.get(ResourceType.STYLE.getName())) != null) {
                for (IResourceValue iResourceValue : map2.values()) {
                    if (!this.isTheme(iResourceValue, map2)) continue;
                    arrayList.add(iResourceValue.getName());
                }
                if (this.mPlatformThemeCount > 0 && arrayList.size() > 0) {
                    this.mThemeCombo.add(THEME_SEPARATOR);
                }
                Collections.sort(arrayList);
                for (String string : arrayList) {
                    this.mThemeCombo.add(string);
                }
            }
            if ((set = ((ProjectResources)((Object)map)).getLanguages()) != null) {
                hashSet.addAll(set);
            }
        }
        for (String string : hashSet) {
            this.mLanguage.add(string);
        }
        this.mDisableUpdates = false;
        this.updateRegionUi((ProjectResources)((Object)map), projectResources);
        if (this.mThemeCombo.getItemCount() > 0) {
            this.mThemeCombo.setEnabled(true);
            if (n == -1) {
                n = 0;
            }
            if (this.mThemeCombo.getItemCount() <= n) {
                this.mThemeCombo.select(0);
            } else {
                this.mThemeCombo.select(n);
            }
        } else {
            this.mThemeCombo.setEnabled(false);
        }
    }

    private boolean isTheme(IResourceValue iResourceValue, Map<String, IResourceValue> map) {
        if (iResourceValue instanceof IStyleResourceValue) {
            IStyleResourceValue iStyleResourceValue = (IStyleResourceValue)iResourceValue;
            boolean bl = false;
            String string = iStyleResourceValue.getParentStyle();
            if (string == null) {
                String string2 = iStyleResourceValue.getName();
                int n = string2.lastIndexOf(46);
                if (n != -1) {
                    string = string2.substring(0, n);
                }
            } else {
                if (string.startsWith("@")) {
                    string = string.substring(1);
                }
                if (string.startsWith("android:")) {
                    bl = true;
                    string = string.substring("android:".length());
                }
                if (string.startsWith("style/")) {
                    string = string.substring("style/".length());
                }
            }
            if (bl) {
                return string.equals("Theme") || string.startsWith("Theme.");
            }
            iResourceValue = map.get(string);
            if (iResourceValue != null) {
                return this.isTheme(iResourceValue, map);
            }
        }
        return false;
    }

    private void updateRegionUi(ProjectResources projectResources, ProjectResources projectResources2) {
        if (projectResources == null && this.mEditedFile != null) {
            projectResources = ResourceManager.getInstance().getProjectResources(this.mEditedFile.getProject());
        }
        if (projectResources2 == null) {
            projectResources2 = this.getFrameworkResources();
        }
        String string = this.mLanguage.getText();
        Set<String> set = null;
        if (projectResources != null) {
            set = projectResources.getRegions(string);
        }
        if (projectResources2 != null) {
            if (set != null) {
                Set<String> object = projectResources2.getRegions(string);
                set.addAll(object);
            } else {
                set = projectResources2.getRegions(string);
            }
        }
        if (set != null) {
            this.mDisableUpdates = true;
            this.mRegion.removeAll();
            for (String string2 : set) {
                this.mRegion.add(string2);
            }
            this.mDisableUpdates = false;
        }
    }

    private Map<String, Map<String, IResourceValue>> getConfiguredFrameworkResources() {
        if (this.mConfiguredFrameworkRes == null) {
            ProjectResources projectResources = this.getFrameworkResources();
            if (projectResources == null) {
                AdtPlugin.log(4, "Failed to get ProjectResource for the framework", new Object[0]);
            }
            this.mConfiguredFrameworkRes = projectResources.getConfiguredResources(this.mCurrentConfig);
        }
        return this.mConfiguredFrameworkRes;
    }

    private void createAlternateLayout(final FolderConfiguration folderConfiguration) {
        new Job("Create Alternate Resource"){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                String string = folderConfiguration.getFolderName(ResourceFolderType.LAYOUT, Sdk.getCurrent().getTarget(GraphicalLayoutEditor.this.mEditedFile.getProject()));
                try {
                    int n;
                    IFolder iFolder = (IFolder)GraphicalLayoutEditor.this.mEditedFile.getParent().getParent();
                    String string2 = iFolder.getLocation().toOSString();
                    File file = new File(String.valueOf(string2) + File.separator + string);
                    if (file.isFile()) {
                        String string3 = String.format("File 'res/%1$s' is in the way!", string);
                        AdtPlugin.displayError("Layout Creation", string3);
                        return new Status(4, "com.android.ide.eclipse.adt", string3);
                    }
                    if (!file.exists()) {
                        file.mkdir();
                    }
                    File file2 = new File(String.valueOf(file.getAbsolutePath()) + File.separator + GraphicalLayoutEditor.this.mEditedFile.getName());
                    file2.createNewFile();
                    InputStream inputStream = GraphicalLayoutEditor.this.mEditedFile.getContents();
                    FileOutputStream fileOutputStream = new FileOutputStream(file2);
                    byte[] byArray = new byte[512];
                    while ((n = inputStream.read(byArray)) != -1) {
                        fileOutputStream.write(byArray, 0, n);
                    }
                    inputStream.close();
                    fileOutputStream.close();
                    iFolder.refreshLocal(2, new IProgressMonitor(){

                        public void done() {
                            GraphicalLayoutEditor.this.mCurrentConfig.set(folderConfiguration);
                            GraphicalLayoutEditor.this.mParent.getDisplay().asyncExec(new Runnable(){

                                public void run() {
                                    GraphicalLayoutEditor.this.onConfigurationChange();
                                }
                            });
                        }

                        public void beginTask(String string, int n) {
                        }

                        public void internalWorked(double d) {
                        }

                        public boolean isCanceled() {
                            return false;
                        }

                        public void setCanceled(boolean bl) {
                        }

                        public void setTaskName(String string) {
                        }

                        public void subTask(String string) {
                        }

                        public void worked(int n) {
                        }
                    });
                }
                catch (IOException iOException) {
                    String string4 = String.format("Failed to create File 'res/%1$s/%2$s' : %3$s", string, GraphicalLayoutEditor.this.mEditedFile.getName(), iOException.getMessage());
                    AdtPlugin.displayError("Layout Creation", string4);
                    return new Status(4, "com.android.ide.eclipse.adt", string4, (Throwable)iOException);
                }
                catch (CoreException coreException) {
                    String string5 = String.format("Failed to create File 'res/%1$s/%2$s' : %3$s", string, GraphicalLayoutEditor.this.mEditedFile.getName(), coreException.getMessage());
                    AdtPlugin.displayError("Layout Creation", string5);
                    return coreException.getStatus();
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private ProjectResources getFrameworkResources() {
        AndroidTargetData androidTargetData;
        IAndroidTarget iAndroidTarget;
        Sdk sdk;
        if (this.mEditedFile != null && (sdk = Sdk.getCurrent()) != null && (iAndroidTarget = sdk.getTarget(this.mEditedFile.getProject())) != null && (androidTargetData = sdk.getTargetData(iAndroidTarget)) != null) {
            return androidTargetData.getFrameworkResources();
        }
        return null;
    }

    private ILayoutResult computeLayout(AndroidTargetData.LayoutBridge layoutBridge, IXmlPullParser iXmlPullParser, Object object, int n, int n2, int n3, float f, float f2, String string, boolean bl, Map<String, Map<String, IResourceValue>> map, Map<String, Map<String, IResourceValue>> map2, IProjectCallback iProjectCallback, ILayoutLog iLayoutLog) {
        if (layoutBridge.apiLevel >= 3) {
            return layoutBridge.bridge.computeLayout(iXmlPullParser, object, n, n2, n3, f, f2, string, bl, map, map2, iProjectCallback, iLayoutLog);
        }
        if (layoutBridge.apiLevel == 2) {
            return layoutBridge.bridge.computeLayout(iXmlPullParser, object, n, n2, string, bl, this.mConfiguredProjectRes, map2, (IProjectCallback)this.mProjectCallback, this.mLogger);
        }
        if (bl) {
            string = "*" + string;
        }
        return layoutBridge.bridge.computeLayout(iXmlPullParser, object, n, n2, string, this.mConfiguredProjectRes, map2, (IProjectCallback)this.mProjectCallback, this.mLogger);
    }

    private class ActionMenuListener
    implements IMenuListener {
        private final GraphicalViewer mViewer;

        public ActionMenuListener(GraphicalViewer graphicalViewer) {
            this.mViewer = graphicalViewer;
        }

        public void menuAboutToShow(IMenuManager iMenuManager) {
            ArrayList<UiElementNode> arrayList = new ArrayList<UiElementNode>();
            for (Object e : this.mViewer.getSelectedEditParts()) {
                UiElementEditPart uiElementEditPart;
                UiElementNode uiElementNode;
                if (!(e instanceof UiElementEditPart) || (uiElementNode = (uiElementEditPart = (UiElementEditPart)e).getUiNode()) == null) continue;
                arrayList.add(uiElementNode);
            }
            if (arrayList.size() > 0) {
                GraphicalLayoutEditor.this.doCreateMenuAction(iMenuManager, this.mViewer, arrayList);
            }
        }
    }

    class DropListener
    extends TemplateTransferDropTargetListener {
        public DropListener(EditPartViewer editPartViewer) {
            super(editPartViewer);
        }

        protected CreationFactory getFactory(final Object object) {
            return new CreationFactory(){

                public Object getNewObject() {
                    return null;
                }

                public Object getObjectType() {
                    return object;
                }
            };
        }
    }
}

