/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.descriptors;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.editors.IconFactory;
import com.android.ide.eclipse.adt.internal.editors.descriptors.AttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiElementNode;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementDescriptor {
    private String mXmlName;
    private String mUiName;
    private AttributeDescriptor[] mAttributes;
    private ElementDescriptor[] mChildren;
    private String mTooltip;
    private String mSdkUrl;
    private boolean mMandatory;

    public ElementDescriptor(String string, String string2, String string3, String string4, AttributeDescriptor[] attributeDescriptorArray, ElementDescriptor[] elementDescriptorArray, boolean bl) {
        this.mMandatory = bl;
        this.mXmlName = string;
        this.mUiName = string2;
        this.mTooltip = string3 != null && string3.length() > 0 ? string3 : null;
        this.mSdkUrl = string4 != null && string4.length() > 0 ? string4 : null;
        this.setAttributes(attributeDescriptorArray != null ? attributeDescriptorArray : new AttributeDescriptor[]{});
        this.mChildren = elementDescriptorArray != null ? elementDescriptorArray : new ElementDescriptor[]{};
    }

    public ElementDescriptor(String string, ElementDescriptor[] elementDescriptorArray, boolean bl) {
        this(string, ElementDescriptor.prettyName(string), null, null, null, elementDescriptorArray, bl);
    }

    public ElementDescriptor(String string, ElementDescriptor[] elementDescriptorArray) {
        this(string, ElementDescriptor.prettyName(string), null, null, null, elementDescriptorArray, false);
    }

    public ElementDescriptor(String string) {
        this(string, ElementDescriptor.prettyName(string), null, null, null, null, false);
    }

    public boolean isMandatory() {
        return this.mMandatory;
    }

    public final String getXmlLocalName() {
        int n = this.mXmlName.indexOf(58);
        if (n != -1) {
            return this.mXmlName.substring(n + 1);
        }
        return this.mXmlName;
    }

    public String getXmlName() {
        return this.mXmlName;
    }

    public final String getNamespace() {
        if (this.mXmlName.startsWith("android:")) {
            return "http://schemas.android.com/apk/res/android";
        }
        return "";
    }

    public String getUiName() {
        return this.mUiName;
    }

    public Image getIcon() {
        IconFactory iconFactory = IconFactory.getInstance();
        int n = this.hasChildren() ? 10 : 6;
        int n2 = this.hasChildren() ? 82 : 67;
        Image image = iconFactory.getIcon(this.mXmlName, n, n2);
        return image != null ? image : AdtPlugin.getAndroidLogo();
    }

    public ImageDescriptor getImageDescriptor() {
        IconFactory iconFactory = IconFactory.getInstance();
        int n = this.hasChildren() ? 10 : 6;
        int n2 = this.hasChildren() ? 82 : 67;
        ImageDescriptor imageDescriptor = iconFactory.getImageDescriptor(this.mXmlName, n, n2);
        return imageDescriptor != null ? imageDescriptor : AdtPlugin.getAndroidLogoDesc();
    }

    public AttributeDescriptor[] getAttributes() {
        return this.mAttributes;
    }

    public void setAttributes(AttributeDescriptor[] attributeDescriptorArray) {
        this.mAttributes = attributeDescriptorArray;
        AttributeDescriptor[] attributeDescriptorArray2 = attributeDescriptorArray;
        int n = attributeDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            AttributeDescriptor attributeDescriptor = attributeDescriptorArray2[n2];
            attributeDescriptor.setParent(this);
            ++n2;
        }
    }

    public ElementDescriptor[] getChildren() {
        return this.mChildren;
    }

    public boolean hasChildren() {
        return this.mChildren.length > 0;
    }

    public void setChildren(ElementDescriptor[] elementDescriptorArray) {
        this.mChildren = elementDescriptorArray;
    }

    public void setChildren(Collection<ElementDescriptor> collection) {
        this.setChildren(collection.toArray(new ElementDescriptor[collection.size()]));
    }

    public String getTooltip() {
        return this.mTooltip;
    }

    public String getSdkUrl() {
        return this.mSdkUrl;
    }

    public void setTooltip(String string) {
        this.mTooltip = string;
    }

    public void setSdkUrl(String string) {
        this.mSdkUrl = string;
    }

    public UiElementNode createUiNode() {
        return new UiElementNode(this);
    }

    public ElementDescriptor findChildrenDescriptor(String string, boolean bl) {
        return this.findChildrenDescriptorInternal(string, bl, null);
    }

    private ElementDescriptor findChildrenDescriptorInternal(String string, boolean bl, Set<ElementDescriptor> set) {
        ElementDescriptor elementDescriptor;
        if (bl && set == null) {
            set = new HashSet<ElementDescriptor>();
        }
        ElementDescriptor[] elementDescriptorArray = this.getChildren();
        int n = elementDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            elementDescriptor = elementDescriptorArray[n2];
            if (elementDescriptor.getXmlName().equals(string)) {
                return elementDescriptor;
            }
            ++n2;
        }
        if (set != null) {
            set.add(this);
        }
        if (bl) {
            elementDescriptorArray = this.getChildren();
            n = elementDescriptorArray.length;
            n2 = 0;
            while (n2 < n) {
                ElementDescriptor elementDescriptor2;
                elementDescriptor = elementDescriptorArray[n2];
                if ((set == null || set.add(elementDescriptor)) && (elementDescriptor2 = elementDescriptor.findChildrenDescriptorInternal(string, bl, set)) != null) {
                    return elementDescriptor2;
                }
                ++n2;
            }
        }
        return null;
    }

    private static String prettyName(String string) {
        char[] cArray = string.toCharArray();
        if (cArray.length > 0) {
            cArray[0] = Character.toUpperCase(cArray[0]);
        }
        return new String(cArray).replace("-", " ");
    }
}

