/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.descriptors;

import com.android.ide.eclipse.adt.internal.editors.descriptors.AttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.BooleanAttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.ElementDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.FlagAttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.ListAttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.ReferenceAttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.TextAttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiDocumentNode;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiElementNode;
import com.android.ide.eclipse.adt.internal.resources.DeclareStyleableInfo;
import com.android.ide.eclipse.adt.internal.resources.ResourceType;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DescriptorsUtils {
    private static final String DEFAULT_WIDGET_PREFIX = "widget";
    private static final int JAVADOC_BREAK_LENGTH = 60;
    public static final String MANIFEST_SDK_URL = "/reference/android/R.styleable.html#";
    public static final String IMAGE_KEY = "image";
    private static final String CODE = "$code";
    private static final String LINK = "$link";
    private static final String ELEM = "$elem";
    private static final String BREAK = "$break";

    public static void appendAttributes(ArrayList<AttributeDescriptor> arrayList, String string, String string2, DeclareStyleableInfo.AttributeInfo[] attributeInfoArray, Set<String> set, Map<String, Object> map) {
        DeclareStyleableInfo.AttributeInfo[] attributeInfoArray2 = attributeInfoArray;
        int n = attributeInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string3;
            DeclareStyleableInfo.AttributeInfo attributeInfo = attributeInfoArray2[n2];
            boolean bl = false;
            if (set != null && (set.contains("*/" + (string3 = attributeInfo.getName())) || set.contains(String.valueOf(string) + "/" + string3))) {
                bl = true;
            }
            DescriptorsUtils.appendAttribute(arrayList, string, string2, attributeInfo, bl, map);
            ++n2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void appendAttribute(ArrayList<AttributeDescriptor> arrayList, String string, String string2, DeclareStyleableInfo.AttributeInfo attributeInfo, boolean bl, Map<String, Object> map) {
        DeclareStyleableInfo.AttributeInfo.Format[] formatArray;
        int n;
        String string3;
        AttributeDescriptor attributeDescriptor = null;
        String string4 = attributeInfo.getName();
        String string5 = DescriptorsUtils.prettyAttributeUiName(attributeInfo.getName());
        if (bl) {
            string5 = String.valueOf(string5) + "*";
        }
        String string6 = null;
        String string7 = attributeInfo.getJavaDoc();
        if (string7 == null) {
            string7 = "";
        }
        if ((string3 = attributeInfo.getDeprecatedDoc()) != null) {
            if (string7.length() > 0) {
                string7 = String.valueOf(string7) + "@@";
            }
            string7 = String.valueOf(string7) + "* Deprecated";
            if (string3.length() != 0) {
                string7 = String.valueOf(string7) + ": " + string3;
            }
            if (string3.length() == 0 || !string3.endsWith(".")) {
                string7 = String.valueOf(string7) + ".";
            }
        }
        if ((n = (formatArray = attributeInfo.getFormats()).length) > 0) {
            void entry;
            HashSet<DeclareStyleableInfo.AttributeInfo.Format> hashSet = new HashSet<DeclareStyleableInfo.AttributeInfo.Format>();
            StringBuilder stringBuilder = new StringBuilder();
            if (string7 != null && string7.length() > 0) {
                stringBuilder.append(string7);
                stringBuilder.append(" ");
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.append("@@");
            }
            stringBuilder.append("[");
            boolean n2 = false;
            while (entry < n) {
                DeclareStyleableInfo.AttributeInfo.Format format = formatArray[entry];
                hashSet.add(format);
                stringBuilder.append(format.toString().toLowerCase());
                if (entry < n - 1) {
                    stringBuilder.append(", ");
                }
                ++entry;
            }
            stringBuilder.append("]");
            if (bl) {
                stringBuilder.append(".@@* ");
                stringBuilder.append("Required.");
            }
            stringBuilder.append(" ");
            string7 = stringBuilder.toString();
            string6 = DescriptorsUtils.formatTooltip(string7);
            if (map != null) {
                for (Map.Entry entry2 : map.entrySet()) {
                    Object object;
                    boolean bl2;
                    String string8 = (String)entry2.getKey();
                    String[] stringArray = string8.split("/");
                    String string9 = null;
                    if (stringArray.length < 1) continue;
                    if (stringArray.length == 1) {
                        string9 = stringArray[0];
                        stringArray = null;
                    } else {
                        string9 = stringArray[stringArray.length - 1];
                        stringArray = stringArray[0].split(",");
                    }
                    if (string9 == null || !string9.equals(string4)) continue;
                    boolean bl3 = bl2 = stringArray.length < 1;
                    if (!bl2) {
                        String[] stringArray2 = stringArray;
                        int constructor = stringArray.length;
                        int clazz = 0;
                        while (clazz < constructor) {
                            object = stringArray2[clazz];
                            if (((String)object).equals("*") || ((String)object).equals(string)) {
                                bl2 = true;
                                break;
                            }
                            ++clazz;
                        }
                    }
                    if (!bl2) continue;
                    object = entry2.getValue();
                    if (object instanceof Class) {
                        try {
                            Class clazz = (Class)object;
                            Constructor constructor = clazz.getConstructor(String.class, String.class, String.class, String.class);
                            attributeDescriptor = (AttributeDescriptor)constructor.newInstance(string4, string5, string2, string6);
                        }
                        catch (SecurityException securityException) {
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                        }
                        catch (InstantiationException instantiationException) {
                        }
                        catch (IllegalAccessException illegalAccessException) {
                        }
                        catch (InvocationTargetException invocationTargetException) {}
                        continue;
                    }
                    if (!(object instanceof ITextAttributeCreator)) continue;
                    attributeDescriptor = ((ITextAttributeCreator)object).create(string4, string5, string2, string6);
                }
            }
            if (attributeDescriptor == null) {
                if (hashSet.contains((Object)DeclareStyleableInfo.AttributeInfo.Format.REFERENCE)) {
                    attributeDescriptor = new ReferenceAttributeDescriptor(string4, string5, string2, string6);
                } else if (hashSet.contains((Object)DeclareStyleableInfo.AttributeInfo.Format.ENUM)) {
                    attributeDescriptor = new ListAttributeDescriptor(string4, string5, string2, string6, attributeInfo.getEnumValues());
                } else if (hashSet.contains((Object)DeclareStyleableInfo.AttributeInfo.Format.FLAG)) {
                    attributeDescriptor = new FlagAttributeDescriptor(string4, string5, string2, string6, attributeInfo.getFlagValues());
                } else if (hashSet.contains((Object)DeclareStyleableInfo.AttributeInfo.Format.BOOLEAN)) {
                    attributeDescriptor = new BooleanAttributeDescriptor(string4, string5, string2, string6);
                } else if (hashSet.contains((Object)DeclareStyleableInfo.AttributeInfo.Format.STRING)) {
                    attributeDescriptor = new ReferenceAttributeDescriptor(ResourceType.STRING, string4, string5, string2, string6);
                }
            }
        }
        if (attributeDescriptor == null) {
            if (string6 == null) {
                string6 = DescriptorsUtils.formatTooltip(string7);
            }
            attributeDescriptor = new TextAttributeDescriptor(string4, string5, string2, string6);
        }
        attributeDescriptor.setDeprecated(attributeInfo.getDeprecatedDoc() != null);
        arrayList.add(attributeDescriptor);
    }

    public static boolean containsAttribute(ArrayList<AttributeDescriptor> arrayList, String string, DeclareStyleableInfo.AttributeInfo attributeInfo) {
        String string2 = attributeInfo.getName();
        for (AttributeDescriptor attributeDescriptor : arrayList) {
            if (!attributeDescriptor.getXmlLocalName().equals(string2) || string != attributeDescriptor.getNamespaceUri() && (string == null || !string.equals(attributeDescriptor.getNamespaceUri()))) continue;
            return true;
        }
        return false;
    }

    public static String prettyAttributeUiName(String string) {
        if (string.length() < 1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.charAt(0);
        stringBuffer.append((char)(n >= 97 && n <= 122 ? n + 65 - 97 : n));
        int n2 = string.length();
        int n3 = 1;
        while (n3 < n2) {
            n = string.charAt(n3);
            if (n >= 65 && n <= 90) {
                stringBuffer.append(' ');
                if (n >= 88 && n <= 90 && (n3 == n2 - 1 || n3 < n2 - 1 && string.charAt(n3 + 1) >= 'A' && string.charAt(n3 + 1) <= 'Z')) {
                    stringBuffer.append((char)n);
                } else {
                    stringBuffer.append((char)(n - 65 + 97));
                }
            } else if (n == 95) {
                stringBuffer.append(' ');
            } else {
                stringBuffer.append((char)n);
            }
            ++n3;
        }
        string = stringBuffer.toString();
        string = string.replaceAll("(?<=^| )sdk(?=$| )", "SDK");
        string = string.replaceAll("(?<=^| )uri(?=$| )", "URI");
        return string;
    }

    public static String capitalize(String string) {
        if (string == null || string.length() < 1 || string.charAt(0) < 'a' || string.charAt(0) > 'z') {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((char)(string.charAt(0) + 65 - 97));
        stringBuilder.append(string.substring(1));
        return stringBuilder.toString();
    }

    public static String formatTooltip(String string) {
        ArrayList<String> arrayList = DescriptorsUtils.scanJavadoc(string);
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            String string2 = arrayList.get(n2);
            if (CODE.equals(string2)) {
                if ((string2 = arrayList.get(++n2)) != null) {
                    stringBuilder.append('\"').append(string2).append('\"');
                }
            } else if (LINK.equals(string2)) {
                String string3 = arrayList.get(++n2);
                String string4 = arrayList.get(++n2);
                String string5 = arrayList.get(++n2);
                if (string3 != null) {
                    string3 = string3.trim();
                }
                if (string4 != null) {
                    string4 = string4.trim();
                }
                if (string5 != null) {
                    string5 = string5.trim();
                }
                if (string5 == null || string5.length() == 0) {
                    string5 = string4;
                }
                if (string3 != null && string3.length() > 0 && (string5 == null || string5.length() == 0)) {
                    string5 = string3;
                }
                if (string5 != null) {
                    stringBuilder.append(string5);
                }
            } else if (ELEM.equals(string2)) {
                if ((string2 = arrayList.get(++n2)) != null) {
                    stringBuilder.append(string2);
                }
            } else if (BREAK.equals(string2)) {
                bl = true;
            } else if (string2 != null) {
                if (bl && string2.trim().length() > 0) {
                    stringBuilder.append('\r');
                }
                stringBuilder.append(string2);
                bl = false;
            }
            ++n2;
        }
        return stringBuilder.toString();
    }

    public static String formatFormText(String string, ElementDescriptor elementDescriptor, String string2) {
        ArrayList<String> arrayList = DescriptorsUtils.scanJavadoc(string);
        String string3 = String.valueOf(string2) + MANIFEST_SDK_URL;
        String string4 = elementDescriptor.getSdkUrl();
        if (string4 != null && string4.startsWith(MANIFEST_SDK_URL)) {
            string3 = String.valueOf(string2) + string4;
        }
        StringBuilder stringBuilder = new StringBuilder();
        Image image = elementDescriptor.getIcon();
        if (image != null) {
            stringBuilder.append("<form><li style=\"image\" value=\"image\">");
        } else {
            stringBuilder.append("<form><p>");
        }
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            String string5 = arrayList.get(n2);
            if (CODE.equals(string5)) {
                string5 = arrayList.get(++n2);
                if (elementDescriptor.getXmlName().equals(string5) && string3 != null) {
                    stringBuilder.append("<a href=\"");
                    stringBuilder.append(string3);
                    stringBuilder.append("\">");
                    stringBuilder.append(string5);
                    stringBuilder.append("</a>");
                } else if (string5 != null) {
                    stringBuilder.append('\"').append(string5).append('\"');
                }
            } else if (LINK.equals(string5)) {
                String string6 = arrayList.get(++n2);
                String string7 = arrayList.get(++n2);
                String string8 = arrayList.get(++n2);
                if (string6 != null) {
                    string6 = string6.trim();
                }
                if (string7 != null) {
                    string7 = string7.trim();
                }
                if (string8 != null) {
                    string8 = string8.trim();
                }
                if (string8 == null || string8.length() == 0) {
                    string8 = string7;
                }
                if ((string6 == null || string6.length() == 0) && string3 != null) {
                    string6 = string3;
                }
                String string9 = null;
                if (string6 != null && string6.length() > 0) {
                    if (string6.startsWith("http")) {
                        string9 = string6;
                        if (string7 != null && string7.length() > 0) {
                            int n3 = string9.lastIndexOf(35);
                            if (n3 < 0) {
                                string9 = String.valueOf(string9) + "#";
                            } else if (n3 < string9.length() - 1) {
                                string9 = string9.substring(0, n3 + 1);
                            }
                            string9 = String.valueOf(string9) + string7;
                        }
                    } else if (string8 == null || string8.length() == 0) {
                        string8 = string6;
                    }
                }
                if (string9 != null && string8 != null) {
                    stringBuilder.append("<a href=\"");
                    stringBuilder.append(string9);
                    stringBuilder.append("\">");
                    stringBuilder.append(string8);
                    stringBuilder.append("</a>");
                } else if (string8 != null) {
                    stringBuilder.append("<b>").append(string8).append("</b>");
                }
            } else if (ELEM.equals(string5)) {
                string5 = arrayList.get(++n2);
                if (string4 != null && string5 != null) {
                    stringBuilder.append("<a href=\"");
                    stringBuilder.append(string4);
                    stringBuilder.append("\">");
                    stringBuilder.append(string5);
                    stringBuilder.append("</a>");
                } else if (string5 != null) {
                    stringBuilder.append("<b>").append(string5).append("</b>");
                }
            } else if (!BREAK.equals(string5) && string5 != null) {
                stringBuilder.append(string5);
            }
            ++n2;
        }
        if (image != null) {
            stringBuilder.append("</li></form>");
        } else {
            stringBuilder.append("</p></form>");
        }
        return stringBuilder.toString();
    }

    private static ArrayList<String> scanJavadoc(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string != null) {
            string = string.replaceAll("[ \t\f\r\n]+", " ");
        }
        Pattern pattern = Pattern.compile("\\{@link\\s+([^#\\}\\s]*)(?:#([^\\s\\}]*))?(?:\\s*([^\\}]*))?\\}(.*)");
        Pattern pattern2 = Pattern.compile("<code>(.+?)</code>(.*)");
        Pattern pattern3 = Pattern.compile("@([\\w -]+)@(.*)");
        Pattern pattern4 = Pattern.compile("@@(.*)");
        Pattern pattern5 = Pattern.compile("([@<\\{])(.*)");
        Pattern pattern6 = Pattern.compile("([^@<\\{]+)(.*)");
        int n = 0;
        String string2 = null;
        while (string != null && string.length() > 0) {
            String string3 = null;
            Matcher matcher = pattern2.matcher(string);
            if (matcher.matches()) {
                arrayList.add(CODE);
                string2 = DescriptorsUtils.cleanupJavadocHtml(matcher.group(1));
                arrayList.add(string2);
                string = matcher.group(2);
                if (string2 != null) {
                    n += string2.length();
                }
            } else {
                matcher = pattern.matcher(string);
                if (matcher.matches()) {
                    arrayList.add(LINK);
                    arrayList.add(matcher.group(1));
                    arrayList.add(matcher.group(2));
                    string2 = DescriptorsUtils.cleanupJavadocHtml(matcher.group(3));
                    arrayList.add(string2);
                    string = matcher.group(4);
                    if (string2 != null) {
                        n += string2.length();
                    }
                } else {
                    matcher = pattern3.matcher(string);
                    if (matcher.matches()) {
                        arrayList.add(ELEM);
                        string2 = DescriptorsUtils.cleanupJavadocHtml(matcher.group(1));
                        arrayList.add(string2);
                        string = matcher.group(2);
                        if (string2 != null) {
                            n += string2.length() - 2;
                        }
                    } else {
                        matcher = pattern4.matcher(string);
                        if (matcher.matches()) {
                            arrayList.add(BREAK);
                            n = 0;
                            string = matcher.group(1);
                        } else {
                            matcher = pattern5.matcher(string);
                            if (matcher.matches()) {
                                string3 = matcher.group(1);
                                string = matcher.group(2);
                            } else {
                                matcher = pattern6.matcher(string);
                                if (matcher.matches()) {
                                    string3 = matcher.group(1);
                                    string = matcher.group(2);
                                } else {
                                    string3 = string;
                                    string = null;
                                }
                            }
                        }
                    }
                }
            }
            if (string3 == null || string3.length() <= 0) continue;
            string3 = DescriptorsUtils.cleanupJavadocHtml(string3);
            if (n >= 60) {
                arrayList.add(BREAK);
                n = 0;
            }
            while (n + string3.length() > 60) {
                int n2 = string3.indexOf(32, 60 - n);
                if (n2 <= 0) break;
                arrayList.add(string3.substring(0, n2 + 1));
                arrayList.add(BREAK);
                n = 0;
                string3 = string3.substring(n2 + 1);
            }
            arrayList.add(string3);
            n += string3.length();
        }
        return arrayList;
    }

    private static String cleanupJavadocHtml(String string) {
        if (string != null) {
            string = string.replaceAll("&lt;", "\"");
            string = string.replaceAll("&gt;", "\"");
            string = string.replaceAll("<[^>]+>", "");
        }
        return string;
    }

    public static void setDefaultLayoutAttributes(UiElementNode uiElementNode, boolean bl) {
        String string;
        UiElementNode uiElementNode2;
        UiElementNode uiElementNode3;
        boolean bl2 = uiElementNode.getDescriptor().hasChildren() && uiElementNode.getUiParent() instanceof UiDocumentNode;
        uiElementNode.setAttributeValue("layout_width", bl2 ? "fill_parent" : "wrap_content", false);
        uiElementNode.setAttributeValue("layout_height", bl2 ? "fill_parent" : "wrap_content", false);
        String string2 = DescriptorsUtils.getFreeWidgetId(uiElementNode);
        if (string2 != null) {
            uiElementNode.setAttributeValue("id", string2, false);
        }
        uiElementNode.setAttributeValue("text", string2, false);
        if (bl && (uiElementNode3 = uiElementNode.getUiParent()) != null && uiElementNode3.getDescriptor().getXmlLocalName().equals("RelativeLayout") && (uiElementNode2 = uiElementNode.getUiPreviousSibling()) != null && (string = uiElementNode2.getAttributeValue("id")) != null && string.length() > 0) {
            string = string.replace("@+", "@");
            uiElementNode.setAttributeValue("layout_below", string, false);
        }
    }

    public static String getFreeWidgetId(UiElementNode uiElementNode) {
        String string = uiElementNode.getDescriptor().getXmlLocalName();
        if ("TabWidget".equals(string)) {
            return "@android:id/tabs";
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = string;
        return "@+id/" + DescriptorsUtils.getFreeWidgetId(uiElementNode.getUiRoot(), objectArray);
    }

    private static String getFreeWidgetId(UiElementNode uiElementNode, Object[] objectArray) {
        String string;
        HashSet<String> hashSet = (HashSet<String>)objectArray[3];
        if (hashSet == null) {
            objectArray[3] = hashSet = new HashSet<String>();
        }
        int n = objectArray[1] == null ? 0 : (Integer)objectArray[1];
        String string2 = (String)objectArray[2];
        String string3 = (String)objectArray[0];
        if (string2 == null) {
            int n2 = string3.indexOf(46);
            if (n2 >= 0) {
                string3 = string3.substring(n2 + 1);
            }
            if ((n2 = string3.indexOf(36)) >= 0) {
                string3 = string3.substring(n2 + 1);
            }
            if ((string3 = string3.replaceAll("[^a-zA-Z]", "")).length() == 0) {
                string3 = DEFAULT_WIDGET_PREFIX;
            }
            while (hashSet.contains(string2 = String.format("%1$s%2$02d", string3, ++n))) {
            }
            objectArray[0] = string3;
            objectArray[1] = n;
            objectArray[2] = string2;
        }
        if ((string = uiElementNode.getAttributeValue("id")) != null) {
            string = string.replace("@+id/", "");
            if (hashSet.add(string = string.replace("@id/", "")) && hashSet.contains(string2)) {
                while (hashSet.contains(string2 = String.format("%1$s%2$02d", string3, ++n))) {
                }
                objectArray[1] = n;
                objectArray[2] = string2;
            }
        }
        for (UiElementNode uiElementNode2 : uiElementNode.getUiChildren()) {
            DescriptorsUtils.getFreeWidgetId(uiElementNode2, objectArray);
        }
        return (String)objectArray[2];
    }

    public static interface ITextAttributeCreator {
        public TextAttributeDescriptor create(String var1, String var2, String var3, String var4);
    }
}

