/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.build;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.build.Messages;
import com.android.ide.eclipse.adt.internal.project.BaseProjectHelper;
import com.android.ide.eclipse.adt.internal.project.ProjectHelper;
import com.android.ide.eclipse.adt.internal.project.XmlErrorHandler;
import com.android.ide.eclipse.adt.internal.sdk.LoadStatus;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BaseBuilder
extends IncrementalProjectBuilder {
    private static final Pattern sPattern0Line1 = Pattern.compile("^\\s+\\(skipping hidden file\\s'(.*)'\\)$");
    private static final Pattern sPattern1Line1 = Pattern.compile("^ERROR\\s+at\\s+line\\s+(\\d+):\\s+(.*)$");
    private static final Pattern sPattern1Line2 = Pattern.compile("^\\s+\\(Occurred while parsing\\s+(.*)\\)$");
    private static final Pattern sPattern2Line1 = Pattern.compile("^ERROR:\\s+(.+)$");
    private static final Pattern sPattern2Line2 = Pattern.compile("Defined\\s+at\\s+file\\s+(.+)\\s+line\\s+(\\d+)");
    private static final Pattern sPattern3Line1 = Pattern.compile("^(.+)\\sline\\s(\\d+):\\s(.+)$");
    private static final Pattern sPattern4Line1 = Pattern.compile("^Error\\s+parsing\\s+XML\\s+file\\s(.+)$");
    private static final Pattern sPattern4Line2 = Pattern.compile("^(.+)\\s+at\\s+line\\s+(\\d+)$");
    private static final Pattern sPattern5Line1 = Pattern.compile("^(.+?):(\\d+):\\s+WARNING:(.+)$");
    private static final Pattern sPattern6Line1 = Pattern.compile("^(.+?):(\\d+):\\s+(.+)$");
    private static final Pattern sPattern7Line1 = Pattern.compile("^ERROR:\\s+9-patch\\s+image\\s+(.+)\\s+malformed\\.$");
    private static final Pattern sPattern8Line1 = Pattern.compile("^(invalid resource directory name): (.*)$");
    private static final Pattern sPattern9Line1 = Pattern.compile("^Invalid configuration: (.+)$");
    private SAXParserFactory mParserFactory = SAXParserFactory.newInstance();

    public BaseBuilder() {
        this.mParserFactory.setNamespaceAware(false);
    }

    protected final void checkXML(IResource iResource, BaseDeltaVisitor baseDeltaVisitor) {
        if (iResource instanceof IFile) {
            IFile iFile = (IFile)iResource;
            this.removeMarkersFromFile(iFile, "com.android.ide.eclipse.common.xmlProblem");
            XmlErrorHandler xmlErrorHandler = new XmlErrorHandler(iFile, baseDeltaVisitor);
            try {
                this.getParser().parse(iFile.getContents(), (DefaultHandler)xmlErrorHandler);
            }
            catch (Exception exception) {}
        }
    }

    protected final SAXParser getParser() throws ParserConfigurationException, SAXException {
        return this.mParserFactory.newSAXParser();
    }

    protected final void markProject(String string, String string2, int n) {
        BaseProjectHelper.addMarker((IResource)this.getProject(), string, string2, n);
    }

    protected final void removeMarkersFromFile(IFile iFile, String string) {
        try {
            if (iFile.exists()) {
                iFile.deleteMarkers(string, true, 0);
            }
        }
        catch (CoreException coreException) {
            String string2 = String.format(Messages.Marker_Delete_Error, string, iFile.toString());
            AdtPlugin.printErrorToConsole(this.getProject(), new Object[]{string2});
        }
    }

    protected final void removeMarkersFromContainer(IContainer iContainer, String string) {
        try {
            if (iContainer.exists()) {
                iContainer.deleteMarkers(string, true, 2);
            }
        }
        catch (CoreException coreException) {
            String string2 = String.format(Messages.Marker_Delete_Error, string, iContainer.toString());
            AdtPlugin.printErrorToConsole(this.getProject(), new Object[]{string2});
        }
    }

    protected static final void removeMarkersFromProject(IProject iProject, String string) {
        try {
            if (iProject.exists()) {
                iProject.deleteMarkers(string, true, 2);
            }
        }
        catch (CoreException coreException) {
            String string2 = String.format(Messages.Marker_Delete_Error, string, iProject.getName());
            AdtPlugin.printErrorToConsole(iProject, new Object[]{string2});
        }
    }

    protected final int grabProcessOutput(final Process process, final ArrayList<String> arrayList) throws InterruptedException {
        new Thread(""){

            public void run() {
                InputStreamReader inputStreamReader = new InputStreamReader(process.getErrorStream());
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                try {
                    String string;
                    while ((string = bufferedReader.readLine()) != null) {
                        arrayList.add(string);
                    }
                }
                catch (IOException iOException) {}
            }
        }.start();
        new Thread(""){

            public void run() {
                InputStreamReader inputStreamReader = new InputStreamReader(process.getInputStream());
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                IProject iProject = BaseBuilder.this.getProject();
                try {
                    String string;
                    while ((string = bufferedReader.readLine()) != null) {
                        AdtPlugin.printBuildToConsole(2, iProject, string);
                    }
                }
                catch (IOException iOException) {}
            }
        }.start();
        return process.waitFor();
    }

    protected final boolean parseAaptOutput(ArrayList<String> arrayList, IProject iProject) {
        if (arrayList.size() == 0) {
            return false;
        }
        String string = iProject.getLocation().toOSString();
        int n = 0;
        while (n < arrayList.size()) {
            String string2 = arrayList.get(n);
            Matcher matcher = sPattern0Line1.matcher(string2);
            if (!matcher.matches()) {
                String string3;
                String string4;
                String string5;
                matcher = sPattern1Line1.matcher(string2);
                if (matcher.matches()) {
                    string5 = matcher.group(1);
                    string4 = matcher.group(2);
                    if ((matcher = this.getNextLineMatcher(arrayList, ++n, sPattern1Line2)) == null) {
                        return true;
                    }
                    string3 = matcher.group(1);
                    if (!this.checkAndMark(string3, string5, string4, string, iProject, "com.android.ide.eclipse.common.aaptProblem", 2)) {
                        return true;
                    }
                } else {
                    matcher = sPattern7Line1.matcher(string2);
                    if (matcher.matches()) {
                        string5 = matcher.group(1);
                        string4 = string2;
                        if (++n < arrayList.size()) {
                            string4 = arrayList.get(n).trim();
                            if (++n < arrayList.size()) {
                                string4 = String.valueOf(string4) + " - " + arrayList.get(n).trim();
                                ++n;
                            }
                        }
                        if (!this.checkAndMark(string5, null, string4, string, iProject, "com.android.ide.eclipse.common.aaptProblem", 2)) {
                            return true;
                        }
                    } else {
                        matcher = sPattern2Line1.matcher(string2);
                        if (matcher.matches()) {
                            string5 = matcher.group(1);
                            if ((matcher = this.getNextLineMatcher(arrayList, ++n, sPattern2Line2)) == null) {
                                return true;
                            }
                            string4 = matcher.group(1);
                            if (!this.checkAndMark(string4, string3 = matcher.group(2), string5, string, iProject, "com.android.ide.eclipse.common.aaptProblem", 2)) {
                                return true;
                            }
                        } else {
                            matcher = sPattern3Line1.matcher(string2);
                            if (matcher.matches()) {
                                string5 = matcher.group(1);
                                if (!this.checkAndMark(string5, string4 = matcher.group(2), string3 = matcher.group(3), string, iProject, "com.android.ide.eclipse.common.aaptProblem", 2)) {
                                    return true;
                                }
                            } else {
                                matcher = sPattern4Line1.matcher(string2);
                                if (matcher.matches()) {
                                    string5 = matcher.group(1);
                                    if ((matcher = this.getNextLineMatcher(arrayList, ++n, sPattern4Line2)) == null) {
                                        return true;
                                    }
                                    string4 = matcher.group(1);
                                    string3 = matcher.group(2);
                                    if (!this.checkAndMark(string5, string3, string4, string, iProject, "com.android.ide.eclipse.common.aaptProblem", 2)) {
                                        return true;
                                    }
                                } else {
                                    matcher = sPattern5Line1.matcher(string2);
                                    if (matcher.matches()) {
                                        string5 = matcher.group(1);
                                        if (!this.checkAndMark(string5, string4 = matcher.group(2), string3 = matcher.group(3), string, iProject, "com.android.ide.eclipse.common.aaptProblem", 1)) {
                                            return true;
                                        }
                                    } else {
                                        matcher = sPattern6Line1.matcher(string2);
                                        if (matcher.matches()) {
                                            string5 = matcher.group(1);
                                            if (!this.checkAndMark(string5, string4 = matcher.group(2), string3 = matcher.group(3), string, iProject, "com.android.ide.eclipse.common.aaptProblem", 2)) {
                                                return true;
                                            }
                                        } else {
                                            matcher = sPattern8Line1.matcher(string2);
                                            if (matcher.matches()) {
                                                string5 = matcher.group(2);
                                                if (!this.checkAndMark(string5, null, string4 = matcher.group(1), string, iProject, "com.android.ide.eclipse.common.aaptProblem", 2)) {
                                                    return true;
                                                }
                                            } else {
                                                matcher = sPattern9Line1.matcher(string2);
                                                if (matcher.matches()) {
                                                    string5 = matcher.group(1);
                                                    string4 = String.format("APK Configuration filter '%1$s' is invalid", string5);
                                                    ++n;
                                                    if (!this.checkAndMark(null, null, string4, string, iProject, "com.android.ide.eclipse.common.aapt2Problem", 2)) {
                                                        return true;
                                                    }
                                                } else {
                                                    return true;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            ++n;
        }
        return false;
    }

    protected boolean saveProjectStringProperty(String string, String string2) {
        IProject iProject = this.getProject();
        return ProjectHelper.saveStringProperty((IResource)iProject, string, string2);
    }

    protected String loadProjectStringProperty(String string) {
        IProject iProject = this.getProject();
        return ProjectHelper.loadStringProperty((IResource)iProject, string);
    }

    protected boolean saveProjectBooleanProperty(String string, boolean bl) {
        IProject iProject = this.getProject();
        return ProjectHelper.saveStringProperty((IResource)iProject, string, Boolean.toString(bl));
    }

    protected boolean loadProjectBooleanProperty(String string, boolean bl) {
        IProject iProject = this.getProject();
        return ProjectHelper.loadBooleanProperty((IResource)iProject, string, bl);
    }

    protected boolean saveProjectResourceProperty(String string, IResource iResource) {
        return ProjectHelper.saveResourceProperty((IResource)this.getProject(), string, iResource);
    }

    protected IResource loadProjectResourceProperty(String string) {
        IProject iProject = this.getProject();
        return ProjectHelper.loadResourceProperty((IResource)iProject, string);
    }

    private final boolean checkAndMark(String string, String string2, String string3, String string4, IProject iProject, String string5, int n) {
        File file;
        if (string != null && !(file = new File(string)).exists()) {
            return false;
        }
        int n2 = -1;
        if (string2 != null) {
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        IProject iProject2 = iProject;
        if (string != null && (iProject2 = this.getResourceFromFullPath(string, string4, iProject)) == null) {
            return false;
        }
        boolean bl = false;
        try {
            String string6;
            int n3;
            IMarker iMarker;
            int n4;
            IMarker[] iMarkerArray;
            IMarker[] iMarkerArray2 = iMarkerArray = iProject2.findMarkers(string5, true, 0);
            if (iMarkerArray.length != 0 && (n4 = (iMarker = iMarkerArray2[0]).getAttribute("lineNumber", -1)) == n2 && (n3 = iMarker.getAttribute("severity", -1)) == n && (string6 = iMarker.getAttribute("message", null)) != null && string6.equals(string3)) {
                bl = true;
            }
        }
        catch (CoreException coreException) {}
        if (!bl) {
            if (n2 != -1) {
                BaseProjectHelper.addMarker((IResource)iProject2, string5, string3, n2, n);
            } else {
                BaseProjectHelper.addMarker((IResource)iProject2, string5, string3, n);
            }
        }
        return true;
    }

    private final Matcher getNextLineMatcher(ArrayList<String> arrayList, int n, Pattern pattern) {
        if (n == arrayList.size()) {
            return null;
        }
        Matcher matcher = pattern.matcher(arrayList.get(n));
        if (matcher.matches()) {
            return matcher;
        }
        return null;
    }

    private IResource getResourceFromFullPath(String string, String string2, IProject iProject) {
        String string3;
        IResource iResource;
        if (string.startsWith(string2) && (iResource = iProject.findMember(string3 = string.substring(string2.length()))).exists()) {
            return iResource;
        }
        return null;
    }

    protected final String[] getExternalJars() {
        IProject iProject = this.getProject();
        IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        ArrayList<String> arrayList = new ArrayList<String>();
        IClasspathEntry[] iClasspathEntryArray = iJavaProject.readRawClasspath();
        if (iClasspathEntryArray != null) {
            IClasspathEntry[] iClasspathEntryArray2 = iClasspathEntryArray;
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry iClasspathEntry = iClasspathEntryArray2[n2];
                if (iClasspathEntry.getEntryKind() == 1 || iClasspathEntry.getEntryKind() == 4) {
                    IPath iPath;
                    if (iClasspathEntry.getEntryKind() == 4) {
                        iClasspathEntry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)iClasspathEntry);
                    }
                    if ("jar".equalsIgnoreCase((iPath = iClasspathEntry.getPath()).getFileExtension())) {
                        boolean bl = false;
                        IResource iResource = iWorkspaceRoot.findMember(iPath);
                        if (iResource != null && iResource.exists() && iResource.getType() == 1) {
                            bl = true;
                            arrayList.add(iResource.getLocation().toOSString());
                        }
                        if (!bl) {
                            String string = iPath.toOSString();
                            File file = new File(string);
                            if (file.exists()) {
                                arrayList.add(string);
                            } else {
                                String string2 = String.format(Messages.Couldnt_Locate_s_Error, iPath);
                                AdtPlugin.printBuildToConsole(2, iProject, string2);
                                this.markProject("com.android.ide.eclipse.adt.adtProblem", string2, 1);
                            }
                        }
                    }
                }
                ++n2;
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    protected void abortOnBadSetup(IProject iProject) throws CoreException {
        IMarker[] iMarkerArray;
        if (AdtPlugin.getDefault().getSdkLoadStatus() != LoadStatus.LOADED) {
            this.stopBuild("SDK is not loaded yet", new Object[0]);
        }
        if ((iMarkerArray = iProject.findMarkers("com.android.ide.eclipse.adt.targetProblem", false, 0)).length > 0) {
            this.stopBuild("", new Object[0]);
        }
        if ((iMarkerArray = iProject.findMarkers("com.android.ide.eclipse.adt.adtProblem", false, 0)).length > 0) {
            this.stopBuild("", new Object[0]);
        }
    }

    protected final void stopBuild(String string, Object ... objectArray) throws CoreException {
        throw new CoreException((IStatus)new Status(8, "com.android.ide.eclipse.adt", String.format(string, objectArray)));
    }

    protected void removeDerivedResources(IResource iResource, IProgressMonitor iProgressMonitor) throws CoreException {
        if (iResource.exists()) {
            if (iResource.isDerived()) {
                iResource.delete(true, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 10));
            } else if (iResource.getType() == 2) {
                IResource[] iResourceArray;
                IFolder iFolder = (IFolder)iResource;
                IResource[] iResourceArray2 = iResourceArray = iFolder.members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource iResource2 = iResourceArray2[n2];
                    this.removeDerivedResources(iResource2, iProgressMonitor);
                    ++n2;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class BaseDeltaVisitor
    implements XmlErrorHandler.XmlErrorListener {
        protected BaseBuilder mBuilder;
        public boolean mXmlError = false;

        public BaseDeltaVisitor(BaseBuilder baseBuilder) {
            this.mBuilder = baseBuilder;
        }

        protected static String[] findMatchingSourceFolder(ArrayList<IPath> arrayList, String[] stringArray) {
            for (IPath iPath : arrayList) {
                String[] stringArray2 = iPath.segments();
                boolean bl = true;
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    String string2 = stringArray2[n2];
                    if (!string.equalsIgnoreCase(string2)) {
                        bl = false;
                        break;
                    }
                    ++n2;
                }
                if (!bl) continue;
                return stringArray2;
            }
            return null;
        }

        @Override
        public void errorFound() {
            this.mXmlError = true;
        }
    }
}

