/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.actions;

import com.android.ide.eclipse.adt.internal.project.ProjectHelper;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaModelStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class ConvertToAndroidAction
implements IObjectActionDelegate {
    private ISelection mSelection;

    public void setActivePart(IAction iAction, IWorkbenchPart iWorkbenchPart) {
    }

    public void run(IAction iAction) {
        if (this.mSelection instanceof IStructuredSelection) {
            for (Object e : (IStructuredSelection)this.mSelection) {
                IProject iProject = null;
                if (e instanceof IProject) {
                    iProject = (IProject)e;
                } else if (e instanceof IAdaptable) {
                    iProject = (IProject)((IAdaptable)e).getAdapter(IProject.class);
                }
                if (iProject == null) continue;
                this.convertProject(iProject);
            }
        }
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        this.mSelection = iSelection;
    }

    private void convertProject(final IProject iProject) {
        new Job("Convert Project"){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                try {
                    if (iProgressMonitor != null) {
                        iProgressMonitor.beginTask(String.format("Convert %1$s to Android", iProject.getName()), 5);
                    }
                    IProjectDescription iProjectDescription = iProject.getDescription();
                    String[] stringArray = iProjectDescription.getNatureIds();
                    int n = 0;
                    while (n < stringArray.length) {
                        if ("com.android.ide.eclipse.adt.AndroidNature".equals(stringArray[n])) {
                            Status status = new Status(2, "com.android.ide.eclipse.adt", "Project is already an Android project");
                            return status;
                        }
                        ++n;
                    }
                    if (iProgressMonitor != null) {
                        iProgressMonitor.worked(1);
                    }
                    String[] stringArray2 = new String[stringArray.length + 1];
                    System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
                    stringArray2[0] = "com.android.ide.eclipse.adt.AndroidNature";
                    iProjectDescription.setNatureIds(stringArray2);
                    iProject.setDescription(iProjectDescription, null);
                    if (iProgressMonitor != null) {
                        iProgressMonitor.worked(1);
                    }
                    IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
                    ProjectHelper.fixProjectClasspathEntries(iJavaProject);
                    if (iProgressMonitor != null) {
                        iProgressMonitor.worked(1);
                    }
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (JavaModelException javaModelException) {
                    IJavaModelStatus iJavaModelStatus = javaModelException.getJavaModelStatus();
                    return iJavaModelStatus;
                }
                catch (CoreException coreException) {
                    IStatus iStatus = coreException.getStatus();
                    return iStatus;
                }
                finally {
                    if (iProgressMonitor != null) {
                        iProgressMonitor.done();
                    }
                }
            }
        }.schedule();
    }
}

