/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.ddms;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.ddmuilib.DdmUiPreferences;
import com.android.ddmuilib.DevicePanel;
import com.android.ide.eclipse.ddms.ImageLoader;
import com.android.ide.eclipse.ddms.preferences.PreferenceInitializer;
import com.android.ide.eclipse.ddms.views.DeviceView;
import java.util.ArrayList;
import java.util.Calendar;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public final class DdmsPlugin
extends AbstractUIPlugin
implements AndroidDebugBridge.IDeviceChangeListener,
DevicePanel.IUiSelectionListener {
    public static final String PLUGIN_ID = "com.android.ide.eclipse.ddms";
    private static final String ADB_LOCATION = "com.android.ide.eclipse.ddms.adb";
    private static DdmsPlugin sPlugin;
    private static String sAdbLocation;
    private static IDebugLauncher sRunningAppDebugLauncher;
    private MessageConsole mDdmsConsole;
    private ImageLoader mLoader;
    private IDevice mCurrentDevice;
    private Client mCurrentClient;
    private boolean mListeningToUiSelection = false;
    private final ArrayList<ISelectionListener> mListeners = new ArrayList();
    private Color mRed;
    private boolean mDdmlibInitialized;

    public DdmsPlugin() {
        sPlugin = this;
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        final Display display = DdmsPlugin.getDisplay();
        final IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        AndroidDebugBridge.addDeviceChangeListener(this);
        DdmUiPreferences.setStore(iPreferenceStore);
        this.mDdmsConsole = new MessageConsole("DDMS", null);
        ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{this.mDdmsConsole});
        final MessageConsoleStream messageConsoleStream = this.mDdmsConsole.newMessageStream();
        final MessageConsoleStream messageConsoleStream2 = this.mDdmsConsole.newMessageStream();
        this.mRed = new Color((Device)display, 255, 0, 0);
        display.asyncExec(new Runnable(){

            public void run() {
                messageConsoleStream2.setColor(DdmsPlugin.this.mRed);
            }
        });
        Log.setLogOutput(new Log.ILogOutput(){

            public void printLog(Log.LogLevel logLevel, String string, String string2) {
                if (logLevel.getPriority() >= Log.LogLevel.ERROR.getPriority()) {
                    DdmsPlugin.printToStream(messageConsoleStream2, string, string2);
                    ConsolePlugin.getDefault().getConsoleManager().showConsoleView((IConsole)DdmsPlugin.this.mDdmsConsole);
                } else {
                    DdmsPlugin.printToStream(messageConsoleStream, string, string2);
                }
            }

            public void printAndPromptLog(final Log.LogLevel logLevel, final String string, final String string2) {
                this.printLog(logLevel, string, string2);
                display.asyncExec(new Runnable(){

                    public void run() {
                        Shell shell = display.getActiveShell();
                        if (logLevel == Log.LogLevel.ERROR) {
                            MessageDialog.openError((Shell)shell, (String)string, (String)string2);
                        } else {
                            MessageDialog.openWarning((Shell)shell, (String)string, (String)string2);
                        }
                    }
                });
            }
        });
        this.mLoader = new ImageLoader((Plugin)this);
        Preferences preferences = this.getPluginPreferences();
        preferences.addPropertyChangeListener(new Preferences.IPropertyChangeListener(){

            public void propertyChange(Preferences.PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getProperty();
                if ("com.android.ide.eclipse.ddms.adbDebugBasePort".equals(string)) {
                    DdmPreferences.setDebugPortBase(iPreferenceStore.getInt("com.android.ide.eclipse.ddms.adbDebugBasePort"));
                } else if ("com.android.ide.eclipse.ddms.debugSelectedPort".equals(string)) {
                    DdmPreferences.setSelectedDebugPort(iPreferenceStore.getInt("com.android.ide.eclipse.ddms.debugSelectedPort"));
                } else if ("com.android.ide.eclipse.ddms.threadStatusInterval".equals(string)) {
                    DdmUiPreferences.setThreadRefreshInterval(iPreferenceStore.getInt("com.android.ide.eclipse.ddms.threadStatusInterval"));
                } else if ("com.android.ide.eclipse.ddms.logLevel".equals(string)) {
                    DdmPreferences.setLogLevel(iPreferenceStore.getString("com.android.ide.eclipse.ddms.logLevel"));
                }
            }
        });
        sAdbLocation = iPreferenceStore.getString(ADB_LOCATION);
        new Thread(){

            public void run() {
                DdmsPlugin.getDefault().initDdmlib();
                AndroidDebugBridge.createBridge(sAdbLocation, true);
            }
        }.start();
    }

    public static Display getDisplay() {
        IWorkbench iWorkbench = sPlugin.getWorkbench();
        if (iWorkbench != null) {
            return iWorkbench.getDisplay();
        }
        return null;
    }

    public void stop(BundleContext bundleContext) throws Exception {
        AndroidDebugBridge.removeDeviceChangeListener(this);
        AndroidDebugBridge.terminate();
        this.mRed.dispose();
        sPlugin = null;
        super.stop(bundleContext);
    }

    public static DdmsPlugin getDefault() {
        return sPlugin;
    }

    public static ImageLoader getImageLoader() {
        if (sPlugin != null) {
            return DdmsPlugin.sPlugin.mLoader;
        }
        return null;
    }

    public static String getAdb() {
        return sAdbLocation;
    }

    public static void setAdb(String string, boolean bl) {
        sAdbLocation = string;
        sPlugin.getPreferenceStore().setValue(ADB_LOCATION, sAdbLocation);
        if (bl) {
            new Thread(){

                public void run() {
                    DdmsPlugin.getDefault().initDdmlib();
                    AndroidDebugBridge.createBridge(sAdbLocation, false);
                }
            }.start();
        }
    }

    private synchronized void initDdmlib() {
        if (!this.mDdmlibInitialized) {
            PreferenceInitializer.setupPreferences();
            AndroidDebugBridge.init(true);
            this.mDdmlibInitialized = true;
        }
    }

    public static void setRunningAppDebugLauncher(IDebugLauncher iDebugLauncher) {
        sRunningAppDebugLauncher = iDebugLauncher;
        Display display = DdmsPlugin.getDisplay();
        if (display != null && !display.isDisposed()) {
            display.asyncExec(new Runnable(){

                public void run() {
                    DeviceView deviceView = DeviceView.getInstance();
                    if (deviceView != null) {
                        deviceView.setDebugLauncher(sRunningAppDebugLauncher);
                    }
                }
            });
        }
    }

    public static IDebugLauncher getRunningAppDebugLauncher() {
        return sRunningAppDebugLauncher;
    }

    public synchronized void addSelectionListener(ISelectionListener iSelectionListener) {
        this.mListeners.add(iSelectionListener);
        iSelectionListener.selectionChanged(this.mCurrentDevice);
        iSelectionListener.selectionChanged(this.mCurrentClient);
    }

    public synchronized void removeSelectionListener(ISelectionListener iSelectionListener) {
        this.mListeners.remove(iSelectionListener);
    }

    public synchronized void setListeningState(boolean bl) {
        this.mListeningToUiSelection = bl;
    }

    public void deviceConnected(IDevice iDevice) {
        if (!this.mListeningToUiSelection && this.mCurrentDevice == null) {
            this.handleDefaultSelection(iDevice);
        }
    }

    public void deviceDisconnected(IDevice iDevice) {
        if (!this.mListeningToUiSelection && this.mCurrentDevice == iDevice) {
            AndroidDebugBridge androidDebugBridge = AndroidDebugBridge.getBridge();
            if (androidDebugBridge != null) {
                IDevice[] iDeviceArray = androidDebugBridge.getDevices();
                if (iDeviceArray.length == 0) {
                    this.handleDefaultSelection((IDevice)null);
                } else {
                    this.handleDefaultSelection(iDeviceArray[0]);
                }
            } else {
                this.handleDefaultSelection((IDevice)null);
            }
        }
    }

    public void deviceChanged(IDevice iDevice, int n) {
        if (!this.mListeningToUiSelection && iDevice == this.mCurrentDevice) {
            if (this.mCurrentClient == null) {
                this.handleDefaultSelection(iDevice);
            } else {
                Client[] clientArray = iDevice.getClients();
                boolean bl = false;
                Client[] clientArray2 = clientArray;
                int n2 = clientArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    Client client = clientArray2[n3];
                    if (client == this.mCurrentClient) {
                        bl = true;
                        break;
                    }
                    ++n3;
                }
                if (!bl) {
                    this.mCurrentClient = null;
                    this.handleDefaultSelection(iDevice);
                }
            }
        }
    }

    public synchronized void selectionChanged(IDevice iDevice, Client client) {
        if (this.mCurrentDevice != iDevice) {
            this.mCurrentDevice = iDevice;
            for (ISelectionListener iSelectionListener : this.mListeners) {
                iSelectionListener.selectionChanged(this.mCurrentDevice);
            }
        }
        if (this.mCurrentClient != client) {
            this.mCurrentClient = client;
            for (ISelectionListener iSelectionListener : this.mListeners) {
                iSelectionListener.selectionChanged(this.mCurrentClient);
            }
        }
    }

    private void handleDefaultSelection(final IDevice iDevice) {
        try {
            Display display = DdmsPlugin.getDisplay();
            display.asyncExec(new Runnable(){

                public void run() {
                    boolean bl = false;
                    if (DdmsPlugin.this.mCurrentDevice != iDevice) {
                        DdmsPlugin.this.mCurrentDevice = iDevice;
                        bl = true;
                        for (Object object : DdmsPlugin.this.mListeners) {
                            object.selectionChanged(DdmsPlugin.this.mCurrentDevice);
                        }
                    }
                    if (iDevice != null) {
                        if (bl || DdmsPlugin.this.mCurrentClient == null) {
                            Object object;
                            object = iDevice.getClients();
                            if (((Client[])object).length > 0) {
                                DdmsPlugin.this.handleDefaultSelection(object[0]);
                            } else {
                                DdmsPlugin.this.handleDefaultSelection(null);
                            }
                        }
                    } else {
                        DdmsPlugin.this.handleDefaultSelection(null);
                    }
                }
            });
        }
        catch (SWTException sWTException) {}
    }

    private void handleDefaultSelection(Client client) {
        this.mCurrentClient = client;
        for (ISelectionListener iSelectionListener : this.mListeners) {
            iSelectionListener.selectionChanged(this.mCurrentClient);
        }
    }

    private static synchronized void printToStream(MessageConsoleStream messageConsoleStream, String string, String string2) {
        String string3 = DdmsPlugin.getMessageTag(string);
        messageConsoleStream.print(string3);
        messageConsoleStream.println(string2);
    }

    private static String getMessageTag(String string) {
        Calendar calendar = Calendar.getInstance();
        if (string == null) {
            return String.format("[%1$tF %1$tT]", calendar);
        }
        return String.format("[%1$tF %1$tT - %2$s]", calendar, string);
    }

    public static interface IDebugLauncher {
        public boolean debug(String var1, int var2);
    }

    public static interface ISelectionListener {
        public void selectionChanged(Client var1);

        public void selectionChanged(IDevice var1);
    }
}

