/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib.log.event;

import com.android.ddmlib.log.EventContainer;
import com.android.ddmlib.log.EventLogParser;
import com.android.ddmlib.log.InvalidTypeException;
import com.android.ddmuilib.log.event.EventDisplay;
import java.awt.Color;

public abstract class SyncCommon
extends EventDisplay {
    private int mLastState;
    private long mLastStartTime;
    private long mLastStopTime;
    private String mLastDetails;
    private int mLastSyncSource;
    protected static final int CALENDAR = 0;
    protected static final int GMAIL = 1;
    protected static final int FEEDS = 2;
    protected static final int CONTACTS = 3;
    protected static final int ERRORS = 4;
    protected static final int NUM_AUTHS = 4;
    protected static final String[] AUTH_NAMES = new String[]{"Calendar", "Gmail", "Feeds", "Contacts", "Errors"};
    protected static final Color[] AUTH_COLORS = new Color[]{Color.MAGENTA, Color.GREEN, Color.BLUE, Color.ORANGE, Color.RED};
    final int EVENT_SYNC = 2720;
    final int EVENT_TICKLE = 2742;
    final int EVENT_SYNC_DETAILS = 2743;

    protected SyncCommon(String string) {
        super(string);
    }

    void resetUI() {
        this.mLastStartTime = 0L;
        this.mLastStopTime = 0L;
        this.mLastState = -1;
        this.mLastSyncSource = -1;
        this.mLastDetails = "";
    }

    void newEvent(EventContainer eventContainer, EventLogParser eventLogParser) {
        try {
            if (eventContainer.mTag == 2720) {
                int n = Integer.parseInt(eventContainer.getValueAsString(1));
                if (n == 0) {
                    this.mLastStartTime = (long)eventContainer.sec * 1000L + (long)eventContainer.nsec / 1000000L;
                    this.mLastState = 0;
                    this.mLastSyncSource = Integer.parseInt(eventContainer.getValueAsString(2));
                    this.mLastDetails = "";
                } else if (n == 1 && this.mLastState == 0) {
                    this.mLastStopTime = (long)eventContainer.sec * 1000L + (long)eventContainer.nsec / 1000000L;
                    if (this.mLastStartTime == 0L) {
                        this.mLastStartTime = this.mLastStopTime;
                    }
                    int n2 = this.getAuth(eventContainer.getValueAsString(0));
                    this.processSyncEvent(eventContainer, n2, this.mLastStartTime, this.mLastStopTime, this.mLastDetails, true, this.mLastSyncSource);
                    this.mLastState = 1;
                }
            } else if (eventContainer.mTag == 2743) {
                long l;
                this.mLastDetails = eventContainer.getValueAsString(3);
                if (this.mLastState != 0 && (l = (long)eventContainer.sec * 1000L + (long)eventContainer.nsec / 1000000L) - this.mLastStopTime <= 250L) {
                    int n = this.getAuth(eventContainer.getValueAsString(0));
                    this.processSyncEvent(eventContainer, n, this.mLastStartTime, this.mLastStopTime, this.mLastDetails, false, this.mLastSyncSource);
                }
            }
        }
        catch (InvalidTypeException invalidTypeException) {}
    }

    abstract void processSyncEvent(EventContainer var1, int var2, long var3, long var5, String var7, boolean var8, int var9);

    protected int getAuth(String string) throws InvalidTypeException {
        if ("calendar".equals(string) || "cl".equals(string)) {
            return 0;
        }
        if ("contacts".equals(string) || "cp".equals(string)) {
            return 3;
        }
        if ("subscribedfeeds".equals(string)) {
            return 2;
        }
        if ("gmail-ls".equals(string) || "mail".equals(string)) {
            return 1;
        }
        if ("gmail-live".equals(string)) {
            return 1;
        }
        if ("unknown".equals(string)) {
            return -1;
        }
        throw new InvalidTypeException("Unknown authname " + string);
    }
}

