/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib.log.event;

import com.android.ddmlib.log.EventContainer;
import com.android.ddmlib.log.EventLogParser;
import com.android.ddmlib.log.EventValueDescription;
import com.android.ddmuilib.DdmUiPreferences;
import com.android.ddmuilib.IImageLoader;
import com.android.ddmuilib.log.event.EventDisplay;
import com.android.ddmuilib.log.event.EventValueSelector;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EventDisplayOptions
extends Dialog {
    private static final int DLG_WIDTH = 700;
    private static final int DLG_HEIGHT = 700;
    private IImageLoader mImageLoader;
    private Shell mParent;
    private Shell mShell;
    private boolean mEditStatus = false;
    private final ArrayList<EventDisplay> mDisplayList = new ArrayList();
    private List mEventDisplayList;
    private Button mEventDisplayNewButton;
    private Button mEventDisplayDeleteButton;
    private Button mEventDisplayUpButton;
    private Button mEventDisplayDownButton;
    private Text mDisplayWidthText;
    private Text mDisplayHeightText;
    private Text mDisplayNameText;
    private Combo mDisplayTypeCombo;
    private Group mChartOptions;
    private Group mHistOptions;
    private Button mPidFilterCheckBox;
    private Text mPidText;
    private Map<Integer, String> mEventTagMap;
    private Map<Integer, EventValueDescription[]> mEventDescriptionMap;
    private ArrayList<Integer> mPidList;
    private EventLogParser mLogParser;
    private Group mInfoGroup;
    private SelectionWidgets mValueSelection;
    private SelectionWidgets mOccurrenceSelection;
    private boolean mProcessTextChanges = true;
    private Text mTimeLimitText;
    private Text mHistWidthText;

    EventDisplayOptions(IImageLoader iImageLoader, Shell shell) {
        super(shell, 67680);
        this.mImageLoader = iImageLoader;
    }

    boolean open(EventLogParser eventLogParser, ArrayList<EventDisplay> arrayList, ArrayList<EventContainer> arrayList2) {
        this.mLogParser = eventLogParser;
        if (eventLogParser != null) {
            this.mEventTagMap = eventLogParser.getTagMap();
            this.mEventDescriptionMap = eventLogParser.getEventInfoMap();
        }
        this.duplicateEventDisplay(arrayList);
        this.buildPidList(arrayList2);
        this.createUI();
        if (this.mParent == null || this.mShell == null) {
            return false;
        }
        this.mShell.setMinimumSize(700, 700);
        Rectangle rectangle = this.mParent.getBounds();
        int n = rectangle.x + rectangle.width / 2;
        int n2 = n - 350;
        int n3 = rectangle.y + rectangle.height / 2;
        int n4 = n3 - 350;
        this.mShell.setBounds(n2, n4, 700, 700);
        this.mShell.layout();
        this.mShell.open();
        Display display = this.mParent.getDisplay();
        while (!this.mShell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.mEditStatus;
    }

    ArrayList<EventDisplay> getEventDisplays() {
        return this.mDisplayList;
    }

    private void createUI() {
        this.mParent = this.getParent();
        this.mShell = new Shell(this.mParent, this.getStyle());
        this.mShell.setText("Event Display Configuration");
        this.mShell.setLayout((Layout)new GridLayout(1, true));
        Composite composite = new Composite((Composite)this.mShell, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout(2, false));
        Composite composite2 = new Composite(composite, 0);
        Composite composite3 = new Composite(composite, 0);
        this.createLeftPanel(composite2);
        this.createRightPanel(composite3);
        this.mShell.addListener(21, new Listener(){

            public void handleEvent(Event event) {
                event.doit = true;
            }
        });
        Label label = new Label((Composite)this.mShell, 258);
        label.setLayoutData((Object)new GridData(768));
        Composite composite4 = new Composite((Composite)this.mShell, 0);
        composite4.setLayoutData((Object)new GridData(768));
        GridLayout gridLayout = new GridLayout(2, true);
        composite4.setLayout((Layout)gridLayout);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        Button button = new Button(composite4, 8);
        button.setText("OK");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                EventDisplayOptions.this.mShell.close();
            }
        });
        Button button2 = new Button(composite4, 8);
        button2.setText("Cancel");
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                EventDisplayOptions.this.mEditStatus = false;
                EventDisplayOptions.this.mShell.close();
            }
        });
        this.enable(false);
        this.fillEventDisplayList();
    }

    private void createLeftPanel(Composite composite) {
        final IPreferenceStore iPreferenceStore = DdmUiPreferences.getStore();
        composite.setLayoutData((Object)new GridData(1040));
        GridLayout gridLayout = new GridLayout(1, false);
        composite.setLayout((Layout)gridLayout);
        gridLayout.verticalSpacing = 1;
        this.mEventDisplayList = new List(composite, 68100);
        this.mEventDisplayList.setLayoutData((Object)new GridData(1808));
        this.mEventDisplayList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                EventDisplayOptions.this.handleEventDisplaySelection();
            }
        });
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(768));
        gridLayout = new GridLayout(5, false);
        composite2.setLayout((Layout)gridLayout);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        this.mEventDisplayNewButton = new Button(composite2, 0x800008);
        this.mEventDisplayNewButton.setImage(this.mImageLoader.loadImage("add.png", composite.getDisplay()));
        this.mEventDisplayNewButton.setToolTipText("Adds a new event display");
        this.mEventDisplayNewButton.setLayoutData((Object)new GridData(64));
        this.mEventDisplayNewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                EventDisplayOptions.this.createNewEventDisplay();
            }
        });
        this.mEventDisplayDeleteButton = new Button(composite2, 0x800008);
        this.mEventDisplayDeleteButton.setImage(this.mImageLoader.loadImage("delete.png", composite.getDisplay()));
        this.mEventDisplayDeleteButton.setToolTipText("Deletes the selected event display");
        this.mEventDisplayDeleteButton.setLayoutData((Object)new GridData(64));
        this.mEventDisplayDeleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                EventDisplayOptions.this.deleteEventDisplay();
            }
        });
        this.mEventDisplayUpButton = new Button(composite2, 0x800008);
        this.mEventDisplayUpButton.setImage(this.mImageLoader.loadImage("up.png", composite.getDisplay()));
        this.mEventDisplayUpButton.setToolTipText("Moves the selected event display up");
        this.mEventDisplayUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = EventDisplayOptions.this.mEventDisplayList.getSelectionIndex();
                if (n > 0) {
                    EventDisplay eventDisplay = (EventDisplay)EventDisplayOptions.this.mDisplayList.remove(n);
                    EventDisplayOptions.this.mDisplayList.add(n - 1, eventDisplay);
                    EventDisplayOptions.this.mEventDisplayList.remove(n);
                    EventDisplayOptions.this.mEventDisplayList.add(eventDisplay.getName(), n - 1);
                    EventDisplayOptions.this.mEventDisplayList.select(n - 1);
                    EventDisplayOptions.this.handleEventDisplaySelection();
                    EventDisplayOptions.this.mEventDisplayList.showSelection();
                    EventDisplayOptions.this.setModified();
                }
            }
        });
        this.mEventDisplayDownButton = new Button(composite2, 0x800008);
        this.mEventDisplayDownButton.setImage(this.mImageLoader.loadImage("down.png", composite.getDisplay()));
        this.mEventDisplayDownButton.setToolTipText("Moves the selected event display down");
        this.mEventDisplayDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = EventDisplayOptions.this.mEventDisplayList.getSelectionIndex();
                if (n != -1 && n < EventDisplayOptions.this.mEventDisplayList.getItemCount() - 1) {
                    EventDisplay eventDisplay = (EventDisplay)EventDisplayOptions.this.mDisplayList.remove(n);
                    EventDisplayOptions.this.mDisplayList.add(n + 1, eventDisplay);
                    EventDisplayOptions.this.mEventDisplayList.remove(n);
                    EventDisplayOptions.this.mEventDisplayList.add(eventDisplay.getName(), n + 1);
                    EventDisplayOptions.this.mEventDisplayList.select(n + 1);
                    EventDisplayOptions.this.handleEventDisplaySelection();
                    EventDisplayOptions.this.mEventDisplayList.showSelection();
                    EventDisplayOptions.this.setModified();
                }
            }
        });
        Group group = new Group(composite, 0);
        group.setText("Display Size:");
        group.setLayoutData((Object)new GridData(768));
        group.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label((Composite)group, 0);
        label.setText("Width:");
        this.mDisplayWidthText = new Text((Composite)group, 18436);
        this.mDisplayWidthText.setLayoutData((Object)new GridData(768));
        this.mDisplayWidthText.setText(Integer.toString(iPreferenceStore.getInt("EventLogPanel.width")));
        this.mDisplayWidthText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                String string = EventDisplayOptions.this.mDisplayWidthText.getText().trim();
                try {
                    iPreferenceStore.setValue("EventLogPanel.width", Integer.parseInt(string));
                    EventDisplayOptions.this.setModified();
                }
                catch (NumberFormatException numberFormatException) {}
            }
        });
        label = new Label((Composite)group, 0);
        label.setText("Height:");
        this.mDisplayHeightText = new Text((Composite)group, 18436);
        this.mDisplayHeightText.setLayoutData((Object)new GridData(768));
        this.mDisplayHeightText.setText(Integer.toString(iPreferenceStore.getInt("EventLogPanel.height")));
        this.mDisplayHeightText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                String string = EventDisplayOptions.this.mDisplayHeightText.getText().trim();
                try {
                    iPreferenceStore.setValue("EventLogPanel.height", Integer.parseInt(string));
                    EventDisplayOptions.this.setModified();
                }
                catch (NumberFormatException numberFormatException) {}
            }
        });
    }

    private void createRightPanel(Composite composite) {
        composite.setLayout((Layout)new GridLayout(1, true));
        composite.setLayoutData((Object)new GridData(1808));
        this.mInfoGroup = new Group(composite, 0);
        this.mInfoGroup.setLayoutData((Object)new GridData(768));
        this.mInfoGroup.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label((Composite)this.mInfoGroup, 16384);
        label.setText("Name:");
        this.mDisplayNameText = new Text((Composite)this.mInfoGroup, 18436);
        this.mDisplayNameText.setLayoutData((Object)new GridData(768));
        this.mDisplayNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                EventDisplay eventDisplay;
                if (EventDisplayOptions.this.mProcessTextChanges && (eventDisplay = EventDisplayOptions.this.getCurrentEventDisplay()) != null) {
                    eventDisplay.setName(EventDisplayOptions.this.mDisplayNameText.getText());
                    int n = EventDisplayOptions.this.mEventDisplayList.getSelectionIndex();
                    EventDisplayOptions.this.mEventDisplayList.remove(n);
                    EventDisplayOptions.this.mEventDisplayList.add(eventDisplay.getName(), n);
                    EventDisplayOptions.this.mEventDisplayList.select(n);
                    EventDisplayOptions.this.handleEventDisplaySelection();
                    EventDisplayOptions.this.setModified();
                }
            }
        });
        Label label2 = new Label((Composite)this.mInfoGroup, 16384);
        label2.setText("Type:");
        this.mDisplayTypeCombo = new Combo((Composite)this.mInfoGroup, 12);
        this.mDisplayTypeCombo.setLayoutData((Object)new GridData(768));
        this.mDisplayTypeCombo.add("Log All");
        this.mDisplayTypeCombo.add("Filtered Log");
        this.mDisplayTypeCombo.add("Graph");
        this.mDisplayTypeCombo.add("Sync");
        this.mDisplayTypeCombo.add("Sync Histogram");
        this.mDisplayTypeCombo.add("Sync Performance");
        this.mDisplayTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                EventDisplay eventDisplay = EventDisplayOptions.this.getCurrentEventDisplay();
                if (eventDisplay != null && eventDisplay.getDisplayType() != EventDisplayOptions.this.mDisplayTypeCombo.getSelectionIndex()) {
                    EventDisplayOptions.this.setModified();
                    String string = eventDisplay.getName();
                    EventDisplay eventDisplay2 = EventDisplay.eventDisplayFactory(EventDisplayOptions.this.mDisplayTypeCombo.getSelectionIndex(), string);
                    EventDisplayOptions.this.setCurrentEventDisplay(eventDisplay2);
                    EventDisplayOptions.this.fillUiWith(eventDisplay2);
                }
            }
        });
        this.mChartOptions = new Group((Composite)this.mInfoGroup, 0);
        this.mChartOptions.setText("Chart Options");
        GridData gridData = new GridData(768);
        this.mChartOptions.setLayoutData((Object)gridData);
        gridData.horizontalSpan = 2;
        this.mChartOptions.setLayout((Layout)new GridLayout(2, false));
        Label label3 = new Label((Composite)this.mChartOptions, 0);
        label3.setText("Time Limit (seconds):");
        this.mTimeLimitText = new Text((Composite)this.mChartOptions, 2048);
        this.mTimeLimitText.setLayoutData((Object)new GridData(768));
        this.mTimeLimitText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                block7: {
                    String string = EventDisplayOptions.this.mTimeLimitText.getText().trim();
                    EventDisplay eventDisplay = EventDisplayOptions.this.getCurrentEventDisplay();
                    if (eventDisplay != null) {
                        try {
                            try {
                                if (string.length() == 0) {
                                    eventDisplay.resetChartTimeLimit();
                                    break block7;
                                }
                                eventDisplay.setChartTimeLimit(Long.parseLong(string));
                            }
                            catch (NumberFormatException numberFormatException) {
                                eventDisplay.resetChartTimeLimit();
                                EventDisplayOptions.this.setModified();
                            }
                        }
                        finally {
                            EventDisplayOptions.this.setModified();
                        }
                    }
                }
            }
        });
        this.mHistOptions = new Group((Composite)this.mInfoGroup, 0);
        this.mHistOptions.setText("Histogram Options");
        GridData gridData2 = new GridData(768);
        this.mHistOptions.setLayoutData((Object)gridData2);
        gridData2.horizontalSpan = 2;
        this.mHistOptions.setLayout((Layout)new GridLayout(2, false));
        Label label4 = new Label((Composite)this.mHistOptions, 0);
        label4.setText("Histogram width (hours):");
        this.mHistWidthText = new Text((Composite)this.mHistOptions, 2048);
        this.mHistWidthText.setLayoutData((Object)new GridData(768));
        this.mHistWidthText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                block7: {
                    String string = EventDisplayOptions.this.mHistWidthText.getText().trim();
                    EventDisplay eventDisplay = EventDisplayOptions.this.getCurrentEventDisplay();
                    if (eventDisplay != null) {
                        try {
                            try {
                                if (string.length() == 0) {
                                    eventDisplay.resetHistWidth();
                                    break block7;
                                }
                                eventDisplay.setHistWidth(Long.parseLong(string));
                            }
                            catch (NumberFormatException numberFormatException) {
                                eventDisplay.resetHistWidth();
                                EventDisplayOptions.this.setModified();
                            }
                        }
                        finally {
                            EventDisplayOptions.this.setModified();
                        }
                    }
                }
            }
        });
        this.mPidFilterCheckBox = new Button((Composite)this.mInfoGroup, 32);
        this.mPidFilterCheckBox.setText("Enable filtering by pid");
        gridData = new GridData(768);
        this.mPidFilterCheckBox.setLayoutData((Object)gridData);
        gridData.horizontalSpan = 2;
        this.mPidFilterCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                EventDisplay eventDisplay = EventDisplayOptions.this.getCurrentEventDisplay();
                if (eventDisplay != null) {
                    eventDisplay.setPidFiltering(EventDisplayOptions.this.mPidFilterCheckBox.getSelection());
                    EventDisplayOptions.this.mPidText.setEnabled(EventDisplayOptions.this.mPidFilterCheckBox.getSelection());
                    EventDisplayOptions.this.setModified();
                }
            }
        });
        Label label5 = new Label((Composite)this.mInfoGroup, 0);
        label5.setText("Pid Filter:");
        label5.setToolTipText("Enter all pids, separated by commas");
        this.mPidText = new Text((Composite)this.mInfoGroup, 2048);
        this.mPidText.setLayoutData((Object)new GridData(768));
        this.mPidText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                EventDisplay eventDisplay;
                if (EventDisplayOptions.this.mProcessTextChanges && (eventDisplay = EventDisplayOptions.this.getCurrentEventDisplay()) != null && eventDisplay.getPidFiltering()) {
                    String string = EventDisplayOptions.this.mPidText.getText().trim();
                    String[] stringArray = string.split("\\s*,\\s*");
                    ArrayList<Integer> arrayList = new ArrayList<Integer>();
                    String[] stringArray2 = stringArray;
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String string2 = stringArray2[n2];
                        try {
                            arrayList.add(Integer.valueOf(string2));
                        }
                        catch (NumberFormatException numberFormatException) {}
                        ++n2;
                    }
                    eventDisplay.setPidFilterList(arrayList);
                    EventDisplayOptions.this.setModified();
                }
            }
        });
        this.mValueSelection = this.createEventSelection(composite, EventDisplay.ValueDisplayDescriptor.class, "Event Value Display");
        this.mOccurrenceSelection = this.createEventSelection(composite, EventDisplay.OccurrenceDisplayDescriptor.class, "Event Occurrence Display");
    }

    private SelectionWidgets createEventSelection(Composite composite, final Class<? extends EventDisplay.OccurrenceDisplayDescriptor> clazz, String string) {
        Group group = new Group(composite, 0);
        group.setLayoutData((Object)new GridData(1808));
        GridLayout gridLayout = new GridLayout(2, false);
        group.setLayout((Layout)gridLayout);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        group.setText(string);
        final SelectionWidgets selectionWidgets = new SelectionWidgets();
        selectionWidgets.mList = new List((Composite)group, 2564);
        selectionWidgets.mList.setLayoutData((Object)new GridData(1808));
        selectionWidgets.mList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = selectionWidgets.mList.getSelectionIndex();
                if (n != -1) {
                    selectionWidgets.mDeleteButton.setEnabled(true);
                    selectionWidgets.mEditButton.setEnabled(true);
                } else {
                    selectionWidgets.mDeleteButton.setEnabled(false);
                    selectionWidgets.mEditButton.setEnabled(false);
                }
            }
        });
        Composite composite2 = new Composite((Composite)group, 0);
        composite2.setLayoutData((Object)new GridData(1040));
        gridLayout = new GridLayout(1, false);
        composite2.setLayout((Layout)gridLayout);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        selectionWidgets.mNewButton = new Button(composite2, 0x800008);
        selectionWidgets.mNewButton.setText("New...");
        selectionWidgets.mNewButton.setLayoutData((Object)new GridData(768));
        selectionWidgets.mNewButton.setEnabled(false);
        selectionWidgets.mNewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                try {
                    EventValueSelector eventValueSelector;
                    EventDisplay eventDisplay = EventDisplayOptions.this.getCurrentEventDisplay();
                    if (eventDisplay != null && (eventValueSelector = new EventValueSelector(EventDisplayOptions.this.mShell)).open(clazz, EventDisplayOptions.this.mLogParser)) {
                        eventDisplay.addDescriptor(eventValueSelector.getDescriptor());
                        EventDisplayOptions.this.fillUiWith(eventDisplay);
                        EventDisplayOptions.this.setModified();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        selectionWidgets.mEditButton = new Button(composite2, 0x800008);
        selectionWidgets.mEditButton.setText("Edit...");
        selectionWidgets.mEditButton.setLayoutData((Object)new GridData(768));
        selectionWidgets.mEditButton.setEnabled(false);
        selectionWidgets.mEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n;
                EventDisplay eventDisplay = EventDisplayOptions.this.getCurrentEventDisplay();
                if (eventDisplay != null && (n = selectionWidgets.mList.getSelectionIndex()) != -1) {
                    EventDisplay.OccurrenceDisplayDescriptor occurrenceDisplayDescriptor = eventDisplay.getDescriptor(clazz, n);
                    EventValueSelector eventValueSelector = new EventValueSelector(EventDisplayOptions.this.mShell);
                    if (eventValueSelector.open(occurrenceDisplayDescriptor, EventDisplayOptions.this.mLogParser)) {
                        occurrenceDisplayDescriptor.replaceWith(eventValueSelector.getDescriptor());
                        eventDisplay.updateValueDescriptorCheck();
                        EventDisplayOptions.this.fillUiWith(eventDisplay);
                        selectionWidgets.mList.select(n);
                        selectionWidgets.mList.notifyListeners(13, null);
                        EventDisplayOptions.this.setModified();
                    }
                }
            }
        });
        selectionWidgets.mDeleteButton = new Button(composite2, 0x800008);
        selectionWidgets.mDeleteButton.setLayoutData((Object)new GridData(768));
        selectionWidgets.mDeleteButton.setText("Delete");
        selectionWidgets.mDeleteButton.setEnabled(false);
        selectionWidgets.mDeleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n;
                EventDisplay eventDisplay = EventDisplayOptions.this.getCurrentEventDisplay();
                if (eventDisplay != null && (n = selectionWidgets.mList.getSelectionIndex()) != -1) {
                    eventDisplay.removeDescriptor(clazz, n);
                    EventDisplayOptions.this.fillUiWith(eventDisplay);
                    EventDisplayOptions.this.setModified();
                }
            }
        });
        return selectionWidgets;
    }

    private void duplicateEventDisplay(ArrayList<EventDisplay> arrayList) {
        for (EventDisplay eventDisplay : arrayList) {
            this.mDisplayList.add(EventDisplay.clone(eventDisplay));
        }
    }

    private void buildPidList(ArrayList<EventContainer> arrayList) {
        this.mPidList = new ArrayList();
        for (EventContainer eventContainer : arrayList) {
            if (this.mPidList.indexOf(eventContainer.pid) != -1) continue;
            this.mPidList.add(eventContainer.pid);
        }
    }

    private void setModified() {
        this.mEditStatus = true;
    }

    private void enable(boolean bl) {
        this.mEventDisplayDeleteButton.setEnabled(bl);
        int n = this.mEventDisplayList.getSelectionIndex();
        int n2 = this.mEventDisplayList.getItemCount();
        this.mEventDisplayUpButton.setEnabled(bl && n > 0);
        this.mEventDisplayDownButton.setEnabled(bl && n != -1 && n < n2 - 1);
        this.mDisplayNameText.setEnabled(bl);
        this.mDisplayTypeCombo.setEnabled(bl);
        this.mPidFilterCheckBox.setEnabled(bl);
        this.mValueSelection.setEnabled(bl);
        this.mOccurrenceSelection.setEnabled(bl);
        this.mValueSelection.mNewButton.setEnabled(bl);
        this.mOccurrenceSelection.mNewButton.setEnabled(bl);
        if (!bl) {
            this.mPidText.setEnabled(false);
        }
    }

    private void fillEventDisplayList() {
        for (EventDisplay eventDisplay : this.mDisplayList) {
            this.mEventDisplayList.add(eventDisplay.getName());
        }
    }

    private void createNewEventDisplay() {
        int n = this.mDisplayList.size();
        String string = String.format("display %1$d", n + 1);
        EventDisplay eventDisplay = EventDisplay.eventDisplayFactory(0, string);
        this.mDisplayList.add(eventDisplay);
        this.mEventDisplayList.add(string);
        this.mEventDisplayList.select(n);
        this.handleEventDisplaySelection();
        this.mEventDisplayList.showSelection();
        this.setModified();
    }

    private void deleteEventDisplay() {
        int n = this.mEventDisplayList.getSelectionIndex();
        if (n != -1) {
            this.mDisplayList.remove(n);
            this.mEventDisplayList.remove(n);
            if (this.mDisplayList.size() < n) {
                --n;
            }
            this.mEventDisplayList.select(n);
            this.handleEventDisplaySelection();
            this.setModified();
        }
    }

    private EventDisplay getCurrentEventDisplay() {
        int n = this.mEventDisplayList.getSelectionIndex();
        if (n != -1) {
            return this.mDisplayList.get(n);
        }
        return null;
    }

    private void setCurrentEventDisplay(EventDisplay eventDisplay) {
        int n = this.mEventDisplayList.getSelectionIndex();
        if (n != -1) {
            this.mDisplayList.set(n, eventDisplay);
        }
    }

    private void handleEventDisplaySelection() {
        EventDisplay eventDisplay = this.getCurrentEventDisplay();
        if (eventDisplay != null) {
            this.enable(true);
            this.fillUiWith(eventDisplay);
        } else {
            this.enable(false);
            this.emptyUi();
        }
    }

    private void emptyUi() {
        this.mDisplayNameText.setText("");
        this.mDisplayTypeCombo.clearSelection();
        this.mValueSelection.mList.removeAll();
        this.mOccurrenceSelection.mList.removeAll();
    }

    private void fillUiWith(EventDisplay eventDisplay) {
        long l;
        Object object;
        this.mProcessTextChanges = false;
        this.mDisplayNameText.setText(eventDisplay.getName());
        int n = eventDisplay.getDisplayType();
        this.mDisplayTypeCombo.select(n);
        if (n == 2) {
            object = (GridData)this.mChartOptions.getLayoutData();
            ((GridData)object).exclude = false;
            this.mChartOptions.setVisible(!((GridData)object).exclude);
            l = eventDisplay.getChartTimeLimit();
            if (l != -1L) {
                this.mTimeLimitText.setText(Long.toString(l));
            } else {
                this.mTimeLimitText.setText("");
            }
        } else {
            object = (GridData)this.mChartOptions.getLayoutData();
            ((GridData)object).exclude = true;
            this.mChartOptions.setVisible(!((GridData)object).exclude);
            this.mTimeLimitText.setText("");
        }
        if (n == 4) {
            object = (GridData)this.mHistOptions.getLayoutData();
            ((GridData)object).exclude = false;
            this.mHistOptions.setVisible(!((GridData)object).exclude);
            l = eventDisplay.getHistWidth();
            if (l != -1L) {
                this.mHistWidthText.setText(Long.toString(l));
            } else {
                this.mHistWidthText.setText("");
            }
        } else {
            object = (GridData)this.mHistOptions.getLayoutData();
            ((GridData)object).exclude = true;
            this.mHistOptions.setVisible(!((GridData)object).exclude);
            this.mHistWidthText.setText("");
        }
        this.mInfoGroup.layout(true);
        this.mShell.layout(true);
        this.mShell.pack();
        if (eventDisplay.getPidFiltering()) {
            this.mPidFilterCheckBox.setSelection(true);
            this.mPidText.setEnabled(true);
            object = eventDisplay.getPidFilterList();
            if (object != null) {
                StringBuilder stringBuilder = new StringBuilder();
                int n2 = ((ArrayList)object).size();
                int n3 = 0;
                while (n3 < n2) {
                    stringBuilder.append(((ArrayList)object).get(n3));
                    if (n3 < n2 - 1) {
                        stringBuilder.append(", ");
                    }
                    ++n3;
                }
                this.mPidText.setText(stringBuilder.toString());
            } else {
                this.mPidText.setText("");
            }
        } else {
            this.mPidFilterCheckBox.setSelection(false);
            this.mPidText.setEnabled(false);
            this.mPidText.setText("");
        }
        this.mProcessTextChanges = true;
        this.mValueSelection.mList.removeAll();
        this.mOccurrenceSelection.mList.removeAll();
        if (eventDisplay.getDisplayType() == 1 || eventDisplay.getDisplayType() == 2) {
            this.mOccurrenceSelection.setEnabled(true);
            this.mValueSelection.setEnabled(true);
            object = eventDisplay.getValueDescriptors();
            while (object.hasNext()) {
                EventDisplay.ValueDisplayDescriptor valueDisplayDescriptor = (EventDisplay.ValueDisplayDescriptor)object.next();
                this.mValueSelection.mList.add(String.format("%1$s: %2$s [%3$s]%4$s", this.mEventTagMap.get(valueDisplayDescriptor.eventTag), valueDisplayDescriptor.valueName, this.getSeriesLabelDescription(valueDisplayDescriptor), this.getFilterDescription(valueDisplayDescriptor)));
            }
            Iterator<EventDisplay.OccurrenceDisplayDescriptor> iterator = eventDisplay.getOccurrenceDescriptors();
            while (iterator.hasNext()) {
                EventDisplay.OccurrenceDisplayDescriptor occurrenceDisplayDescriptor = iterator.next();
                this.mOccurrenceSelection.mList.add(String.format("%1$s [%2$s]%3$s", this.mEventTagMap.get(occurrenceDisplayDescriptor.eventTag), this.getSeriesLabelDescription(occurrenceDisplayDescriptor), this.getFilterDescription(occurrenceDisplayDescriptor)));
            }
            this.mValueSelection.mList.notifyListeners(13, null);
            this.mOccurrenceSelection.mList.notifyListeners(13, null);
        } else {
            this.mOccurrenceSelection.setEnabled(false);
            this.mValueSelection.setEnabled(false);
        }
    }

    private String getSeriesLabelDescription(EventDisplay.OccurrenceDisplayDescriptor occurrenceDisplayDescriptor) {
        if (occurrenceDisplayDescriptor.seriesValueIndex != -1) {
            if (occurrenceDisplayDescriptor.includePid) {
                return String.format("%1$s + pid", this.mEventDescriptionMap.get(occurrenceDisplayDescriptor.eventTag)[occurrenceDisplayDescriptor.seriesValueIndex].getName());
            }
            return this.mEventDescriptionMap.get(occurrenceDisplayDescriptor.eventTag)[occurrenceDisplayDescriptor.seriesValueIndex].getName();
        }
        return "pid";
    }

    private String getFilterDescription(EventDisplay.OccurrenceDisplayDescriptor occurrenceDisplayDescriptor) {
        if (occurrenceDisplayDescriptor.filterValueIndex != -1) {
            return String.format(" [%1$s %2$s %3$s]", this.mEventDescriptionMap.get(occurrenceDisplayDescriptor.eventTag)[occurrenceDisplayDescriptor.filterValueIndex].getName(), occurrenceDisplayDescriptor.filterCompareMethod.testString(), occurrenceDisplayDescriptor.filterValue != null ? occurrenceDisplayDescriptor.filterValue.toString() : "?");
        }
        return "";
    }

    private static class SelectionWidgets {
        private List mList;
        private Button mNewButton;
        private Button mEditButton;
        private Button mDeleteButton;

        private SelectionWidgets() {
        }

        private void setEnabled(boolean bl) {
            this.mList.setEnabled(bl);
            this.mNewButton.setEnabled(bl);
            this.mEditButton.setEnabled(bl);
            this.mDeleteButton.setEnabled(bl);
        }
    }
}

