/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.ddmlib.RawImage;
import com.android.ddmuilib.DdmUiPreferences;
import com.android.ddmuilib.ImageHelper;
import com.android.ddmuilib.WritePng;
import java.io.IOException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ScreenShotDialog
extends Dialog {
    private Label mBusyLabel;
    private Label mImageLabel;
    private Button mSave;
    private IDevice mDevice;

    public ScreenShotDialog(Shell shell) {
        this(shell, 67680);
    }

    public ScreenShotDialog(Shell shell, int n) {
        super(shell, n);
    }

    public void open(IDevice iDevice) {
        this.mDevice = iDevice;
        Shell shell = this.getParent();
        Shell shell2 = new Shell(shell, this.getStyle());
        shell2.setText("Device Screen Capture");
        this.createContents(shell2);
        shell2.pack();
        shell2.open();
        this.updateDeviceImage(shell2);
        Display display = shell.getDisplay();
        while (!shell2.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    private void createContents(final Shell shell) {
        shell.setLayout((Layout)new GridLayout(3, true));
        this.mBusyLabel = new Label((Composite)shell, 0);
        this.mBusyLabel.setText("Preparing...");
        GridData gridData = new GridData(32);
        gridData.horizontalSpan = 3;
        this.mBusyLabel.setLayoutData((Object)gridData);
        this.mImageLabel = new Label((Composite)shell, 2048);
        gridData = new GridData(64);
        gridData.horizontalSpan = 3;
        this.mImageLabel.setLayoutData((Object)gridData);
        Display display = shell.getDisplay();
        this.mImageLabel.setImage(ImageHelper.createPlaceHolderArt(display, 50, 50, display.getSystemColor(9)));
        Button button = new Button((Composite)shell, 8);
        button.setText("Refresh");
        gridData = new GridData(64);
        gridData.widthHint = 80;
        button.setLayoutData((Object)gridData);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ScreenShotDialog.this.updateDeviceImage(shell);
            }
        });
        this.mSave = new Button((Composite)shell, 8);
        this.mSave.setText("Save");
        gridData = new GridData(64);
        gridData.widthHint = 80;
        this.mSave.setLayoutData((Object)gridData);
        this.mSave.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ScreenShotDialog.this.saveImage(shell);
            }
        });
        Button button2 = new Button((Composite)shell, 8);
        button2.setText("Done");
        gridData = new GridData(64);
        gridData.widthHint = 80;
        button2.setLayoutData((Object)gridData);
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                shell.close();
            }
        });
        shell.setDefaultButton(button2);
    }

    private void updateDeviceImage(Shell shell) {
        this.mBusyLabel.setText("Capturing...");
        shell.setCursor(shell.getDisplay().getSystemCursor(1));
        Image image = this.getDeviceImage();
        if (image == null) {
            Display display = shell.getDisplay();
            image = ImageHelper.createPlaceHolderArt(display, 320, 240, display.getSystemColor(9));
            this.mSave.setEnabled(false);
            this.mBusyLabel.setText("Screen not available");
        } else {
            this.mSave.setEnabled(true);
            this.mBusyLabel.setText("Captured image:");
        }
        this.mImageLabel.setImage(image);
        this.mImageLabel.pack();
        shell.pack();
        shell.setCursor(shell.getDisplay().getSystemCursor(0));
    }

    private Image getDeviceImage() {
        RawImage rawImage;
        try {
            rawImage = this.mDevice.getScreenshot();
        }
        catch (IOException iOException) {
            Log.w("ddms", "Unable to get frame buffer: " + iOException.getMessage());
            return null;
        }
        if (rawImage == null) {
            return null;
        }
        assert (rawImage.bpp == 16);
        PaletteData paletteData = new PaletteData(63488, 2016, 31);
        ImageData imageData = new ImageData(rawImage.width, rawImage.height, rawImage.bpp, paletteData, 1, rawImage.data);
        return new Image((Device)this.getParent().getDisplay(), imageData);
    }

    private void saveImage(Shell shell) {
        FileDialog fileDialog = new FileDialog(shell, 8192);
        fileDialog.setText("Save image...");
        fileDialog.setFileName("device.png");
        fileDialog.setFilterPath(DdmUiPreferences.getStore().getString("lastImageSaveDir"));
        fileDialog.setFilterNames(new String[]{"PNG Files (*.png)"});
        fileDialog.setFilterExtensions(new String[]{"*.png"});
        String string = fileDialog.open();
        if (string != null) {
            DdmUiPreferences.getStore().setValue("lastImageSaveDir", fileDialog.getFilterPath());
            Log.i("ddms", "Saving image to " + string);
            ImageData imageData = this.mImageLabel.getImage().getImageData();
            try {
                WritePng.savePng(string, imageData);
            }
            catch (IOException iOException) {
                Log.w("ddms", "Unable to save " + string + ": " + iOException);
            }
        }
    }
}

