/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib.log;

import com.android.ddmlib.log.InvalidTypeException;
import com.android.ddmlib.log.LogReceiver;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EventContainer {
    public int mTag;
    public int pid;
    public int tid;
    public int sec;
    public int nsec;
    private Object mData;

    EventContainer(LogReceiver.LogEntry logEntry, int n, Object object) {
        this.getType(object);
        this.mTag = n;
        this.mData = object;
        this.pid = logEntry.pid;
        this.tid = logEntry.tid;
        this.sec = logEntry.sec;
        this.nsec = logEntry.nsec;
    }

    EventContainer(int n, int n2, int n3, int n4, int n5, Object object) {
        this.getType(object);
        this.mTag = n;
        this.mData = object;
        this.pid = n2;
        this.tid = n3;
        this.sec = n4;
        this.nsec = n5;
    }

    public final Integer getInt() throws InvalidTypeException {
        if (this.getType(this.mData) == EventValueType.INT) {
            return (Integer)this.mData;
        }
        throw new InvalidTypeException();
    }

    public final Long getLong() throws InvalidTypeException {
        if (this.getType(this.mData) == EventValueType.LONG) {
            return (Long)this.mData;
        }
        throw new InvalidTypeException();
    }

    public final String getString() throws InvalidTypeException {
        if (this.getType(this.mData) == EventValueType.STRING) {
            return (String)this.mData;
        }
        throw new InvalidTypeException();
    }

    public Object getValue(int n) {
        return this.getValue(this.mData, n, true);
    }

    public double getValueAsDouble(int n) throws InvalidTypeException {
        return this.getValueAsDouble(this.mData, n, true);
    }

    public String getValueAsString(int n) throws InvalidTypeException {
        return this.getValueAsString(this.mData, n, true);
    }

    public EventValueType getType() {
        return this.getType(this.mData);
    }

    public final EventValueType getType(Object object) {
        if (object instanceof Integer) {
            return EventValueType.INT;
        }
        if (object instanceof Long) {
            return EventValueType.LONG;
        }
        if (object instanceof String) {
            return EventValueType.STRING;
        }
        if (object instanceof Object[]) {
            Object[] objectArray;
            Object[] objectArray2 = objectArray = (Object[])object;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object2 = objectArray2[n2];
                EventValueType eventValueType = this.getType(object2);
                if (eventValueType == EventValueType.LIST || eventValueType == EventValueType.TREE) {
                    return EventValueType.TREE;
                }
                ++n2;
            }
            return EventValueType.LIST;
        }
        return EventValueType.UNKNOWN;
    }

    public boolean testValue(int n, Object object, CompareMethod compareMethod) throws InvalidTypeException {
        EventValueType eventValueType = this.getType(this.mData);
        if (n > 0 && eventValueType != EventValueType.LIST) {
            throw new InvalidTypeException();
        }
        Object object2 = this.mData;
        if (eventValueType == EventValueType.LIST) {
            object2 = ((Object[])this.mData)[n];
        }
        if (!object2.getClass().equals(object2.getClass())) {
            throw new InvalidTypeException();
        }
        switch (compareMethod) {
            case EQUAL_TO: {
                return object2.equals(object);
            }
            case LESSER_THAN: {
                if (object2 instanceof Integer) {
                    return ((Integer)object2).compareTo((Integer)object) <= 0;
                }
                if (object2 instanceof Long) {
                    return ((Long)object2).compareTo((Long)object) <= 0;
                }
                throw new InvalidTypeException();
            }
            case LESSER_THAN_STRICT: {
                if (object2 instanceof Integer) {
                    return ((Integer)object2).compareTo((Integer)object) < 0;
                }
                if (object2 instanceof Long) {
                    return ((Long)object2).compareTo((Long)object) < 0;
                }
                throw new InvalidTypeException();
            }
            case GREATER_THAN: {
                if (object2 instanceof Integer) {
                    return ((Integer)object2).compareTo((Integer)object) >= 0;
                }
                if (object2 instanceof Long) {
                    return ((Long)object2).compareTo((Long)object) >= 0;
                }
                throw new InvalidTypeException();
            }
            case GREATER_THAN_STRICT: {
                if (object2 instanceof Integer) {
                    return ((Integer)object2).compareTo((Integer)object) > 0;
                }
                if (object2 instanceof Long) {
                    return ((Long)object2).compareTo((Long)object) > 0;
                }
                throw new InvalidTypeException();
            }
            case BIT_CHECK: {
                if (object2 instanceof Integer) {
                    return ((Integer)object2 & (Integer)object) != 0;
                }
                if (object2 instanceof Long) {
                    return ((Long)object2 & (Long)object) != 0L;
                }
                throw new InvalidTypeException();
            }
        }
        throw new InvalidTypeException();
    }

    private final Object getValue(Object object, int n, boolean bl) {
        EventValueType eventValueType = this.getType(object);
        switch (eventValueType) {
            case INT: 
            case LONG: 
            case STRING: {
                return object;
            }
            case LIST: {
                if (!bl) break;
                Object[] objectArray = (Object[])object;
                if (n < 0 || n >= objectArray.length) break;
                return this.getValue(objectArray[n], n, false);
            }
        }
        return null;
    }

    private final double getValueAsDouble(Object object, int n, boolean bl) throws InvalidTypeException {
        EventValueType eventValueType = this.getType(object);
        switch (eventValueType) {
            case INT: {
                return ((Integer)object).doubleValue();
            }
            case LONG: {
                return ((Long)object).doubleValue();
            }
            case STRING: {
                throw new InvalidTypeException();
            }
            case LIST: {
                if (!bl) break;
                Object[] objectArray = (Object[])object;
                if (n < 0 || n >= objectArray.length) break;
                return this.getValueAsDouble(objectArray[n], n, false);
            }
        }
        throw new InvalidTypeException();
    }

    private final String getValueAsString(Object object, int n, boolean bl) throws InvalidTypeException {
        EventValueType eventValueType = this.getType(object);
        switch (eventValueType) {
            case INT: {
                return ((Integer)object).toString();
            }
            case LONG: {
                return ((Long)object).toString();
            }
            case STRING: {
                return (String)object;
            }
            case LIST: {
                if (bl) {
                    Object[] objectArray = (Object[])object;
                    if (n < 0 || n >= objectArray.length) break;
                    return this.getValueAsString(objectArray[n], n, false);
                }
                throw new InvalidTypeException("getValueAsString() doesn't support EventValueType.TREE");
            }
        }
        throw new InvalidTypeException("getValueAsString() unsupported type:" + (Object)((Object)eventValueType));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CompareMethod {
        EQUAL_TO("equals", "=="),
        LESSER_THAN("less than or equals to", "<="),
        LESSER_THAN_STRICT("less than", "<"),
        GREATER_THAN("greater than or equals to", ">="),
        GREATER_THAN_STRICT("greater than", ">"),
        BIT_CHECK("bit check", "&");

        private final String mName;
        private final String mTestString;

        private CompareMethod(String string2, String string3) {
            this.mName = string2;
            this.mTestString = string3;
        }

        public String toString() {
            return this.mName;
        }

        public String testString() {
            return this.mTestString;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EventValueType {
        UNKNOWN(0),
        INT(1),
        LONG(2),
        STRING(3),
        LIST(4),
        TREE(5);

        private static final Pattern STORAGE_PATTERN;
        private int mValue;

        static {
            STORAGE_PATTERN = Pattern.compile("^(\\d+)@(.*)$");
        }

        static EventValueType getEventValueType(int n) {
            EventValueType[] eventValueTypeArray = EventValueType.values();
            int n2 = eventValueTypeArray.length;
            int n3 = 0;
            while (n3 < n2) {
                EventValueType eventValueType = eventValueTypeArray[n3];
                if (eventValueType.mValue == n) {
                    return eventValueType;
                }
                ++n3;
            }
            return null;
        }

        public static String getStorageString(Object object) {
            if (object instanceof String) {
                return String.valueOf(EventValueType.STRING.mValue) + "@" + (String)object;
            }
            if (object instanceof Integer) {
                return String.valueOf(EventValueType.INT.mValue) + "@" + object.toString();
            }
            if (object instanceof Long) {
                return String.valueOf(EventValueType.LONG.mValue) + "@" + object.toString();
            }
            return null;
        }

        public static Object getObjectFromStorageString(String string) {
            Matcher matcher = STORAGE_PATTERN.matcher(string);
            if (matcher.matches()) {
                EventValueType eventValueType;
                block9: {
                    try {
                        eventValueType = EventValueType.getEventValueType(Integer.parseInt(matcher.group(1)));
                        if (eventValueType != null) break block9;
                        return null;
                    }
                    catch (NumberFormatException numberFormatException) {
                        return null;
                    }
                }
                switch (eventValueType) {
                    case STRING: {
                        return matcher.group(2);
                    }
                    case INT: {
                        return Integer.valueOf(matcher.group(2));
                    }
                    case LONG: {
                        return Long.valueOf(matcher.group(2));
                    }
                }
            }
            return null;
        }

        public int getValue() {
            return this.mValue;
        }

        public String toString() {
            return super.toString().toLowerCase();
        }

        private EventValueType(int n2) {
            this.mValue = n2;
        }
    }
}

