/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class NativeStackCallInfo {
    private static final Pattern SOURCE_NAME_PATTERN = Pattern.compile("^(.+):(\\d+)$");
    private String mLibrary;
    private String mMethod;
    private String mSourceFile;
    private int mLineNumber = -1;

    public NativeStackCallInfo(String string, String string2, String string3) {
        this.mLibrary = string;
        this.mMethod = string2;
        Matcher matcher = SOURCE_NAME_PATTERN.matcher(string3);
        if (matcher.matches()) {
            this.mSourceFile = matcher.group(1);
            try {
                this.mLineNumber = Integer.parseInt(matcher.group(2));
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            this.mSourceFile = string3;
        }
    }

    public String getLibraryName() {
        return this.mLibrary;
    }

    public String getMethodName() {
        return this.mMethod;
    }

    public String getSourceFile() {
        return this.mSourceFile;
    }

    public int getLineNumber() {
        return this.mLineNumber;
    }
}

