/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.ChunkHandler;
import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.Log;
import com.android.ddmlib.MonitorThread;
import java.io.IOException;
import java.nio.ByteBuffer;

final class HandleAppName
extends ChunkHandler {
    public static final int CHUNK_APNM = ChunkHandler.type("APNM");
    private static final HandleAppName mInst = new HandleAppName();

    private HandleAppName() {
    }

    public static void register(MonitorThread monitorThread) {
        monitorThread.registerChunkHandler(CHUNK_APNM, mInst);
    }

    public void clientReady(Client client) throws IOException {
    }

    public void clientDisconnected(Client client) {
    }

    public void handleChunk(Client client, int n, ByteBuffer byteBuffer, boolean bl, int n2) {
        Log.d("ddm-appname", "handling " + ChunkHandler.name(n));
        if (n == CHUNK_APNM) {
            assert (!bl);
            HandleAppName.handleAPNM(client, byteBuffer);
        } else {
            this.handleUnknownChunk(client, n, byteBuffer, bl, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleAPNM(Client client, ByteBuffer byteBuffer) {
        ClientData clientData;
        int n = byteBuffer.getInt();
        String string = HandleAppName.getString(byteBuffer, n);
        Log.i("ddm-appname", "APNM: app='" + string + "'");
        ClientData clientData2 = clientData = client.getClientData();
        synchronized (clientData2) {
            clientData.setClientDescription(string);
        }
        client = HandleAppName.checkDebuggerPortForAppName(client, string);
        if (client != null) {
            client.update(1);
        }
    }
}

