/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.AdbHelper;
import com.android.ddmlib.IDevice;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.security.InvalidParameterException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class EmulatorConsole {
    private static final String DEFAULT_ENCODING = "ISO-8859-1";
    private static final int WAIT_TIME = 5;
    private static final int STD_TIMEOUT = 5000;
    private static final String HOST = "127.0.0.1";
    private static final String COMMAND_PING = "help\r\n";
    private static final String COMMAND_AVD_NAME = "avd name\r\n";
    private static final String COMMAND_KILL = "kill\r\n";
    private static final String COMMAND_GSM_STATUS = "gsm status\r\n";
    private static final String COMMAND_GSM_CALL = "gsm call %1$s\r\n";
    private static final String COMMAND_GSM_CANCEL_CALL = "gsm cancel %1$s\r\n";
    private static final String COMMAND_GSM_DATA = "gsm data %1$s\r\n";
    private static final String COMMAND_GSM_VOICE = "gsm voice %1$s\r\n";
    private static final String COMMAND_SMS_SEND = "sms send %1$s %2$s\r\n";
    private static final String COMMAND_NETWORK_STATUS = "network status\r\n";
    private static final String COMMAND_NETWORK_SPEED = "network speed %1$s\r\n";
    private static final String COMMAND_NETWORK_LATENCY = "network delay %1$s\r\n";
    private static final String COMMAND_GPS = "geo nmea $GPGGA,%1$02d%2$02d%3$02d.%4$03d,%5$03d%6$09.6f,%7$c,%8$03d%9$09.6f,%10$c,1,10,0.0,0.0,0,0.0,0,0.0,0000\r\n";
    private static final Pattern RE_KO = Pattern.compile("KO:\\s+(.*)");
    public static final int[] MIN_LATENCIES;
    public final int[] DOWNLOAD_SPEEDS;
    public static final String[] NETWORK_SPEEDS;
    public static final String[] NETWORK_LATENCIES;
    public static final String RESULT_OK;
    private static final Pattern sEmulatorRegexp;
    private static final Pattern sVoiceStatusRegexp;
    private static final Pattern sDataStatusRegexp;
    private static final Pattern sDownloadSpeedRegexp;
    private static final Pattern sMinLatencyRegexp;
    private static final HashMap<Integer, EmulatorConsole> sEmulators;
    private int mPort;
    private SocketChannel mSocketChannel;
    private byte[] mBuffer;

    static {
        int[] nArray = new int[4];
        nArray[1] = 150;
        nArray[2] = 80;
        nArray[3] = 35;
        MIN_LATENCIES = nArray;
        NETWORK_SPEEDS = new String[]{"full", "gsm", "hscsd", "gprs", "edge", "umts", "hsdpa"};
        NETWORK_LATENCIES = new String[]{"none", "gprs", "edge", "umts"};
        RESULT_OK = null;
        sEmulatorRegexp = Pattern.compile("emulator-(\\d+)");
        sVoiceStatusRegexp = Pattern.compile("gsm\\s+voice\\s+state:\\s*([a-z]+)", 2);
        sDataStatusRegexp = Pattern.compile("gsm\\s+data\\s+state:\\s*([a-z]+)", 2);
        sDownloadSpeedRegexp = Pattern.compile("\\s+download\\s+speed:\\s+(\\d+)\\s+bits.*", 2);
        sMinLatencyRegexp = Pattern.compile("\\s+minimum\\s+latency:\\s+(\\d+)\\s+ms", 2);
        sEmulators = new HashMap();
    }

    public static synchronized EmulatorConsole getConsole(IDevice iDevice) {
        Matcher matcher = sEmulatorRegexp.matcher(iDevice.getSerialNumber());
        if (matcher.matches()) {
            int n;
            try {
                n = Integer.parseInt(matcher.group(1));
                if (n <= 0) {
                    return null;
                }
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            EmulatorConsole emulatorConsole = sEmulators.get(n);
            if (emulatorConsole != null && !emulatorConsole.ping()) {
                EmulatorConsole.RemoveConsole(emulatorConsole.mPort);
                emulatorConsole = null;
            }
            if (emulatorConsole == null) {
                emulatorConsole = new EmulatorConsole(n);
                if (emulatorConsole.start()) {
                    sEmulators.put(n, emulatorConsole);
                } else {
                    emulatorConsole = null;
                }
            }
            return emulatorConsole;
        }
        return null;
    }

    private static synchronized void RemoveConsole(int n) {
        sEmulators.remove(n);
    }

    private EmulatorConsole(int n) {
        int[] nArray = new int[7];
        nArray[1] = 14400;
        nArray[2] = 43200;
        nArray[3] = 80000;
        nArray[4] = 236800;
        nArray[5] = 1920000;
        nArray[6] = 14400000;
        this.DOWNLOAD_SPEEDS = nArray;
        this.mBuffer = new byte[1024];
        this.mPort = n;
    }

    private boolean start() {
        InetSocketAddress inetSocketAddress;
        try {
            InetAddress inetAddress = InetAddress.getByName(HOST);
            inetSocketAddress = new InetSocketAddress(inetAddress, this.mPort);
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
        try {
            this.mSocketChannel = SocketChannel.open(inetSocketAddress);
        }
        catch (IOException iOException) {
            return false;
        }
        this.readLines();
        return true;
    }

    private synchronized boolean ping() {
        if (this.sendCommand(COMMAND_PING)) {
            return this.readLines() != null;
        }
        return false;
    }

    public synchronized void kill() {
        if (this.sendCommand(COMMAND_KILL)) {
            EmulatorConsole.RemoveConsole(this.mPort);
        }
    }

    public synchronized String getAvdName() {
        if (this.sendCommand(COMMAND_AVD_NAME)) {
            String[] stringArray = this.readLines();
            if (stringArray != null && stringArray.length == 2) {
                return stringArray[0];
            }
            Matcher matcher = RE_KO.matcher(stringArray[stringArray.length - 1]);
            if (matcher.matches()) {
                return matcher.group(1);
            }
        }
        return null;
    }

    public synchronized NetworkStatus getNetworkStatus() {
        String[] stringArray;
        if (this.sendCommand(COMMAND_NETWORK_STATUS) && this.isValid(stringArray = this.readLines())) {
            NetworkStatus networkStatus = new NetworkStatus();
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string;
                String string2 = stringArray2[n2];
                Matcher matcher = sDownloadSpeedRegexp.matcher(string2);
                if (matcher.matches()) {
                    string = matcher.group(1);
                    networkStatus.speed = this.getSpeedIndex(string);
                } else {
                    matcher = sMinLatencyRegexp.matcher(string2);
                    if (matcher.matches()) {
                        string = matcher.group(1);
                        networkStatus.latency = this.getLatencyIndex(string);
                    }
                }
                ++n2;
            }
            return networkStatus;
        }
        return null;
    }

    public synchronized GsmStatus getGsmStatus() {
        String[] stringArray;
        if (this.sendCommand(COMMAND_GSM_STATUS) && this.isValid(stringArray = this.readLines())) {
            GsmStatus gsmStatus = new GsmStatus();
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string;
                String string2 = stringArray2[n2];
                Matcher matcher = sVoiceStatusRegexp.matcher(string2);
                if (matcher.matches()) {
                    string = matcher.group(1);
                    gsmStatus.voice = GsmMode.getEnum(string.toLowerCase());
                } else {
                    matcher = sDataStatusRegexp.matcher(string2);
                    if (matcher.matches()) {
                        string = matcher.group(1);
                        gsmStatus.data = GsmMode.getEnum(string.toLowerCase());
                    }
                }
                ++n2;
            }
            return gsmStatus;
        }
        return null;
    }

    public synchronized String setGsmVoiceMode(GsmMode gsmMode) throws InvalidParameterException {
        if (gsmMode == GsmMode.UNKNOWN) {
            throw new InvalidParameterException();
        }
        String string = String.format(COMMAND_GSM_VOICE, gsmMode.getTag());
        return this.processCommand(string);
    }

    public synchronized String setGsmDataMode(GsmMode gsmMode) throws InvalidParameterException {
        if (gsmMode == GsmMode.UNKNOWN) {
            throw new InvalidParameterException();
        }
        String string = String.format(COMMAND_GSM_DATA, gsmMode.getTag());
        return this.processCommand(string);
    }

    public synchronized String call(String string) {
        String string2 = String.format(COMMAND_GSM_CALL, string);
        return this.processCommand(string2);
    }

    public synchronized String cancelCall(String string) {
        String string2 = String.format(COMMAND_GSM_CANCEL_CALL, string);
        return this.processCommand(string2);
    }

    public synchronized String sendSms(String string, String string2) {
        String string3 = String.format(COMMAND_SMS_SEND, string, string2);
        return this.processCommand(string3);
    }

    public synchronized String setNetworkSpeed(int n) {
        String string = String.format(COMMAND_NETWORK_SPEED, NETWORK_SPEEDS[n]);
        return this.processCommand(string);
    }

    public synchronized String setNetworkLatency(int n) {
        String string = String.format(COMMAND_NETWORK_LATENCY, NETWORK_LATENCIES[n]);
        return this.processCommand(string);
    }

    public synchronized String sendLocation(double d, double d2, double d3) {
        Calendar calendar = Calendar.getInstance();
        double d4 = Math.abs(d);
        int n = (int)Math.floor(d4);
        char c = 'E';
        if (d < 0.0) {
            c = 'W';
        }
        double d5 = (d4 - Math.floor(d4)) * 60.0;
        double d6 = Math.abs(d2);
        int n2 = (int)Math.floor(d6);
        char c2 = 'N';
        if (d2 < 0.0) {
            c2 = 'S';
        }
        double d7 = (d6 - Math.floor(d6)) * 60.0;
        String string = String.format(COMMAND_GPS, calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14), n2, d7, Character.valueOf(c2), n, d5, Character.valueOf(c));
        return this.processCommand(string);
    }

    private boolean sendCommand(String string) {
        boolean bl = false;
        try {
            byte[] byArray;
            try {
                byArray = string.getBytes(DEFAULT_ENCODING);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                boolean bl2 = bl;
                if (!bl) {
                    EmulatorConsole.RemoveConsole(this.mPort);
                }
                return bl2;
            }
            try {
                AdbHelper.write(this.mSocketChannel, byArray, byArray.length, 5000);
                bl = true;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        finally {
            if (!bl) {
                EmulatorConsole.RemoveConsole(this.mPort);
            }
        }
        return bl;
    }

    private String processCommand(String string) {
        if (this.sendCommand(string)) {
            String[] stringArray = this.readLines();
            if (stringArray != null && stringArray.length > 0) {
                Matcher matcher = RE_KO.matcher(stringArray[stringArray.length - 1]);
                if (matcher.matches()) {
                    return matcher.group(1);
                }
                return RESULT_OK;
            }
            return "Unable to communicate with the emulator";
        }
        return "Unable to send command to the emulator";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String[] readLines() {
        try {
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.mBuffer, 0, this.mBuffer.length);
            int n = 0;
            boolean bl = false;
            while (true) {
                int n2;
                if (byteBuffer.position() == byteBuffer.limit() || bl) {
                    String string = new String(this.mBuffer, 0, byteBuffer.position(), DEFAULT_ENCODING);
                    return string.split("\r\n");
                }
                int n3 = this.mSocketChannel.read(byteBuffer);
                if (n3 < 0) {
                    return null;
                }
                if (n3 == 0) {
                    if (n * 5 > 5000) {
                        return null;
                    }
                    try {
                        Thread.sleep(5L);
                    }
                    catch (InterruptedException interruptedException) {}
                    ++n;
                } else {
                    n = 0;
                }
                if (byteBuffer.position() < 4 || !this.endsWithOK(n2 = byteBuffer.position()) && !this.lastLineIsKO(n2)) continue;
                bl = true;
            }
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private boolean endsWithOK(int n) {
        return this.mBuffer[n - 1] == 10 && this.mBuffer[n - 2] == 13 && this.mBuffer[n - 3] == 75 && this.mBuffer[n - 4] == 79;
    }

    private boolean lastLineIsKO(int n) {
        if (this.mBuffer[n - 1] != 10 || this.mBuffer[n - 2] != 13) {
            return false;
        }
        int n2 = 0;
        n2 = n - 3;
        while (n2 >= 0) {
            if (this.mBuffer[n2] == 10 && n2 > 0 && this.mBuffer[n2 - 1] == 13) break;
            --n2;
        }
        return this.mBuffer[n2 + 1] == 75 && this.mBuffer[n2 + 2] == 79;
    }

    private boolean isValid(String[] stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            return !RE_KO.matcher(stringArray[stringArray.length - 1]).matches();
        }
        return false;
    }

    private int getLatencyIndex(String string) {
        try {
            int n = Integer.parseInt(string);
            int n2 = 0;
            while (n2 < MIN_LATENCIES.length) {
                if (MIN_LATENCIES[n2] == n) {
                    return n2;
                }
                ++n2;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return -1;
    }

    private int getSpeedIndex(String string) {
        try {
            int n = Integer.parseInt(string);
            int n2 = 0;
            while (n2 < this.DOWNLOAD_SPEEDS.length) {
                if (this.DOWNLOAD_SPEEDS[n2] == n) {
                    return n2;
                }
                ++n2;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return -1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GsmMode {
        UNKNOWN(null),
        UNREGISTERED(new String[]{"unregistered", "off"}),
        HOME(new String[]{"home", "on"}),
        ROAMING("roaming"),
        SEARCHING("searching"),
        DENIED("denied");

        private final String[] tags;

        private GsmMode(String string2) {
            this.tags = string2 != null ? new String[]{string2} : new String[0];
        }

        private GsmMode(String[] stringArray) {
            this.tags = stringArray;
        }

        public static GsmMode getEnum(String string) {
            GsmMode[] gsmModeArray = GsmMode.values();
            int n = gsmModeArray.length;
            int n2 = 0;
            while (n2 < n) {
                GsmMode gsmMode = gsmModeArray[n2];
                String[] stringArray = gsmMode.tags;
                int n3 = gsmMode.tags.length;
                int n4 = 0;
                while (n4 < n3) {
                    String string2 = stringArray[n4];
                    if (string2.equals(string)) {
                        return gsmMode;
                    }
                    ++n4;
                }
                ++n2;
            }
            return UNKNOWN;
        }

        public String getTag() {
            if (this.tags.length > 0) {
                return this.tags[0];
            }
            return null;
        }
    }

    public static class GsmStatus {
        public GsmMode voice = GsmMode.UNKNOWN;
        public GsmMode data = GsmMode.UNKNOWN;
    }

    public static class NetworkStatus {
        public int speed = -1;
        public int latency = -1;
    }
}

