/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.wizards.newxmlfile;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.editors.descriptors.DocumentDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.ElementDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.IDescriptorProvider;
import com.android.ide.eclipse.adt.internal.project.ProjectChooserHelper;
import com.android.ide.eclipse.adt.internal.resources.configurations.FolderConfiguration;
import com.android.ide.eclipse.adt.internal.resources.configurations.ResourceQualifier;
import com.android.ide.eclipse.adt.internal.resources.manager.ResourceFolderType;
import com.android.ide.eclipse.adt.internal.sdk.AndroidTargetData;
import com.android.ide.eclipse.adt.internal.sdk.Sdk;
import com.android.ide.eclipse.adt.internal.ui.ConfigurationSelector;
import com.android.sdklib.IAndroidTarget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NewXmlFileCreationPage
extends WizardPage {
    private static final TypeInfo[] sTypes = new TypeInfo[]{new TypeInfo("Layout", "An XML file that describes a screen layout.", ResourceFolderType.LAYOUT, 2, "LinearLayout", "http://schemas.android.com/apk/res/android", "android:layout_width=\"wrap_content\"\nandroid:layout_height=\"wrap_content\"", 1), new TypeInfo("Values", "An XML file with simple values: colors, strings, dimensions, etc.", ResourceFolderType.VALUES, "resources", null, null, null, 1), new TypeInfo("Menu", "An XML file that describes an menu.", ResourceFolderType.MENU, "menu", null, "http://schemas.android.com/apk/res/android", null, 1), new TypeInfo("AppWidget Provider", "An XML file that describes a widget provider.", ResourceFolderType.XML, 8, null, "http://schemas.android.com/apk/res/android", null, 3), new TypeInfo("Preference", "An XML file that describes preferences.", ResourceFolderType.XML, 7, "PreferenceScreen", "http://schemas.android.com/apk/res/android", null, 1), new TypeInfo("Searchable", "An XML file that describes a searchable.", ResourceFolderType.XML, 6, null, "http://schemas.android.com/apk/res/android", null, 1), new TypeInfo("Animation", "An XML file that describes an animation.", ResourceFolderType.ANIM, new String[]{"set", "alpha", "scale", "translate", "rotate"}, "set", null, null, 1)};
    static final int NUM_COL = 4;
    private static final String RES_FOLDER_ABS = "/res/";
    private static final String RES_FOLDER_REL = "res/";
    private IProject mProject;
    private Text mProjectTextField;
    private Button mProjectBrowseButton;
    private Text mFileNameTextField;
    private Text mWsFolderPathTextField;
    private Combo mRootElementCombo;
    private IStructuredSelection mInitialSelection;
    private ConfigurationSelector mConfigSelector;
    private FolderConfiguration mTempConfig = new FolderConfiguration();
    private boolean mInternalWsFolderPathUpdate;
    private boolean mInternalTypeUpdate;
    private boolean mInternalConfigSelectorUpdate;
    private ProjectChooserHelper mProjectChooserHelper;
    private Sdk.ITargetChangeListener mSdkTargetChangeListener;
    private TypeInfo mCurrentTypeInfo;

    protected NewXmlFileCreationPage(String string) {
        super(string);
        this.setPageComplete(false);
    }

    public void setInitialSelection(IStructuredSelection iStructuredSelection) {
        this.mInitialSelection = iStructuredSelection;
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setFont(composite.getFont());
        this.initializeDialogUnits((Control)composite);
        composite2.setLayout((Layout)new GridLayout(4, false));
        composite2.setLayoutData((Object)new GridData(1808));
        this.createProjectGroup(composite2);
        this.createTypeGroup(composite2);
        this.createRootGroup(composite2);
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite2);
        this.initializeFromSelection(this.mInitialSelection);
        this.initializeRootValues();
        this.enableTypesBasedOnApi();
        if (this.mCurrentTypeInfo != null) {
            this.updateRootCombo(this.mCurrentTypeInfo);
        }
        this.installTargetChangeListener();
        this.validatePage();
    }

    private void installTargetChangeListener() {
        this.mSdkTargetChangeListener = new Sdk.ITargetChangeListener(){

            public void onProjectTargetChange(IProject iProject) {
                if (iProject != null && iProject == NewXmlFileCreationPage.this.mProject) {
                    NewXmlFileCreationPage.this.changeProject(NewXmlFileCreationPage.this.mProject);
                }
            }

            public void onTargetsLoaded() {
                if (NewXmlFileCreationPage.this.mProject != null) {
                    NewXmlFileCreationPage.this.changeProject(NewXmlFileCreationPage.this.mProject);
                }
            }
        };
        AdtPlugin.getDefault().addTargetListener(this.mSdkTargetChangeListener);
    }

    public void dispose() {
        if (this.mSdkTargetChangeListener != null) {
            AdtPlugin.getDefault().removeTargetListener(this.mSdkTargetChangeListener);
            this.mSdkTargetChangeListener = null;
        }
        super.dispose();
    }

    public IProject getProject() {
        return this.mProject;
    }

    public String getFileName() {
        return this.mFileNameTextField == null ? "" : this.mFileNameTextField.getText();
    }

    public String getWsFolderPath() {
        return this.mWsFolderPathTextField == null ? "" : this.mWsFolderPathTextField.getText();
    }

    public IFile getDestinationFile() {
        IProject iProject = this.getProject();
        String string = this.getWsFolderPath();
        String string2 = this.getFileName();
        if (iProject != null && string.length() > 0 && string2.length() > 0) {
            IPath iPath = new Path(string).append(string2);
            IFile iFile = iProject.getFile(iPath);
            return iFile;
        }
        return null;
    }

    public TypeInfo getSelectedType() {
        TypeInfo typeInfo = null;
        TypeInfo[] typeInfoArray = sTypes;
        int n = sTypes.length;
        int n2 = 0;
        while (n2 < n) {
            TypeInfo typeInfo2 = typeInfoArray[n2];
            if (typeInfo2.getWidget().getSelection()) {
                typeInfo = typeInfo2;
                break;
            }
            ++n2;
        }
        return typeInfo;
    }

    public String getRootElement() {
        int n = this.mRootElementCombo.getSelectionIndex();
        if (n >= 0) {
            return this.mRootElementCombo.getItem(n);
        }
        return null;
    }

    private GridData newGridData(int n) {
        GridData gridData = new GridData();
        gridData.horizontalSpan = n;
        return gridData;
    }

    private GridData newGridData(int n, int n2) {
        GridData gridData = new GridData(n2);
        gridData.horizontalSpan = n;
        return gridData;
    }

    private void emptyCell(Composite composite) {
        new Label(composite, 0);
    }

    private int padWithEmptyCells(Composite composite, int n) {
        while (n < 4) {
            this.emptyCell(composite);
            ++n;
        }
        n = 0;
        return n;
    }

    private void createProjectGroup(Composite composite) {
        int n = 0;
        String string = "The Android Project where the new resource file will be created.";
        Label label = new Label(composite, 0);
        label.setText("Project");
        label.setToolTipText(string);
        ++n;
        this.mProjectTextField = new Text(composite, 2048);
        this.mProjectTextField.setLayoutData((Object)new GridData(768));
        this.mProjectTextField.setToolTipText(string);
        this.mProjectTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                NewXmlFileCreationPage.this.onProjectFieldUpdated();
            }
        });
        ++n;
        this.mProjectBrowseButton = new Button(composite, 0);
        this.mProjectBrowseButton.setText("Browse...");
        this.mProjectBrowseButton.setToolTipText("Allows you to select the Android project to modify.");
        this.mProjectBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                NewXmlFileCreationPage.this.onProjectBrowse();
            }
        });
        this.mProjectChooserHelper = new ProjectChooserHelper(composite.getShell());
        ++n;
        n = this.padWithEmptyCells(composite, n);
        string = "The name of the resource file to create.";
        label = new Label(composite, 0);
        label.setText("File");
        label.setToolTipText(string);
        ++n;
        this.mFileNameTextField = new Text(composite, 2048);
        this.mFileNameTextField.setLayoutData((Object)new GridData(768));
        this.mFileNameTextField.setToolTipText(string);
        this.mFileNameTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                NewXmlFileCreationPage.this.validatePage();
            }
        });
        this.padWithEmptyCells(composite, ++n);
    }

    private void createTypeGroup(Composite composite) {
        Label label = new Label(composite, 258);
        label.setLayoutData((Object)this.newGridData(4, 512));
        label = new Label(composite, 0);
        label.setText("What type of resource would you like to create?");
        label.setLayoutData((Object)this.newGridData(4));
        this.emptyCell(composite);
        Composite composite2 = new Composite(composite, 0);
        this.padWithEmptyCells(composite, 2);
        composite2.setLayout((Layout)new GridLayout(4, true));
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (selectionEvent.getSource() instanceof Button) {
                    NewXmlFileCreationPage.this.onRadioTypeUpdated((Button)selectionEvent.getSource());
                }
            }
        };
        int n = sTypes.length;
        int n2 = (n + 2) / 4;
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            int n5 = 0;
            while (n5 < 4) {
                if (n4 < n) {
                    TypeInfo typeInfo = sTypes[n4];
                    Button button = new Button(composite2, 16);
                    typeInfo.setWidget(button);
                    button.setSelection(false);
                    button.setText(typeInfo.getUiName());
                    button.setToolTipText(typeInfo.getTooltip());
                    button.addSelectionListener((SelectionListener)selectionAdapter);
                } else {
                    this.emptyCell(composite2);
                }
                ++n5;
                ++n4;
            }
            ++n3;
        }
        label = new Label(composite, 0);
        label.setText("What type of resource configuration would you like?");
        label.setLayoutData((Object)this.newGridData(4));
        this.emptyCell(composite);
        this.mConfigSelector = new ConfigurationSelector(composite);
        GridData gridData = this.newGridData(2, 1536);
        gridData.widthHint = 600;
        gridData.heightHint = 250;
        this.mConfigSelector.setLayoutData(gridData);
        this.mConfigSelector.setOnChangeListener(new onConfigSelectorUpdated());
        this.emptyCell(composite);
        String string = "The folder where the file will be generated, relative to the project.";
        label = new Label(composite, 0);
        label.setText("Folder");
        label.setToolTipText(string);
        this.mWsFolderPathTextField = new Text(composite, 2048);
        this.mWsFolderPathTextField.setLayoutData((Object)new GridData(768));
        this.mWsFolderPathTextField.setToolTipText(string);
        this.mWsFolderPathTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                NewXmlFileCreationPage.this.onWsFolderPathUpdated();
            }
        });
    }

    private void createRootGroup(Composite composite) {
        Label label = new Label(composite, 258);
        label.setLayoutData((Object)this.newGridData(4, 512));
        String string = "The root element to create in the XML file.";
        label = new Label(composite, 0);
        label.setText("Select the root element for the XML file:");
        label.setLayoutData((Object)this.newGridData(4));
        label.setToolTipText(string);
        this.emptyCell(composite);
        this.mRootElementCombo = new Combo(composite, 12);
        this.mRootElementCombo.setEnabled(false);
        this.mRootElementCombo.select(0);
        this.mRootElementCombo.setLayoutData((Object)new GridData(768));
        this.mRootElementCombo.setToolTipText(string);
        this.padWithEmptyCells(composite, 2);
    }

    private void initializeFromSelection(IStructuredSelection iStructuredSelection) {
        if (iStructuredSelection == null) {
            return;
        }
        IProject iProject = null;
        String string = null;
        String string2 = null;
        int n = 0;
        for (Object e : iStructuredSelection.toList()) {
            if (!(e instanceof IAdaptable)) continue;
            IResource iResource = (IResource)((IAdaptable)e).getAdapter(IResource.class);
            IProject iProject2 = iResource != null ? iResource.getProject() : null;
            try {
                if (iProject2 == null) continue;
                if (!iProject2.hasNature("com.android.ide.eclipse.adt.AndroidNature")) {
                }
            }
            catch (CoreException coreException) {}
            continue;
            int n2 = 1;
            IPath iPath = null;
            String string3 = null;
            if (iResource.getType() == 2) {
                iPath = iResource.getProjectRelativePath();
            } else if (iResource.getType() == 1) {
                string3 = iResource.getName();
                iPath = iResource.getParent().getProjectRelativePath();
            }
            if (iPath != null && iPath.segmentCount() > 1 && "res".equals(iPath.segment(0))) {
                n2 += 2;
            } else {
                iPath = null;
                string3 = null;
            }
            if ((n2 += string3 != null ? 4 : 0) <= n) continue;
            n = n2;
            iProject = iProject2;
            string = iPath != null ? iPath.toString() : null;
            string2 = string3;
        }
        if (n > 0) {
            this.mProject = iProject;
            this.mProjectTextField.setText(iProject != null ? iProject.getName() : "");
            this.mFileNameTextField.setText(string2 != null ? string2 : "");
            this.mWsFolderPathTextField.setText(string != null ? string : "");
        }
    }

    private void initializeRootValues() {
        TypeInfo[] typeInfoArray = sTypes;
        int n = sTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Object object;
            Object object2;
            Object object3;
            TypeInfo typeInfo = typeInfoArray[n2];
            ArrayList<String> arrayList = typeInfo.getRoots();
            if (arrayList.size() > 0) {
                arrayList.clear();
            }
            if ((object3 = typeInfo.getRootSeed()) instanceof String) {
                arrayList.add((String)object3);
            } else if (object3 instanceof String[]) {
                object2 = (String[])object3;
                int n3 = ((String[])object2).length;
                int n4 = 0;
                while (n4 < n3) {
                    object = object2[n4];
                    arrayList.add((String)object);
                    ++n4;
                }
            } else if (object3 instanceof Integer && this.mProject != null) {
                object = null;
                AndroidTargetData androidTargetData = null;
                object = Sdk.getCurrent().getTarget(this.mProject);
                if (object == null) {
                    AdtPlugin.log(1, "NewXmlFile wizard: no platform target for project %s", this.mProject.getName());
                } else {
                    androidTargetData = Sdk.getCurrent().getTargetData((IAndroidTarget)object);
                    if (androidTargetData == null) {
                        AdtPlugin.log(1, "NewXmlFile wizard: no data for target %s, project %s", object.getName(), this.mProject.getName());
                    } else {
                        IDescriptorProvider iDescriptorProvider = androidTargetData.getDescriptorProvider((Integer)object3);
                        object2 = iDescriptorProvider.getDescriptor();
                        if (object2 != null) {
                            HashSet<ElementDescriptor> hashSet = new HashSet<ElementDescriptor>();
                            this.initRootElementDescriptor(arrayList, (ElementDescriptor)object2, hashSet);
                        }
                        Collections.sort(arrayList);
                    }
                }
            }
            ++n2;
        }
    }

    private void initRootElementDescriptor(ArrayList<String> arrayList, ElementDescriptor elementDescriptor, HashSet<ElementDescriptor> hashSet) {
        Object object;
        if (!(elementDescriptor instanceof DocumentDescriptor) && (object = elementDescriptor.getXmlName()) != null && ((String)object).length() > 0) {
            arrayList.add((String)object);
        }
        hashSet.add(elementDescriptor);
        ElementDescriptor[] elementDescriptorArray = elementDescriptor.getChildren();
        int n = elementDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = elementDescriptorArray[n2];
            if (!hashSet.contains(object)) {
                this.initRootElementDescriptor(arrayList, (ElementDescriptor)object, hashSet);
            }
            ++n2;
        }
    }

    private void onProjectFieldUpdated() {
        String string = this.mProjectTextField.getText();
        IJavaProject[] iJavaProjectArray = this.mProjectChooserHelper.getAndroidProjects(null);
        IProject iProject = null;
        IJavaProject[] iJavaProjectArray2 = iJavaProjectArray;
        int n = iJavaProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaProject iJavaProject = iJavaProjectArray2[n2];
            if (iJavaProject.getProject().getName().equals(string)) {
                iProject = iJavaProject.getProject();
                break;
            }
            ++n2;
        }
        if (iProject != this.mProject) {
            this.changeProject(iProject);
        }
    }

    private void onProjectBrowse() {
        IJavaProject iJavaProject = this.mProjectChooserHelper.chooseJavaProject(this.mProjectTextField.getText());
        if (iJavaProject != null) {
            this.changeProject(iJavaProject.getProject());
            this.mProjectTextField.setText(this.mProject.getName());
        }
    }

    private void changeProject(IProject iProject) {
        this.mProject = iProject;
        this.enableTypesBasedOnApi();
        this.resetFolderPath(false);
        this.initializeRootValues();
        this.updateRootCombo(this.getSelectedType());
        this.validatePage();
    }

    private void onWsFolderPathUpdated() {
        if (this.mInternalWsFolderPathUpdate) {
            return;
        }
        String string = this.mWsFolderPathTextField.getText();
        string = string.replaceAll("/+\\.\\./+|/+\\./+|//+|\\\\+|^/+", "/");
        string = string.replaceAll("^\\.\\./+|^\\./+", "");
        string = string.replaceAll("/+\\.\\.$|/+\\.$|/+$", "");
        ArrayList<TypeInfo> arrayList = new ArrayList<TypeInfo>();
        if (string.startsWith(RES_FOLDER_REL)) {
            string = RES_FOLDER_ABS + string.substring(RES_FOLDER_REL.length());
            this.mInternalWsFolderPathUpdate = true;
            this.mWsFolderPathTextField.setText(string);
            this.mInternalWsFolderPathUpdate = false;
        }
        if (string.startsWith(RES_FOLDER_ABS)) {
            String[] stringArray;
            int n = (string = string.substring(RES_FOLDER_ABS.length())).indexOf(47);
            if (n >= 0) {
                string = string.substring(0, n);
            }
            if ((stringArray = string.split("-")).length > 0) {
                String string2 = stringArray[0];
                this.mInternalConfigSelectorUpdate = true;
                this.mConfigSelector.setConfiguration(stringArray);
                this.mInternalConfigSelectorUpdate = false;
                boolean bl = false;
                TypeInfo[] typeInfoArray = sTypes;
                int n2 = sTypes.length;
                int n3 = 0;
                while (n3 < n2) {
                    TypeInfo typeInfo = typeInfoArray[n3];
                    if (typeInfo.getResFolderName().equals(string2)) {
                        arrayList.add(typeInfo);
                        bl |= typeInfo.getWidget().getSelection();
                    }
                    ++n3;
                }
                if (arrayList.size() == 1) {
                    if (!bl) {
                        this.selectType((TypeInfo)arrayList.get(0));
                    }
                } else if (arrayList.size() > 1) {
                    if (!bl) {
                        this.selectType(null);
                    }
                } else {
                    this.selectType(null);
                }
            }
        }
        this.validatePage();
    }

    private void onRadioTypeUpdated(Button button) {
        Object object;
        if (this.mInternalTypeUpdate || !button.getSelection()) {
            return;
        }
        Object object2 = null;
        TypeInfo[] typeInfoArray = sTypes;
        int n = sTypes.length;
        int n2 = 0;
        while (n2 < n) {
            object = typeInfoArray[n2];
            if (((TypeInfo)object).getWidget() == button) {
                object2 = object;
                break;
            }
            ++n2;
        }
        if (object2 == null) {
            return;
        }
        this.updateRootCombo((TypeInfo)object2);
        object = this.mWsFolderPathTextField.getText();
        String string = null;
        this.mConfigSelector.getConfiguration(this.mTempConfig);
        ResourceQualifier resourceQualifier = this.mTempConfig.getInvalidQualifier();
        if (resourceQualifier == null) {
            string = RES_FOLDER_ABS + this.mTempConfig.getFolderName(((TypeInfo)object2).getResFolderType(), this.mProject);
        } else if (((String)object).startsWith(RES_FOLDER_ABS)) {
            ((String)object).replaceFirst("^(/res/)[^-]*(.*)", "\\1" + ((TypeInfo)object2).getResFolderName() + "\\2");
        } else {
            string = RES_FOLDER_ABS + this.mTempConfig.getFolderName(((TypeInfo)object2).getResFolderType(), this.mProject);
        }
        if (string != null && !string.equals(object)) {
            this.mInternalWsFolderPathUpdate = true;
            this.mWsFolderPathTextField.setText(string);
            this.mInternalWsFolderPathUpdate = false;
        }
        this.validatePage();
    }

    private void updateRootCombo(TypeInfo typeInfo) {
        this.mRootElementCombo.removeAll();
        if (typeInfo != null) {
            ArrayList<String> arrayList = typeInfo.getRoots();
            this.mRootElementCombo.setEnabled(arrayList != null && arrayList.size() > 1);
            for (String string : arrayList) {
                this.mRootElementCombo.add(string);
            }
            int n = 0;
            String string = typeInfo.getDefaultRoot();
            if (string != null) {
                n = arrayList.indexOf(string);
            }
            this.mRootElementCombo.select(n < 0 ? 0 : n);
        }
    }

    private void selectType(TypeInfo typeInfo) {
        if (typeInfo == null || !typeInfo.getWidget().getSelection()) {
            this.mInternalTypeUpdate = true;
            this.mCurrentTypeInfo = typeInfo;
            TypeInfo[] typeInfoArray = sTypes;
            int n = sTypes.length;
            int n2 = 0;
            while (n2 < n) {
                TypeInfo typeInfo2 = typeInfoArray[n2];
                typeInfo2.getWidget().setSelection(typeInfo2 == typeInfo);
                ++n2;
            }
            this.updateRootCombo(typeInfo);
            this.mInternalTypeUpdate = false;
        }
    }

    private void enableTypesBasedOnApi() {
        IAndroidTarget iAndroidTarget = this.mProject != null ? Sdk.getCurrent().getTarget(this.mProject) : null;
        int n = 1;
        if (iAndroidTarget != null) {
            n = iAndroidTarget.getVersion().getApiLevel();
        }
        TypeInfo[] typeInfoArray = sTypes;
        int n2 = sTypes.length;
        int n3 = 0;
        while (n3 < n2) {
            TypeInfo typeInfo = typeInfoArray[n3];
            typeInfo.getWidget().setEnabled(typeInfo.getTargetApiLevel() <= n);
            ++n3;
        }
    }

    private void resetFolderPath(boolean bl) {
        TypeInfo typeInfo = this.getSelectedType();
        if (typeInfo != null) {
            this.mConfigSelector.getConfiguration(this.mTempConfig);
            StringBuffer stringBuffer = new StringBuffer(RES_FOLDER_ABS);
            stringBuffer.append(this.mTempConfig.getFolderName(typeInfo.getResFolderType(), this.mProject));
            this.mInternalWsFolderPathUpdate = true;
            this.mWsFolderPathTextField.setText(stringBuffer.toString());
            this.mInternalWsFolderPathUpdate = false;
            if (bl) {
                this.validatePage();
            }
        }
    }

    private void validatePage() {
        Object object;
        String string = null;
        String string2 = null;
        if (this.getProject() == null) {
            string = "Please select an Android project.";
        }
        if (string == null) {
            object = this.getFileName();
            if (object == null || ((String)object).length() == 0) {
                string = "A destination file name is required.";
            } else if (!((String)object).endsWith(".xml")) {
                string = String.format("The filename must end with %1$s.", ".xml");
            }
        }
        if (string == null && (object = this.getSelectedType()) == null) {
            string = "One of the types must be selected (e.g. layout, values, etc.)";
        }
        if (string == null) {
            TypeInfo typeInfo;
            object = Sdk.getCurrent().getTarget(this.mProject);
            int n = 1;
            if (object != null) {
                n = object.getVersion().getApiLevel();
            }
            if ((typeInfo = this.getSelectedType()).getTargetApiLevel() > n) {
                string = "The API level of the selected type (e.g. AppWidget, etc.) is not compatible with the API level of the project.";
            }
        }
        if (string == null) {
            object = this.mConfigSelector.getState();
            if (object == ConfigurationSelector.ConfigurationState.INVALID_CONFIG) {
                ResourceQualifier resourceQualifier = this.mConfigSelector.getInvalidQualifier();
                if (resourceQualifier != null) {
                    string = String.format("The qualifier '%1$s' is invalid in the folder configuration.", resourceQualifier.getName());
                }
            } else if (object == ConfigurationSelector.ConfigurationState.REGION_WITHOUT_LANGUAGE) {
                string = "The Region qualifier requires the Language qualifier.";
            }
        }
        if (string == null && !((String)(object = this.getWsFolderPath())).startsWith(RES_FOLDER_ABS)) {
            string = String.format("Target folder must start with %1$s.", RES_FOLDER_ABS);
        }
        if (string == null && (object = this.getDestinationFile()) != null && object.exists()) {
            string2 = "The destination file already exists";
        }
        this.setPageComplete(string == null);
        if (string != null) {
            this.setMessage(string, 3);
        } else if (string2 != null) {
            this.setMessage(string2, 2);
        } else {
            this.setErrorMessage(null);
            this.setMessage(null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TypeInfo {
        private final String mUiName;
        private final ResourceFolderType mResFolderType;
        private final String mTooltip;
        private final Object mRootSeed;
        private Button mWidget;
        private ArrayList<String> mRoots = new ArrayList();
        private final String mXmlns;
        private final String mDefaultAttrs;
        private final String mDefaultRoot;
        private final int mTargetApiLevel;

        public TypeInfo(String string, String string2, ResourceFolderType resourceFolderType, Object object, String string3, String string4, String string5, int n) {
            this.mUiName = string;
            this.mResFolderType = resourceFolderType;
            this.mTooltip = string2;
            this.mRootSeed = object;
            this.mDefaultRoot = string3;
            this.mXmlns = string4;
            this.mDefaultAttrs = string5;
            this.mTargetApiLevel = n;
        }

        String getUiName() {
            return this.mUiName;
        }

        String getTooltip() {
            return this.mTooltip;
        }

        String getResFolderName() {
            return this.mResFolderType.getName();
        }

        ResourceFolderType getResFolderType() {
            return this.mResFolderType;
        }

        void setWidget(Button button) {
            this.mWidget = button;
        }

        Button getWidget() {
            return this.mWidget;
        }

        Object getRootSeed() {
            return this.mRootSeed;
        }

        String getDefaultRoot() {
            return this.mDefaultRoot;
        }

        ArrayList<String> getRoots() {
            return this.mRoots;
        }

        String getXmlns() {
            return this.mXmlns;
        }

        String getDefaultAttrs() {
            return this.mDefaultAttrs;
        }

        public int getTargetApiLevel() {
            return this.mTargetApiLevel;
        }
    }

    private class onConfigSelectorUpdated
    implements Runnable {
        private onConfigSelectorUpdated() {
        }

        public void run() {
            if (NewXmlFileCreationPage.this.mInternalConfigSelectorUpdate) {
                return;
            }
            NewXmlFileCreationPage.this.resetFolderPath(true);
        }
    }
}

