/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.wizards.newproject;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.project.AndroidNature;
import com.android.ide.eclipse.adt.internal.project.ProjectHelper;
import com.android.ide.eclipse.adt.internal.sdk.Sdk;
import com.android.ide.eclipse.adt.internal.wizards.newproject.NewProjectCreationPage;
import com.android.ide.eclipse.adt.internal.wizards.newproject.NewTestProjectCreationPage;
import com.android.sdklib.IAndroidTarget;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.actions.OpenJavaPerspectiveAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewProjectWizard
extends Wizard
implements INewWizard {
    private static final String PARAM_SDK_TOOLS_DIR = "ANDROID_SDK_TOOLS";
    private static final String PARAM_ACTIVITY = "ACTIVITY_NAME";
    private static final String PARAM_APPLICATION = "APPLICATION_NAME";
    private static final String PARAM_PACKAGE = "PACKAGE";
    private static final String PARAM_PROJECT = "PROJECT_NAME";
    private static final String PARAM_STRING_NAME = "STRING_NAME";
    private static final String PARAM_STRING_CONTENT = "STRING_CONTENT";
    private static final String PARAM_IS_NEW_PROJECT = "IS_NEW_PROJECT";
    private static final String PARAM_SRC_FOLDER = "SRC_FOLDER";
    private static final String PARAM_SDK_TARGET = "SDK_TARGET";
    private static final String PARAM_MIN_SDK_VERSION = "MIN_SDK_VERSION";
    private static final String PARAM_TEST_TARGET_PACKAGE = "TEST_TARGET_PCKG";
    private static final String PARAM_TARGET_SELF = "TARGET_SELF";
    private static final String PARAM_TARGET_MAIN = "TARGET_MAIN";
    private static final String PARAM_TARGET_EXISTING = "TARGET_EXISTING";
    private static final String PARAM_REFERENCE_PROJECT = "REFERENCE_PROJECT";
    private static final String PH_ACTIVITIES = "ACTIVITIES";
    private static final String PH_USES_SDK = "USES-SDK";
    private static final String PH_INTENT_FILTERS = "INTENT_FILTERS";
    private static final String PH_STRINGS = "STRINGS";
    private static final String PH_TEST_USES_LIBRARY = "TEST-USES-LIBRARY";
    private static final String PH_TEST_INSTRUMENTATION = "TEST-INSTRUMENTATION";
    private static final String BIN_DIRECTORY = "bin/";
    private static final String RES_DIRECTORY = "res/";
    private static final String ASSETS_DIRECTORY = "assets/";
    private static final String DRAWABLE_DIRECTORY = "drawable/";
    private static final String LAYOUT_DIRECTORY = "layout/";
    private static final String VALUES_DIRECTORY = "values/";
    private static final String GEN_SRC_DIRECTORY = "gen/";
    private static final String TEMPLATES_DIRECTORY = "templates/";
    private static final String TEMPLATE_MANIFEST = "templates/AndroidManifest.template";
    private static final String TEMPLATE_ACTIVITIES = "templates/activity.template";
    private static final String TEMPLATE_USES_SDK = "templates/uses-sdk.template";
    private static final String TEMPLATE_INTENT_LAUNCHER = "templates/launcher_intent_filter.template";
    private static final String TEMPLATE_TEST_USES_LIBRARY = "templates/test_uses-library.template";
    private static final String TEMPLATE_TEST_INSTRUMENTATION = "templates/test_instrumentation.template";
    private static final String TEMPLATE_STRINGS = "templates/strings.template";
    private static final String TEMPLATE_STRING = "templates/string.template";
    private static final String ICON = "icon.png";
    private static final String STRINGS_FILE = "strings.xml";
    private static final String STRING_RSRC_PREFIX = "@string/";
    private static final String STRING_APP_NAME = "app_name";
    private static final String STRING_HELLO_WORLD = "hello";
    private static final String[] DEFAULT_DIRECTORIES = new String[]{"bin/", "res/", "assets/"};
    private static final String[] RES_DIRECTORIES = new String[]{"drawable/", "layout/", "values/"};
    private static final String PROJECT_LOGO_LARGE = "icons/android_large.png";
    private static final String JAVA_ACTIVITY_TEMPLATE = "java_file.template";
    private static final String LAYOUT_TEMPLATE = "layout.template";
    private static final String MAIN_LAYOUT_XML = "main.xml";
    private NewProjectCreationPage mMainPage;
    private NewTestProjectCreationPage mTestPage;
    private String mPackageName;
    private final AvailablePages mAvailablePages;

    public NewProjectWizard() {
        this(AvailablePages.ANDROID_AND_TEST_PROJECT);
    }

    protected NewProjectWizard(AvailablePages availablePages) {
        this.mAvailablePages = availablePages;
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        this.setHelpAvailable(false);
        this.setWindowTitle("New Android Project");
        this.setImageDescriptor();
        if (this.mAvailablePages == AvailablePages.ANDROID_AND_TEST_PROJECT) {
            this.mMainPage = this.createMainPage();
        }
        this.mTestPage = this.createTestPage();
    }

    protected NewProjectCreationPage createMainPage() {
        return new NewProjectCreationPage();
    }

    protected NewTestProjectCreationPage createTestPage() {
        return new NewTestProjectCreationPage();
    }

    public void addPages() {
        if (this.mAvailablePages == AvailablePages.ANDROID_AND_TEST_PROJECT) {
            this.addPage((IWizardPage)this.mMainPage);
        }
        this.addPage((IWizardPage)this.mTestPage);
        if (this.mMainPage != null && this.mTestPage != null) {
            this.mTestPage.setMainInfo(this.mMainPage.getMainInfo());
            this.mMainPage.setTestInfo(this.mTestPage.getTestInfo());
        }
    }

    public boolean performFinish() {
        if (!this.createAndroidProjects()) {
            return false;
        }
        OpenJavaPerspectiveAction openJavaPerspectiveAction = new OpenJavaPerspectiveAction();
        openJavaPerspectiveAction.run();
        return true;
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    private boolean validateNewProjectLocationIsEmpty(IPath iPath) {
        File file = new File(iPath.toOSString());
        if (file.isDirectory() && file.list().length > 0) {
            return AdtPlugin.displayPrompt("New Android Project", "You are going to create a new Android Project in an existing, non-empty, directory. Are you sure you want to proceed?");
        }
        return true;
    }

    private boolean createAndroidProjects() {
        final ProjectInfo projectInfo = this.collectMainPageInfo();
        if (this.mMainPage != null && projectInfo == null) {
            return false;
        }
        final ProjectInfo projectInfo2 = this.collectTestPageInfo();
        WorkspaceModifyOperation workspaceModifyOperation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor iProgressMonitor) throws InvocationTargetException {
                NewProjectWizard.this.createProjectAsync(iProgressMonitor, projectInfo, projectInfo2);
            }
        };
        this.runAsyncOperation(workspaceModifyOperation);
        return true;
    }

    private ProjectInfo collectMainPageInfo() {
        Object object;
        if (this.mMainPage == null) {
            return null;
        }
        NewProjectCreationPage.IMainInfo iMainInfo = this.mMainPage.getMainInfo();
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        IProject iProject = iWorkspace.getRoot().getProject(iMainInfo.getProjectName());
        IProjectDescription iProjectDescription = iWorkspace.newProjectDescription(iProject.getName());
        this.mPackageName = iMainInfo.getPackageName();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(PARAM_PROJECT, iMainInfo.getProjectName());
        hashMap.put(PARAM_PACKAGE, this.mPackageName);
        hashMap.put(PARAM_APPLICATION, "@string/app_name");
        hashMap.put(PARAM_SDK_TOOLS_DIR, AdtPlugin.getOsSdkToolsFolder());
        hashMap.put(PARAM_IS_NEW_PROJECT, iMainInfo.isNewProject());
        hashMap.put(PARAM_SRC_FOLDER, iMainInfo.getSourceFolder());
        hashMap.put(PARAM_SDK_TARGET, iMainInfo.getSdkTarget());
        hashMap.put(PARAM_MIN_SDK_VERSION, iMainInfo.getMinSdkVersion());
        if (iMainInfo.isCreateActivity()) {
            object = iMainInfo.getActivityName();
            if (((String)object).startsWith(".")) {
                object = ((String)object).substring(1);
            }
            hashMap.put(PARAM_ACTIVITY, object);
        }
        object = new HashMap();
        ((HashMap)object).put(STRING_APP_NAME, iMainInfo.getApplicationName());
        IPath iPath = iMainInfo.getLocationPath();
        IPath iPath2 = Platform.getLocation();
        if (!iPath.equals((Object)iPath2)) {
            iProjectDescription.setLocation(iPath);
        }
        if (iMainInfo.isNewProject() && !iMainInfo.useDefaultLocation() && !this.validateNewProjectLocationIsEmpty(iPath)) {
            return null;
        }
        return new ProjectInfo(iProject, iProjectDescription, hashMap, (HashMap<String, String>)object);
    }

    private ProjectInfo collectTestPageInfo() {
        if (this.mTestPage == null) {
            return null;
        }
        NewTestProjectCreationPage.TestInfo testInfo = this.mTestPage.getTestInfo();
        if (!testInfo.getCreateTestProject()) {
            return null;
        }
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        IProject iProject = iWorkspace.getRoot().getProject(testInfo.getProjectName());
        IProjectDescription iProjectDescription = iWorkspace.newProjectDescription(iProject.getName());
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(PARAM_PROJECT, testInfo.getProjectName());
        hashMap.put(PARAM_PACKAGE, testInfo.getPackageName());
        hashMap.put(PARAM_APPLICATION, "@string/app_name");
        hashMap.put(PARAM_SDK_TOOLS_DIR, AdtPlugin.getOsSdkToolsFolder());
        hashMap.put(PARAM_IS_NEW_PROJECT, true);
        hashMap.put(PARAM_SRC_FOLDER, testInfo.getSourceFolder());
        hashMap.put(PARAM_SDK_TARGET, testInfo.getSdkTarget());
        hashMap.put(PARAM_MIN_SDK_VERSION, testInfo.getMinSdkVersion());
        hashMap.put(PARAM_TEST_TARGET_PACKAGE, testInfo.getTargetPackageName());
        if (testInfo.isTestingSelf()) {
            hashMap.put(PARAM_TARGET_SELF, true);
        }
        if (testInfo.isTestingMain()) {
            hashMap.put(PARAM_TARGET_MAIN, true);
        }
        if (testInfo.isTestingExisting()) {
            hashMap.put(PARAM_TARGET_EXISTING, true);
            hashMap.put(PARAM_REFERENCE_PROJECT, testInfo.getExistingTestedProject());
        }
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        hashMap2.put(STRING_APP_NAME, testInfo.getApplicationName());
        IPath iPath = testInfo.getLocationPath();
        IPath iPath2 = Platform.getLocation();
        if (!iPath.equals((Object)iPath2)) {
            iProjectDescription.setLocation(iPath);
        }
        if (!testInfo.useDefaultLocation() && !this.validateNewProjectLocationIsEmpty(iPath)) {
            return null;
        }
        return new ProjectInfo(iProject, iProjectDescription, hashMap, hashMap2);
    }

    private void runAsyncOperation(WorkspaceModifyOperation workspaceModifyOperation) {
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)workspaceModifyOperation);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof CoreException) {
                CoreException coreException = (CoreException)throwable;
                if (coreException.getStatus().getCode() == 275) {
                    MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Error: Case Variant Exists");
                } else {
                    ErrorDialog.openError((Shell)this.getShell(), (String)"Error", null, (IStatus)coreException.getStatus());
                }
            } else {
                MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)throwable.getMessage());
            }
            invocationTargetException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private void createProjectAsync(IProgressMonitor iProgressMonitor, ProjectInfo projectInfo, ProjectInfo projectInfo2) throws InvocationTargetException {
        iProgressMonitor.beginTask("Create Android Project", 100);
        try {
            try {
                IProject iProject = null;
                if (projectInfo != null) {
                    iProject = this.createEclipseProject((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 50), projectInfo.getProject(), projectInfo.getDescription(), projectInfo.getParameters(), projectInfo.getDictionary());
                }
                if (projectInfo2 != null) {
                    Map<String, Object> map = projectInfo2.getParameters();
                    if (map.containsKey(PARAM_TARGET_MAIN) && iProject != null) {
                        map.put(PARAM_REFERENCE_PROJECT, iProject);
                    }
                    this.createEclipseProject((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 50), projectInfo2.getProject(), projectInfo2.getDescription(), map, projectInfo2.getDictionary());
                }
            }
            catch (CoreException coreException) {
                throw new InvocationTargetException(coreException);
            }
            catch (IOException iOException) {
                throw new InvocationTargetException(iOException);
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    private IProject createEclipseProject(IProgressMonitor iProgressMonitor, IProject iProject, IProjectDescription iProjectDescription, Map<String, Object> map, Map<String, String> map2) throws CoreException, IOException {
        IProject iProject2;
        Object object;
        iProject.create(iProjectDescription, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 10));
        if (iProgressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        iProject.open(128, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 10));
        AndroidNature.setupProjectNatures(iProject, iProgressMonitor);
        this.addDefaultDirectories(iProject, "/", DEFAULT_DIRECTORIES, iProgressMonitor);
        String[] stringArray = new String[]{(String)map.get(PARAM_SRC_FOLDER), GEN_SRC_DIRECTORY};
        this.addDefaultDirectories(iProject, "/", stringArray, iProgressMonitor);
        this.addDefaultDirectories(iProject, RES_DIRECTORY, RES_DIRECTORIES, iProgressMonitor);
        IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
        String[] stringArray2 = stringArray;
        int n = stringArray2.length;
        int n2 = 0;
        while (n2 < n) {
            object = stringArray2[n2];
            this.setupSourceFolder(iJavaProject, (String)object, iProgressMonitor);
            ++n2;
        }
        object = iProject.getFolder("/gen/");
        if (object.exists()) {
            object.setDerived(true);
        }
        if (((Boolean)map.get(PARAM_IS_NEW_PROJECT)).booleanValue()) {
            this.addManifest(iProject, map, map2, iProgressMonitor);
            this.addIcon(iProject, iProgressMonitor);
            this.addSampleCode(iProject, stringArray[0], map, map2, iProgressMonitor);
            if (map2.size() > 0) {
                this.addStringDictionaryFile(iProject, map2, iProgressMonitor);
            }
            iJavaProject.setOutputLocation(iProject.getFolder(BIN_DIRECTORY).getFullPath(), iProgressMonitor);
        }
        if (map.containsKey(PARAM_REFERENCE_PROJECT) && (iProject2 = (IProject)map.get(PARAM_REFERENCE_PROJECT)) != null) {
            IProjectDescription iProjectDescription2 = iProject.getDescription();
            iProjectDescription2.setReferencedProjects(new IProject[]{iProject2});
            iProject.setDescription(iProjectDescription2, 2, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 10));
            stringArray2 = JavaCore.newProjectEntry((IPath)iProject2.getFullPath(), (IAccessRule[])new IAccessRule[0], (boolean)false, (IClasspathAttribute[])new IClasspathAttribute[0], (boolean)false);
            ProjectHelper.addEntryToClasspath(iJavaProject, (IClasspathEntry)stringArray2);
        }
        Sdk.getCurrent().setProject(iProject, (IAndroidTarget)map.get(PARAM_SDK_TARGET), null);
        ProjectHelper.fixProject(iProject);
        return iProject;
    }

    private void addDefaultDirectories(IProject iProject, String string, String[] stringArray, IProgressMonitor iProgressMonitor) throws CoreException {
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFolder iFolder;
            String string2 = stringArray2[n2];
            if (string2.length() > 0 && !(iFolder = iProject.getFolder(String.valueOf(string) + string2)).exists()) {
                iFolder.create(true, true, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 10));
            }
            ++n2;
        }
    }

    private void addManifest(IProject iProject, Map<String, Object> map, Map<String, String> map2, IProgressMonitor iProgressMonitor) throws CoreException, IOException {
        IFile iFile = iProject.getFile("AndroidManifest.xml");
        if (!iFile.exists()) {
            String string;
            Object object;
            String string2;
            String string3 = AdtPlugin.readEmbeddedTextFile(TEMPLATE_MANIFEST);
            string3 = this.replaceParameters(string3, map);
            if (map.containsKey(PARAM_ACTIVITY)) {
                string2 = AdtPlugin.readEmbeddedTextFile(TEMPLATE_ACTIVITIES);
                object = this.replaceParameters(string2, map);
                string = AdtPlugin.readEmbeddedTextFile(TEMPLATE_INTENT_LAUNCHER);
                object = ((String)object).replaceAll(PH_INTENT_FILTERS, string);
                string3 = string3.replaceAll(PH_ACTIVITIES, (String)object);
            } else {
                string3 = string3.replaceAll(PH_ACTIVITIES, "");
            }
            if (map.containsKey(PARAM_TEST_TARGET_PACKAGE)) {
                string2 = AdtPlugin.readEmbeddedTextFile(TEMPLATE_TEST_USES_LIBRARY);
                string3 = string3.replaceAll(PH_TEST_USES_LIBRARY, string2);
                object = AdtPlugin.readEmbeddedTextFile(TEMPLATE_TEST_INSTRUMENTATION);
                string3 = string3.replaceAll(PH_TEST_INSTRUMENTATION, (String)object);
                string3 = this.replaceParameters(string3, map);
            } else {
                string3 = string3.replaceAll(PH_TEST_USES_LIBRARY, "");
                string3 = string3.replaceAll(PH_TEST_INSTRUMENTATION, "");
            }
            string2 = (String)map.get(PARAM_MIN_SDK_VERSION);
            if (string2 != null && string2.length() > 0) {
                object = AdtPlugin.readEmbeddedTextFile(TEMPLATE_USES_SDK);
                string = this.replaceParameters((String)object, map);
                string3 = string3.replaceAll(PH_USES_SDK, string);
            } else {
                string3 = string3.replaceAll(PH_USES_SDK, "");
            }
            object = new ByteArrayInputStream(string3.getBytes("UTF-8"));
            iFile.create((InputStream)object, false, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 10));
        }
    }

    private void addStringDictionaryFile(IProject iProject, Map<String, String> map, IProgressMonitor iProgressMonitor) throws CoreException, IOException {
        IFile iFile = iProject.getFile("res//values//strings.xml");
        if (!iFile.exists()) {
            String string = AdtPlugin.readEmbeddedTextFile(TEMPLATE_STRINGS);
            String string2 = AdtPlugin.readEmbeddedTextFile(TEMPLATE_STRING);
            Set<String> set = map.keySet();
            StringBuilder stringBuilder = new StringBuilder();
            for (String object2 : set) {
                String string3 = map.get(object2);
                String string4 = string2.replace(PARAM_STRING_NAME, object2);
                string4 = string4.replace(PARAM_STRING_CONTENT, string3);
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("\n");
                }
                stringBuilder.append(string4);
            }
            string = string.replace(PH_STRINGS, stringBuilder.toString());
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes("UTF-8"));
            iFile.create((InputStream)byteArrayInputStream, false, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 10));
        }
    }

    private void addIcon(IProject iProject, IProgressMonitor iProgressMonitor) throws CoreException {
        byte[] byArray;
        IFile iFile = iProject.getFile("res//drawable//icon.png");
        if (!iFile.exists() && (byArray = AdtPlugin.readEmbeddedFile("templates/icon.png")) != null) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            iFile.create((InputStream)byteArrayInputStream, false, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 10));
        }
    }

    private void addSampleCode(IProject iProject, String string, Map<String, Object> map, Map<String, String> map2, IProgressMonitor iProgressMonitor) throws CoreException, IOException {
        IFile iFile;
        IFile iFile2;
        String string2;
        String[] stringArray;
        IFolder iFolder = iProject.getFolder(string);
        String string3 = (String)map.get(PARAM_PACKAGE);
        String string4 = (String)map.get(PARAM_ACTIVITY);
        Map<String, Object> map3 = map;
        if (string4 != null && string4.indexOf(46) >= 0) {
            string3 = String.valueOf(string3) + "." + string4;
            int n = string3.lastIndexOf(46);
            string4 = string3.substring(n + 1);
            string3 = string3.substring(0, n);
            map3 = new HashMap<String, Object>(map);
            map3.put(PARAM_PACKAGE, string3);
            map3.put(PARAM_ACTIVITY, string4);
        }
        String[] stringArray2 = stringArray = string3.split("\\.");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            string2 = stringArray2[n2];
            if (!(iFolder = iFolder.getFolder(string2)).exists()) {
                iFolder.create(true, true, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 10));
            }
            ++n2;
        }
        if (string4 != null && !(iFile2 = iFolder.getFile(string2 = String.valueOf(string4) + ".java")).exists()) {
            this.copyFile(JAVA_ACTIVITY_TEMPLATE, iFile2, map3, iProgressMonitor);
        }
        if (!(iFile = (string2 = iProject.getFolder(RES_DIRECTORY).getFolder(LAYOUT_DIRECTORY)).getFile(MAIN_LAYOUT_XML)).exists()) {
            this.copyFile(LAYOUT_TEMPLATE, iFile, map, iProgressMonitor);
            if (string4 != null) {
                map2.put(STRING_HELLO_WORLD, "Hello World, " + string4 + "!");
            } else {
                map2.put(STRING_HELLO_WORLD, "Hello World!");
            }
        }
    }

    private void setupSourceFolder(IJavaProject iJavaProject, String string, IProgressMonitor iProgressMonitor) throws JavaModelException {
        IProject iProject = iJavaProject.getProject();
        IFolder iFolder = iProject.getFolder(string);
        IClasspathEntry[] iClasspathEntryArray = iJavaProject.getRawClasspath();
        iClasspathEntryArray = this.removeSourceClasspath(iClasspathEntryArray, (IContainer)iFolder);
        iClasspathEntryArray = this.removeSourceClasspath(iClasspathEntryArray, iFolder.getParent());
        iClasspathEntryArray = ProjectHelper.addEntryToClasspath(iClasspathEntryArray, JavaCore.newSourceEntry((IPath)iFolder.getFullPath()));
        iJavaProject.setRawClasspath(iClasspathEntryArray, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 10));
    }

    private IClasspathEntry[] removeSourceClasspath(IClasspathEntry[] iClasspathEntryArray, IContainer iContainer) {
        if (iContainer == null) {
            return iClasspathEntryArray;
        }
        IClasspathEntry iClasspathEntry = JavaCore.newSourceEntry((IPath)iContainer.getFullPath());
        int n = iClasspathEntryArray.length;
        int n2 = n - 1;
        while (n2 >= 0) {
            if (iClasspathEntryArray[n2].equals(iClasspathEntry)) {
                IClasspathEntry[] iClasspathEntryArray2 = new IClasspathEntry[n - 1];
                if (n2 > 0) {
                    System.arraycopy(iClasspathEntryArray, 0, iClasspathEntryArray2, 0, n2);
                }
                if (n2 < n - 1) {
                    System.arraycopy(iClasspathEntryArray, n2 + 1, iClasspathEntryArray2, n2, n - n2 - 1);
                }
                --n;
                iClasspathEntryArray = iClasspathEntryArray2;
            }
            --n2;
        }
        return iClasspathEntryArray;
    }

    private void copyFile(String string, IFile iFile, Map<String, Object> map, IProgressMonitor iProgressMonitor) throws CoreException, IOException {
        String string2 = AdtPlugin.readEmbeddedTextFile(TEMPLATES_DIRECTORY + string);
        string2 = this.replaceParameters(string2, map);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string2.getBytes("UTF-8"));
        iFile.create((InputStream)byteArrayInputStream, false, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 10));
    }

    private void setImageDescriptor() {
        ImageDescriptor imageDescriptor = AdtPlugin.getImageDescriptor(PROJECT_LOGO_LARGE);
        this.setDefaultPageImageDescriptor(imageDescriptor);
    }

    private String replaceParameters(String string, Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (!(entry.getValue() instanceof String)) continue;
            string = string.replaceAll(entry.getKey(), (String)entry.getValue());
        }
        return string;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum AvailablePages {
        ANDROID_AND_TEST_PROJECT,
        TEST_PROJECT_ONLY;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProjectInfo {
        private final IProject mProject;
        private final IProjectDescription mDescription;
        private final Map<String, Object> mParameters;
        private final HashMap<String, String> mDictionary;

        public ProjectInfo(IProject iProject, IProjectDescription iProjectDescription, Map<String, Object> map, HashMap<String, String> hashMap) {
            this.mProject = iProject;
            this.mDescription = iProjectDescription;
            this.mParameters = map;
            this.mDictionary = hashMap;
        }

        public IProject getProject() {
            return this.mProject;
        }

        public IProjectDescription getDescription() {
            return this.mDescription;
        }

        public Map<String, Object> getParameters() {
            return this.mParameters;
        }

        public HashMap<String, String> getDictionary() {
            return this.mDictionary;
        }
    }
}

