/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.wizards.export;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.project.AndroidManifestParser;
import com.android.ide.eclipse.adt.internal.project.BaseProjectHelper;
import com.android.ide.eclipse.adt.internal.project.ProjectChooserHelper;
import com.android.ide.eclipse.adt.internal.project.ProjectHelper;
import com.android.ide.eclipse.adt.internal.wizards.export.ExportWizard;
import java.io.File;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

final class ProjectCheckPage
extends ExportWizard.ExportWizardPage {
    private static final String IMG_ERROR = "error.png";
    private static final String IMG_WARNING = "warning.png";
    private final ExportWizard mWizard;
    private Display mDisplay;
    private Image mError;
    private Image mWarning;
    private boolean mHasMessage = false;
    private Composite mTopComposite;
    private Composite mErrorComposite;
    private Text mProjectText;
    private ProjectChooserHelper mProjectChooserHelper;
    private boolean mFirstOnShow = true;

    protected ProjectCheckPage(ExportWizard exportWizard, String string) {
        super(string);
        this.mWizard = exportWizard;
        this.setTitle("Project Checks");
        this.setDescription("Performs a set of checks to make sure the application can be exported.");
    }

    public void createControl(Composite composite) {
        this.mProjectChooserHelper = new ProjectChooserHelper(composite.getShell());
        this.mDisplay = composite.getDisplay();
        GridLayout gridLayout = null;
        GridData gridData = null;
        this.mTopComposite = new Composite(composite, 0);
        this.mTopComposite.setLayoutData((Object)new GridData(1808));
        this.mTopComposite.setLayout((Layout)new GridLayout(1, false));
        Composite composite2 = new Composite(this.mTopComposite, 0);
        composite2.setLayoutData((Object)new GridData(768));
        gridLayout = new GridLayout(3, false);
        composite2.setLayout((Layout)gridLayout);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        Label label = new Label(composite2, 0);
        gridData = new GridData(768);
        label.setLayoutData((Object)gridData);
        gridData.horizontalSpan = 3;
        label.setText("Select the project to export:");
        new Label(composite2, 0).setText("Project:");
        this.mProjectText = new Text(composite2, 2048);
        gridData = new GridData(768);
        this.mProjectText.setLayoutData((Object)gridData);
        this.mProjectText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                ProjectCheckPage.this.handleProjectNameChange();
            }
        });
        Button button = new Button(composite2, 8);
        button.setText("Browse...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                IJavaProject iJavaProject = ProjectCheckPage.this.mProjectChooserHelper.chooseJavaProject(ProjectCheckPage.this.mProjectText.getText().trim());
                if (iJavaProject != null) {
                    IProject iProject = iJavaProject.getProject();
                    ProjectCheckPage.this.mProjectText.setText(iProject.getName());
                }
            }
        });
        this.setControl((Control)this.mTopComposite);
    }

    void onShow() {
        if (this.mFirstOnShow) {
            IProject iProject = this.mWizard.getProject();
            if (iProject != null) {
                this.mProjectText.setText(iProject.getName());
            }
            this.mFirstOnShow = false;
        }
    }

    private void buildErrorUi(IProject iProject) {
        Object object;
        IFolder iFolder;
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setPageComplete(true);
        this.mHasMessage = false;
        GridLayout gridLayout = null;
        this.mErrorComposite = new Composite(this.mTopComposite, 0);
        this.mErrorComposite.setLayoutData((Object)new GridData(768));
        gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing *= 3;
        this.mErrorComposite.setLayout((Layout)gridLayout);
        if (iProject == null) {
            this.setErrorMessage("Select project to export.");
            this.mHasMessage = true;
        } else {
            try {
                if (!iProject.hasNature("com.android.ide.eclipse.adt.AndroidNature")) {
                    this.addError(this.mErrorComposite, "Project is not an Android project.");
                } else {
                    Object object2;
                    if (ProjectHelper.hasError(iProject, true)) {
                        this.addError(this.mErrorComposite, "Project has compilation error(s)");
                    }
                    if ((iFolder = BaseProjectHelper.getOutputFolder(iProject)) != null) {
                        object = iFolder.getLocation().toOSString();
                        object2 = String.valueOf(object) + File.separator + iProject.getName() + ".apk";
                        File file = new File((String)object2);
                        if (!file.isFile()) {
                            this.addError(this.mErrorComposite, String.format("%1$s/%2$s/%1$s%3$s does not exists!", iProject.getName(), iFolder.getName(), ".apk"));
                        }
                    } else {
                        this.addError(this.mErrorComposite, "Unable to get the output folder of the project!");
                    }
                    if ((object2 = ((AndroidManifestParser)(object = AndroidManifestParser.parse(BaseProjectHelper.getJavaProject(iProject), null, true, false))).getDebuggable()) != null && object2 == Boolean.TRUE) {
                        this.addWarning(this.mErrorComposite, "The manifest 'debuggable' attribute is set to true.\nYou should set it to false for applications that you release to the public.");
                    }
                }
            }
            catch (CoreException coreException) {
                this.addError(this.mErrorComposite, "Unable to get project nature");
            }
        }
        if (!this.mHasMessage) {
            iFolder = new Label(this.mErrorComposite, 0);
            object = new GridData(768);
            ((GridData)object).horizontalSpan = 2;
            iFolder.setLayoutData(object);
            iFolder.setText("No errors found. Click Next.");
        }
        this.mTopComposite.layout();
    }

    private void addError(Composite composite, String string) {
        if (this.mError == null) {
            this.mError = AdtPlugin.getImageLoader().loadImage(IMG_ERROR, this.mDisplay);
        }
        new Label(composite, 0).setImage(this.mError);
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(768));
        label.setText(string);
        this.setErrorMessage("Application cannot be exported due to the error(s) below.");
        this.setPageComplete(false);
        this.mHasMessage = true;
    }

    private void addWarning(Composite composite, String string) {
        if (this.mWarning == null) {
            this.mWarning = AdtPlugin.getImageLoader().loadImage(IMG_WARNING, this.mDisplay);
        }
        new Label(composite, 0).setImage(this.mWarning);
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(768));
        label.setText(string);
        this.mHasMessage = true;
    }

    private void handleProjectNameChange() {
        this.setPageComplete(false);
        if (this.mErrorComposite != null) {
            this.mErrorComposite.dispose();
            this.mErrorComposite = null;
        }
        this.mWizard.setProject(null);
        String string = this.mProjectText.getText().trim();
        if (string.length() == 0) {
            this.setErrorMessage("Select project to export.");
        } else if (!string.matches("[a-zA-Z0-9_ \\.-]+")) {
            this.setErrorMessage("Project name contains unsupported characters!");
        } else {
            IJavaProject[] iJavaProjectArray = this.mProjectChooserHelper.getAndroidProjects(null);
            IProject iProject = null;
            IJavaProject[] iJavaProjectArray2 = iJavaProjectArray;
            int n = iJavaProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaProject iJavaProject = iJavaProjectArray2[n2];
                if (iJavaProject.getProject().getName().equals(string)) {
                    iProject = iJavaProject.getProject();
                    break;
                }
                ++n2;
            }
            if (iProject != null) {
                this.setErrorMessage(null);
                this.mWizard.setProject(iProject);
                this.buildErrorUi(iProject);
            } else {
                this.setErrorMessage(String.format("There is no android project named '%1$s'", string));
            }
        }
    }
}

