/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.wizards.export;

import com.android.ide.eclipse.adt.internal.project.ProjectHelper;
import com.android.ide.eclipse.adt.internal.wizards.export.ExportWizard;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

final class KeyCreationPage
extends ExportWizard.ExportWizardPage {
    private final ExportWizard mWizard;
    private Text mAlias;
    private Text mKeyPassword;
    private Text mKeyPassword2;
    private Text mCnField;
    private boolean mDisableOnChange = false;
    private Text mOuField;
    private Text mOField;
    private Text mLField;
    private Text mStField;
    private Text mCField;
    private String mDName;
    private int mValidity = 0;
    private List<String> mExistingAliases;

    protected KeyCreationPage(ExportWizard exportWizard, String string) {
        super(string);
        this.mWizard = exportWizard;
        this.setTitle("Key Creation");
        this.setDescription("");
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(1808));
        GridLayout gridLayout = new GridLayout(2, false);
        composite2.setLayout((Layout)gridLayout);
        new Label(composite2, 0).setText("Alias:");
        this.mAlias = new Text(composite2, 2048);
        GridData gridData = new GridData(768);
        this.mAlias.setLayoutData((Object)gridData);
        new Label(composite2, 0).setText("Password:");
        this.mKeyPassword = new Text(composite2, 0x400800);
        gridData = new GridData(768);
        this.mKeyPassword.setLayoutData((Object)gridData);
        this.mKeyPassword.addVerifyListener(sPasswordVerifier);
        new Label(composite2, 0).setText("Confirm:");
        this.mKeyPassword2 = new Text(composite2, 0x400800);
        gridData = new GridData(768);
        this.mKeyPassword2.setLayoutData((Object)gridData);
        this.mKeyPassword2.addVerifyListener(sPasswordVerifier);
        new Label(composite2, 0).setText("Validity (years):");
        final Text text = new Text(composite2, 2048);
        gridData = new GridData(768);
        text.setLayoutData((Object)gridData);
        text.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent verifyEvent) {
                int n = 0;
                while (n < verifyEvent.text.length()) {
                    char c = verifyEvent.text.charAt(n);
                    if (c < '0' || c > '9') {
                        verifyEvent.doit = false;
                        return;
                    }
                    ++n;
                }
            }
        });
        gridData = new GridData(768);
        new Label(composite2, 258).setLayoutData((Object)gridData);
        gridData.horizontalSpan = 2;
        new Label(composite2, 0).setText("First and Last Name:");
        this.mCnField = new Text(composite2, 2048);
        gridData = new GridData(768);
        this.mCnField.setLayoutData((Object)gridData);
        new Label(composite2, 0).setText("Organizational Unit:");
        this.mOuField = new Text(composite2, 2048);
        gridData = new GridData(768);
        this.mOuField.setLayoutData((Object)gridData);
        new Label(composite2, 0).setText("Organization:");
        this.mOField = new Text(composite2, 2048);
        gridData = new GridData(768);
        this.mOField.setLayoutData((Object)gridData);
        new Label(composite2, 0).setText("City or Locality:");
        this.mLField = new Text(composite2, 2048);
        gridData = new GridData(768);
        this.mLField.setLayoutData((Object)gridData);
        new Label(composite2, 0).setText("State or Province:");
        this.mStField = new Text(composite2, 2048);
        gridData = new GridData(768);
        this.mStField.setLayoutData((Object)gridData);
        new Label(composite2, 0).setText("Country Code (XX):");
        this.mCField = new Text(composite2, 2048);
        gridData = new GridData(768);
        this.mCField.setLayoutData((Object)gridData);
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite2);
        this.mAlias.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                KeyCreationPage.this.mWizard.setKeyAlias(KeyCreationPage.this.mAlias.getText().trim());
                KeyCreationPage.this.onChange();
            }
        });
        this.mKeyPassword.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                KeyCreationPage.this.mWizard.setKeyPassword(KeyCreationPage.this.mKeyPassword.getText());
                KeyCreationPage.this.onChange();
            }
        });
        this.mKeyPassword2.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                KeyCreationPage.this.onChange();
            }
        });
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                try {
                    KeyCreationPage.this.mValidity = Integer.parseInt(text.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    KeyCreationPage.this.mValidity = 0;
                }
                KeyCreationPage.this.mWizard.setValidity(KeyCreationPage.this.mValidity);
                KeyCreationPage.this.onChange();
            }
        });
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                KeyCreationPage.this.onDNameChange();
            }
        };
        this.mCnField.addModifyListener(modifyListener);
        this.mOuField.addModifyListener(modifyListener);
        this.mOField.addModifyListener(modifyListener);
        this.mLField.addModifyListener(modifyListener);
        this.mStField.addModifyListener(modifyListener);
        this.mCField.addModifyListener(modifyListener);
    }

    void onShow() {
        if ((this.mProjectDataChanged & 3) != 0) {
            IProject iProject = this.mWizard.getProject();
            this.mDisableOnChange = true;
            String string = ProjectHelper.loadStringProperty((IResource)iProject, "alias");
            if (string != null) {
                this.mAlias.setText(string);
            }
            this.mExistingAliases = this.mWizard.getKeyCreationMode() ? this.mWizard.getExistingAliases() : null;
            this.mKeyPassword.setText("");
            this.mKeyPassword2.setText("");
            this.mDisableOnChange = false;
            this.onChange();
        }
    }

    public IWizardPage getPreviousPage() {
        if (this.mWizard.getKeyCreationMode()) {
            return this.mWizard.getKeySelectionPage();
        }
        return this.mWizard.getKeystoreSelectionPage();
    }

    public IWizardPage getNextPage() {
        return this.mWizard.getKeyCheckPage();
    }

    private void onChange() {
        String string;
        if (this.mDisableOnChange) {
            return;
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        if (this.mAlias.getText().trim().length() == 0) {
            this.setErrorMessage("Enter key alias.");
            this.setPageComplete(false);
            return;
        }
        if (this.mExistingAliases != null) {
            string = this.mAlias.getText().trim();
            for (String string2 : this.mExistingAliases) {
                if (!string2.equalsIgnoreCase(string)) continue;
                this.setErrorMessage("Key alias already exists in keystore.");
                this.setPageComplete(false);
                return;
            }
        }
        if ((string = this.mKeyPassword.getText()).length() == 0) {
            this.setErrorMessage("Enter key password.");
            this.setPageComplete(false);
            return;
        }
        if (string.length() < 6) {
            this.setErrorMessage("Key password is too short - must be at least 6 characters.");
            this.setPageComplete(false);
            return;
        }
        if (!string.equals(this.mKeyPassword2.getText())) {
            this.setErrorMessage("Key passwords don't match.");
            this.setPageComplete(false);
            return;
        }
        if (this.mValidity == 0) {
            this.setErrorMessage("Key certificate validity is required.");
            this.setPageComplete(false);
            return;
        }
        if (this.mValidity < 25) {
            this.setMessage("A 25 year certificate validity is recommended.", 2);
        } else if (this.mValidity > 1000) {
            this.setErrorMessage("Key certificate validity must be between 1 and 1000 years.");
            this.setPageComplete(false);
            return;
        }
        if (this.mDName == null || this.mDName.length() == 0) {
            this.setErrorMessage("At least one Certificate issuer field is required to be non-empty.");
            this.setPageComplete(false);
            return;
        }
        this.setPageComplete(true);
    }

    private void onDNameChange() {
        StringBuilder stringBuilder = new StringBuilder();
        this.buildDName("CN", this.mCnField, stringBuilder);
        this.buildDName("OU", this.mOuField, stringBuilder);
        this.buildDName("O", this.mOField, stringBuilder);
        this.buildDName("L", this.mLField, stringBuilder);
        this.buildDName("ST", this.mStField, stringBuilder);
        this.buildDName("C", this.mCField, stringBuilder);
        this.mDName = stringBuilder.toString();
        this.mWizard.setDName(this.mDName);
        this.onChange();
    }

    private void buildDName(String string, Text text, StringBuilder stringBuilder) {
        String string2;
        if (text != null && (string2 = text.getText().trim()).length() > 0) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(string);
            stringBuilder.append('=');
            stringBuilder.append(string2);
        }
    }
}

