/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.wizards.export;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.project.BaseProjectHelper;
import com.android.ide.eclipse.adt.internal.project.ProjectHelper;
import com.android.ide.eclipse.adt.internal.wizards.export.KeyCheckPage;
import com.android.ide.eclipse.adt.internal.wizards.export.KeyCreationPage;
import com.android.ide.eclipse.adt.internal.wizards.export.KeySelectionPage;
import com.android.ide.eclipse.adt.internal.wizards.export.KeystoreSelectionPage;
import com.android.ide.eclipse.adt.internal.wizards.export.ProjectCheckPage;
import com.android.jarutils.DebugKeyProvider;
import com.android.jarutils.KeystoreHelper;
import com.android.jarutils.SignedJarBuilder;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExportWizard
extends Wizard
implements IExportWizard {
    private static final String PROJECT_LOGO_LARGE = "icons/android_large.png";
    private static final String PAGE_PROJECT_CHECK = "Page_ProjectCheck";
    private static final String PAGE_KEYSTORE_SELECTION = "Page_KeystoreSelection";
    private static final String PAGE_KEY_CREATION = "Page_KeyCreation";
    private static final String PAGE_KEY_SELECTION = "Page_KeySelection";
    private static final String PAGE_KEY_CHECK = "Page_KeyCheck";
    static final String PROPERTY_KEYSTORE = "keystore";
    static final String PROPERTY_ALIAS = "alias";
    static final String PROPERTY_DESTINATION = "destination";
    static final String PROPERTY_FILENAME = "baseFilename";
    static final int APK_FILE_SOURCE = 0;
    static final int APK_FILE_DEST = 1;
    static final int APK_COUNT = 2;
    private ExportWizardPage[] mPages = new ExportWizardPage[5];
    private IProject mProject;
    private String mKeystore;
    private String mKeystorePassword;
    private boolean mKeystoreCreationMode;
    private String mKeyAlias;
    private String mKeyPassword;
    private int mValidity;
    private String mDName;
    private PrivateKey mPrivateKey;
    private X509Certificate mCertificate;
    private File mDestinationParentFolder;
    private ExportWizardPage mKeystoreSelectionPage;
    private ExportWizardPage mKeyCreationPage;
    private ExportWizardPage mKeySelectionPage;
    private ExportWizardPage mKeyCheckPage;
    private boolean mKeyCreationMode;
    private List<String> mExistingAliases;
    private Map<String, String[]> mApkMap;

    public ExportWizard() {
        this.setHelpAvailable(false);
        this.setWindowTitle("Export Android Application");
        this.setImageDescriptor();
    }

    public void addPages() {
        this.mPages[0] = new ProjectCheckPage(this, PAGE_PROJECT_CHECK);
        this.addPage((IWizardPage)this.mPages[0]);
        this.mKeystoreSelectionPage = this.mPages[1] = new KeystoreSelectionPage(this, PAGE_KEYSTORE_SELECTION);
        this.addPage((IWizardPage)this.mPages[1]);
        this.mKeyCreationPage = this.mPages[2] = new KeyCreationPage(this, PAGE_KEY_CREATION);
        this.addPage((IWizardPage)this.mPages[2]);
        this.mKeySelectionPage = this.mPages[3] = new KeySelectionPage(this, PAGE_KEY_SELECTION);
        this.addPage((IWizardPage)this.mPages[3]);
        this.mKeyCheckPage = this.mPages[4] = new KeyCheckPage(this, PAGE_KEY_CHECK);
        this.addPage((IWizardPage)this.mPages[4]);
    }

    public boolean performFinish() {
        ProjectHelper.saveStringProperty((IResource)this.mProject, PROPERTY_KEYSTORE, this.mKeystore);
        ProjectHelper.saveStringProperty((IResource)this.mProject, PROPERTY_ALIAS, this.mKeyAlias);
        ProjectHelper.saveStringProperty((IResource)this.mProject, PROPERTY_DESTINATION, this.mDestinationParentFolder.getAbsolutePath());
        ProjectHelper.saveStringProperty((IResource)this.mProject, PROPERTY_FILENAME, this.mApkMap.get(null)[1]);
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        final boolean[] blArray = new boolean[1];
        try {
            iWorkbench.getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                    try {
                        blArray[0] = ExportWizard.this.doExport(iProgressMonitor);
                    }
                    finally {
                        iProgressMonitor.done();
                    }
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return blArray[0];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean doExport(IProgressMonitor iProgressMonitor) {
        try {
            Object object;
            Object object2;
            IFolder iFolder;
            this.mProject.build(10, iProgressMonitor);
            if (this.mKeystoreCreationMode || this.mKeyCreationMode) {
                iFolder = new ArrayList();
                boolean bl = KeystoreHelper.createNewStore((String)this.mKeystore, null, (String)this.mKeystorePassword, (String)this.mKeyAlias, (String)this.mKeyPassword, (String)this.mDName, (int)this.mValidity, (DebugKeyProvider.IKeyGenOutput)new DebugKeyProvider.IKeyGenOutput((ArrayList)iFolder){
                    private final /* synthetic */ ArrayList val$output;
                    {
                        this.val$output = arrayList;
                    }

                    public void err(String string) {
                        this.val$output.add(string);
                    }

                    public void out(String string) {
                        this.val$output.add(string);
                    }
                });
                if (!bl) {
                    this.displayError(iFolder.toArray(new String[iFolder.size()]));
                    return false;
                }
                object2 = KeyStore.getInstance(KeyStore.getDefaultType());
                FileInputStream fileInputStream = new FileInputStream(this.mKeystore);
                ((KeyStore)object2).load(fileInputStream, this.mKeystorePassword.toCharArray());
                fileInputStream.close();
                object = (KeyStore.PrivateKeyEntry)((KeyStore)object2).getEntry(this.mKeyAlias, new KeyStore.PasswordProtection(this.mKeyPassword.toCharArray()));
                if (object == null) {
                    this.displayError("Could not find key");
                    return false;
                }
                this.mPrivateKey = ((KeyStore.PrivateKeyEntry)object).getPrivateKey();
                this.mCertificate = (X509Certificate)((KeyStore.PrivateKeyEntry)object).getCertificate();
            }
            if (this.mPrivateKey == null) return false;
            if (this.mCertificate == null) return false;
            iFolder = BaseProjectHelper.getOutputFolder(this.mProject);
            if (iFolder == null) {
                return false;
            }
            String string = iFolder.getLocation().toOSString();
            object2 = this.mApkMap.entrySet();
            boolean bl = false;
            object = AdtPlugin.getOsAbsoluteZipAlign();
            File file = new File((String)object);
            bl = file.isFile();
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                String[] stringArray = (String[])entry.getValue();
                String string2 = stringArray[0];
                String string3 = stringArray[1];
                File file2 = bl ? File.createTempFile("android", ".apk") : new File(this.mDestinationParentFolder, string3);
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                SignedJarBuilder signedJarBuilder = new SignedJarBuilder((OutputStream)fileOutputStream, this.mPrivateKey, this.mCertificate);
                FileInputStream fileInputStream = new FileInputStream(new File(string, string2));
                try {
                    File file3;
                    String string4;
                    signedJarBuilder.writeZip((InputStream)fileInputStream, null);
                    signedJarBuilder.close();
                    if (!bl || (string4 = this.zipAlign((String)object, file2, file3 = new File(this.mDestinationParentFolder, string3))) == null) continue;
                    this.displayError(string4);
                    return false;
                }
                finally {
                    try {
                        fileInputStream.close();
                    }
                    finally {
                        fileOutputStream.close();
                    }
                }
            }
            if (bl) return true;
            AdtPlugin.displayWarning("Export Wizard", "The zipalign tool was not found in the SDK.\n\nPlease update to the latest SDK and re-export your application\nor run zipalign manually.\n\nAligning applications allows Android to use application resources\nmore efficiently.");
            return true;
        }
        catch (Throwable throwable) {
            this.displayError(throwable);
        }
        return false;
    }

    public boolean canFinish() {
        return this.mApkMap != null && this.mApkMap.size() > 0 && (this.mPrivateKey != null && this.mCertificate != null || this.mKeystoreCreationMode || this.mKeyCreationMode) && this.mDestinationParentFolder != null;
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        IResource iResource;
        Object object = iStructuredSelection.getFirstElement();
        if (object instanceof IProject) {
            this.mProject = (IProject)object;
        } else if (object instanceof IAdaptable && (iResource = (IResource)((IAdaptable)object).getAdapter(IResource.class)) != null) {
            this.mProject = iResource.getProject();
        }
    }

    ExportWizardPage getKeystoreSelectionPage() {
        return this.mKeystoreSelectionPage;
    }

    ExportWizardPage getKeyCreationPage() {
        return this.mKeyCreationPage;
    }

    ExportWizardPage getKeySelectionPage() {
        return this.mKeySelectionPage;
    }

    ExportWizardPage getKeyCheckPage() {
        return this.mKeyCheckPage;
    }

    private void setImageDescriptor() {
        ImageDescriptor imageDescriptor = AdtPlugin.getImageDescriptor(PROJECT_LOGO_LARGE);
        this.setDefaultPageImageDescriptor(imageDescriptor);
    }

    IProject getProject() {
        return this.mProject;
    }

    void setProject(IProject iProject) {
        this.mProject = iProject;
        this.updatePageOnChange(1);
    }

    void setKeystore(String string) {
        this.mKeystore = string;
        this.mPrivateKey = null;
        this.mCertificate = null;
        this.updatePageOnChange(2);
    }

    String getKeystore() {
        return this.mKeystore;
    }

    void setKeystoreCreationMode(boolean bl) {
        this.mKeystoreCreationMode = bl;
        this.updatePageOnChange(2);
    }

    boolean getKeystoreCreationMode() {
        return this.mKeystoreCreationMode;
    }

    void setKeystorePassword(String string) {
        this.mKeystorePassword = string;
        this.mPrivateKey = null;
        this.mCertificate = null;
        this.updatePageOnChange(2);
    }

    String getKeystorePassword() {
        return this.mKeystorePassword;
    }

    void setKeyCreationMode(boolean bl) {
        this.mKeyCreationMode = bl;
        this.updatePageOnChange(4);
    }

    boolean getKeyCreationMode() {
        return this.mKeyCreationMode;
    }

    void setExistingAliases(List<String> list) {
        this.mExistingAliases = list;
    }

    List<String> getExistingAliases() {
        return this.mExistingAliases;
    }

    void setKeyAlias(String string) {
        this.mKeyAlias = string;
        this.mPrivateKey = null;
        this.mCertificate = null;
        this.updatePageOnChange(4);
    }

    String getKeyAlias() {
        return this.mKeyAlias;
    }

    void setKeyPassword(String string) {
        this.mKeyPassword = string;
        this.mPrivateKey = null;
        this.mCertificate = null;
        this.updatePageOnChange(4);
    }

    String getKeyPassword() {
        return this.mKeyPassword;
    }

    void setValidity(int n) {
        this.mValidity = n;
        this.updatePageOnChange(4);
    }

    int getValidity() {
        return this.mValidity;
    }

    void setDName(String string) {
        this.mDName = string;
        this.updatePageOnChange(4);
    }

    String getDName() {
        return this.mDName;
    }

    void setSigningInfo(PrivateKey privateKey, X509Certificate x509Certificate) {
        this.mPrivateKey = privateKey;
        this.mCertificate = x509Certificate;
    }

    void setDestination(File file, Map<String, String[]> map) {
        this.mDestinationParentFolder = file;
        this.mApkMap = map;
    }

    void resetDestination() {
        this.mDestinationParentFolder = null;
        this.mApkMap = null;
    }

    void updatePageOnChange(int n) {
        ExportWizardPage[] exportWizardPageArray = this.mPages;
        int n2 = this.mPages.length;
        int n3 = 0;
        while (n3 < n2) {
            ExportWizardPage exportWizardPage = exportWizardPageArray[n3];
            exportWizardPage.projectDataChanged(n);
            ++n3;
        }
    }

    private void displayError(String ... stringArray) {
        String string = null;
        if (stringArray.length == 1) {
            string = stringArray[0];
        } else {
            StringBuilder stringBuilder = new StringBuilder(stringArray[0]);
            int n = 1;
            while (n < stringArray.length) {
                stringBuilder.append('\n');
                stringBuilder.append(stringArray[n]);
                ++n;
            }
            string = stringBuilder.toString();
        }
        AdtPlugin.displayError("Export Wizard", string);
    }

    private void displayError(Throwable throwable) {
        String string = ExportWizard.getExceptionMessage(throwable);
        this.displayError(string);
        AdtPlugin.log(throwable, "Export Wizard Error", new Object[0]);
    }

    private String zipAlign(String string, File file, File file2) throws IOException {
        String[] stringArray = new String[]{string, "-f", "4", file.getAbsolutePath(), file2.getAbsolutePath()};
        Process process = Runtime.getRuntime().exec(stringArray);
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            if (this.grabProcessOutput(process, arrayList) != 0) {
                StringBuilder stringBuilder = new StringBuilder("Error while running zipalign:");
                for (String string2 : arrayList) {
                    stringBuilder.append('\n');
                    stringBuilder.append(string2);
                }
                return stringBuilder.toString();
            }
        }
        catch (InterruptedException interruptedException) {}
        return null;
    }

    private final int grabProcessOutput(final Process process, final ArrayList<String> arrayList) throws InterruptedException {
        new Thread(""){

            public void run() {
                InputStreamReader inputStreamReader = new InputStreamReader(process.getErrorStream());
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                try {
                    String string;
                    while ((string = bufferedReader.readLine()) != null) {
                        arrayList.add(string);
                    }
                }
                catch (IOException iOException) {}
            }
        }.start();
        new Thread(""){

            public void run() {
                InputStreamReader inputStreamReader = new InputStreamReader(process.getInputStream());
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                IProject iProject = ExportWizard.this.getProject();
                try {
                    String string;
                    while ((string = bufferedReader.readLine()) != null) {
                        AdtPlugin.printBuildToConsole(2, iProject, string);
                    }
                }
                catch (IOException iOException) {}
            }
        }.start();
        return process.waitFor();
    }

    static String getExceptionMessage(Throwable throwable) {
        String string = throwable.getMessage();
        if (string == null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            throwable.printStackTrace(new PrintStream(byteArrayOutputStream));
            string = byteArrayOutputStream.toString();
        }
        return string;
    }

    static abstract class ExportWizardPage
    extends WizardPage {
        protected static final int DATA_PROJECT = 1;
        protected static final int DATA_KEYSTORE = 2;
        protected static final int DATA_KEY = 4;
        protected static final VerifyListener sPasswordVerifier = new VerifyListener(){

            public void verifyText(VerifyEvent verifyEvent) {
                int n = verifyEvent.text.length();
                if (n + ((Text)verifyEvent.getSource()).getText().length() > 127) {
                    verifyEvent.doit = false;
                    return;
                }
                int n2 = 0;
                while (n2 < n) {
                    if (verifyEvent.text.charAt(n2) < ' ') {
                        verifyEvent.doit = false;
                        return;
                    }
                    ++n2;
                }
            }
        };
        protected int mProjectDataChanged = 0;

        ExportWizardPage(String string) {
            super(string);
        }

        abstract void onShow();

        public void setVisible(boolean bl) {
            super.setVisible(bl);
            if (bl) {
                this.onShow();
                this.mProjectDataChanged = 0;
            }
        }

        final void projectDataChanged(int n) {
            this.mProjectDataChanged |= n;
        }

        protected void onException(Throwable throwable) {
            String string = ExportWizard.getExceptionMessage(throwable);
            this.setErrorMessage(string);
            this.setPageComplete(false);
        }
    }
}

