/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.sdk;

import com.android.ddmlib.IDevice;
import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.project.AndroidClasspathContainerInitializer;
import com.android.ide.eclipse.adt.internal.resources.manager.ResourceMonitor;
import com.android.ide.eclipse.adt.internal.sdk.AndroidTargetData;
import com.android.ide.eclipse.adt.internal.sdk.LoadStatus;
import com.android.prefs.AndroidLocation;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.ISdkLog;
import com.android.sdklib.SdkConstants;
import com.android.sdklib.SdkManager;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.sdklib.internal.project.ApkConfigurationHelper;
import com.android.sdklib.internal.project.ProjectProperties;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sdk
implements ResourceMonitor.IProjectListener {
    private static Sdk sCurrentSdk = null;
    private final SdkManager mManager;
    private final AvdManager mAvdManager;
    private final HashMap<IProject, IAndroidTarget> mProjectTargetMap = new HashMap();
    private final HashMap<IAndroidTarget, AndroidTargetData> mTargetDataMap = new HashMap();
    private final HashMap<IProject, Map<String, String>> mProjectApkConfigMap = new HashMap();
    private final String mDocBaseUrl;

    public static Sdk loadSdk(String string) {
        ArrayList arrayList;
        ISdkLog iSdkLog;
        SdkManager sdkManager;
        if (sCurrentSdk != null) {
            sCurrentSdk.dispose();
            sCurrentSdk = null;
        }
        if ((sdkManager = SdkManager.createManager((String)string, (ISdkLog)(iSdkLog = new ISdkLog(arrayList = new ArrayList()){
            private final /* synthetic */ ArrayList val$logMessages;
            {
                this.val$logMessages = arrayList;
            }

            public void error(Throwable throwable, String string, Object ... objectArray) {
                if (string != null) {
                    this.val$logMessages.add(String.format("Error: " + string, objectArray));
                }
                if (throwable != null) {
                    this.val$logMessages.add(throwable.getMessage());
                }
            }

            public void warning(String string, Object ... objectArray) {
                this.val$logMessages.add(String.format("Warning: " + string, objectArray));
            }

            public void printf(String string, Object ... objectArray) {
                this.val$logMessages.add(String.format(string, objectArray));
            }
        }))) != null) {
            AvdManager avdManager = null;
            try {
                avdManager = new AvdManager(sdkManager, iSdkLog);
            }
            catch (AndroidLocation.AndroidLocationException androidLocationException) {
                iSdkLog.error((Throwable)androidLocationException, "Error parsing the AVDs", new Object[0]);
            }
            sCurrentSdk = new Sdk(sdkManager, avdManager);
            return sCurrentSdk;
        }
        StringBuilder stringBuilder = new StringBuilder("Error Loading the SDK:\n");
        for (String string2 : arrayList) {
            stringBuilder.append('\n');
            stringBuilder.append(string2);
        }
        AdtPlugin.displayError("Android SDK", stringBuilder.toString());
        return null;
    }

    public static Sdk getCurrent() {
        return sCurrentSdk;
    }

    public String getSdkLocation() {
        return this.mManager.getLocation();
    }

    public String getDocumentationBaseUrl() {
        return this.mDocBaseUrl;
    }

    public IAndroidTarget[] getTargets() {
        return this.mManager.getTargets();
    }

    public IAndroidTarget getTargetFromHashString(String string) {
        return this.mManager.getTargetFromHashString(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProject(IProject iProject, IAndroidTarget iAndroidTarget, Map<String, String> map) {
        Object object = AdtPlugin.getDefault().getSdkLockObject();
        synchronized (object) {
            IAndroidTarget iAndroidTarget2;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            ProjectProperties projectProperties = ProjectProperties.load((String)iProject.getLocation().toOSString(), (ProjectProperties.PropertyType)ProjectProperties.PropertyType.DEFAULT);
            if (projectProperties == null) {
                projectProperties = ProjectProperties.create((String)iProject.getLocation().toOSString(), (ProjectProperties.PropertyType)ProjectProperties.PropertyType.DEFAULT);
            }
            if (iAndroidTarget != null && iAndroidTarget != (iAndroidTarget2 = this.mProjectTargetMap.get(iProject))) {
                projectProperties.setAndroidTarget(iAndroidTarget);
                this.mProjectTargetMap.put(iProject, iAndroidTarget);
                bl = true;
            }
            if (map != null) {
                bl3 = ApkConfigurationHelper.setConfigs((ProjectProperties)projectProperties, map);
                this.mProjectApkConfigMap.put(iProject, map);
                bl2 = true;
            }
            try {
                projectProperties.save();
            }
            catch (IOException iOException) {
                AdtPlugin.log(iOException, "Failed to save default.properties for project '%s'", iProject.getName());
            }
            if (bl) {
                iAndroidTarget2 = JavaCore.create((IProject)iProject);
                AndroidClasspathContainerInitializer.updateProjects(new IJavaProject[]{iAndroidTarget2});
            } else if (bl2) {
                try {
                    iProject.build(bl3 ? 15 : 6, null);
                }
                catch (CoreException coreException) {
                    iAndroidTarget2 = JavaCore.create((IProject)iProject);
                    AndroidClasspathContainerInitializer.updateProjects(new IJavaProject[]{iAndroidTarget2});
                }
            }
            if (bl) {
                AdtPlugin.getDefault().updateTargetListener(iProject);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAndroidTarget getTarget(IProject iProject) {
        Object object = AdtPlugin.getDefault().getSdkLockObject();
        synchronized (object) {
            String string;
            IAndroidTarget iAndroidTarget = this.mProjectTargetMap.get(iProject);
            if (iAndroidTarget == null && (string = Sdk.loadProjectProperties(iProject, this)) != null) {
                iAndroidTarget = this.mManager.getTargetFromHashString(string);
            }
            return iAndroidTarget;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String loadProjectProperties(IProject iProject, Sdk sdk) {
        IPath iPath = iProject.getLocation();
        if (iPath == null) {
            return null;
        }
        ProjectProperties projectProperties = ProjectProperties.load((String)iPath.toOSString(), (ProjectProperties.PropertyType)ProjectProperties.PropertyType.DEFAULT);
        if (projectProperties == null) {
            AdtPlugin.log(4, "Failed to load properties file for project '%s'", iProject.getName());
            return null;
        }
        if (sdk != null) {
            Object object = AdtPlugin.getDefault().getSdkLockObject();
            synchronized (object) {
                Map map = ApkConfigurationHelper.getConfigs((ProjectProperties)projectProperties);
                if (map != null) {
                    sdk.mProjectApkConfigMap.put(iProject, map);
                }
            }
        }
        return projectProperties.getProperty("target");
    }

    public static String getProjectTargetHashString(IProject iProject) {
        return Sdk.loadProjectProperties(iProject, null);
    }

    public static void setProjectTargetHashString(IProject iProject, String string) {
        ProjectProperties projectProperties = ProjectProperties.load((String)iProject.getLocation().toOSString(), (ProjectProperties.PropertyType)ProjectProperties.PropertyType.DEFAULT);
        if (projectProperties == null) {
            projectProperties = ProjectProperties.create((String)iProject.getLocation().toOSString(), (ProjectProperties.PropertyType)ProjectProperties.PropertyType.DEFAULT);
        }
        projectProperties.setProperty("target", string);
        try {
            projectProperties.save();
        }
        catch (IOException iOException) {
            AdtPlugin.log(iOException, "Failed to save default.properties for project '%s'", iProject.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AndroidTargetData getTargetData(IAndroidTarget iAndroidTarget) {
        Object object = AdtPlugin.getDefault().getSdkLockObject();
        synchronized (object) {
            return this.mTargetDataMap.get(iAndroidTarget);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AndroidTargetData getTargetData(IProject iProject) {
        Object object = AdtPlugin.getDefault().getSdkLockObject();
        synchronized (object) {
            IAndroidTarget iAndroidTarget = this.getTarget(iProject);
            if (iAndroidTarget != null) {
                return this.getTargetData(iAndroidTarget);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getProjectApkConfigs(IProject iProject) {
        Object object = AdtPlugin.getDefault().getSdkLockObject();
        synchronized (object) {
            return this.mProjectApkConfigMap.get(iProject);
        }
    }

    public AvdManager getAvdManager() {
        return this.mAvdManager;
    }

    public static AndroidVersion getDeviceVersion(IDevice iDevice) {
        String string;
        Map map;
        block3: {
            try {
                map = iDevice.getProperties();
                string = (String)map.get("ro.build.version.sdk");
                if (string != null) break block3;
                return null;
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        return new AndroidVersion(Integer.parseInt(string), (String)map.get("ro.build.version.codename"));
    }

    private Sdk(SdkManager sdkManager, AvdManager avdManager) {
        this.mManager = sdkManager;
        this.mAvdManager = avdManager;
        ResourceMonitor resourceMonitor = ResourceMonitor.getMonitor();
        resourceMonitor.addProjectListener(this);
        this.mDocBaseUrl = this.getDocumentationBaseUrl(String.valueOf(this.mManager.getLocation()) + SdkConstants.OS_SDK_DOCS_FOLDER);
    }

    private void dispose() {
        ResourceMonitor.getMonitor().removeProjectListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTargetData(IAndroidTarget iAndroidTarget, AndroidTargetData androidTargetData) {
        Object object = AdtPlugin.getDefault().getSdkLockObject();
        synchronized (object) {
            this.mTargetDataMap.put(iAndroidTarget, androidTargetData);
        }
    }

    private String getDocumentationBaseUrl(String string) {
        File file = new File(string);
        if (file.isDirectory()) {
            try {
                String string2 = file.getAbsolutePath();
                if (File.separatorChar != '/') {
                    string2 = string2.replace(File.separatorChar, '/');
                }
                URL uRL = new URL("file", null, "//" + string2);
                String string3 = uRL.toString();
                return string3;
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void projectClosed(IProject iProject) {
        Object object = AdtPlugin.getDefault().getSdkLockObject();
        synchronized (object) {
            AndroidTargetData.LayoutBridge layoutBridge;
            AndroidTargetData androidTargetData;
            IAndroidTarget iAndroidTarget = this.mProjectTargetMap.get(iProject);
            if (iAndroidTarget != null && (androidTargetData = this.mTargetDataMap.get(iAndroidTarget)) != null && (layoutBridge = androidTargetData.getLayoutBridge()) != null && layoutBridge.status == LoadStatus.LOADED) {
                layoutBridge.bridge.clearCaches((Object)iProject);
            }
            this.mProjectTargetMap.remove(iProject);
            this.mProjectApkConfigMap.remove(iProject);
        }
    }

    @Override
    public void projectDeleted(IProject iProject) {
        this.projectClosed(iProject);
    }

    @Override
    public void projectOpened(IProject iProject) {
    }

    @Override
    public void projectOpenedWithWorkspace(IProject iProject) {
    }

    public static interface ITargetChangeListener {
        public void onProjectTargetChange(IProject var1);

        public void onTargetsLoaded();
    }
}

