/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.sdk;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.build.Messages;
import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public final class DexWrapper {
    private static final String DEX_MAIN = "com.android.dx.command.dexer.Main";
    private static final String DEX_CONSOLE = "com.android.dx.command.DxConsole";
    private static final String DEX_ARGS = "com.android.dx.command.dexer.Main$Arguments";
    private static final String MAIN_RUN = "run";
    private Method mRunMethod;
    private Constructor<?> mArgConstructor;
    private Field mArgOutName;
    private Field mArgVerbose;
    private Field mArgJarOutput;
    private Field mArgFileNames;
    private Field mConsoleOut;
    private Field mConsoleErr;

    public synchronized IStatus loadDex(String string) {
        try {
            File file = new File(string);
            if (!file.isFile()) {
                return new Status(4, "com.android.ide.eclipse.adt", String.format(Messages.DexWrapper_s_does_not_exists, string));
            }
            URL uRL = file.toURL();
            URLClassLoader uRLClassLoader = new URLClassLoader(new URL[]{uRL}, DexWrapper.class.getClassLoader());
            Class<?> clazz = uRLClassLoader.loadClass(DEX_MAIN);
            Class<?> clazz2 = uRLClassLoader.loadClass(DEX_CONSOLE);
            Class<?> clazz3 = uRLClassLoader.loadClass(DEX_ARGS);
            try {
                this.mRunMethod = clazz.getMethod(MAIN_RUN, clazz3);
                this.mArgConstructor = clazz3.getConstructor(new Class[0]);
                this.mArgOutName = clazz3.getField("outName");
                this.mArgJarOutput = clazz3.getField("jarOutput");
                this.mArgFileNames = clazz3.getField("fileNames");
                this.mArgVerbose = clazz3.getField("verbose");
                this.mConsoleOut = clazz2.getField("out");
                this.mConsoleErr = clazz2.getField("err");
            }
            catch (SecurityException securityException) {
                return DexWrapper.createErrorStatus(Messages.DexWrapper_SecuryEx_Unable_To_Find_API, securityException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return DexWrapper.createErrorStatus(Messages.DexWrapper_SecuryEx_Unable_To_Find_Method, noSuchMethodException);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                return DexWrapper.createErrorStatus(Messages.DexWrapper_SecuryEx_Unable_To_Find_Field, noSuchFieldException);
            }
            return Status.OK_STATUS;
        }
        catch (MalformedURLException malformedURLException) {
            return DexWrapper.createErrorStatus(String.format(Messages.DexWrapper_Failed_to_load_s, string), malformedURLException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return DexWrapper.createErrorStatus(String.format(Messages.DexWrapper_Failed_to_load_s, string), classNotFoundException);
        }
    }

    public synchronized int run(String string, String[] stringArray, boolean bl, PrintStream printStream, PrintStream printStream2) throws CoreException {
        try {
            this.mConsoleErr.set(null, printStream2);
            this.mConsoleOut.set(null, printStream);
            Object obj = this.mArgConstructor.newInstance(new Object[0]);
            this.mArgOutName.set(obj, string);
            this.mArgFileNames.set(obj, stringArray);
            this.mArgJarOutput.set(obj, false);
            this.mArgVerbose.set(obj, bl);
            Object object = this.mRunMethod.invoke(null, obj);
            if (object instanceof Integer) {
                return (Integer)object;
            }
            return -1;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new CoreException(DexWrapper.createErrorStatus(String.format(Messages.DexWrapper_Unable_To_Execute_Dex_s, illegalAccessException.getMessage()), illegalAccessException));
        }
        catch (InstantiationException instantiationException) {
            throw new CoreException(DexWrapper.createErrorStatus(String.format(Messages.DexWrapper_Unable_To_Execute_Dex_s, instantiationException.getMessage()), instantiationException));
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new CoreException(DexWrapper.createErrorStatus(String.format(Messages.DexWrapper_Unable_To_Execute_Dex_s, invocationTargetException.getMessage()), invocationTargetException));
        }
    }

    private static IStatus createErrorStatus(String string, Exception exception) {
        AdtPlugin.log(exception, string, new Object[0]);
        AdtPlugin.printErrorToConsole(Messages.DexWrapper_Dex_Loader, string);
        return new Status(4, "com.android.ide.eclipse.adt", string, (Throwable)exception);
    }
}

