/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.sdk;

import com.android.ide.eclipse.adt.internal.sdk.IAndroidClassLoader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.management.InvalidAttributeValueException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AndroidJarLoader
extends ClassLoader
implements IAndroidClassLoader {
    private String mOsFrameworkLocation;
    private final HashMap<String, byte[]> mEntryCache = new HashMap();
    private final HashMap<String, Class<?>> mClassCache = new HashMap();

    public AndroidJarLoader(String string) {
        this.mOsFrameworkLocation = string;
    }

    @Override
    public String getSource() {
        return this.mOsFrameworkLocation;
    }

    public void preLoadClasses(String string, String string2, IProgressMonitor iProgressMonitor) throws IOException, InvalidAttributeValueException, ClassFormatError {
        ZipEntry zipEntry;
        String string3 = string.replaceAll("\\.", "/");
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (String)(string2 == null ? "" : string2), (int)100);
        FileInputStream fileInputStream = new FileInputStream(this.mOsFrameworkLocation);
        ZipInputStream zipInputStream = new ZipInputStream(fileInputStream);
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            String string4 = zipEntry.getName();
            if (!string4.endsWith(".class") || string3.length() > 0 && !string4.startsWith(string3)) continue;
            String string5 = this.entryPathToClassName(string4);
            if (!this.mEntryCache.containsKey(string5)) {
                long l = zipEntry.getSize();
                if (l > Integer.MAX_VALUE) {
                    throw new InvalidAttributeValueException();
                }
                byte[] byArray = this.readZipData(zipInputStream, (int)l);
                this.mEntryCache.put(string5, byArray);
            }
            subMonitor.setWorkRemaining(100);
            subMonitor.worked(5);
            subMonitor.subTask(String.format("Preload %1$s", string5));
        }
    }

    @Override
    public HashMap<String, ArrayList<IAndroidClassLoader.IClassDescriptor>> findClassesDerivingFrom(String string, String[] stringArray) throws IOException, InvalidAttributeValueException, ClassFormatError {
        ZipEntry zipEntry;
        Object object;
        string = string.replaceAll("\\.", "/");
        HashMap<String, ArrayList<IAndroidClassLoader.IClassDescriptor>> hashMap = new HashMap<String, ArrayList<IAndroidClassLoader.IClassDescriptor>>();
        Object object2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = object2[n2];
            hashMap.put((String)object, new ArrayList());
            ++n2;
        }
        object = new FileInputStream(this.mOsFrameworkLocation);
        ZipInputStream zipInputStream = new ZipInputStream((InputStream)object);
        block1: while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            Object object3;
            object2 = zipEntry.getName();
            if (!((String)object2).endsWith(".class") || string.length() > 0 && !((String)object2).startsWith(string)) continue;
            String string2 = this.entryPathToClassName((String)object2);
            Class<?> clazz = this.mClassCache.get(string2);
            if (clazz == null) {
                object3 = this.mEntryCache.get(string2);
                if (object3 == null) {
                    long l = zipEntry.getSize();
                    if (l > Integer.MAX_VALUE) {
                        throw new InvalidAttributeValueException();
                    }
                    object3 = this.readZipData(zipInputStream, (int)l);
                }
                clazz = this.defineAndCacheClass(string2, (byte[])object3);
            }
            object3 = clazz.getSuperclass();
            while (object3 != null) {
                String string3 = ((Class)object3).getCanonicalName();
                if (hashMap.containsKey(string3)) {
                    hashMap.get(string3).add(new ClassWrapper(clazz));
                    continue block1;
                }
                object3 = ((Class)object3).getSuperclass();
            }
        }
        return hashMap;
    }

    private String entryPathToClassName(String string) {
        return string.replaceFirst("\\.class$", "").replaceAll("[/\\\\]", ".");
    }

    @Override
    protected Class<?> findClass(String string) throws ClassNotFoundException {
        try {
            Class<?> clazz = this.mClassCache.get(string);
            if (clazz == ClassNotFoundException.class) {
                throw new ClassNotFoundException(string);
            }
            if (clazz != null) {
                return clazz;
            }
            byte[] byArray = this.loadClassData(string);
            if (byArray != null) {
                return this.defineAndCacheClass(string, byArray);
            }
            this.mClassCache.put(string, ClassNotFoundException.class);
            throw new ClassNotFoundException(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw classNotFoundException;
        }
        catch (Exception exception) {
            throw new ClassNotFoundException(exception.getMessage());
        }
    }

    private Class<?> defineAndCacheClass(String string, byte[] byArray) throws ClassFormatError {
        Class<?> clazz = this.defineClass(null, byArray, 0, byArray.length);
        if (clazz != null) {
            this.mClassCache.put(string, clazz);
            this.mEntryCache.remove(string);
        }
        return clazz;
    }

    private synchronized byte[] loadClassData(String string) throws InvalidAttributeValueException, IOException {
        ZipEntry zipEntry;
        byte[] byArray = this.mEntryCache.get(string);
        if (byArray != null) {
            return byArray;
        }
        String string2 = String.valueOf(string.replaceAll("\\.", "/")) + ".class";
        FileInputStream fileInputStream = new FileInputStream(this.mOsFrameworkLocation);
        ZipInputStream zipInputStream = new ZipInputStream(fileInputStream);
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            String string3 = zipEntry.getName();
            if (!string3.equals(string2)) continue;
            long l = zipEntry.getSize();
            if (l > Integer.MAX_VALUE) {
                throw new InvalidAttributeValueException();
            }
            byArray = this.readZipData(zipInputStream, (int)l);
            return byArray;
        }
        return null;
    }

    private byte[] readZipData(ZipInputStream zipInputStream, int n) throws IOException {
        int n2 = 1024;
        int n3 = n < 1 ? n2 : n;
        int n4 = 0;
        byte[] byArray = new byte[n3];
        while (zipInputStream.available() != 0) {
            int n5 = zipInputStream.read(byArray, n4, n3 - n4);
            if (n5 < 0 || n >= 1 && (n4 += n5) >= n) break;
            if (n4 < n3) continue;
            byte[] byArray2 = new byte[n3 + n2];
            System.arraycopy(byArray, 0, byArray2, 0, n3);
            n3 += n2;
            byArray = byArray2;
            n2 *= 2;
        }
        if (n4 < n3) {
            byte[] byArray3 = new byte[n4];
            if (n4 > 0) {
                System.arraycopy(byArray, 0, byArray3, 0, n4);
            }
            byArray = byArray3;
        }
        return byArray;
    }

    @Override
    public IAndroidClassLoader.IClassDescriptor getClass(String string) throws ClassNotFoundException {
        return new ClassWrapper(this.loadClass(string));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ClassWrapper
    implements IAndroidClassLoader.IClassDescriptor {
        private Class<?> mClass;

        public ClassWrapper(Class<?> clazz) {
            this.mClass = clazz;
        }

        @Override
        public String getCanonicalName() {
            return this.mClass.getCanonicalName();
        }

        @Override
        public IAndroidClassLoader.IClassDescriptor[] getDeclaredClasses() {
            Class<?>[] classArray = this.mClass.getDeclaredClasses();
            IAndroidClassLoader.IClassDescriptor[] iClassDescriptorArray = new IAndroidClassLoader.IClassDescriptor[classArray.length];
            int n = 0;
            while (n < classArray.length) {
                iClassDescriptorArray[n] = new ClassWrapper(classArray[n]);
                ++n;
            }
            return iClassDescriptorArray;
        }

        @Override
        public IAndroidClassLoader.IClassDescriptor getEnclosingClass() {
            return new ClassWrapper(this.mClass.getEnclosingClass());
        }

        @Override
        public String getSimpleName() {
            return this.mClass.getSimpleName();
        }

        @Override
        public IAndroidClassLoader.IClassDescriptor getSuperclass() {
            return new ClassWrapper(this.mClass.getSuperclass());
        }

        public boolean equals(Object object) {
            if (object instanceof ClassWrapper) {
                return this.mClass.equals(((ClassWrapper)object).mClass);
            }
            return super.equals(object);
        }

        public int hashCode() {
            return this.mClass.hashCode();
        }

        @Override
        public boolean isInstantiable() {
            int n = this.mClass.getModifiers();
            return !Modifier.isAbstract(n) && Modifier.isPublic(n);
        }

        public Class<?> wrappedClass() {
            return this.mClass;
        }
    }
}

