/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.resources.manager;

import com.android.ide.eclipse.adt.internal.resources.ResourceType;
import com.android.ide.eclipse.adt.internal.resources.manager.ConfigurableResourceItem;
import com.android.ide.eclipse.adt.internal.resources.manager.FolderTypeRelationship;
import com.android.ide.eclipse.adt.internal.resources.manager.ProjectResourceItem;
import com.android.ide.eclipse.adt.internal.resources.manager.ProjectResources;
import com.android.ide.eclipse.adt.internal.resources.manager.ResourceFile;
import com.android.ide.eclipse.adt.internal.resources.manager.ResourceFolder;
import com.android.ide.eclipse.adt.internal.resources.manager.files.IAbstractFile;
import com.android.layoutlib.api.IResourceValue;
import com.android.layoutlib.utils.ResourceValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.SAXParserFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleResourceFile
extends ResourceFile {
    private static final SAXParserFactory sParserFactory = SAXParserFactory.newInstance();
    private static final Pattern sXmlPattern;
    private static final Pattern[] sDrawablePattern;
    private String mResourceName;
    private ResourceType mType;
    private IResourceValue mValue;

    static {
        sParserFactory.setNamespaceAware(true);
        sXmlPattern = Pattern.compile("^(.+)\\.xml", 2);
        sDrawablePattern = new Pattern[]{Pattern.compile("^(.+)\\.9\\.png", 2), Pattern.compile("^(.+)\\.png", 2), Pattern.compile("^(.+)\\.jpg", 2), Pattern.compile("^(.+)\\.gif", 2)};
    }

    public SingleResourceFile(IAbstractFile iAbstractFile, ResourceFolder resourceFolder) {
        super(iAbstractFile, resourceFolder);
        ResourceType[] resourceTypeArray = FolderTypeRelationship.getRelatedResourceTypes(resourceFolder.getType());
        this.mType = resourceTypeArray[0];
        this.mResourceName = this.getResourceName(this.mType);
        this.mValue = new ResourceValue(this.mType.getName(), this.getResourceName(this.mType), iAbstractFile.getOsLocation(), this.isFramework());
    }

    @Override
    public ResourceType[] getResourceTypes() {
        return FolderTypeRelationship.getRelatedResourceTypes(this.getFolder().getType());
    }

    @Override
    public boolean hasResources(ResourceType resourceType) {
        return FolderTypeRelationship.match(resourceType, this.getFolder().getType());
    }

    @Override
    public Collection<ProjectResourceItem> getResources(ResourceType resourceType, ProjectResources projectResources) {
        ProjectResourceItem projectResourceItem = projectResources.findResourceItem(resourceType, this.mResourceName);
        ArrayList<ProjectResourceItem> arrayList = new ArrayList<ProjectResourceItem>();
        if (projectResourceItem == null) {
            projectResourceItem = new ConfigurableResourceItem(this.mResourceName);
            arrayList.add(projectResourceItem);
        }
        projectResourceItem.add(this);
        return arrayList;
    }

    @Override
    public IResourceValue getValue(ResourceType resourceType, String string) {
        return this.mValue;
    }

    private String getResourceName(ResourceType resourceType) {
        String string = this.getFile().getName();
        if (resourceType == ResourceType.ANIM || resourceType == ResourceType.LAYOUT || resourceType == ResourceType.MENU || resourceType == ResourceType.COLOR || resourceType == ResourceType.XML) {
            Matcher matcher = sXmlPattern.matcher(string);
            if (matcher.matches()) {
                return matcher.group(1);
            }
        } else if (resourceType == ResourceType.DRAWABLE) {
            Object object;
            Pattern[] patternArray = sDrawablePattern;
            int n = sDrawablePattern.length;
            int n2 = 0;
            while (n2 < n) {
                object = patternArray[n2];
                Matcher matcher = ((Pattern)object).matcher(string);
                if (matcher.matches()) {
                    return matcher.group(1);
                }
                ++n2;
            }
            object = sXmlPattern.matcher(string);
            if (((Matcher)object).matches()) {
                return ((Matcher)object).group(1);
            }
        }
        return string;
    }
}

