/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.resources.configurations;

import com.android.ide.eclipse.adt.internal.editors.IconFactory;
import com.android.ide.eclipse.adt.internal.resources.configurations.FolderConfiguration;
import com.android.ide.eclipse.adt.internal.resources.configurations.ResourceQualifier;
import com.android.sdklib.IAndroidTarget;
import org.eclipse.swt.graphics.Image;

public final class TextInputMethodQualifier
extends ResourceQualifier {
    public static final String NAME = "Text Input Method";
    private TextInputMethod mValue;

    public TextInputMethodQualifier() {
    }

    public TextInputMethodQualifier(TextInputMethod textInputMethod) {
        this.mValue = textInputMethod;
    }

    public TextInputMethod getValue() {
        return this.mValue;
    }

    public String getName() {
        return NAME;
    }

    public String getShortName() {
        return "Text Input";
    }

    public Image getIcon() {
        return IconFactory.getInstance().getIcon("text_input");
    }

    public boolean isValid() {
        return this.mValue != null;
    }

    public boolean checkAndSet(String string, FolderConfiguration folderConfiguration) {
        TextInputMethod textInputMethod = TextInputMethod.getEnum(string);
        if (textInputMethod != null) {
            TextInputMethodQualifier textInputMethodQualifier = new TextInputMethodQualifier();
            textInputMethodQualifier.mValue = textInputMethod;
            folderConfiguration.setTextInputMethodQualifier(textInputMethodQualifier);
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object instanceof TextInputMethodQualifier) {
            return this.mValue == ((TextInputMethodQualifier)object).mValue;
        }
        return false;
    }

    public int hashCode() {
        if (this.mValue != null) {
            return this.mValue.hashCode();
        }
        return 0;
    }

    public String getFolderSegment(IAndroidTarget iAndroidTarget) {
        if (this.mValue != null) {
            return this.mValue.getValue();
        }
        return "";
    }

    public String getStringValue() {
        if (this.mValue != null) {
            return this.mValue.getDisplayValue();
        }
        return "";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TextInputMethod {
        NOKEY("nokeys", "No Keys"),
        QWERTY("qwerty", "Qwerty"),
        TWELVEKEYS("12key", "12 Key");

        private String mValue;
        private String mDisplayValue;

        private TextInputMethod(String string2, String string3) {
            this.mValue = string2;
            this.mDisplayValue = string3;
        }

        static TextInputMethod getEnum(String string) {
            TextInputMethod[] textInputMethodArray = TextInputMethod.values();
            int n = textInputMethodArray.length;
            int n2 = 0;
            while (n2 < n) {
                TextInputMethod textInputMethod = textInputMethodArray[n2];
                if (textInputMethod.mValue.equals(string)) {
                    return textInputMethod;
                }
                ++n2;
            }
            return null;
        }

        public String getValue() {
            return this.mValue;
        }

        public String getDisplayValue() {
            return this.mDisplayValue;
        }

        public static int getIndex(TextInputMethod textInputMethod) {
            int n = 0;
            TextInputMethod[] textInputMethodArray = TextInputMethod.values();
            int n2 = textInputMethodArray.length;
            int n3 = 0;
            while (n3 < n2) {
                TextInputMethod textInputMethod2 = textInputMethodArray[n3];
                if (textInputMethod == textInputMethod2) {
                    return n;
                }
                ++n;
                ++n3;
            }
            return -1;
        }

        public static TextInputMethod getByIndex(int n) {
            int n2 = 0;
            TextInputMethod[] textInputMethodArray = TextInputMethod.values();
            int n3 = textInputMethodArray.length;
            int n4 = 0;
            while (n4 < n3) {
                TextInputMethod textInputMethod = textInputMethodArray[n4];
                if (n2 == n) {
                    return textInputMethod;
                }
                ++n2;
                ++n4;
            }
            return null;
        }
    }
}

