/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.resources.configurations;

import com.android.ide.eclipse.adt.internal.editors.IconFactory;
import com.android.ide.eclipse.adt.internal.resources.configurations.FolderConfiguration;
import com.android.ide.eclipse.adt.internal.resources.configurations.ResourceQualifier;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import org.eclipse.swt.graphics.Image;

public class ScreenSizeQualifier
extends ResourceQualifier {
    public static final String NAME = "Screen Size";
    private ScreenSize mValue = null;

    public ScreenSizeQualifier() {
    }

    public ScreenSizeQualifier(ScreenSize screenSize) {
        this.mValue = screenSize;
    }

    public ScreenSize getValue() {
        return this.mValue;
    }

    public String getName() {
        return NAME;
    }

    public String getShortName() {
        return "Size";
    }

    public Image getIcon() {
        return IconFactory.getInstance().getIcon("size");
    }

    public boolean isValid() {
        return this.mValue != null;
    }

    public boolean checkAndSet(String string, FolderConfiguration folderConfiguration) {
        ScreenSize screenSize = ScreenSize.getEnum(string);
        if (screenSize != null) {
            ScreenSizeQualifier screenSizeQualifier = new ScreenSizeQualifier(screenSize);
            folderConfiguration.setScreenSizeQualifier(screenSizeQualifier);
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object instanceof ScreenSizeQualifier) {
            return this.mValue == ((ScreenSizeQualifier)object).mValue;
        }
        return false;
    }

    public int hashCode() {
        if (this.mValue != null) {
            return this.mValue.hashCode();
        }
        return 0;
    }

    public String getFolderSegment(IAndroidTarget iAndroidTarget) {
        if (this.mValue != null) {
            if (iAndroidTarget == null) {
                return this.mValue.getValue();
            }
            AndroidVersion androidVersion = iAndroidTarget.getVersion();
            if (androidVersion.getApiLevel() >= 4 || androidVersion.getApiLevel() == 3 && "Donut".equals(androidVersion.getCodename())) {
                return this.mValue.getValue();
            }
        }
        return "";
    }

    public String getStringValue() {
        if (this.mValue != null) {
            return this.mValue.getDisplayValue();
        }
        return "";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ScreenSize {
        SMALL("small", "Small"),
        NORMAL("normal", "Normal"),
        LARGE("large", "Large");

        private String mValue;
        private String mDisplayValue;

        private ScreenSize(String string2, String string3) {
            this.mValue = string2;
            this.mDisplayValue = string3;
        }

        static ScreenSize getEnum(String string) {
            ScreenSize[] screenSizeArray = ScreenSize.values();
            int n = screenSizeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ScreenSize screenSize = screenSizeArray[n2];
                if (screenSize.mValue.equals(string)) {
                    return screenSize;
                }
                ++n2;
            }
            return null;
        }

        public String getValue() {
            return this.mValue;
        }

        public String getDisplayValue() {
            return this.mDisplayValue;
        }

        public static int getIndex(ScreenSize screenSize) {
            int n = 0;
            ScreenSize[] screenSizeArray = ScreenSize.values();
            int n2 = screenSizeArray.length;
            int n3 = 0;
            while (n3 < n2) {
                ScreenSize screenSize2 = screenSizeArray[n3];
                if (screenSize2 == screenSize) {
                    return n;
                }
                ++n;
                ++n3;
            }
            return -1;
        }

        public static ScreenSize getByIndex(int n) {
            int n2 = 0;
            ScreenSize[] screenSizeArray = ScreenSize.values();
            int n3 = screenSizeArray.length;
            int n4 = 0;
            while (n4 < n3) {
                ScreenSize screenSize = screenSizeArray[n4];
                if (n2 == n) {
                    return screenSize;
                }
                ++n2;
                ++n4;
            }
            return null;
        }
    }
}

