/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.resources.configurations;

import com.android.ide.eclipse.adt.internal.editors.IconFactory;
import com.android.ide.eclipse.adt.internal.resources.configurations.FolderConfiguration;
import com.android.ide.eclipse.adt.internal.resources.configurations.ResourceQualifier;
import com.android.sdklib.IAndroidTarget;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.graphics.Image;

public final class NetworkCodeQualifier
extends ResourceQualifier {
    private static final int DEFAULT_CODE = -1;
    private static final Pattern sNetworkCodePattern = Pattern.compile("^mnc(\\d{1,3})$");
    private int mCode = -1;
    public static final String NAME = "Mobile Network Code";

    public static NetworkCodeQualifier getQualifier(String string) {
        Matcher matcher = sNetworkCodePattern.matcher(string);
        if (matcher.matches()) {
            String string2 = matcher.group(1);
            int n = -1;
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            NetworkCodeQualifier networkCodeQualifier = new NetworkCodeQualifier();
            networkCodeQualifier.mCode = n;
            return networkCodeQualifier;
        }
        return null;
    }

    public static String getFolderSegment(int n) {
        if (n != -1 && n >= 1 && n <= 999) {
            return String.format("mnc%1$d", n);
        }
        return "";
    }

    public int getCode() {
        return this.mCode;
    }

    public String getName() {
        return NAME;
    }

    public String getShortName() {
        return "Network Code";
    }

    public Image getIcon() {
        return IconFactory.getInstance().getIcon("mnc");
    }

    public boolean isValid() {
        return this.mCode != -1;
    }

    public boolean checkAndSet(String string, FolderConfiguration folderConfiguration) {
        Matcher matcher = sNetworkCodePattern.matcher(string);
        if (matcher.matches()) {
            String string2 = matcher.group(1);
            int n = -1;
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            NetworkCodeQualifier networkCodeQualifier = new NetworkCodeQualifier();
            networkCodeQualifier.mCode = n;
            folderConfiguration.setNetworkCodeQualifier(networkCodeQualifier);
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object instanceof NetworkCodeQualifier) {
            return this.mCode == ((NetworkCodeQualifier)object).mCode;
        }
        return false;
    }

    public int hashCode() {
        return this.mCode;
    }

    public String getFolderSegment(IAndroidTarget iAndroidTarget) {
        return NetworkCodeQualifier.getFolderSegment(this.mCode);
    }

    public String getStringValue() {
        if (this.mCode != -1) {
            return String.format("MNC %1$d", this.mCode);
        }
        return "";
    }
}

