/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.resources.configurations;

import com.android.ide.eclipse.adt.internal.editors.IconFactory;
import com.android.ide.eclipse.adt.internal.resources.configurations.FolderConfiguration;
import com.android.ide.eclipse.adt.internal.resources.configurations.ResourceQualifier;
import com.android.sdklib.IAndroidTarget;
import org.eclipse.swt.graphics.Image;

public final class NavigationMethodQualifier
extends ResourceQualifier {
    public static final String NAME = "Navigation Method";
    private NavigationMethod mValue;

    public NavigationMethodQualifier() {
    }

    public NavigationMethodQualifier(NavigationMethod navigationMethod) {
        this.mValue = navigationMethod;
    }

    public NavigationMethod getValue() {
        return this.mValue;
    }

    public String getName() {
        return NAME;
    }

    public String getShortName() {
        return "Navigation";
    }

    public Image getIcon() {
        return IconFactory.getInstance().getIcon("navpad");
    }

    public boolean isValid() {
        return this.mValue != null;
    }

    public boolean checkAndSet(String string, FolderConfiguration folderConfiguration) {
        NavigationMethod navigationMethod = NavigationMethod.getEnum(string);
        if (navigationMethod != null) {
            NavigationMethodQualifier navigationMethodQualifier = new NavigationMethodQualifier();
            navigationMethodQualifier.mValue = navigationMethod;
            folderConfiguration.setNavigationMethodQualifier(navigationMethodQualifier);
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object instanceof NavigationMethodQualifier) {
            return this.mValue == ((NavigationMethodQualifier)object).mValue;
        }
        return false;
    }

    public int hashCode() {
        if (this.mValue != null) {
            return this.mValue.hashCode();
        }
        return 0;
    }

    public String getFolderSegment(IAndroidTarget iAndroidTarget) {
        if (this.mValue != null) {
            return this.mValue.getValue();
        }
        return "";
    }

    public String getStringValue() {
        if (this.mValue != null) {
            return this.mValue.getDisplayValue();
        }
        return "";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NavigationMethod {
        DPAD("dpad", "D-pad"),
        TRACKBALL("trackball", "Trackball"),
        WHEEL("wheel", "Wheel"),
        NONAV("nonav", "No Navigation");

        private String mValue;
        private String mDisplay;

        private NavigationMethod(String string2, String string3) {
            this.mValue = string2;
            this.mDisplay = string3;
        }

        static NavigationMethod getEnum(String string) {
            NavigationMethod[] navigationMethodArray = NavigationMethod.values();
            int n = navigationMethodArray.length;
            int n2 = 0;
            while (n2 < n) {
                NavigationMethod navigationMethod = navigationMethodArray[n2];
                if (navigationMethod.mValue.equals(string)) {
                    return navigationMethod;
                }
                ++n2;
            }
            return null;
        }

        public String getValue() {
            return this.mValue;
        }

        public String getDisplayValue() {
            return this.mDisplay;
        }

        public static int getIndex(NavigationMethod navigationMethod) {
            int n = 0;
            NavigationMethod[] navigationMethodArray = NavigationMethod.values();
            int n2 = navigationMethodArray.length;
            int n3 = 0;
            while (n3 < n2) {
                NavigationMethod navigationMethod2 = navigationMethodArray[n3];
                if (navigationMethod2 == navigationMethod) {
                    return n;
                }
                ++n;
                ++n3;
            }
            return -1;
        }

        public static NavigationMethod getByIndex(int n) {
            int n2 = 0;
            NavigationMethod[] navigationMethodArray = NavigationMethod.values();
            int n3 = navigationMethodArray.length;
            int n4 = 0;
            while (n4 < n3) {
                NavigationMethod navigationMethod = navigationMethodArray[n4];
                if (n2 == n) {
                    return navigationMethod;
                }
                ++n2;
                ++n4;
            }
            return null;
        }
    }
}

