/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.refactorings.extractstring;

import com.android.ide.eclipse.adt.internal.refactorings.extractstring.ExtractStringRefactoring;
import com.android.ide.eclipse.adt.internal.refactorings.extractstring.XmlStringFileHelper;
import com.android.ide.eclipse.adt.internal.resources.configurations.FolderConfiguration;
import com.android.ide.eclipse.adt.internal.resources.manager.ResourceFolderType;
import com.android.ide.eclipse.adt.internal.ui.ConfigurationSelector;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

class ExtractStringInputPage
extends UserInputWizardPage
implements IWizardPage {
    private static HashMap<String, String> sLastResFilePath = new HashMap();
    private final IProject mProject;
    private Combo mStringIdCombo;
    private Text mStringValueField;
    private ConfigurationSelector mConfigSelector;
    private Combo mResFileCombo;
    private static final Pattern RES_XML_FILE_REGEX = Pattern.compile("/res/[a-z][a-zA-Z0-9_-]+/[^.]+\\.xml");
    private static final String RES_FOLDER_ABS = "/res/";
    private static final String RES_FOLDER_REL = "res/";
    private static final String DEFAULT_RES_FILE_PATH = "/res/values/strings.xml";
    private XmlStringFileHelper mXmlHelper = new XmlStringFileHelper();

    public ExtractStringInputPage(IProject iProject) {
        super("ExtractStringInputPage");
        this.mProject = iProject;
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite2.setLayout((Layout)gridLayout);
        this.createStringGroup(composite2);
        this.createResFileGroup(composite2);
        this.validatePage();
        this.setControl((Control)composite2);
    }

    public void createStringGroup(Composite composite) {
        ExtractStringRefactoring extractStringRefactoring = this.getOurRefactoring();
        Group group = new Group(composite, 0);
        group.setLayoutData((Object)new GridData(768));
        if (extractStringRefactoring.getMode() == ExtractStringRefactoring.Mode.EDIT_SOURCE) {
            group.setText("String Replacement");
        } else {
            group.setText("New String");
        }
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        group.setLayout((Layout)gridLayout);
        Label label = new Label((Composite)group, 0);
        label.setText("&String");
        String string = extractStringRefactoring.getTokenString();
        this.mStringValueField = new Text((Composite)group, 18436);
        this.mStringValueField.setLayoutData((Object)new GridData(768));
        this.mStringValueField.setText(string != null ? string : "");
        extractStringRefactoring.setNewStringValue(this.mStringValueField.getText());
        this.mStringValueField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                ExtractStringInputPage.this.validatePage();
            }
        });
        label = new Label((Composite)group, 0);
        if (extractStringRefactoring.getMode() == ExtractStringRefactoring.Mode.EDIT_SOURCE) {
            label.setText("&Replace by R.string.");
        } else if (extractStringRefactoring.getMode() == ExtractStringRefactoring.Mode.SELECT_NEW_ID) {
            label.setText("New &R.string.");
        } else {
            label.setText("ID &R.string.");
        }
        this.mStringIdCombo = new Combo((Composite)group, 18436);
        this.mStringIdCombo.setLayoutData((Object)new GridData(768));
        this.mStringIdCombo.setText(this.guessId(string));
        this.mStringIdCombo.forceFocus();
        extractStringRefactoring.setNewStringId(this.mStringIdCombo.getText().trim());
        this.mStringIdCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                ExtractStringInputPage.this.validatePage();
            }
        });
        this.mStringIdCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ExtractStringInputPage.this.validatePage();
            }
        });
    }

    private void createResFileGroup(Composite composite) {
        Group group = new Group(composite, 0);
        group.setLayoutData((Object)new GridData(768));
        group.setText("XML resource to edit");
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        group.setLayout((Layout)gridLayout);
        Label label = new Label((Composite)group, 0);
        label.setText("&Configuration:");
        this.mConfigSelector = new ConfigurationSelector((Composite)group);
        GridData gridData = new GridData(1536);
        gridData.horizontalSpan = 2;
        gridData.widthHint = 600;
        gridData.heightHint = 250;
        this.mConfigSelector.setLayoutData(gridData);
        OnConfigSelectorUpdated onConfigSelectorUpdated2 = new OnConfigSelectorUpdated();
        this.mConfigSelector.setOnChangeListener(onConfigSelectorUpdated2);
        label = new Label((Composite)group, 0);
        label.setText("Resource &file:");
        this.mResFileCombo = new Combo((Composite)group, 4);
        this.mResFileCombo.select(0);
        this.mResFileCombo.setLayoutData((Object)new GridData(768));
        this.mResFileCombo.addModifyListener((ModifyListener)onConfigSelectorUpdated2);
        String string = this.mProject.getFullPath().toPortableString();
        String string2 = sLastResFilePath.get(string);
        this.mResFileCombo.setText(string2 != null ? string2 : DEFAULT_RES_FILE_PATH);
        onConfigSelectorUpdated2.run();
    }

    private String guessId(String string) {
        if (string == null) {
            return "";
        }
        string = string.toLowerCase();
        if ((string = string.replaceAll("[^a-zA-Z0-9]+", "_")).length() > 0 && !Character.isJavaIdentifierStart(string.charAt(0))) {
            string = "_" + string;
        }
        return string;
    }

    private ExtractStringRefactoring getOurRefactoring() {
        return (ExtractStringRefactoring)this.getRefactoring();
    }

    private boolean validatePage() {
        boolean bl = true;
        ExtractStringRefactoring extractStringRefactoring = this.getOurRefactoring();
        String string = this.mStringIdCombo.getText().trim();
        if (string == null || string.length() < 1) {
            this.setErrorMessage("Please provide a resource ID.");
            bl = false;
        } else {
            int n = 0;
            while (n < string.length()) {
                boolean bl2;
                char c = string.charAt(n);
                boolean bl3 = bl2 = n == 0 ? Character.isJavaIdentifierStart(c) : Character.isJavaIdentifierPart(c);
                if (!bl2) {
                    this.setErrorMessage(String.format("The resource ID must be a valid Java identifier. The character %1$c at position %2$d is not acceptable.", Character.valueOf(c), n + 1));
                    bl = false;
                    break;
                }
                ++n;
            }
            if (bl) {
                extractStringRefactoring.setNewStringId(string);
            }
        }
        String string2 = this.mResFileCombo.getText();
        if (bl) {
            if (string2 == null || string2.length() == 0) {
                this.setErrorMessage("A resource file name is required.");
                bl = false;
            } else if (!RES_XML_FILE_REGEX.matcher(string2).matches()) {
                this.setErrorMessage("The XML file name is not valid.");
                bl = false;
            }
        }
        if (bl) {
            this.setErrorMessage(null);
            extractStringRefactoring.setTargetFile(string2);
            sLastResFilePath.put(this.mProject.getFullPath().toPortableString(), string2);
            String string3 = this.mXmlHelper.valueOfStringId(this.mProject, string2, string);
            if (string3 != null) {
                String string4 = String.format("%1$s already contains a string ID '%2$s' with value '%3$s'.", string2, string, string3);
                if (extractStringRefactoring.getMode() == ExtractStringRefactoring.Mode.SELECT_NEW_ID) {
                    this.setErrorMessage(string4);
                    bl = false;
                } else {
                    this.setMessage(string4, 2);
                }
            } else if (this.mProject.findMember(string2) == null) {
                this.setMessage(String.format("File %2$s does not exist and will be created.", string, string2), 1);
            } else {
                this.setMessage(null);
            }
        }
        if (bl) {
            extractStringRefactoring.setNewStringValue(this.mStringValueField.getText());
        }
        this.setPageComplete(bl);
        return bl;
    }

    private void updateStringValueCombo() {
        String string = this.mResFileCombo.getText();
        Map<String, String> map = this.mXmlHelper.getResIdsForFile(this.mProject, string);
        String string2 = this.mStringIdCombo.getText();
        this.mStringIdCombo.removeAll();
        this.mStringIdCombo.setItems(map.keySet().toArray(new String[map.size()]));
        if (!string2.equals(this.mStringIdCombo.getText())) {
            this.mStringIdCombo.setText(string2);
        }
    }

    public class OnConfigSelectorUpdated
    implements Runnable,
    ModifyListener {
        private final Pattern mPathRegex = Pattern.compile("(/res/[a-z][a-zA-Z0-9_-]+/)(.+)");
        private FolderConfiguration mTempConfig = new FolderConfiguration();
        private HashMap<String, TreeSet<String>> mFolderCache = new HashMap();
        private String mLastFolderUsedInCombo = null;
        private boolean mInternalConfigChange;
        private boolean mInternalFileComboChange;

        public void run() {
            if (this.mInternalConfigChange) {
                return;
            }
            String string = "";
            String string2 = ExtractStringInputPage.this.mResFileCombo.getText();
            Matcher matcher = this.mPathRegex.matcher(string2);
            if (matcher.matches()) {
                string = matcher.group(2);
                string2 = matcher.group(1);
            } else {
                string2 = "";
            }
            ExtractStringInputPage.this.mConfigSelector.getConfiguration(this.mTempConfig);
            StringBuffer stringBuffer = new StringBuffer(ExtractStringInputPage.RES_FOLDER_ABS);
            stringBuffer.append(this.mTempConfig.getFolderName(ResourceFolderType.VALUES, ExtractStringInputPage.this.mProject));
            stringBuffer.append('/');
            String string3 = stringBuffer.toString();
            if (string3.equals(string2) && string3.equals(this.mLastFolderUsedInCombo)) {
                return;
            }
            TreeSet<String> treeSet = this.mFolderCache.get(string3);
            if (treeSet == null) {
                treeSet = new TreeSet();
                IFolder object = ExtractStringInputPage.this.mProject.getFolder(string3);
                if (object != null && object.exists()) {
                    try {
                        IResource[] iResourceArray = object.members();
                        int n = iResourceArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IResource iResource = iResourceArray[n2];
                            String string4 = iResource.getName();
                            if (iResource.getType() == 1 && string4.endsWith(".xml")) {
                                treeSet.add(String.valueOf(string3) + string4);
                            }
                            ++n2;
                        }
                    }
                    catch (CoreException coreException) {}
                }
                this.mFolderCache.put(string3, treeSet);
            }
            string2 = String.valueOf(string3) + string;
            if (string.length() > 0 && !treeSet.contains(string2)) {
                treeSet.add(string2);
            }
            try {
                int n;
                this.mInternalFileComboChange = true;
                ExtractStringInputPage.this.mResFileCombo.removeAll();
                for (String string5 : treeSet) {
                    ExtractStringInputPage.this.mResFileCombo.add(string5);
                }
                int n3 = -1;
                if (string.length() > 0 && (n = ExtractStringInputPage.this.mResFileCombo.indexOf(string2)) >= 0) {
                    ExtractStringInputPage.this.mResFileCombo.select(n);
                }
                if (n == -1) {
                    ExtractStringInputPage.this.mResFileCombo.setText(string2);
                }
                this.mLastFolderUsedInCombo = string3;
            }
            finally {
                this.mInternalFileComboChange = false;
            }
            ExtractStringInputPage.this.updateStringValueCombo();
            ExtractStringInputPage.this.validatePage();
        }

        public void modifyText(ModifyEvent modifyEvent) {
            if (this.mInternalFileComboChange) {
                return;
            }
            String string = ExtractStringInputPage.this.mResFileCombo.getText();
            string = string.replaceAll("/+\\.\\./+|/+\\./+|//+|\\\\+|^/+", "/");
            string = string.replaceAll("^\\.\\./+|^\\./+", "");
            if ((string = string.replaceAll("/+\\.\\.$|/+\\.$|/+$", "")).startsWith(ExtractStringInputPage.RES_FOLDER_REL)) {
                string = ExtractStringInputPage.RES_FOLDER_ABS + string.substring(ExtractStringInputPage.RES_FOLDER_REL.length());
                this.mInternalFileComboChange = true;
                ExtractStringInputPage.this.mResFileCombo.setText(string);
                this.mInternalFileComboChange = false;
            }
            if (string.startsWith(ExtractStringInputPage.RES_FOLDER_ABS)) {
                String string2;
                String[] stringArray;
                int n = (string = string.substring(ExtractStringInputPage.RES_FOLDER_ABS.length())).indexOf(47);
                if (n >= 0) {
                    string = string.substring(0, n);
                }
                if ((stringArray = string.split("-")).length > 0 && (string2 = stringArray[0]) != null && !string2.equals(string)) {
                    this.mInternalConfigChange = true;
                    ExtractStringInputPage.this.mConfigSelector.setConfiguration(stringArray);
                    this.mInternalConfigChange = false;
                }
            }
            ExtractStringInputPage.this.updateStringValueCombo();
            ExtractStringInputPage.this.validatePage();
        }
    }
}

