/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.refactorings.extractstring;

import com.android.ide.eclipse.adt.internal.refactorings.extractstring.ExtractStringRefactoring;
import com.android.ide.eclipse.adt.internal.refactorings.extractstring.ExtractStringWizard;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class ExtractStringAction
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow mWindow;
    private ITextSelection mSelection;
    private IEditorPart mEditor;
    private IFile mFile;

    public void init(IWorkbenchWindow iWorkbenchWindow) {
        this.mWindow = iWorkbenchWindow;
    }

    public void dispose() {
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        this.mSelection = null;
        this.mFile = null;
        if (iSelection instanceof ITextSelection) {
            this.mSelection = (ITextSelection)iSelection;
            if (this.mSelection.getLength() > 0) {
                this.mEditor = this.getActiveEditor();
                this.mFile = this.getSelectedFile(this.mEditor);
            }
        }
        iAction.setEnabled(this.mSelection != null && this.mFile != null);
    }

    public void run(IAction iAction) {
        if (this.mSelection != null && this.mFile != null) {
            ExtractStringRefactoring extractStringRefactoring = new ExtractStringRefactoring(this.mFile, this.mEditor, this.mSelection);
            ExtractStringWizard extractStringWizard = new ExtractStringWizard(extractStringRefactoring, this.mFile.getProject());
            RefactoringWizardOpenOperation refactoringWizardOpenOperation = new RefactoringWizardOpenOperation((RefactoringWizard)extractStringWizard);
            try {
                refactoringWizardOpenOperation.run(this.mWindow.getShell(), extractStringWizard.getDefaultPageTitle());
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private IEditorPart getActiveEditor() {
        IWorkbenchPage iWorkbenchPage;
        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null && (iWorkbenchPage = iWorkbenchWindow.getActivePage()) != null) {
            return iWorkbenchPage.getActiveEditor();
        }
        return null;
    }

    private IFile getSelectedFile(IEditorPart iEditorPart) {
        FileEditorInput fileEditorInput;
        IFile iFile;
        IEditorInput iEditorInput;
        if (iEditorPart != null && (iEditorInput = iEditorPart.getEditorInput()) instanceof FileEditorInput && (iFile = (fileEditorInput = (FileEditorInput)iEditorInput).getFile()).exists()) {
            IProject iProject = iFile.getProject();
            try {
                if (iProject != null && iProject.hasNature("com.android.ide.eclipse.adt.AndroidNature")) {
                    return iFile;
                }
            }
            catch (CoreException coreException) {}
        }
        return null;
    }
}

