/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.properties;

import com.android.ide.eclipse.adt.internal.sdk.Sdk;
import com.android.sdklib.IAndroidTarget;
import com.android.sdkuilib.internal.widgets.ApkConfigWidget;
import com.android.sdkuilib.internal.widgets.SdkTargetSelector;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;

public class AndroidPropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    private IProject mProject;
    private SdkTargetSelector mSelector;
    private ApkConfigWidget mApkConfigWidget;

    protected Control createContents(Composite composite) {
        this.mProject = (IProject)this.getElement();
        IAndroidTarget[] iAndroidTargetArray = null;
        if (Sdk.getCurrent() != null) {
            iAndroidTargetArray = Sdk.getCurrent().getTargets();
        }
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(1808));
        composite2.setLayout((Layout)new GridLayout(1, false));
        Label label = new Label(composite2, 0);
        label.setText("Project Build Target");
        this.mSelector = new SdkTargetSelector(composite2, iAndroidTargetArray);
        label = new Label(composite2, 258);
        label.setLayoutData((Object)new GridData(768));
        label = new Label(composite2, 0);
        label.setText("Project APK Configurations");
        this.mApkConfigWidget = new ApkConfigWidget(composite2);
        Sdk sdk = Sdk.getCurrent();
        if (sdk != null && this.mProject.isOpen()) {
            IAndroidTarget iAndroidTarget = sdk.getTarget(this.mProject);
            if (iAndroidTarget != null) {
                this.mSelector.setSelection(iAndroidTarget);
            }
            Map<String, String> map = sdk.getProjectApkConfigs(this.mProject);
            this.mApkConfigWidget.fillTable(map);
        }
        this.mSelector.setSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                IAndroidTarget iAndroidTarget = AndroidPropertyPage.this.mSelector.getSelected();
                AndroidPropertyPage.this.setValid(iAndroidTarget != null);
            }
        });
        this.mProject.isOpen();
        return composite2;
    }

    public boolean performOk() {
        Sdk sdk = Sdk.getCurrent();
        if (sdk != null) {
            sdk.setProject(this.mProject, this.mSelector.getSelected(), this.mApkConfigWidget.getApkConfigs());
        }
        return true;
    }
}

