/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.project;

import com.android.ide.eclipse.adt.internal.project.BaseProjectHelper;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlErrorHandler
extends DefaultHandler {
    private IFile mFile;
    private XmlErrorListener mErrorListener;

    public XmlErrorHandler(IFile iFile, XmlErrorListener xmlErrorListener) {
        this.mFile = iFile;
        this.mErrorListener = xmlErrorListener;
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        this.handleError(sAXParseException, sAXParseException.getLineNumber());
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.handleError(sAXParseException, sAXParseException.getLineNumber());
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        if (this.mFile != null) {
            BaseProjectHelper.addMarker((IResource)this.mFile, "com.android.ide.eclipse.common.xmlProblem", sAXParseException.getMessage(), sAXParseException.getLineNumber(), 1);
        }
    }

    protected final IFile getFile() {
        return this.mFile;
    }

    protected void handleError(Exception exception, int n) {
        String string;
        if (this.mErrorListener != null) {
            this.mErrorListener.errorFound();
        }
        if ((string = exception.getMessage()) == null) {
            string = "Unknown error " + exception.getClass().getCanonicalName();
        }
        if (this.mFile != null) {
            if (n != -1) {
                BaseProjectHelper.addMarker((IResource)this.mFile, "com.android.ide.eclipse.common.xmlProblem", string, n, 2);
            } else {
                BaseProjectHelper.addMarker((IResource)this.mFile, "com.android.ide.eclipse.common.xmlProblem", string, 2);
            }
        }
    }

    public static class BasicXmlErrorListener
    implements XmlErrorListener {
        public boolean mHasXmlError = false;

        public void errorFound() {
            this.mHasXmlError = true;
        }
    }

    public static interface XmlErrorListener {
        public void errorFound();
    }
}

