/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.project;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.AndroidConstants;
import com.android.ide.eclipse.adt.internal.project.AndroidClasspathContainerInitializer;
import com.android.ide.eclipse.adt.internal.project.AndroidManifestParser;
import com.android.ide.eclipse.adt.internal.project.BaseProjectHelper;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProjectHelper {
    public static final int COMPILER_COMPLIANCE_OK = 0;
    public static final int COMPILER_COMPLIANCE_LEVEL = 1;
    public static final int COMPILER_COMPLIANCE_SOURCE = 2;
    public static final int COMPILER_COMPLIANCE_CODEGEN_TARGET = 3;

    public static IClasspathEntry[] addEntryToClasspath(IClasspathEntry[] iClasspathEntryArray, IClasspathEntry iClasspathEntry) {
        int n = iClasspathEntryArray.length;
        IClasspathEntry[] iClasspathEntryArray2 = new IClasspathEntry[n + 1];
        System.arraycopy(iClasspathEntryArray, 0, iClasspathEntryArray2, 0, n);
        iClasspathEntryArray2[n] = iClasspathEntry;
        return iClasspathEntryArray2;
    }

    public static void addEntryToClasspath(IJavaProject iJavaProject, IClasspathEntry iClasspathEntry) throws JavaModelException {
        IClasspathEntry[] iClasspathEntryArray = iJavaProject.getRawClasspath();
        iClasspathEntryArray = ProjectHelper.addEntryToClasspath(iClasspathEntryArray, iClasspathEntry);
        iJavaProject.setRawClasspath(iClasspathEntryArray, (IProgressMonitor)new NullProgressMonitor());
    }

    public static IClasspathEntry[] removeEntryFromClasspath(IClasspathEntry[] iClasspathEntryArray, int n) {
        int n2 = iClasspathEntryArray.length;
        IClasspathEntry[] iClasspathEntryArray2 = new IClasspathEntry[n2 - 1];
        System.arraycopy(iClasspathEntryArray, 0, iClasspathEntryArray2, 0, n);
        System.arraycopy(iClasspathEntryArray, n + 1, iClasspathEntryArray2, n, iClasspathEntryArray.length - n - 1);
        return iClasspathEntryArray2;
    }

    public static String getJavaDocPath(String string) {
        String string2 = string.replaceAll("\\\\", "/");
        if (string2.startsWith("/")) {
            return "file:" + string2;
        }
        return "file:/" + string2;
    }

    public static int findClasspathEntryByPath(IClasspathEntry[] iClasspathEntryArray, String string, int n) {
        int n2 = 0;
        while (n2 < iClasspathEntryArray.length) {
            IPath iPath;
            String string2;
            IClasspathEntry iClasspathEntry = iClasspathEntryArray[n2];
            int n3 = iClasspathEntry.getEntryKind();
            if ((n3 == n || n == 0) && (string2 = (iPath = iClasspathEntry.getPath()).toOSString()).equals(string)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public static int findClasspathEntryByName(IClasspathEntry[] iClasspathEntryArray, String string, int n, int n2) {
        if (n2 < 0) {
            n2 = 0;
        }
        int n3 = n2;
        while (n3 < iClasspathEntryArray.length) {
            IPath iPath;
            String string2;
            IClasspathEntry iClasspathEntry = iClasspathEntryArray[n3];
            int n4 = iClasspathEntry.getEntryKind();
            if ((n4 == n || n == 0) && (string2 = (iPath = iClasspathEntry.getPath()).segment(iPath.segmentCount() - 1)).equals(string)) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public static void fixProject(IProject iProject) throws JavaModelException {
        if (AdtPlugin.getOsSdkFolder().length() == 0) {
            AdtPlugin.printToConsole(iProject, "Unknown SDK Location, project not fixed.");
            return;
        }
        IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
        ProjectHelper.fixProjectClasspathEntries(iJavaProject);
    }

    public static void fixProjectClasspathEntries(IJavaProject iJavaProject) throws JavaModelException {
        IClasspathEntry[] iClasspathEntryArray;
        IClasspathEntry[] iClasspathEntryArray2 = iClasspathEntryArray = iJavaProject.getRawClasspath();
        int n = ProjectHelper.findClasspathEntryByPath(iClasspathEntryArray, JavaRuntime.JRE_CONTAINER, 5);
        if (n != -1) {
            iClasspathEntryArray = ProjectHelper.removeEntryFromClasspath(iClasspathEntryArray, n);
        }
        IPath iPath = iJavaProject.getOutputLocation();
        boolean bl = false;
        int n2 = 0;
        while (n2 < iClasspathEntryArray.length) {
            IClasspathEntry iClasspathEntry = iClasspathEntryArray[n2];
            int n3 = iClasspathEntry.getEntryKind();
            if (n3 == 3) {
                IPath iPath2 = iClasspathEntry.getPath();
                if (iPath2.equals((Object)iPath)) {
                    iClasspathEntryArray = ProjectHelper.removeEntryFromClasspath(iClasspathEntryArray, n2);
                    continue;
                }
            } else if (n3 == 5 && AndroidClasspathContainerInitializer.checkPath(iClasspathEntry.getPath())) {
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            iClasspathEntryArray = ProjectHelper.addEntryToClasspath(iClasspathEntryArray, AndroidClasspathContainerInitializer.getContainerEntry());
        }
        if (iClasspathEntryArray != iClasspathEntryArray2) {
            iJavaProject.setRawClasspath(iClasspathEntryArray, (IProgressMonitor)new NullProgressMonitor());
        }
        ProjectHelper.checkAndFixCompilerCompliance(iJavaProject);
    }

    public static final int checkCompilerCompliance(IJavaProject iJavaProject) {
        String string = iJavaProject.getOption("org.eclipse.jdt.core.compiler.compliance", true);
        if (!ProjectHelper.checkCompliance(string)) {
            return 1;
        }
        String string2 = iJavaProject.getOption("org.eclipse.jdt.core.compiler.source", true);
        if (!ProjectHelper.checkCompliance(string2)) {
            return 2;
        }
        String string3 = iJavaProject.getOption("org.eclipse.jdt.core.compiler.codegen.targetPlatform", true);
        if (!ProjectHelper.checkCompliance(string3)) {
            return 3;
        }
        return 0;
    }

    public static final int checkCompilerCompliance(IProject iProject) {
        IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
        return ProjectHelper.checkCompilerCompliance(iJavaProject);
    }

    public static final void checkAndFixCompilerCompliance(IProject iProject) {
        IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
        ProjectHelper.checkAndFixCompilerCompliance(iJavaProject);
    }

    public static final void checkAndFixCompilerCompliance(IJavaProject iJavaProject) {
        if (ProjectHelper.checkCompilerCompliance(iJavaProject) != 0) {
            iJavaProject.setOption("org.eclipse.jdt.core.compiler.compliance", "1.5");
            iJavaProject.setOption("org.eclipse.jdt.core.compiler.source", "1.5");
            iJavaProject.setOption("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
            try {
                iJavaProject.getProject().build(15, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {
                AdtPlugin.printErrorToConsole(iJavaProject.getProject(), new Object[]{"Project compiler settings changed. Clean your project."});
            }
        }
    }

    public static IProject findAndroidProjectByAppName(String string) {
        IProject[] iProjectArray;
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        IProject[] iProjectArray2 = iProjectArray = iWorkspace.getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            block11: {
                IProject iProject = iProjectArray2[n2];
                if (!iProject.isOpen()) break block11;
                try {
                    if (!iProject.hasNature("com.android.ide.eclipse.adt.AndroidNature")) {
                    }
                }
                catch (CoreException coreException) {}
                break block11;
                IFile iFile = AndroidManifestParser.getManifest(iProject);
                if (iFile != null) {
                    AndroidManifestParser androidManifestParser = null;
                    try {
                        androidManifestParser = AndroidManifestParser.parseForData(iFile);
                    }
                    catch (CoreException coreException) {}
                    if (androidManifestParser != null) {
                        String[] stringArray;
                        String string2 = androidManifestParser.getPackage();
                        if (string2 != null && string2.equals(string)) {
                            return iProject;
                        }
                        String[] stringArray2 = stringArray = androidManifestParser.getProcesses();
                        int n3 = stringArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String string3 = stringArray2[n4];
                            if (string3.equals(string)) {
                                return iProject;
                            }
                            ++n4;
                        }
                    }
                }
            }
            ++n2;
        }
        return null;
    }

    public static void fixProjectNatureOrder(IProject iProject) throws CoreException {
        IProjectDescription iProjectDescription = iProject.getDescription();
        String[] stringArray = iProjectDescription.getNatureIds();
        if (!"com.android.ide.eclipse.adt.AndroidNature".equals(stringArray[0])) {
            int n = 0;
            while (n < stringArray.length) {
                if ("com.android.ide.eclipse.adt.AndroidNature".equals(stringArray[n])) {
                    ProjectHelper.removeNature(iProject, "com.android.ide.eclipse.adt.AndroidNature");
                    iProjectDescription = iProject.getDescription();
                    stringArray = iProjectDescription.getNatureIds();
                    String[] stringArray2 = new String[stringArray.length + 1];
                    stringArray2[0] = "com.android.ide.eclipse.adt.AndroidNature";
                    System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
                    iProjectDescription.setNatureIds(stringArray2);
                    iProject.setDescription(iProjectDescription, null);
                    break;
                }
                ++n;
            }
        }
    }

    public static void removeNature(IProject iProject, String string) throws CoreException {
        IProjectDescription iProjectDescription = iProject.getDescription();
        String[] stringArray = iProjectDescription.getNatureIds();
        int n = 0;
        while (n < stringArray.length) {
            if (string.equals(stringArray[n])) {
                String[] stringArray2 = new String[stringArray.length - 1];
                if (n > 0) {
                    System.arraycopy(stringArray, 0, stringArray2, 0, n);
                }
                System.arraycopy(stringArray, n + 1, stringArray2, n, stringArray.length - n - 1);
                iProjectDescription.setNatureIds(stringArray2);
                iProject.setDescription(iProjectDescription, null);
                return;
            }
            ++n;
        }
    }

    public static boolean hasError(IProject iProject, boolean bl) throws CoreException {
        IMarker iMarker;
        int n;
        IMarker[] iMarkerArray = iProject.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
        if (iMarkerArray != null && iMarkerArray.length > 0) {
            IMarker[] iMarkerArray2 = iMarkerArray;
            n = iMarkerArray.length;
            int n2 = 0;
            while (n2 < n) {
                iMarker = iMarkerArray2[n2];
                int n3 = iMarker.getAttribute("severity", -1);
                if (n3 == 2) {
                    return true;
                }
                ++n2;
            }
        }
        if (bl) {
            IMarker iMarker2 = iMarker = ProjectHelper.getReferencedProjects(iProject);
            int n4 = ((IProject[])iMarker2).length;
            n = 0;
            while (n < n4) {
                IMarker iMarker3 = iMarker2[n];
                if (ProjectHelper.hasError((IProject)iMarker3, false)) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public static boolean saveStringProperty(IResource iResource, String string, String string2) {
        QualifiedName qualifiedName = new QualifiedName("com.android.ide.eclipse.adt", string);
        try {
            iResource.setPersistentProperty(qualifiedName, string2);
        }
        catch (CoreException coreException) {
            return false;
        }
        return true;
    }

    public static String loadStringProperty(IResource iResource, String string) {
        QualifiedName qualifiedName = new QualifiedName("com.android.ide.eclipse.adt", string);
        try {
            String string2 = iResource.getPersistentProperty(qualifiedName);
            return string2;
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public static boolean saveBooleanProperty(IResource iResource, String string, boolean bl) {
        return ProjectHelper.saveStringProperty(iResource, string, Boolean.toString(bl));
    }

    public static boolean loadBooleanProperty(IResource iResource, String string, boolean bl) {
        String string2 = ProjectHelper.loadStringProperty(iResource, string);
        if (string2 != null) {
            return Boolean.parseBoolean(string2);
        }
        return bl;
    }

    public static boolean saveResourceProperty(IResource iResource, String string, IResource iResource2) {
        if (iResource2 != null) {
            IPath iPath = iResource2.getProjectRelativePath();
            return ProjectHelper.saveStringProperty(iResource, string, iPath.toString());
        }
        return ProjectHelper.saveStringProperty(iResource, string, "");
    }

    public static IResource loadResourceProperty(IResource iResource, String string) {
        String string2 = ProjectHelper.loadStringProperty(iResource, string);
        if (string2 != null && string2.length() > 0) {
            return iResource.getProject().findMember(string2);
        }
        return null;
    }

    public static IProject[] getReferencedProjects(IProject iProject) throws CoreException {
        IProject[] iProjectArray = iProject.getReferencedProjects();
        ArrayList<IProject> arrayList = new ArrayList<IProject>();
        IProject[] iProjectArray2 = iProjectArray;
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject iProject2 = iProjectArray2[n2];
            if (iProject2.isOpen() && iProject2.hasNature("org.eclipse.jdt.core.javanature")) {
                arrayList.add(iProject2);
            }
            ++n2;
        }
        return arrayList.toArray(new IProject[arrayList.size()]);
    }

    private static boolean checkCompliance(String string) {
        String[] stringArray = AndroidConstants.COMPILER_COMPLIANCE;
        int n = AndroidConstants.COMPILER_COMPLIANCE.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray[n2];
            if (string2 != null && string2.equals(string)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String getApkFilename(IProject iProject, String string) {
        if (string != null) {
            return String.valueOf(iProject.getName()) + "-" + string + ".apk";
        }
        return String.valueOf(iProject.getName()) + ".apk";
    }

    public static List<IJavaProject> getAndroidProjectDependencies(IJavaProject iJavaProject) throws JavaModelException {
        String[] stringArray = iJavaProject.getRequiredProjectNames();
        IJavaModel iJavaModel = iJavaProject.getJavaModel();
        ArrayList<IJavaProject> arrayList = new ArrayList<IJavaProject>(stringArray.length);
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            block4: {
                String string = stringArray2[n2];
                IJavaProject iJavaProject2 = iJavaModel.getJavaProject(string);
                try {
                    if (!iJavaProject2.getProject().hasNature("com.android.ide.eclipse.adt.AndroidNature")) {
                    }
                }
                catch (CoreException coreException) {}
                break block4;
                arrayList.add(iJavaProject2);
            }
            ++n2;
        }
        return arrayList;
    }

    public static IFile getApplicationPackage(IProject iProject) {
        IFolder iFolder = BaseProjectHelper.getOutputFolder(iProject);
        if (iFolder == null) {
            AdtPlugin.printErrorToConsole(iProject, new Object[]{"Failed to get the output location of the project. Check build path properties"});
            return null;
        }
        String string = String.valueOf(iProject.getName()) + ".apk";
        IResource iResource = iFolder.findMember(string);
        if (iResource instanceof IFile && iResource.exists()) {
            return (IFile)iResource;
        }
        String string2 = String.format("Could not find %1$s!", string);
        AdtPlugin.printErrorToConsole(iProject, new Object[]{string2});
        return null;
    }
}

