/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.project;

import com.android.ide.eclipse.adt.AdtPlugin;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;

public class FolderDecorator
implements ILightweightLabelDecorator {
    private ImageDescriptor mDescriptor = AdtPlugin.getImageDescriptor("/icons/android_project.png");

    public void decorate(Object object, IDecoration iDecoration) {
        if (object instanceof IFolder) {
            IFolder iFolder = (IFolder)object;
            IProject iProject = iFolder.getProject();
            try {
                if (iProject.hasNature("com.android.ide.eclipse.adt.AndroidNature") && iFolder.getParent().getType() == 4) {
                    String string = iFolder.getName();
                    if (string.equals("assets")) {
                        this.doDecoration(iDecoration, null);
                    } else if (string.equals("res")) {
                        this.doDecoration(iDecoration, null);
                    } else if (string.equals("gen")) {
                        this.doDecoration(iDecoration, " [Generated Java Files]");
                    } else if (string.equals("libs")) {
                        this.doDecoration(iDecoration, null);
                    }
                }
            }
            catch (CoreException coreException) {
                AdtPlugin.log(coreException, "Unable to get nature of project '%s'.", iProject.getName());
            }
        }
    }

    public void doDecoration(IDecoration iDecoration, String string) {
        iDecoration.addOverlay(this.mDescriptor, 0);
        if (string != null) {
            iDecoration.addSuffix(string);
        }
    }

    public boolean isLabelProperty(Object object, String string) {
        return false;
    }

    public void addListener(ILabelProviderListener iLabelProviderListener) {
    }

    public void removeListener(ILabelProviderListener iLabelProviderListener) {
    }

    public void dispose() {
    }
}

