/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.project;

import com.android.ide.eclipse.adt.internal.project.BaseProjectHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.jar.JarEntry;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public final class ExportHelper {
    private static IExportCallback sCallback;

    public static void setCallback(IExportCallback iExportCallback) {
        sCallback = iExportCallback;
    }

    public static void startExportWizard(IProject iProject) {
        if (sCallback != null) {
            sCallback.startExportWizard(iProject);
        }
    }

    public static void exportProject(IProject iProject) {
        Shell shell = Display.getCurrent().getActiveShell();
        IFolder iFolder = BaseProjectHelper.getOutputFolder(iProject);
        if (iFolder != null) {
            IPath iPath = iFolder.getLocation();
            String string = String.valueOf(iProject.getName()) + ".apk";
            File file = new File(String.valueOf(iPath.toOSString()) + File.separator + string);
            if (!file.exists() || !file.isFile()) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Android IDE Plug-in", (String)String.format("Failed to export %1$s: %2$s doesn't exist!", iProject.getName(), file.getPath()));
                return;
            }
            FileDialog fileDialog = new FileDialog(shell, 8192);
            fileDialog.setText("Export Project");
            fileDialog.setFileName(string);
            String string2 = fileDialog.open();
            if (string2 != null) {
                block28: {
                    Object object;
                    ZipInputStream zipInputStream = null;
                    ZipOutputStream zipOutputStream = null;
                    FileInputStream fileInputStream = null;
                    FileOutputStream fileOutputStream = null;
                    try {
                        fileInputStream = new FileInputStream(file);
                        zipInputStream = new ZipInputStream(fileInputStream);
                        object = new File(string2);
                        fileOutputStream = new FileOutputStream((File)object);
                        zipOutputStream = new ZipOutputStream(fileOutputStream);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        if (zipInputStream != null) {
                            try {
                                zipInputStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                        MessageDialog.openError((Shell)shell, (String)"Android IDE Plug-in", (String)String.format("Failed to export %1$s: %2$s doesn't exist!", iProject.getName(), file.getPath()));
                        return;
                    }
                    try {
                        try {
                            byte[] byArray = new byte[4096];
                            while ((object = zipInputStream.getNextEntry()) != null) {
                                int n;
                                String string3 = ((ZipEntry)object).getName();
                                if (((ZipEntry)object).isDirectory() || string3.startsWith("META-INF/")) continue;
                                JarEntry jarEntry = ((ZipEntry)object).getMethod() == 0 ? new JarEntry((ZipEntry)object) : new JarEntry(string3);
                                zipOutputStream.putNextEntry(jarEntry);
                                while ((n = zipInputStream.read(byArray)) != -1) {
                                    zipOutputStream.write(byArray, 0, n);
                                }
                                zipOutputStream.closeEntry();
                                zipInputStream.closeEntry();
                            }
                        }
                        catch (IOException iOException) {
                            MessageDialog.openError((Shell)shell, (String)"Android IDE Plug-in", (String)String.format("Failed to export %1$s: %2$s", iProject.getName(), iOException.getMessage()));
                            try {
                                zipOutputStream.close();
                            }
                            catch (IOException iOException2) {}
                            try {
                                zipInputStream.close();
                            }
                            catch (IOException iOException3) {}
                            break block28;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            zipOutputStream.close();
                        }
                        catch (IOException iOException) {}
                        try {
                            zipInputStream.close();
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        zipOutputStream.close();
                    }
                    catch (IOException iOException) {}
                    try {
                        zipInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                MessageDialog.openWarning((Shell)shell, (String)"Android IDE Plug-in", (String)String.format("An unsigned package of the application was saved at\n%1$s\n\nBefore publishing the application you will need to:\n- Sign the application with your release key,\n- run zipalign on the signed package. ZipAlign is located in <SDK>/tools/\n\nAligning applications allows Android to use application resources\nmore efficiently.", string2));
            }
        } else {
            MessageDialog.openError((Shell)shell, (String)"Android IDE Plug-in", (String)String.format("Failed to export %1$s: Could not get project output location", iProject.getName()));
        }
    }

    public static interface IExportCallback {
        public void startExportWizard(IProject var1);
    }
}

