/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.launch.junit;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.junit.util.TestSearchEngine;

public class AndroidJUnitPropertyTester
extends PropertyTester {
    private static final String PROPERTY_IS_TEST = "isTest";
    private static final String PROPERTY_CAN_LAUNCH_AS_JUNIT_TEST = "canLaunchAsJUnit";

    public boolean test(Object object, String string, Object[] objectArray, Object object2) {
        IResource iResource;
        IJavaElement iJavaElement;
        if (!(object instanceof IAdaptable)) {
            String string2 = object == null ? "null" : object.getClass().getName();
            throw new IllegalArgumentException(String.format("Element must be of type IAdaptable, is %s", string2));
        }
        if (object instanceof IJavaElement) {
            iJavaElement = (IJavaElement)object;
        } else if (object instanceof IResource ? (iJavaElement = JavaCore.create((IResource)((IResource)object))) == null : (iJavaElement = (IJavaElement)((IAdaptable)object).getAdapter(IJavaElement.class)) == null && (iJavaElement = JavaCore.create((IResource)(iResource = (IResource)((IAdaptable)object).getAdapter(IResource.class)))) == null) {
            return false;
        }
        if (PROPERTY_IS_TEST.equals(string)) {
            return this.isJUnitTest(iJavaElement);
        }
        if (PROPERTY_CAN_LAUNCH_AS_JUNIT_TEST.equals(string)) {
            return this.canLaunchAsJUnitTest(iJavaElement);
        }
        throw new IllegalArgumentException(String.format("Unknown test property '%s'", string));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean canLaunchAsJUnitTest(IJavaElement iJavaElement) {
        try {
            switch (iJavaElement.getElementType()) {
                case 2: {
                    return true;
                }
                case 3: {
                    return false;
                }
                case 4: {
                    return ((IPackageFragment)iJavaElement).hasChildren();
                }
                case 5: 
                case 6: 
                case 7: 
                case 9: {
                    return this.isJUnitTest(iJavaElement);
                }
            }
            return false;
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    private boolean isJUnitTest(IJavaElement iJavaElement) {
        try {
            IType iType = null;
            if (iJavaElement instanceof ICompilationUnit) {
                iType = ((ICompilationUnit)iJavaElement).findPrimaryType();
            } else if (iJavaElement instanceof IClassFile) {
                iType = ((IClassFile)iJavaElement).getType();
            } else if (iJavaElement instanceof IType) {
                iType = (IType)iJavaElement;
            } else if (iJavaElement instanceof IMember) {
                iType = ((IMember)iJavaElement).getDeclaringType();
            }
            if (iType != null && iType.exists()) {
                return TestSearchEngine.isTestOrTestSuite((IType)iType);
            }
        }
        catch (CoreException coreException) {}
        return false;
    }
}

