/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.launch.junit;

import com.android.ddmlib.IDevice;
import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.launch.DelayedLaunchInfo;
import com.android.ide.eclipse.adt.internal.launch.IAndroidLaunchAction;
import com.android.ide.eclipse.adt.internal.launch.junit.runtime.AndroidJUnitLaunchInfo;
import com.android.ide.eclipse.adt.internal.launch.junit.runtime.RemoteAdtTestRunner;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.jdt.junit.launcher.JUnitLaunchConfigurationDelegate;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.VMRunnerConfiguration;

class AndroidJUnitLaunchAction
implements IAndroidLaunchAction {
    private final AndroidJUnitLaunchInfo mLaunchInfo;

    public AndroidJUnitLaunchAction(AndroidJUnitLaunchInfo androidJUnitLaunchInfo) {
        this.mLaunchInfo = androidJUnitLaunchInfo;
    }

    public boolean doLaunchAction(DelayedLaunchInfo delayedLaunchInfo, IDevice iDevice) {
        String string = String.format("Launching instrumentation %s on device %s", this.mLaunchInfo.getRunner(), iDevice.getSerialNumber());
        AdtPlugin.printToConsole(delayedLaunchInfo.getProject(), string);
        try {
            this.mLaunchInfo.setDebugMode(delayedLaunchInfo.isDebugMode());
            this.mLaunchInfo.setDevice(delayedLaunchInfo.getDevice());
            JUnitLaunchDelegate jUnitLaunchDelegate = new JUnitLaunchDelegate(this.mLaunchInfo);
            String string2 = delayedLaunchInfo.isDebugMode() ? "debug" : "run";
            jUnitLaunchDelegate.launch(delayedLaunchInfo.getLaunch().getLaunchConfiguration(), string2, (ILaunch)delayedLaunchInfo.getLaunch(), delayedLaunchInfo.getMonitor());
        }
        catch (CoreException coreException) {
            AdtPlugin.printErrorToConsole(delayedLaunchInfo.getProject(), new Object[]{"Failed to launch test"});
        }
        return true;
    }

    public String getLaunchDescription() {
        return String.format("%s JUnit launch", this.mLaunchInfo.getRunner());
    }

    private static class JUnitLaunchDelegate
    extends JUnitLaunchConfigurationDelegate {
        private AndroidJUnitLaunchInfo mLaunchInfo;

        public JUnitLaunchDelegate(AndroidJUnitLaunchInfo androidJUnitLaunchInfo) {
            this.mLaunchInfo = androidJUnitLaunchInfo;
        }

        public synchronized void launch(ILaunchConfiguration iLaunchConfiguration, String string, ILaunch iLaunch, IProgressMonitor iProgressMonitor) throws CoreException {
            super.launch(iLaunchConfiguration, string, iLaunch, iProgressMonitor);
        }

        public String verifyMainTypeName(ILaunchConfiguration iLaunchConfiguration) {
            return "com.android.ide.eclipse.adt.junit.internal.runner.RemoteAndroidTestRunner";
        }

        public IVMRunner getVMRunner(ILaunchConfiguration iLaunchConfiguration, String string) {
            return new VMTestRunner(this.mLaunchInfo);
        }

        public ILaunch getLaunch(ILaunchConfiguration iLaunchConfiguration, String string) {
            return this.mLaunchInfo.getLaunch();
        }
    }

    private static class TestRunnerProcess
    extends Thread
    implements IProcess {
        private final VMRunnerConfiguration mRunConfig;
        private final AndroidJUnitLaunchInfo mJUnitInfo;
        private RemoteAdtTestRunner mTestRunner = null;
        private boolean mIsTerminated = false;

        TestRunnerProcess(VMRunnerConfiguration vMRunnerConfiguration, AndroidJUnitLaunchInfo androidJUnitLaunchInfo) {
            this.mRunConfig = vMRunnerConfiguration;
            this.mJUnitInfo = androidJUnitLaunchInfo;
        }

        public String getAttribute(String string) {
            return null;
        }

        public int getExitValue() {
            return 0;
        }

        public String getLabel() {
            return this.mJUnitInfo.getLaunch().getLaunchMode();
        }

        public ILaunch getLaunch() {
            return this.mJUnitInfo.getLaunch();
        }

        public IStreamsProxy getStreamsProxy() {
            return null;
        }

        public void setAttribute(String string, String string2) {
        }

        public Object getAdapter(Class clazz) {
            return null;
        }

        public boolean canTerminate() {
            return true;
        }

        public boolean isTerminated() {
            return this.mIsTerminated;
        }

        public void terminate() {
            if (this.mTestRunner != null) {
                this.mTestRunner.terminate();
            }
            this.mIsTerminated = true;
        }

        public void run() {
            this.mTestRunner = new RemoteAdtTestRunner();
            this.mTestRunner.runTests(this.mRunConfig.getProgramArguments(), this.mJUnitInfo);
        }
    }

    private static class VMTestRunner
    implements IVMRunner {
        private final AndroidJUnitLaunchInfo mJUnitInfo;

        VMTestRunner(AndroidJUnitLaunchInfo androidJUnitLaunchInfo) {
            this.mJUnitInfo = androidJUnitLaunchInfo;
        }

        public void run(VMRunnerConfiguration vMRunnerConfiguration, ILaunch iLaunch, IProgressMonitor iProgressMonitor) throws CoreException {
            TestRunnerProcess testRunnerProcess = new TestRunnerProcess(vMRunnerConfiguration, this.mJUnitInfo);
            testRunnerProcess.start();
            iLaunch.addProcess((IProcess)testRunnerProcess);
        }
    }
}

