/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.launch;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.launch.AndroidLaunchController;
import com.android.ide.eclipse.adt.internal.project.AndroidManifestParser;
import com.android.ide.eclipse.adt.internal.project.BaseProjectHelper;
import com.android.ide.eclipse.adt.internal.project.ProjectChooserHelper;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class MainLaunchConfigTab
extends AbstractLaunchConfigurationTab {
    public static final String LAUNCH_TAB_IMAGE = "mainLaunchTab.png";
    protected static final String EMPTY_STRING = "";
    protected Text mProjText;
    private Button mProjButton;
    private Combo mActivityCombo;
    private final ArrayList<AndroidManifestParser.Activity> mActivities = new ArrayList();
    private WidgetListener mListener = new WidgetListener();
    private Button mDefaultActionButton;
    private Button mActivityActionButton;
    private Button mDoNothingActionButton;
    private int mLaunchAction = 0;
    private ProjectChooserHelper mProjectChooserHelper;

    public void createControl(Composite composite) {
        this.mProjectChooserHelper = new ProjectChooserHelper(composite.getShell());
        Font font = composite.getFont();
        Composite composite2 = new Composite(composite, 0);
        this.setControl((Control)composite2);
        GridLayout gridLayout = new GridLayout();
        gridLayout.verticalSpacing = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setFont(font);
        this.createProjectEditor(composite2);
        this.createVerticalSpacer(composite2, 1);
        Group group = new Group(composite2, 0);
        group.setText("Launch Action:");
        GridData gridData = new GridData(768);
        group.setLayoutData((Object)gridData);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 2;
        group.setLayout((Layout)gridLayout2);
        group.setFont(font);
        this.mDefaultActionButton = new Button((Composite)group, 16);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.mDefaultActionButton.setLayoutData((Object)gridData);
        this.mDefaultActionButton.setText("Launch Default Activity");
        this.mDefaultActionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (MainLaunchConfigTab.this.mDefaultActionButton.getSelection()) {
                    MainLaunchConfigTab.this.mLaunchAction = 0;
                    MainLaunchConfigTab.this.mActivityCombo.setEnabled(false);
                    MainLaunchConfigTab.this.checkParameters();
                }
            }
        });
        this.mActivityActionButton = new Button((Composite)group, 16);
        this.mActivityActionButton.setText("Launch:");
        this.mActivityActionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (MainLaunchConfigTab.this.mActivityActionButton.getSelection()) {
                    MainLaunchConfigTab.this.mLaunchAction = 1;
                    MainLaunchConfigTab.this.mActivityCombo.setEnabled(true);
                    MainLaunchConfigTab.this.checkParameters();
                }
            }
        });
        this.mActivityCombo = new Combo((Composite)group, 12);
        gridData = new GridData(768);
        this.mActivityCombo.setLayoutData((Object)gridData);
        this.mActivityCombo.clearSelection();
        this.mActivityCombo.setEnabled(false);
        this.mActivityCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MainLaunchConfigTab.this.checkParameters();
            }
        });
        this.mDoNothingActionButton = new Button((Composite)group, 16);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.mDoNothingActionButton.setLayoutData((Object)gridData);
        this.mDoNothingActionButton.setText("Do Nothing");
        this.mDoNothingActionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (MainLaunchConfigTab.this.mDoNothingActionButton.getSelection()) {
                    MainLaunchConfigTab.this.mLaunchAction = 2;
                    MainLaunchConfigTab.this.mActivityCombo.setEnabled(false);
                    MainLaunchConfigTab.this.checkParameters();
                }
            }
        });
    }

    public String getName() {
        return "Android";
    }

    public Image getImage() {
        return AdtPlugin.getImageLoader().loadImage(LAUNCH_TAB_IMAGE, null);
    }

    public void performApply(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        iLaunchConfigurationWorkingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, this.mProjText.getText());
        iLaunchConfigurationWorkingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_ALLOW_TERMINATE, true);
        iLaunchConfigurationWorkingCopy.setAttribute("com.android.ide.eclipse.adt.action", this.mLaunchAction);
        int n = this.mActivityCombo.getSelectionIndex();
        if (this.mActivities != null && n >= 0 && n < this.mActivities.size()) {
            iLaunchConfigurationWorkingCopy.setAttribute("com.android.ide.eclipse.adt.activity", this.mActivities.get(n).getName());
        }
        this.mapResources(iLaunchConfigurationWorkingCopy);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        iLaunchConfigurationWorkingCopy.setAttribute("com.android.ide.eclipse.adt.action", 0);
    }

    protected void createProjectEditor(Composite composite) {
        Font font = composite.getFont();
        Group group = new Group(composite, 0);
        group.setText("Project:");
        GridData gridData = new GridData(768);
        group.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        group.setLayout((Layout)gridLayout);
        group.setFont(font);
        this.mProjText = new Text((Composite)group, 2052);
        gridData = new GridData(768);
        this.mProjText.setLayoutData((Object)gridData);
        this.mProjText.setFont(font);
        this.mProjText.addModifyListener((ModifyListener)this.mListener);
        this.mProjButton = this.createPushButton((Composite)group, "Browse...", null);
        this.mProjButton.addSelectionListener((SelectionListener)this.mListener);
    }

    protected WidgetListener getDefaultListener() {
        return this.mListener;
    }

    protected IJavaProject getJavaProject(IJavaModel iJavaModel) {
        String string = this.mProjText.getText().trim();
        if (string.length() < 1) {
            return null;
        }
        return iJavaModel.getJavaProject(string);
    }

    protected void handleProjectButtonSelected() {
        IJavaProject iJavaProject = this.mProjectChooserHelper.chooseJavaProject(this.mProjText.getText().trim());
        if (iJavaProject == null) {
            return;
        }
        String string = iJavaProject.getElementName();
        this.mProjText.setText(string);
        IProject iProject = iJavaProject.getProject();
        this.loadActivities(iProject);
    }

    public void initializeFrom(ILaunchConfiguration iLaunchConfiguration) {
        String string = EMPTY_STRING;
        try {
            string = iLaunchConfiguration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, EMPTY_STRING);
        }
        catch (CoreException coreException) {}
        this.mProjText.setText(string);
        IProject iProject = this.mProjectChooserHelper.getAndroidProject(string);
        this.loadActivities(iProject);
        this.mLaunchAction = 0;
        try {
            this.mLaunchAction = iLaunchConfiguration.getAttribute("com.android.ide.eclipse.adt.action", this.mLaunchAction);
        }
        catch (CoreException coreException) {}
        this.mDefaultActionButton.setSelection(this.mLaunchAction == 0);
        this.mActivityActionButton.setSelection(this.mLaunchAction == 1);
        this.mDoNothingActionButton.setSelection(this.mLaunchAction == 2);
        String string2 = EMPTY_STRING;
        try {
            string2 = iLaunchConfiguration.getAttribute("com.android.ide.eclipse.adt.activity", EMPTY_STRING);
        }
        catch (CoreException coreException) {}
        if (this.mLaunchAction != 1) {
            this.mActivityCombo.setEnabled(false);
            this.mActivityCombo.clearSelection();
        } else {
            this.mActivityCombo.setEnabled(true);
            if (string2 == null || string2.equals(EMPTY_STRING)) {
                this.mActivityCombo.clearSelection();
            } else if (this.mActivities != null && this.mActivities.size() > 0) {
                boolean bl = false;
                int n = 0;
                while (n < this.mActivities.size()) {
                    if (string2.equals(this.mActivities.get(n).getName())) {
                        bl = true;
                        this.mActivityCombo.select(n);
                        break;
                    }
                    ++n;
                }
                if (!bl) {
                    this.mActivityCombo.clearSelection();
                }
            }
        }
    }

    protected void mapResources(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IJavaModel iJavaModel = JavaCore.create((IWorkspaceRoot)iWorkspaceRoot);
        IJavaProject iJavaProject = this.getJavaProject(iJavaModel);
        IResource[] iResourceArray = null;
        if (iJavaProject != null) {
            iResourceArray = AndroidLaunchController.getResourcesToMap(iJavaProject.getProject());
        }
        iLaunchConfigurationWorkingCopy.setMappedResources(iResourceArray);
    }

    private void loadActivities(IProject iProject) {
        if (iProject != null) {
            try {
                AndroidManifestParser androidManifestParser = AndroidManifestParser.parse(BaseProjectHelper.getJavaProject(iProject), null, true, false);
                if (androidManifestParser != null) {
                    AndroidManifestParser.Activity[] activityArray = androidManifestParser.getActivities();
                    this.mActivities.clear();
                    this.mActivityCombo.removeAll();
                    AndroidManifestParser.Activity[] activityArray2 = activityArray;
                    int n = activityArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        AndroidManifestParser.Activity activity = activityArray2[n2];
                        if (activity.isExported() && activity.hasAction()) {
                            this.mActivities.add(activity);
                            this.mActivityCombo.add(activity.getName());
                        }
                        ++n2;
                    }
                    if (this.mActivities.size() > 0) {
                        if (this.mLaunchAction == 1) {
                            this.mActivityCombo.setEnabled(true);
                        }
                    } else {
                        this.mActivityCombo.setEnabled(false);
                    }
                    this.mActivityCombo.clearSelection();
                    return;
                }
            }
            catch (CoreException coreException) {}
        }
        this.mActivityCombo.removeAll();
        this.mActivities.clear();
    }

    private IProject checkParameters() {
        block9: {
            try {
                String string = this.mProjText.getText();
                if (string.length() == 0) {
                    this.setErrorMessage("Project Name is required!");
                    break block9;
                }
                if (!string.matches("[a-zA-Z0-9_ \\.-]+")) {
                    this.setErrorMessage("Project name contains unsupported characters!");
                    break block9;
                }
                IJavaProject[] iJavaProjectArray = this.mProjectChooserHelper.getAndroidProjects(null);
                IProject iProject = null;
                IJavaProject[] iJavaProjectArray2 = iJavaProjectArray;
                int n = iJavaProjectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaProject iJavaProject = iJavaProjectArray2[n2];
                    if (iJavaProject.getProject().getName().equals(string)) {
                        iProject = iJavaProject.getProject();
                        break;
                    }
                    ++n2;
                }
                if (iProject != null) {
                    this.setErrorMessage(null);
                } else {
                    this.setErrorMessage(String.format("There is no android project named '%1$s'", string));
                }
                IProject iProject2 = iProject;
                return iProject2;
            }
            finally {
                this.updateLaunchConfigurationDialog();
            }
        }
        return null;
    }

    private class WidgetListener
    implements ModifyListener,
    SelectionListener {
        private WidgetListener() {
        }

        public void modifyText(ModifyEvent modifyEvent) {
            IProject iProject = MainLaunchConfigTab.this.checkParameters();
            MainLaunchConfigTab.this.loadActivities(iProject);
            MainLaunchConfigTab.this.setDirty(true);
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            Object object = selectionEvent.getSource();
            if (object == MainLaunchConfigTab.this.mProjButton) {
                MainLaunchConfigTab.this.handleProjectButtonSelected();
            } else {
                MainLaunchConfigTab.this.checkParameters();
            }
        }
    }
}

