/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.launch;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.ddmuilib.IImageLoader;
import com.android.ddmuilib.ImageHelper;
import com.android.ddmuilib.TableHelper;
import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.sdk.Sdk;
import com.android.ide.eclipse.ddms.DdmsPlugin;
import com.android.ide.eclipse.ddms.ImageLoader;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.sdkuilib.internal.widgets.AvdSelector;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public class DeviceChooserDialog
extends Dialog
implements AndroidDebugBridge.IDeviceChangeListener {
    private static final int ICON_WIDTH = 16;
    private Table mDeviceTable;
    private TableViewer mViewer;
    private AvdSelector mPreferredAvdSelector;
    private Image mDeviceImage;
    private Image mEmulatorImage;
    private Image mMatchImage;
    private Image mNoMatchImage;
    private Image mWarningImage;
    private final DeviceChooserResponse mResponse;
    private final String mPackageName;
    private final IAndroidTarget mProjectTarget;
    private final Sdk mSdk;
    private Button mDeviceRadioButton;
    private boolean mDisableAvdSelectionChange = false;

    public DeviceChooserDialog(Shell shell, DeviceChooserResponse deviceChooserResponse, String string, IAndroidTarget iAndroidTarget) {
        super(shell);
        this.mResponse = deviceChooserResponse;
        this.mPackageName = string;
        this.mProjectTarget = iAndroidTarget;
        this.mSdk = Sdk.getCurrent();
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        this.loadImages();
    }

    private void cleanup() {
        AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        this.mEmulatorImage.dispose();
        this.mDeviceImage.dispose();
        this.mMatchImage.dispose();
        this.mNoMatchImage.dispose();
        this.mWarningImage.dispose();
    }

    protected void okPressed() {
        this.cleanup();
        super.okPressed();
    }

    protected void cancelPressed() {
        this.cleanup();
        super.cancelPressed();
    }

    protected Control createContents(Composite composite) {
        Control control = super.createContents(composite);
        this.updateDefaultSelection();
        return control;
    }

    protected Control createDialogArea(Composite composite) {
        this.getShell().setText("Android Device Chooser");
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(1, true));
        Label label = new Label(composite2, 0);
        label.setText(String.format("Select a device compatible with target %s.", this.mProjectTarget.getFullName()));
        this.mDeviceRadioButton = new Button(composite2, 16);
        this.mDeviceRadioButton.setText("Choose a running Android device");
        this.mDeviceRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                boolean bl = DeviceChooserDialog.this.mDeviceRadioButton.getSelection();
                DeviceChooserDialog.this.mDeviceTable.setEnabled(bl);
                DeviceChooserDialog.this.mPreferredAvdSelector.setEnabled(!bl);
                if (bl) {
                    DeviceChooserDialog.this.handleDeviceSelection();
                } else {
                    DeviceChooserDialog.this.mResponse.setAvdToLaunch(DeviceChooserDialog.this.mPreferredAvdSelector.getSelected());
                }
                DeviceChooserDialog.this.enableOkButton();
            }
        });
        this.mDeviceRadioButton.setSelection(true);
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayoutData((Object)new GridData(768));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginLeft = 30;
        composite3.setLayout((Layout)gridLayout);
        this.mDeviceTable = new Table(composite3, 67588);
        GridData gridData = new GridData(1808);
        this.mDeviceTable.setLayoutData((Object)gridData);
        gridData.heightHint = 100;
        this.mDeviceTable.setHeaderVisible(true);
        this.mDeviceTable.setLinesVisible(true);
        TableHelper.createTableColumn((Table)this.mDeviceTable, (String)"Serial Number", (int)16384, (String)"AAA+AAAAAAAAAAAAAAAAAAA", null, null);
        TableHelper.createTableColumn((Table)this.mDeviceTable, (String)"AVD Name", (int)16384, (String)"AAAAAAAAAAAAAAAAAAA", null, null);
        TableHelper.createTableColumn((Table)this.mDeviceTable, (String)"Target", (int)16384, (String)"AAA+Android 9.9.9", null, null);
        TableHelper.createTableColumn((Table)this.mDeviceTable, (String)"Debug", (int)16384, (String)"Debug", null, null);
        TableHelper.createTableColumn((Table)this.mDeviceTable, (String)"State", (int)16384, (String)"bootloader", null, null);
        this.mViewer = new TableViewer(this.mDeviceTable);
        this.mViewer.setContentProvider((IContentProvider)new ContentProvider());
        this.mViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.mViewer.setInput((Object)AndroidDebugBridge.getBridge());
        this.mDeviceTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DeviceChooserDialog.this.handleDeviceSelection();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                DeviceChooserDialog.this.handleDeviceSelection();
                if (DeviceChooserDialog.this.isOkButtonEnabled()) {
                    DeviceChooserDialog.this.okPressed();
                }
            }
        });
        Button button = new Button(composite2, 16);
        button.setText("Launch a new Android Virtual Device");
        composite3 = new Composite(composite2, 0);
        composite3.setLayoutData((Object)new GridData(768));
        gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginLeft = 30;
        composite3.setLayout((Layout)gridLayout);
        this.mPreferredAvdSelector = new AvdSelector(composite3, this.mSdk.getSdkLocation(), this.mSdk.getAvdManager(), (AvdSelector.IAvdFilter)new NonRunningAvdFilter(), AvdSelector.DisplayMode.SIMPLE_SELECTION);
        this.mPreferredAvdSelector.setTableHeightHint(100);
        this.mPreferredAvdSelector.setEnabled(false);
        this.mPreferredAvdSelector.setSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (!DeviceChooserDialog.this.mDisableAvdSelectionChange) {
                    DeviceChooserDialog.this.mResponse.setAvdToLaunch(DeviceChooserDialog.this.mPreferredAvdSelector.getSelected());
                    DeviceChooserDialog.this.enableOkButton();
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                this.widgetSelected(selectionEvent);
                if (DeviceChooserDialog.this.isOkButtonEnabled()) {
                    DeviceChooserDialog.this.okPressed();
                }
            }
        });
        return composite2;
    }

    private void loadImages() {
        ImageLoader imageLoader = DdmsPlugin.getImageLoader();
        Display display = DdmsPlugin.getDisplay();
        ImageLoader imageLoader2 = AdtPlugin.getImageLoader();
        if (this.mDeviceImage == null) {
            this.mDeviceImage = ImageHelper.loadImage((IImageLoader)imageLoader, (Display)display, (String)"device.png", (int)16, (int)16, (Color)display.getSystemColor(3));
        }
        if (this.mEmulatorImage == null) {
            this.mEmulatorImage = ImageHelper.loadImage((IImageLoader)imageLoader, (Display)display, (String)"emulator.png", (int)16, (int)16, (Color)display.getSystemColor(9));
        }
        if (this.mMatchImage == null) {
            this.mMatchImage = ImageHelper.loadImage((IImageLoader)imageLoader2, (Display)display, (String)"match.png", (int)16, (int)16, (Color)display.getSystemColor(5));
        }
        if (this.mNoMatchImage == null) {
            this.mNoMatchImage = ImageHelper.loadImage((IImageLoader)imageLoader2, (Display)display, (String)"error.png", (int)16, (int)16, (Color)display.getSystemColor(3));
        }
        if (this.mWarningImage == null) {
            this.mWarningImage = ImageHelper.loadImage((IImageLoader)imageLoader2, (Display)display, (String)"warning.png", (int)16, (int)16, (Color)display.getSystemColor(7));
        }
    }

    private static String getStateString(IDevice iDevice) {
        IDevice.DeviceState deviceState = iDevice.getState();
        if (deviceState == IDevice.DeviceState.ONLINE) {
            return "Online";
        }
        if (deviceState == IDevice.DeviceState.OFFLINE) {
            return "Offline";
        }
        if (deviceState == IDevice.DeviceState.BOOTLOADER) {
            return "Bootloader";
        }
        return "??";
    }

    public void deviceConnected(IDevice iDevice) {
        final DeviceChooserDialog deviceChooserDialog = this;
        this.exec(new Runnable(){

            public void run() {
                if (!DeviceChooserDialog.this.mDeviceTable.isDisposed()) {
                    DeviceChooserDialog.this.mViewer.refresh();
                    DeviceChooserDialog.this.updateDefaultSelection();
                    DeviceChooserDialog.this.refillAvdList(false);
                } else {
                    AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)deviceChooserDialog);
                }
            }
        });
    }

    public void deviceDisconnected(IDevice iDevice) {
        this.deviceConnected(iDevice);
    }

    public void deviceChanged(final IDevice iDevice, int n) {
        if ((n & 5) != 0) {
            final DeviceChooserDialog deviceChooserDialog = this;
            this.exec(new Runnable(){

                public void run() {
                    if (!DeviceChooserDialog.this.mDeviceTable.isDisposed()) {
                        DeviceChooserDialog.this.mViewer.refresh((Object)iDevice);
                        DeviceChooserDialog.this.updateDefaultSelection();
                        DeviceChooserDialog.this.refillAvdList(false);
                        if (iDevice == DeviceChooserDialog.this.mResponse.getDeviceToUse()) {
                            DeviceChooserDialog.this.enableOkButton();
                        }
                    } else {
                        AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)deviceChooserDialog);
                    }
                }
            });
        }
    }

    private boolean isDeviceMode() {
        return this.mDeviceRadioButton.getSelection();
    }

    private void enableOkButton() {
        Button button = this.getButton(0);
        if (this.isDeviceMode()) {
            button.setEnabled(this.mResponse.getDeviceToUse() != null && this.mResponse.getDeviceToUse().isOnline());
        } else {
            button.setEnabled(this.mResponse.getAvdToLaunch() != null);
        }
    }

    private boolean isOkButtonEnabled() {
        Button button = this.getButton(0);
        return button.isEnabled();
    }

    private void exec(Runnable runnable) {
        try {
            Display display = this.mDeviceTable.getDisplay();
            display.asyncExec(runnable);
        }
        catch (SWTException sWTException) {
            AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        }
    }

    private void handleDeviceSelection() {
        int n = this.mDeviceTable.getSelectionCount();
        if (n != 1) {
            this.handleSelection(null);
        } else {
            int n2 = this.mDeviceTable.getSelectionIndex();
            Object object = this.mViewer.getElementAt(n2);
            if (object instanceof IDevice) {
                this.handleSelection((IDevice)object);
            } else {
                this.handleSelection(null);
            }
        }
    }

    private void handleSelection(IDevice iDevice) {
        this.mResponse.setDeviceToUse(iDevice);
        this.enableOkButton();
    }

    private void updateDefaultSelection() {
        if (this.mDeviceTable.getSelectionCount() == 0) {
            IDevice[] iDeviceArray;
            AndroidDebugBridge androidDebugBridge = AndroidDebugBridge.getBridge();
            IDevice[] iDeviceArray2 = iDeviceArray = androidDebugBridge.getDevices();
            int n = iDeviceArray.length;
            int n2 = 0;
            while (n2 < n) {
                Client[] clientArray;
                IDevice iDevice = iDeviceArray2[n2];
                Client[] clientArray2 = clientArray = iDevice.getClients();
                int n3 = clientArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Client client = clientArray2[n4];
                    if (this.mPackageName.equals(client.getClientData().getClientDescription())) {
                        this.mViewer.setSelection((ISelection)new StructuredSelection((Object)iDevice));
                        this.handleSelection(iDevice);
                        return;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        this.handleDeviceSelection();
    }

    private void refillAvdList(boolean bl) {
        AvdManager.AvdInfo avdInfo = this.mPreferredAvdSelector.getSelected();
        this.mDisableAvdSelectionChange = true;
        this.mPreferredAvdSelector.refresh(false);
        if (avdInfo != null && !this.mPreferredAvdSelector.setSelection(avdInfo)) {
            this.mResponse.setAvdToLaunch(null);
            this.enableOkButton();
        }
        this.mDisableAvdSelectionChange = false;
    }

    private class ContentProvider
    implements IStructuredContentProvider {
        private ContentProvider() {
        }

        public Object[] getElements(Object object) {
            if (object instanceof AndroidDebugBridge) {
                return ((AndroidDebugBridge)object).getDevices();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }

    public static class DeviceChooserResponse {
        private AvdManager.AvdInfo mAvdToLaunch;
        private IDevice mDeviceToUse;

        public void setDeviceToUse(IDevice iDevice) {
            this.mDeviceToUse = iDevice;
            this.mAvdToLaunch = null;
        }

        public void setAvdToLaunch(AvdManager.AvdInfo avdInfo) {
            this.mAvdToLaunch = avdInfo;
            this.mDeviceToUse = null;
        }

        public IDevice getDeviceToUse() {
            return this.mDeviceToUse;
        }

        public AvdManager.AvdInfo getAvdToLaunch() {
            return this.mAvdToLaunch;
        }
    }

    private class LabelProvider
    implements ITableLabelProvider {
        private LabelProvider() {
        }

        public Image getColumnImage(Object object, int n) {
            if (object instanceof IDevice) {
                IDevice iDevice = (IDevice)object;
                switch (n) {
                    case 0: {
                        return iDevice.isEmulator() ? DeviceChooserDialog.this.mEmulatorImage : DeviceChooserDialog.this.mDeviceImage;
                    }
                    case 2: {
                        if (!iDevice.isEmulator()) {
                            AndroidVersion androidVersion = Sdk.getDeviceVersion(iDevice);
                            if (androidVersion == null) {
                                return DeviceChooserDialog.this.mWarningImage;
                            }
                            if (!androidVersion.canRun(DeviceChooserDialog.this.mProjectTarget.getVersion())) {
                                return DeviceChooserDialog.this.mNoMatchImage;
                            }
                            return DeviceChooserDialog.this.mProjectTarget.isPlatform() ? DeviceChooserDialog.this.mMatchImage : DeviceChooserDialog.this.mWarningImage;
                        }
                        AvdManager.AvdInfo avdInfo = DeviceChooserDialog.this.mSdk.getAvdManager().getAvd(iDevice.getAvdName(), true);
                        if (avdInfo == null) {
                            return DeviceChooserDialog.this.mWarningImage;
                        }
                        return DeviceChooserDialog.this.mProjectTarget.isCompatibleBaseFor(avdInfo.getTarget()) ? DeviceChooserDialog.this.mMatchImage : DeviceChooserDialog.this.mNoMatchImage;
                    }
                }
            }
            return null;
        }

        public String getColumnText(Object object, int n) {
            if (object instanceof IDevice) {
                IDevice iDevice = (IDevice)object;
                switch (n) {
                    case 0: {
                        return iDevice.getSerialNumber();
                    }
                    case 1: {
                        if (iDevice.isEmulator()) {
                            return iDevice.getAvdName();
                        }
                        return "N/A";
                    }
                    case 2: {
                        if (iDevice.isEmulator()) {
                            AvdManager.AvdInfo avdInfo = DeviceChooserDialog.this.mSdk.getAvdManager().getAvd(iDevice.getAvdName(), true);
                            if (avdInfo == null) {
                                return "?";
                            }
                            return avdInfo.getTarget().getFullName();
                        }
                        String string = iDevice.getProperty("ro.build.version.release");
                        if (string == null) {
                            return "unknown";
                        }
                        return string;
                    }
                    case 3: {
                        String string = iDevice.getProperty("ro.debuggable");
                        if (string != null && string.equals("1")) {
                            return "Yes";
                        }
                        return "";
                    }
                    case 4: {
                        return DeviceChooserDialog.getStateString(iDevice);
                    }
                }
            }
            return null;
        }

        public void addListener(ILabelProviderListener iLabelProviderListener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object object, String string) {
            return false;
        }

        public void removeListener(ILabelProviderListener iLabelProviderListener) {
        }
    }

    private final class NonRunningAvdFilter
    implements AvdSelector.IAvdFilter {
        private IDevice[] mDevices;

        private NonRunningAvdFilter() {
        }

        public void prepare() {
            this.mDevices = AndroidDebugBridge.getBridge().getDevices();
        }

        public boolean accept(AvdManager.AvdInfo avdInfo) {
            if (this.mDevices != null) {
                IDevice[] iDeviceArray = this.mDevices;
                int n = this.mDevices.length;
                int n2 = 0;
                while (n2 < n) {
                    IDevice iDevice = iDeviceArray[n2];
                    if (!DeviceChooserDialog.this.mProjectTarget.isCompatibleBaseFor(avdInfo.getTarget()) || avdInfo.getName().equals(iDevice.getAvdName())) {
                        return false;
                    }
                    ++n2;
                }
            }
            return true;
        }

        public void cleanup() {
            this.mDevices = null;
        }
    }
}

